/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.jrc.JRClusterService;

public class JRRoundLoadBalancer
implements LoadBalancer {
    protected int iCur = 0;
    protected int iCount = 1;
    protected Member localMember = null;
    protected JRClusterService clusterServ = null;

    public JRRoundLoadBalancer(JRClusterService jRClusterService) {
        this.clusterServ = jRClusterService;
    }

    public Member selectMember(Member member, Member[] memberArray) {
        this.localMember = member;
        if (memberArray.length == 1) {
            return member;
        }
        this.iCount = memberArray.length;
        if (this.iCur >= this.iCount) {
            this.iCur = 0;
        }
        if (this.iCur < 0) {
            this.iCur = 0;
        }
        Member member2 = null;
        boolean bl = false;
        int n = 1;
        while (!bl) {
            member2 = memberArray[this.iCur];
            if (this.canSelectMember(member2)) break;
            this.QOIV();
            if (++n <= this.iCount) continue;
            member2 = null;
            bl = true;
        }
        if (member2 == null) {
            member2 = memberArray[this.iCur];
        }
        this.QOIV();
        return member2;
    }

    public boolean canSelectMember(Member member) {
        int n = 0;
        try {
            n = this.clusterServ.getConcurrentReports(member);
        }
        catch (Exception exception) {
            return false;
        }
        int n2 = ((ReportMember)member).getMaxConcurrentReports();
        if (n2 == 0) {
            return true;
        }
        return n < n2;
    }

    private int QOIV() {
        this.iCur = this.iCur < this.iCount - 1 ? ++this.iCur : 0;
        return this.iCur;
    }
}

