/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JCliResource;
import jet.JSException;
import jet.bean.JREngine;
import jet.bean.ReportEngineAPI;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.CustomTaskIntf;
import jet.cs.TaskIntf;
import jet.cs.util.APIConst;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.ExportedFileList;
import jet.server.api.OndemandReportRecord;
import jet.server.api.RptServerException;
import jet.server.api.SecurityContext;
import jet.server.api.SecurityContextFactory;
import jet.server.api.TaskListener;
import jet.server.api.TooManyReportsException;
import jet.server.api.UserTask;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.intf.engine.ReportEngine;
import jet.server.intf.jrs.ClusterListener;
import jet.server.intf.jrs.MemberManager;
import jet.server.intf.jrs.SchedulingService;
import jet.server.intf.jrs.TaskManager;
import jet.server.jrc.DelTempFileThread;
import jet.server.jrc.DurationCheckingThread;
import jet.server.jrc.EngineErrorsMgrThread;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.JRMemberManager;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrc.RunRptThread;
import jet.server.jrc.SendConcurrentReportsThread;
import jet.server.jrc.TableProxy;
import jet.server.jrc.TableProxyExecutorQueueFactory;
import jet.server.jrc.TaskStatisticRecorder;
import jet.server.jrc.TempRstInfo;
import jet.server.jrc.engine.JREngineContext;
import jet.server.jrc.engine.JREngineManager;
import jet.server.jrc.engine.JRReportEngine;
import jet.server.jrc.track.Tracker;
import jet.server.jrserver.JRExportedFileList;
import jet.server.jrserver.JROndemandReportManager;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.jrserver.JRReportSheetInfo;
import jet.server.jrserver.JRResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRRunReportTimeoutException;
import jet.server.jrserver.JRTaskCancellationException;
import jet.server.log.ServiceLogger;
import jet.server.schedule.InternalStorableTask;
import jet.server.schedule.InternalTask;
import jet.server.schedule.JRServerInfo;
import jet.server.schedule.Launchable;
import jet.server.schedule.LaunchableObj;
import jet.server.schedule.SchdTools;
import jet.server.schedule.StartListener;
import jet.server.schedule.TerminationListener;
import jet.server.schedule.jrtasks.ExportInATypeTask;
import jet.server.schedule.jrtasks.ExportTask;
import jet.server.schedule.jrtasks.HtmlPipeFileNames;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.MonitorThread;
import jet.server.schedule.jrtasks.PublishRptTask;
import jet.server.schedule.jrtasks.RunAndViewTermLsn;
import jet.server.schedule.jrtasks.RunRptTask;
import jet.server.schedule.jrtasks.RunRptTaskRoot;
import jet.server.schedule.jrtasks.UpdateRptTask;
import jet.server.schedule.jrtasks.UserTaskProxy;
import jet.server.schedule.jrtasks.ViewRptTask;
import jet.server.schedule.jrtasks.ViewTestRptTask;
import jet.server.util.Queue;
import jet.server.util.ThreadQueueController;
import jet.server.util.ThreadQueueElement;
import jet.util.ReportsetEngineInfo;

public class JRTaskManager
implements TaskManager,
TerminationListener,
ClusterListener {
    public static final int ON_DEMAND = 1;
    public static final int SCHEDULED = 2;
    public static final int BURSTING_MAIN = 3;
    public static final int BURSTING_SUB = 4;
    public static final String TASK_TOPIC = "TaskManager";
    public static final int SUBMIT_TASK = 0;
    public static final int START_TASK = 1;
    public static final int FINISH_TASK = 2;
    public static final int FAILED_TASK = 3;
    public static final int SUBMITED = 1;
    public static final int UNLAUNCH = 2;
    public static final int TASK_QUEUE = 3;
    public static final int RUNNING = 4;
    public static final int INIT_ENGINE = 5;
    public static final int LOAD_REPORT = 6;
    public static final int EXPORTING = 7;
    public static final int EXIT_ENGINE = 8;
    public static final int COMPLETED = 9;
    public static final int FAILED = 10;
    public static final String TASK_ID = "taskID";
    public static final String RPT_NAME = "rptName";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER_NAME = "serverName";
    public static final String RUN_HOST = "runHost";
    public static final String RUN_PORT = "runPort";
    public static final String SUBMIT_TIME = "submitTime";
    public static final String START_TIME = "startTime";
    public static final String FINISH_TIME = "finishTime";
    public static final String RPT_PAGES = "rptPages";
    public static final String RPT_SOURCE = "rptSource";
    public static final String RST_FILE_NAME = "rstFileName";
    public static final String USER_NAME = "userName";
    public static final String REASON = "reason";
    public static final String ENGINE_INFO = "engineInfo";
    public static final String FAILED_INFO = "failedInfo";
    public static final String FIRST_SUBMIT_TIME = "firstSubmitTime";
    public static final String RUN_TIMES_NUMBER = "runTimesNumber";
    private JRDataService J = null;
    protected JROndemandReportManager ondemandManager = null;
    Hashtable QOIV = null;
    Hashtable TASK_PUBLISH_ANALYSIS_DISPLAY_NAME = null;
    protected RunAndViewTermLsn ravtLsn = null;
    protected JROndemandReportManager lrptMan = null;
    private DelTempFileThread TIMEOUT = null;
    private Hashtable add = new Hashtable();
    private Hashtable addClusterListener = new Hashtable();
    private JRResourceManager addElement = null;
    private MonitorThread addFailedTask = new MonitorThread();
    private SendConcurrentReportsThread addFailedTaskToMonitor = null;
    private ReportMember addFinishedTask = null;
    private MemberManager addFinishedTaskToMonitor = null;
    private boolean addRecord = false;
    private boolean addRunningTask = false;
    private ThreadQueueController addRunningTaskToMonitor = null;
    private int addTask = -1;
    private final Vector addTerminationListener = new Vector();
    private final Vector addWaitingTask = new Vector();
    private final Vector addWaitingTaskToMonitor = new Vector();
    private Hashtable append = new Hashtable();
    private Hashtable assertCheck = new Hashtable();
    private Vector available = new Vector();
    private Vector beforeStopLaunch = new Vector();
    private JRClusterService booleanValue = null;
    private Vector canAutoRefresh = new Vector();
    private Queue canCancelRecoveryTask = new Queue();
    private int canRunReport = -1;
    private JREngineManager cancelTask = null;
    private SchedulingService class$ = null;
    private int clearMem = 0;
    private SecurityContextFactory clone = null;
    private ConnectionInfoProvider close = null;
    private Object contains = new Object();
    private DurationCheckingThread containsKey = null;
    private EngineErrorsMgrThread convertEscapes = new EngineErrorsMgrThread();
    private JRRptServer copyAllFiles;
    private TaskStatisticRecorder currentThread;
    static Class class$jet$server$schedule$jrtasks$ViewRptTask;
    static Class class$jet$server$schedule$jrtasks$ViewTestRptTask;
    static Class class$jet$server$schedule$jrtasks$ExportInATypeTask;
    static Class class$jet$server$schedule$jrtasks$ExportTask;

    public JRTaskManager(JRRptServer jRRptServer, JRResourceManager jRResourceManager, JRClusterService jRClusterService, JROndemandReportManager jROndemandReportManager) {
        this(jRResourceManager, jRClusterService, jROndemandReportManager);
        this.copyAllFiles = jRRptServer;
        this.currentThread = new TaskStatisticRecorder(ServerEnv.getReportHome() + "profiling");
    }

    public JRTaskManager(JRResourceManager jRResourceManager, JRClusterService jRClusterService, JROndemandReportManager jROndemandReportManager) {
        this.ondemandManager = jROndemandReportManager;
        this.lrptMan = jROndemandReportManager;
        this.QOIV = new Hashtable();
        this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME = new Hashtable();
        this.ravtLsn = new RunAndViewTermLsn(this);
        this.addElement = jRResourceManager;
        this.booleanValue = jRClusterService;
        if (jRClusterService != null) {
            this.addFinishedTaskToMonitor = jRClusterService.getMemberManager();
            this.addFinishedTask = (ReportMember)jRClusterService.getLocalMember();
            if (this.addFinishedTask.isAdmin()) {
                ((JRMemberManager)this.addFinishedTaskToMonitor).addClusterListener(this);
            }
        }
    }

    public void setEngineManager(JREngineManager jREngineManager) {
        this.cancelTask = jREngineManager;
    }

    public JREngineManager getEngineManager() {
        return this.cancelTask;
    }

    public String getTempDir() {
        return this.addElement.getTempDir();
    }

    public ClusterService getClusterService() {
        return this.booleanValue;
    }

    public void setDataService(JRDataService jRDataService) {
        this.J = jRDataService;
    }

    public JRDataService getDataService() {
        return this.J;
    }

    public SchedulingService getSchedulingService() {
        return this.class$;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.class$ = schedulingService;
    }

    public void start() throws Exception {
        this.TIMEOUT = new DelTempFileThread(this.copyAllFiles, this.ondemandManager);
        if (this.booleanValue != null) {
            this.addRecord = ServerEnv.mustSendConcurrentReports();
            if (this.addRecord && JRTask.getMaxReports() == 0 && !ServerEnv.updateReportsImmediately()) {
                this.addFailedTaskToMonitor = new SendConcurrentReportsThread(this);
            }
        }
        try {
            SchdTools.setMailConfig(SchdTools.loadMailConfig());
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(600029, 3);
            ServiceLogger.logError(throwable);
        }
        this.addTask = ServerEnv.getQueueSize();
        if (this.addTask > 0) {
            this.canRunReport = (this.addTask + 15) * 4;
            this.addRunningTaskToMonitor = new ThreadQueueController(this.addTask);
        } else {
            this.addRunningTaskToMonitor = null;
        }
        Tracker.getInstance().init(this.addRunningTaskToMonitor, this.canCancelRecoveryTask, this.addFinishedTask == null ? false : this.addFinishedTask.isAdmin(), this.booleanValue);
        if (System.getProperty("com.jinfonet.securityContextFactory") != null) {
            try {
                this.clone = (SecurityContextFactory)Class.forName(System.getProperty("com.jinfonet.securityContextFactory")).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        if (ServerEnv.isEnableTaskDuration() && ServerEnv.getTimeoutsCheckCycle() > 0) {
            this.containsKey = new DurationCheckingThread(this);
        }
        this.addRunningTask = true;
    }

    public void quit() throws Exception {
        this.stop();
        if (this.addElement != null) {
            String string;
            String string2;
            SchdTools.deleteTempFiles(this.addElement.getTempDir());
            String string3 = ServerEnv.getReportHome();
            if (!string3.endsWith(File.separator)) {
                string2 = string3 + File.separator + "temp" + File.separator + "convertFiles";
                string = string3 + File.separator + "temp" + File.separator + "runingConvertFiles";
            } else {
                string2 = string3 + "temp" + File.separator + "convertFiles";
                string = string3 + "temp" + File.separator + "runingConvertFiles";
            }
            SchdTools.deleteTempFilesWithSubFolders(string2);
            SchdTools.deleteTempFilesWithSubFolders(string);
        }
        this.lrptMan = null;
        this.ravtLsn = null;
        this.addElement = null;
        this.booleanValue = null;
        if (this.J != null) {
            this.J = null;
        }
        this.addFinishedTask = null;
        this.addFinishedTaskToMonitor = null;
        this.cancelTask = null;
        this.ondemandManager = null;
        if (this.addFailedTaskToMonitor != null) {
            this.addFailedTaskToMonitor.clearMem();
            this.addFailedTaskToMonitor = null;
        }
        if (this.currentThread != null) {
            this.currentThread.quit();
        }
        Tracker.getInstance().release();
        UnicastRemoteObject.unexportObject(this.close, true);
        this.addRunningTask = false;
    }

    public void stop() throws Exception {
        this.TIMEOUT.stopRun();
        this.convertEscapes.I();
        this.addFailedTask.destroy();
        if (this.containsKey != null) {
            this.containsKey.stopRun();
        }
        if (this.addFailedTaskToMonitor != null) {
            this.addFailedTaskToMonitor.stop();
        }
        if (this.addRunningTask) {
            this.addRunningTask = false;
        }
        if (this.TIMEOUT != null && this.TIMEOUT.isAlive()) {
            try {
                this.TIMEOUT.stop();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        this.addFailedTask = null;
        this.TIMEOUT = null;
    }

    public String runTask(String string, Properties properties) throws Exception {
        properties.put("TS_tsk_submit", new Long(System.currentTimeMillis()));
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        if (properties.getProperty("jrs.task_class").equals("jet.server.schedule.jrtasks.PublishRptTask")) {
            String string2 = properties.getProperty("jrs.cmd");
            SchdTools.removeUnusedTaskProps(properties);
            if (string2 != null) {
                properties.put("jrs.cmd", string2);
            }
        }
        return this.runTask(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runTask(Properties properties) throws Exception {
        Object object;
        if (!properties.containsKey("TS_tsk_submit")) {
            properties.put("TS_tsk_submit", new Long(System.currentTimeMillis()));
        }
        String string = null;
        boolean bl = JRSchedulingService.isInternalTaskIntf(properties);
        String string2 = null;
        if (!bl) {
            string2 = String.valueOf(Tracker.getSequenceId());
            properties.put("sequence_ID", string2);
        }
        String string3 = properties.getProperty("jrs.report");
        boolean bl2 = CSUtil.getBoolean(properties.getProperty("jrs.is_bursting_task"), false);
        boolean bl3 = properties.getProperty("jrs.task_class").equals(APIConst.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME);
        Hashtable hashtable = this.addClusterListener;
        synchronized (hashtable) {
            if (this.canRunReport > 0 && this.addClusterListener.size() >= this.canRunReport) {
                string = (String)properties.get("jrs.task_id");
                if (string == null) {
                    string = SchdTools.getIdBase();
                }
                properties.put("jrs.task_id", string);
                this.canCancelRecoveryTask.put(properties);
                if (!bl3 && !bl) {
                    this.addWaitingTaskToMonitor(string2, string, string3, bl2 ? 3 : 2, ServerEnv.getHostName(), System.currentTimeMillis(), properties.getProperty("jrs.catalog"), properties.getProperty("jrs.uid"), 2);
                }
            } else {
                object = this.J(properties);
                if (!bl3 && !bl) {
                    this.addWaitingTaskToMonitor(string2, ((LaunchableObj)object).getTask().getId(), string3, bl2 ? 3 : 2, ServerEnv.getHostName(), System.currentTimeMillis(), properties.getProperty("jrs.catalog"), properties.getProperty("jrs.uid"), 1);
                }
                ((LaunchableObj)object).setUid((String)properties.get("jrs.uid"));
                ((LaunchableObj)object).addTerminationListener(this);
                Thread thread = new Thread((Runnable)object);
                this.addClusterListener.put(object, thread);
                thread.start();
                this.addFailedTaskToMonitor(object);
                string = ((LaunchableObj)object).getTask().getId();
            }
        }
        object = (String)properties.get("jrs.cmd");
        if (object != null && ((String)object).equalsIgnoreCase("jrs.run_task")) {
            this.TIMEOUT(string);
            while (!this.addClusterListener(string)) {
                Thread.yield();
                Thread.sleep(1000L);
            }
            this.add(string);
        }
        return string;
    }

    private LaunchableObj J(Properties properties) throws Exception {
        TaskIntf taskIntf = (TaskIntf)this.makeTask(properties);
        if (taskIntf == null) {
            throw new Exception(JCliResource.getMessage("CS_ERR_54") + " " + this.addClusterListener);
        }
        LaunchableObj launchableObj = new LaunchableObj(taskIntf, 0L);
        String string = (String)properties.get("jrs.launch_type");
        int n = string == null ? 0 : CSUtil.parseInt(string);
        launchableObj.setLaunchType(n);
        return launchableObj;
    }

    private String QOIV(String string, String string2, String string3, ViewRptTask viewRptTask, RunRptThread runRptThread, Hashtable hashtable, boolean bl) throws Exception {
        int n;
        String string4 = viewRptTask.getId();
        String string5 = (String)viewRptTask.getValue("rstName");
        this.prepareRslt(string5);
        int n2 = CSUtil.getResultType((String)hashtable.get("jrs.result_type"), -1);
        String string6 = null;
        if (n2 == 0) {
            string6 = this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME(string2, string3, string5, hashtable);
        }
        Properties properties = null;
        properties = new Properties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string7 = (String)enumeration.nextElement();
            if (!string7.startsWith("jrs.param$")) continue;
            properties.put(string7, hashtable.get(string7));
        }
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.auto_archive"));
        int n3 = CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), -1);
        if (n3 == -1 && string2 != null) {
            n3 = this.addElement.getLatestVersionNumber(string2);
        }
        if ((n = CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), -1)) == -1) {
            n = this.addElement.getLatestVersionNumber(string3);
        }
        String string8 = (String)hashtable.get("jrs.result");
        JRReportSheetInfo jRReportSheetInfo = null;
        Enumeration enumeration2 = viewRptTask.getRunningReportSheets().getAllReportSheets();
        if (enumeration2 != null && enumeration2.hasMoreElements()) {
            String string9 = (String)enumeration2.nextElement();
            jRReportSheetInfo = new JRReportSheetInfo(string9, viewRptTask.getRunningReportSheets().getReportSheetDisplayName(string9), null);
        } else {
            jRReportSheetInfo = new JRReportSheetInfo(viewRptTask.getReport(), null, null);
        }
        int n4 = APIUtil.parseInt("" + hashtable.get("jrs.result_type"));
        String string10 = this.ondemandManager.registerOndemandReport(string4, string, string2, n3, string3, jRReportSheetInfo, n, properties, string6, !bl2, string5, string8, n4);
        viewRptTask.setOndemandID(string10);
        if (string10 != null) {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.ondemandManager.getOndemandReportRecord(string10);
            if (jROndemandReportRecord != null) {
                jROndemandReportRecord.setEngineErrors(viewRptTask.getEngineErrors());
            }
            this.QOIV.put(string10, viewRptTask);
            if (runRptThread != null) {
                this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.put(string10, runRptThread);
            }
        }
        if (bl) {
            this.lrptMan.registerLargeReport(string, string2, string3, string5, properties, string6, runRptThread, viewRptTask);
            this.lrptMan.removeLargeReportIfTimeout();
        }
        return string10;
    }

    public String runReport(String string, String string2, String string3, Properties properties) throws TooManyReportsException, Throwable {
        Properties properties2 = this.addElement(string, string2, string3, properties);
        String string4 = properties2.getProperty("jrs.result_loca");
        if (string4 == null || string4.trim().length() == 0) {
            properties2.put("jrs.result_loca", this.getTempDir());
            properties2.put("jrs.result_loca_type", String.valueOf(1));
        }
        properties2.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ViewRptTask == null ? (class$jet$server$schedule$jrtasks$ViewRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewRptTask")) : class$jet$server$schedule$jrtasks$ViewRptTask).getName());
        String string5 = String.valueOf(Tracker.getSequenceId());
        properties2.put("sequence_ID", string5);
        ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties2);
        if (viewRptTask != null) {
            List list;
            viewRptTask.setJRTaskManager(this);
            String string6 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string7 = new File(string6).getName();
            viewRptTask.putValue("rstName", string7);
            this.addWaitingTaskToMonitor(string5, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
            viewRptTask.setThrow(true);
            this.QOIV(string, string2, string3, viewRptTask, null, properties, false);
            viewRptTask.runReport();
            this.ravtLsn.terminated(viewRptTask);
            if (viewRptTask.hasError()) {
                String string8 = viewRptTask.getErrorMsg();
                List list2 = viewRptTask.getEngineErrors();
                Throwable throwable = viewRptTask.getThrdThrow();
                viewRptTask = null;
                throw new RptServerException(string8, throwable, list2);
            }
            if (string6 != null && (list = viewRptTask.getEngineErrors()) != null && list.size() > 0) {
                this.convertEscapes.I(string6, list);
            }
            viewRptTask = null;
            return string6;
        }
        return null;
    }

    public String runReportNotWaitResult(String string, String string2, String string3, Properties properties) throws RptServerException, TooManyReportsException {
        String string4;
        Properties properties2 = this.addElement(string, string2, string3, properties);
        String string5 = null;
        if (CSUtil.getBoolean((String)properties2.get("jrs.auto_archive"))) {
            properties2.put("jrs.archive_specified_destination", this.addElement.getRemoteHistDir());
            properties2.put("jrs.result_loca", this.addElement.getArchivePath(string));
            properties2.put("jrs.result_loca_type", String.valueOf(1));
        } else {
            string4 = properties2.getProperty("jrs.result_loca");
            if (string4 == null || string4.trim().length() == 0) {
                properties2.put("jrs.result_loca", this.getTempDir());
                properties2.put("jrs.result_loca_type", String.valueOf(1));
            }
        }
        properties2.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ViewRptTask == null ? (class$jet$server$schedule$jrtasks$ViewRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewRptTask")) : class$jet$server$schedule$jrtasks$ViewRptTask).getName());
        string4 = String.valueOf(Tracker.getSequenceId());
        properties2.put("sequence_ID", string4);
        try {
            Object object;
            ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties2);
            String string6 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string7 = new File(string6).getName();
            viewRptTask.putValue("rstName", string7);
            boolean bl = CSUtil.getBoolean((String)properties2.get("isWait"), false);
            if (viewRptTask != null) {
                viewRptTask.setJRTaskManager(this);
                this.addWaitingTaskToMonitor(string4, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
                viewRptTask.setWait(bl);
                object = new RunRptThread(this, viewRptTask);
                this.QOIV(string, string2, string3, viewRptTask, (RunRptThread)object, properties, false);
                ((Thread)object).start();
                string5 = string6;
            }
            if (string6 != null && (object = viewRptTask.getEngineErrors()) != null && object.size() > 0) {
                this.convertEscapes.I(string6, (List)object);
            }
            return string5;
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public long runTestReport(Properties properties) throws Exception {
        String string = properties.getProperty("jrs.result_loca");
        if (string == null || string.trim().length() == 0) {
            properties.put("jrs.result_loca", this.getTempDir());
            properties.put("jrs.result_loca_type", String.valueOf(1));
        }
        properties.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ViewTestRptTask == null ? (class$jet$server$schedule$jrtasks$ViewTestRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewTestRptTask")) : class$jet$server$schedule$jrtasks$ViewTestRptTask).getName());
        String string2 = String.valueOf(Tracker.getSequenceId());
        properties.put("sequence_ID", string2);
        ViewTestRptTask viewTestRptTask = (ViewTestRptTask)this.makeTask(properties);
        viewTestRptTask.setJRTaskManager(this);
        this.addWaitingTaskToMonitor(string2, viewTestRptTask.getId(), viewTestRptTask.getReport(), 1, ServerEnv.getHostName(), System.currentTimeMillis(), viewTestRptTask.getCatalog(), viewTestRptTask.getUid(), 1);
        viewTestRptTask.setThrow(true);
        viewTestRptTask.runReport();
        if (viewTestRptTask.hasError()) {
            throw new Exception(viewTestRptTask.getErrorMsg(), viewTestRptTask.getThrdThrow());
        }
        return viewTestRptTask.getRunTime();
    }

    public void copyAllFiles(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                Object object;
                Object object2;
                if (!fileArray[n].isDirectory()) {
                    object2 = new FileInputStream(fileArray[n].toString());
                    object = new FileOutputStream(string2 + File.separator + fileArray[n].getName());
                    byte[] byArray = new byte[((FileInputStream)object2).available()];
                    ((FileInputStream)object2).read(byArray);
                    ((FileOutputStream)object).write(byArray);
                    ((FileInputStream)object2).close();
                    ((FileOutputStream)object).close();
                } else {
                    object2 = string2 + File.separator + fileArray[n].getName();
                    object = new File((String)object2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdir();
                    }
                    this.copyAllFiles(fileArray[n].getPath(), (String)object2);
                }
                ++n;
            }
        }
    }

    private String TASK_PUBLISH_ANALYSIS_DISPLAY_NAME(String string, String string2, String string3, Hashtable hashtable) {
        boolean bl;
        String string4;
        String string5 = null;
        string5 = "jrs.result_type=0";
        int n = CSUtil.parseInt((String)hashtable.get("jrs.applet_type"), -1);
        if (n >= 0) {
            string5 = string5 + "&jrs.applet_type=" + n;
        }
        if ((string4 = (String)hashtable.get("jrs.frameapplet")) != null) {
            string5 = string5 + "&jrs.frameapplet=" + string4;
        }
        if (bl = APIUtil.getBoolean((String)hashtable.get("jrs.isjrsapltpg"), false)) {
            string5 = string5 + "&jrs.isjrsapltpg=" + bl;
        }
        string5 = string5 + "&jrs.catalog=" + string;
        string5 = string5 + "&jrs.report=" + string2;
        string5 = string5 + "&jrs.temp_file=" + string3;
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runReportWithTimeouts(String string, String string2, String string3, Properties properties, long l) throws RptServerException, TooManyReportsException, Throwable {
        String string4;
        Properties properties2 = this.addElement(string, string2, string3, properties);
        if (CSUtil.getBoolean((String)properties.get("jrs.auto_archive"))) {
            properties.put("jrs.archive_specified_destination", this.addElement.getRemoteHistDir());
            properties.put("jrs.result_loca", this.addElement.getArchivePath(string));
            properties.put("jrs.result_loca_type", String.valueOf(1));
        } else {
            string4 = properties2.getProperty("jrs.result_loca");
            if (string4 == null || string4.trim().length() == 0) {
                properties2.put("jrs.result_loca", this.getTempDir());
                properties2.put("jrs.result_loca_type", String.valueOf(1));
            }
        }
        properties.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ViewRptTask == null ? (class$jet$server$schedule$jrtasks$ViewRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewRptTask")) : class$jet$server$schedule$jrtasks$ViewRptTask).getName());
        string4 = String.valueOf(Tracker.getSequenceId());
        properties.put("sequence_ID", string4);
        ViewRptTask viewRptTask = (ViewRptTask)this.makeTask(properties);
        if (viewRptTask != null) {
            Object object;
            viewRptTask.setJRTaskManager(this);
            String string5 = viewRptTask.getResultType() == 1 ? viewRptTask.getHtmlResult() : viewRptTask.getResult();
            String string6 = new File(string5).getName();
            viewRptTask.putValue("rstName", string6);
            this.addWaitingTaskToMonitor(string4, viewRptTask.getId(), string3, 1, ServerEnv.getHostName(), System.currentTimeMillis(), string2, string, 1);
            viewRptTask.setStatus("Wait in queue");
            long l2 = (Long)viewRptTask.getValue("jrs.task_duration");
            if (ServerEnv.isEnableTaskDuration() && l2 > 0L && (l2 < l || l <= 0L)) {
                viewRptTask.setThrow(true);
                object = new RunRptThread(this, viewRptTask);
                String string7 = this.QOIV(string, string2, string3, viewRptTask, (RunRptThread)object, properties, true);
                ((Thread)object).start();
                Object object2 = object;
                synchronized (object2) {
                    object.wait(l2 < 250L ? 250L : l2);
                    Thread.yield();
                }
                if (!((RunRptThread)object).I()) {
                    String string8;
                    boolean bl;
                    ((RunRptThread)object).setSendEmail(true);
                    OndemandReportRecord ondemandReportRecord = this.ondemandManager.getOndemandReportRecord(string7);
                    viewRptTask.setHandledDuration(true);
                    boolean bl2 = (Boolean)viewRptTask.getValue("jrs.auto_cancel_task");
                    if (bl2) {
                        this.addFinishedTaskToMonitor(viewRptTask, (RunRptThread)object);
                        ((JROndemandReportRecord)ondemandReportRecord).setDuration(l2);
                        ((JROndemandReportRecord)ondemandReportRecord).setCancelled(true);
                        ServiceLogger.logEvent("Cancelled ondemand report: " + viewRptTask.getReport() + ", catalog: " + viewRptTask.getCatalog() + ", started time: " + new Date(ondemandReportRecord.getStartedTime()));
                    }
                    if ((bl = ((Boolean)viewRptTask.getValue("jrs.need_notify_duration")).booleanValue()) && (string8 = (String)viewRptTask.getValue("jrs.duration_notify_mail")) != null && string8.length() > 0) {
                        String string9 = " Task Type: Ondemand Run\nTask ID: " + viewRptTask.getId() + "\nReport: " + viewRptTask.getReport() + "\nCatalog:" + viewRptTask.getCatalog() + "\nTask Status: " + viewRptTask.getStatus() + "\nTask Start Time: " + new Date(ondemandReportRecord.getStartedTime()) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
                        CSMail cSMail = new CSMail(string8, null, null, "Task Timeout Notification", string9, false);
                        viewRptTask.execTimeoutNotification(cSMail);
                    }
                    throw new JRTaskCancellationException("Task cancelled", viewRptTask);
                }
                if (((RunRptThread)object).Z() != null) {
                    throw ((RunRptThread)object).Z();
                }
                object = null;
            } else if (l > 0L) {
                viewRptTask.setThrow(true);
                object = new RunRptThread(this, viewRptTask);
                Object object3 = new Object();
                ((RunRptThread)object).setMonitorObject(object3);
                String string10 = this.QOIV(string, string2, string3, viewRptTask, (RunRptThread)object, properties, true);
                ((Thread)object).start();
                Object object4 = object3;
                synchronized (object4) {
                    object3.wait(l < 1000L ? 1000L : l);
                }
                if (!((RunRptThread)object).I()) {
                    ((RunRptThread)object).setSendEmail(true);
                    throw new JRRunReportTimeoutException(string5, (Thread)object, viewRptTask);
                }
                if (((RunRptThread)object).Z() != null) {
                    throw ((RunRptThread)object).Z();
                }
                object = null;
            } else {
                viewRptTask.setThrow(true);
                viewRptTask.runReport();
                this.ravtLsn.terminated(viewRptTask);
            }
            if (viewRptTask.hasError()) {
                throw new RptServerException(viewRptTask.getErrorMsg(), viewRptTask.getThrdThrow(), viewRptTask.getEngineErrors());
            }
            if (CSUtil.getBoolean((String)properties.get("jrs.auto_archive"))) {
                this.copyAllFiles((String)properties.get("jrs.result_loca"), this.getTempDir());
            }
            if (string5 != null && (object = viewRptTask.getEngineErrors()) != null && object.size() > 0) {
                this.convertEscapes.I(string5, (List)object);
            }
            return string5;
        }
        viewRptTask = null;
        return null;
    }

    public String exportResultToOneFormat(String string, String string2, Properties properties) throws RptServerException {
        if (properties == null || string2 == null) {
            return null;
        }
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        File file = new File(string2);
        try {
            if (file.exists()) {
                return this.exportResultInAType(file.getCanonicalPath(), properties);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new RptServerException(throwable);
        }
        return null;
    }

    public String exportResultInAType(String string, Properties properties) throws Throwable {
        if (properties == null || string == null) {
            return null;
        }
        properties.put("jrs.result", string);
        properties.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ExportInATypeTask == null ? (class$jet$server$schedule$jrtasks$ExportInATypeTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ExportInATypeTask")) : class$jet$server$schedule$jrtasks$ExportInATypeTask).getName());
        properties.put("exportResultInAType", String.valueOf(true));
        ExportInATypeTask exportInATypeTask = (ExportInATypeTask)this.makeTask(properties);
        if (exportInATypeTask != null) {
            exportInATypeTask.setThrow(true);
            exportInATypeTask.export();
            return exportInATypeTask.getResultName();
        }
        return null;
    }

    public ExportedFileList exportResult(String string, String string2, Properties properties) throws RptServerException {
        if (properties == null || string2 == null) {
            return null;
        }
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        JRExportedFileList jRExportedFileList = null;
        File file = new File(string2);
        try {
            if (file.exists()) {
                properties.put("jrs.result", file.getCanonicalPath());
                properties.put("jrs.task_class", (class$jet$server$schedule$jrtasks$ExportTask == null ? (class$jet$server$schedule$jrtasks$ExportTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ExportTask")) : class$jet$server$schedule$jrtasks$ExportTask).getName());
                ExportTask exportTask = (ExportTask)this.makeTask(properties);
                if (exportTask != null) {
                    exportTask.setThrow(true);
                    exportTask.export();
                    Object[] objectArray = exportTask.getExportList();
                    if (objectArray != null) {
                        jRExportedFileList = new JRExportedFileList(objectArray);
                    }
                }
            }
            return jRExportedFileList;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new RptServerException(throwable);
        }
    }

    public Vector getActiveTasks() {
        Vector<LaunchableObj> vector = new Vector<LaunchableObj>();
        Enumeration enumeration = this.addClusterListener.keys();
        while (enumeration.hasMoreElements()) {
            LaunchableObj launchableObj = (LaunchableObj)enumeration.nextElement();
            if (launchableObj == null) continue;
            vector.addElement(launchableObj);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminated(Object object) throws Exception {
        TaskIntf taskIntf = null;
        if (object instanceof LaunchableObj) {
            boolean bl;
            Object object2;
            Hashtable hashtable = this.addClusterListener;
            synchronized (hashtable) {
                this.addClusterListener.remove(object);
                if (this.canRunReport > 0) {
                    this.addFinishedTask();
                }
            }
            LaunchableObj launchableObj = (LaunchableObj)object;
            int n = launchableObj.getLaunchType();
            taskIntf = launchableObj.getTask();
            int n2 = -1;
            if (taskIntf instanceof UpdateRptTask) {
                n2 = ((UpdateRptTask)taskIntf).getVersionID();
            } else if (taskIntf instanceof PublishRptTask) {
                n2 = ((PublishRptTask)taskIntf).getVersionID();
            }
            String string = taskIntf.getId();
            this.add(string);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = "";
            String string7 = null;
            String string8 = "";
            long[] lArray = null;
            Hashtable hashtable2 = null;
            boolean bl2 = false;
            if (taskIntf instanceof RunRptTaskRoot) {
                string2 = ((RunRptTaskRoot)taskIntf).getEngMsgs();
                string3 = ((RunRptTaskRoot)taskIntf).getTaskName();
                string4 = ((RunRptTaskRoot)taskIntf).getCatalog();
                string5 = ((RunRptTaskRoot)taskIntf).getReport();
                object2 = ((RunRptTaskRoot)taskIntf).getRunningReportSheets().getAllReportSheets();
                if (object2 != null) {
                    while (object2.hasMoreElements()) {
                        string6 = string6 + ((RunRptTaskRoot)taskIntf).getRunningReportSheets().getReportSheetDisplayName((String)object2.nextElement());
                        if (!object2.hasMoreElements()) continue;
                        string6 = string6 + ",";
                    }
                } else {
                    string6 = ((RunRptTaskRoot)taskIntf).getCurrentReport();
                }
                string7 = (String)taskIntf.getValue("jrs.param_file");
                if (string7 == null) {
                    string7 = ((RunRptTaskRoot)taskIntf).getParamFile();
                }
                if (taskIntf instanceof RunRptTask) {
                    int n3 = -1;
                    bl = false;
                    if (taskIntf instanceof UpdateRptTask) {
                        bl = true;
                    } else if (((RunRptTask)taskIntf).isWillPublishToVersion) {
                        bl = true;
                    }
                    lArray = ((RunRptTask)taskIntf).getSuccInfo();
                    string8 = string8 + ((RunRptTask)taskIntf).getToDiskFiles();
                    hashtable2 = ((RunRptTask)taskIntf).getPublishRecords();
                    bl2 = ((RunRptTask)taskIntf).isMissed();
                }
            } else if (taskIntf instanceof UserTaskProxy) {
                string3 = ((UserTaskProxy)taskIntf).getTaskName();
                string4 = ((UserTaskProxy)taskIntf).getCatalog();
                string5 = ((UserTaskProxy)taskIntf).getReport();
                string7 = ((UserTaskProxy)taskIntf).getParamFile();
            }
            if (!(taskIntf instanceof InternalTask)) {
                String string9;
                object2 = new Date();
                String string10 = "";
                if (launchableObj.getTask() instanceof RunRptTaskRoot) {
                    string10 = ((RunRptTaskRoot)launchableObj.getTask()).getUid();
                }
                bl = !taskIntf.hasError() && !launchableObj.hasError();
                String string11 = taskIntf.getErrorMsg();
                String string12 = launchableObj.getMessage();
                if (string11 == null) {
                    string11 = string12;
                } else if (string12 != null) {
                    string11 = string11 + "\n\r" + string12;
                }
                String string13 = taskIntf.getClass().getName();
                if (taskIntf instanceof UserTaskProxy) {
                    string10 = ((UserTaskProxy)taskIntf).getUid();
                    string13 = ((UserTaskProxy)taskIntf).getTaskClass();
                }
                String string14 = ((Date)object2).getTime() + "-" + SchdTools.random.nextInt();
                JRTask jRTask = (JRTask)taskIntf;
                String string15 = null;
                if (bl && jRTask.getSuccessNotify()) {
                    string15 = ((JRTask)taskIntf).execNotification(bl, string11, string, string4, string5, (Date)object2);
                } else if (!bl && jRTask.getFailNotify()) {
                    string15 = ((JRTask)taskIntf).execNotification(bl, string11, string, string4, string5, (Date)object2);
                }
                if (string15 != null) {
                    string11 = string11 == null ? string15 : string11 + "\n\r" + string15;
                }
                if (taskIntf.hasError() || string11 != null && string11.trim().length() != 0) {
                    if (((JRTask)taskIntf).getThrowable() != null) {
                        this.copyAllFiles.handleThrowable(((JRTask)taskIntf).getThrowable());
                    }
                    string9 = null;
                    if (taskIntf instanceof RunRptTaskRoot) {
                        string9 = ((RunRptTaskRoot)taskIntf).getSequenceID();
                    }
                    this.addFailedTaskToMonitor(string9, string, string11 == null ? "null" : string11);
                }
                string9 = string7;
                if (string7 != null) {
                    int n4 = string7.lastIndexOf(File.separator);
                    string9 = string7.substring(n4 + 1);
                }
                String string16 = (String)taskIntf.getValue("jrs.triggers");
                String string17 = (String)taskIntf.getValue("jrs.triggers.logic");
                try {
                    if (ServerEnv.isWriteCompletedInQueue()) {
                        TableProxy tableProxy = new TableProxy();
                        tableProxy.setProxyObject(this.J.getCompletedTable());
                        tableProxy.setProxyMethod("addRecord");
                        tableProxy.setArguments(new Object[]{string, string4, string5, string9, string8, object2, string10, new Boolean(bl), lArray, string11, string13, new Integer(n2), string14, new Integer(n), string2, string3, new Boolean(bl2), string16, string17, hashtable2, string6});
                        TableProxyExecutorQueueFactory.getQueue().enqueue(tableProxy, 0);
                    } else {
                        this.J.getCompletedTable().addRecord(string, string4, string5, string9, string8, (Date)object2, string10, bl, lArray, string11, string13, n2, string14, n, string2, string3, bl2, string16, string17, hashtable2, string6);
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                this.class$.setLastSuccess(string, bl);
            }
        }
        if (object == null || !(object instanceof Launchable)) {
            return;
        }
        if (taskIntf != null) {
            this.sendTaskContext(taskIntf);
            taskIntf = null;
        }
    }

    private void TIMEOUT(String string) {
        if (string != null && string.length() > 0) {
            this.add.put(string, new Date());
        }
    }

    private void add(String string) {
        if (string != null && string.length() > 0) {
            this.add.remove(string);
        }
    }

    private boolean addClusterListener(String string) {
        Object var2_2 = null;
        if (string != null && string.length() > 0) {
            var2_2 = this.add.get(string);
        }
        return var2_2 == null;
    }

    public boolean isRunningQueue() {
        if (this.addRunningTaskToMonitor == null) {
            return false;
        }
        return this.addRunningTaskToMonitor.getActiveAndWaitReportsCount() < JRTask.getMaxReports() || ServerEnv.isSpecialUser();
    }

    public synchronized boolean isTaskQueueFull(int n) {
        if (this.addRunningTaskToMonitor == null) {
            return false;
        }
        return this.addRunningTaskToMonitor.isTaskQueueFull(n);
    }

    public synchronized boolean canRunReport() {
        return this.canRunReport(null);
    }

    public boolean canRunReport(RunRptTaskRoot runRptTaskRoot) {
        if (this.addRunningTaskToMonitor == null) {
            if (JRTask.getMaxReports() <= 0 || this.clearMem < JRTask.getMaxReports()) {
                return true;
            }
            ServiceLogger.logError(3600163, 3);
            return false;
        }
        if (!ServerEnv.isSpecialUser()) {
            return true;
        }
        ServiceLogger.logDebug(6600109, new Object[]{String.valueOf(this.addRunningTaskToMonitor.isFullActive()), String.valueOf(this.addRunningTaskToMonitor.getActiveAndWaitReportsCount())}, 6);
        if (!this.addRunningTaskToMonitor.isFullActive()) {
            return true;
        }
        if (runRptTaskRoot instanceof ViewRptTask && !((RunRptTask)runRptTaskRoot).isWait()) {
            ServiceLogger.logError(3600163, 3);
            ServiceLogger.logError(3600164, String.valueOf(this.addRunningTaskToMonitor.getActiveAndWaitReportsCount()), 3);
            return false;
        }
        if (JRTask.getMaxReports() <= 0 || this.addRunningTaskToMonitor.getActiveAndWaitReportsCount() < JRTask.getMaxReports()) {
            return true;
        }
        if (runRptTaskRoot instanceof ViewRptTask && ((RunRptTask)runRptTaskRoot).isWait()) {
            return true;
        }
        try {
            Thread.sleep(600000L);
            ServiceLogger.logDebug(6600110, 4);
        }
        catch (InterruptedException interruptedException) {
            ServiceLogger.logError(interruptedException, 3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incThreadQueueController(ThreadQueueElement[] threadQueueElementArray) {
        int n = 0;
        if (this.addRunningTaskToMonitor != null) {
            n = this.addRunningTaskToMonitor.queueUp(threadQueueElementArray);
        } else {
            n = threadQueueElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                threadQueueElementArray[n2].enqueue();
                ++n2;
            }
        }
        if (n > 0) {
            Vector vector = this.addTerminationListener;
            synchronized (vector) {
                this.clearMem += n;
            }
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incThreadQueueController(ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        if (this.addRunningTaskToMonitor != null) {
            bl = this.addRunningTaskToMonitor.queueUp(threadQueueElement);
        } else {
            threadQueueElement.enqueue();
            bl = true;
        }
        if (bl) {
            Vector vector = this.addTerminationListener;
            synchronized (vector) {
                ++this.clearMem;
            }
        }
        return bl;
    }

    protected void sendConcurrentReports() {
        try {
            this.addFinishedTaskToMonitor.modifyConcurrentReports(this.addFinishedTask);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void incRptSetEngineRef(Object object) {
        if (object != null) {
            this.addWaitingTask.add(object);
        }
    }

    public void incRptEngineRef(Object object) {
        if (object != null) {
            this.addTerminationListener.addElement(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConCurrentReports() {
        Vector vector = this.addTerminationListener;
        synchronized (vector) {
            int n = this.clearMem;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRptTaskRef(Object object) {
        Vector vector = this.addWaitingTaskToMonitor;
        synchronized (vector) {
            if (object != null) {
                this.addWaitingTaskToMonitor.addElement(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptTaskRef(Object object) {
        Vector vector = this.addWaitingTaskToMonitor;
        synchronized (vector) {
            if (object != null) {
                this.addWaitingTaskToMonitor.removeElement(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskIntf getTask(String string) {
        Vector vector = this.addWaitingTaskToMonitor;
        synchronized (vector) {
            int n = this.addWaitingTaskToMonitor.size();
            int n2 = 0;
            while (n2 < n) {
                TaskIntf taskIntf = (TaskIntf)this.addWaitingTaskToMonitor.elementAt(n2);
                if (taskIntf instanceof RunRptTaskRoot && ((RunRptTaskRoot)taskIntf).getRunTaskId().equals(string)) {
                    return (RunRptTaskRoot)taskIntf;
                }
                if (taskIntf instanceof TaskIntf && ((TaskIntf)taskIntf).getId().equals(string)) {
                    return taskIntf;
                }
                ++n2;
            }
            return null;
        }
    }

    public List getEngineErrors(String string) {
        List list = null;
        if (string != null) {
            list = this.convertEscapes.I(string);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptSetEngineRef(Object object) {
        if (object != null) {
            JREngine jREngine = null;
            if (object instanceof JREngineContext) {
                jREngine = ((JREngineContext)object).getJREngine();
            }
            if (jREngine != null) {
                Vector vector = this.addWaitingTask;
                synchronized (vector) {
                    this.addWaitingTask.remove(jREngine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRptEngineRef(Object object, ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        if (this.addRunningTaskToMonitor != null) {
            int n = threadQueueElement.getStatus();
            if (n == 3 || n == 1 || n == 2) {
                if (n == 3) {
                    bl = true;
                }
                this.addRunningTaskToMonitor.notifyRelease(threadQueueElement);
            }
        } else {
            if (threadQueueElement.getStatus() == 3) {
                bl = true;
            }
            threadQueueElement.dequeue();
        }
        if (object != null) {
            ReportEngineAPI reportEngineAPI = null;
            if (object instanceof JRReportEngine) {
                reportEngineAPI = ((JRReportEngine)object).getReportEngineAPI();
            }
            if (reportEngineAPI != null) {
                Vector vector = this.addTerminationListener;
                synchronized (vector) {
                    if (this.addTerminationListener.removeElement(reportEngineAPI)) {
                        --this.clearMem;
                        if (this.booleanValue != null && this.addRecord) {
                            this.addFinishedTask.setConcurrentReports(this.clearMem);
                            if (this.addFailedTaskToMonitor == null) {
                                this.sendConcurrentReports();
                            } else {
                                this.addFailedTaskToMonitor.decreaseReports();
                            }
                        }
                    }
                }
            }
        } else if (bl) {
            Vector vector = this.addTerminationListener;
            synchronized (vector) {
                --this.clearMem;
                if (this.booleanValue != null && this.addRecord) {
                    this.addFinishedTask.setConcurrentReports(this.clearMem);
                    if (this.addFailedTaskToMonitor == null) {
                        this.sendConcurrentReports();
                    } else {
                        this.addFailedTaskToMonitor.decreaseReports();
                    }
                }
            }
        }
    }

    public ThreadQueueController getThreadQueueController() {
        return this.addRunningTaskToMonitor;
    }

    public void afterLoadReport(ReportEngine reportEngine) {
    }

    public void addPipelineFilenames(String string, HtmlPipeFileNames htmlPipeFileNames) {
        if (string != null && string.length() > 0) {
            this.append.put(string, htmlPipeFileNames);
        }
    }

    public void removePipelineFilenames(String string) {
        if (string != null && string.length() > 0) {
            this.append.remove(string);
        }
    }

    public String getFilenames(String string, int n) {
        HtmlPipeFileNames htmlPipeFileNames;
        String string2 = null;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.append.get(string)) != null) {
            string2 = htmlPipeFileNames.getFilename(n);
        }
        return string2;
    }

    public boolean canAutoRefresh(String string) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.append.get(string)) != null) {
            return htmlPipeFileNames.canAutoRefresh();
        }
        return false;
    }

    public boolean isHtmlPipeLine(String string) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.append.get(string)) != null) {
            return htmlPipeFileNames.isHtmlPipeLine();
        }
        return false;
    }

    public void setRefreshed(String string, boolean bl) {
        HtmlPipeFileNames htmlPipeFileNames;
        if (string != null && string.length() > 0 && (htmlPipeFileNames = (HtmlPipeFileNames)this.append.get(string)) != null) {
            htmlPipeFileNames.setRefreshed(bl);
        }
    }

    private Properties addElement(String string, String string2, String string3, Properties properties) throws RptServerException {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (string != null) {
            properties2.put("jrs.uid", string);
        }
        if (string2 != null) {
            properties2.put("jrs.catalog", string2);
        }
        if (string3 != null) {
            properties2.put("jrs.report", string3);
        }
        return properties2;
    }

    public void prepareRslt(String string) {
        this.addFailedTask();
        if (string != null) {
            this.assertCheck.put(string, new TempRstInfo());
        }
    }

    public void completeOndemand(String string) {
        if (string != null) {
            this.ondemandManager.notifyOndemandCompleted(string);
            this.QOIV.remove(string);
            this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRslt(String string, Object object) {
        if (string != null) {
            this.lrptMan.notifyCompleted(string);
            TempRstInfo tempRstInfo = (TempRstInfo)this.assertCheck.get(string);
            if (tempRstInfo != null) {
                TempRstInfo tempRstInfo2 = tempRstInfo;
                synchronized (tempRstInfo2) {
                    tempRstInfo.Z = System.currentTimeMillis();
                    tempRstInfo.C = object;
                }
            }
        }
    }

    public String getRunRptErrMsg(String string) {
        String string2;
        TempRstInfo tempRstInfo;
        String string3 = null;
        if (string != null && (tempRstInfo = (TempRstInfo)this.assertCheck.get(string2 = string)) != null && tempRstInfo.C != null && !(tempRstInfo.C instanceof Boolean)) {
            string3 = tempRstInfo.C.toString();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTempResultReady(String string) {
        String string2;
        TempRstInfo tempRstInfo;
        boolean bl = true;
        if (string != null && (tempRstInfo = (TempRstInfo)this.assertCheck.get(string2 = string)) != null) {
            TempRstInfo tempRstInfo2 = tempRstInfo;
            synchronized (tempRstInfo2) {
                block5: {
                    if (tempRstInfo.Z >= 0L) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        return true;
    }

    public String waitTempResultReady(String string) throws InterruptedException {
        String string2 = string;
        while (!this.isTempResultReady(string)) {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        return this.getRunRptErrMsg(string);
    }

    private void addFailedTask() {
        Enumeration enumeration = this.assertCheck.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            TempRstInfo tempRstInfo = (TempRstInfo)this.assertCheck.get(string);
            if (tempRstInfo == null || System.currentTimeMillis() - tempRstInfo.I <= SchdTools.TIMEOUT) continue;
            this.assertCheck.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(Launchable launchable) {
        if (launchable == null) {
            return false;
        }
        Thread thread = (Thread)this.addClusterListener.get(launchable);
        if (thread == null) {
            return false;
        }
        launchable.setRuntimeErrorHappened();
        launchable.setCanceled();
        launchable.setMessage(JCliResource.getMessage("CS_ERR_52") + "!");
        launchable.beforeStopLaunch(thread);
        thread.interrupt();
        try {
            thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            ServiceLogger.logError(interruptedException, 3);
        }
        if (thread.isAlive()) {
            ServiceLogger.logDebug(5600149, thread.getName(), 5);
            thread.stop();
        } else {
            ServiceLogger.logDebug(5600150, thread.getName(), 5);
        }
        if (this.canRunReport > 0) {
            Hashtable hashtable = this.addClusterListener;
            synchronized (hashtable) {
                this.addFinishedTask();
            }
        }
        return true;
    }

    public Enumeration getAll() {
        return this.addClusterListener.keys();
    }

    public boolean stopActiveTask(String string) {
        return this.stopActiveTask(string, false);
    }

    public boolean stopActiveTask(String string, boolean bl) {
        boolean bl2 = false;
        LaunchableObj launchableObj = null;
        TaskIntf taskIntf = null;
        Enumeration enumeration = this.addClusterListener.keys();
        while (enumeration.hasMoreElements()) {
            launchableObj = (LaunchableObj)enumeration.nextElement();
            taskIntf = launchableObj.getTask();
            if (taskIntf == null || !taskIntf.getId().equals(string)) continue;
            if (taskIntf instanceof RunRptTask && !((RunRptTask)taskIntf).canCancelRecoveryTask() && ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600148, taskIntf.getId(), 6);
            }
            taskIntf.stopExec(bl);
            this.cancelTask(launchableObj);
            bl2 = true;
        }
        return bl2;
    }

    public void checkActiveTaskDuration() {
        Enumeration enumeration = this.addClusterListener.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            boolean bl;
            LaunchableObj launchableObj = (LaunchableObj)enumeration.nextElement();
            TaskIntf taskIntf = launchableObj.getTask();
            if (taskIntf == null) continue;
            long l = launchableObj.getStartTime();
            long l2 = (Long)taskIntf.getValue("jrs.task_duration");
            if (l2 <= 0L || l <= 0L || System.currentTimeMillis() - l <= l2 || ((JRTask)taskIntf).hasHandledDuration()) continue;
            ((JRTask)taskIntf).setHandledDuration(true);
            boolean bl2 = (Boolean)taskIntf.getValue("jrs.auto_cancel_task");
            if (bl2) {
                taskIntf.stopExec();
                this.cancelTask(launchableObj);
                ServiceLogger.logEvent("Cancelled Schedule Task, task ID:" + taskIntf.getId() + ", report: " + ((RunRptTaskRoot)taskIntf).getReport() + ", catalog: " + ((RunRptTaskRoot)taskIntf).getCatalog() + ", started time: " + new Date(l));
            }
            if (!(bl = ((Boolean)taskIntf.getValue("jrs.need_notify_duration")).booleanValue()) || (string = (String)taskIntf.getValue("jrs.duration_notify_mail")) == null || string.length() <= 0) continue;
            String string2 = " Task Type: Schedule Run\nTask ID: " + taskIntf.getId() + "\nReport: " + ((RunRptTaskRoot)taskIntf).getReport() + "\nCatalog:" + ((RunRptTaskRoot)taskIntf).getCatalog() + "\nTask Status: " + ((JRTask)taskIntf).getStatus() + "\nTask Start Time: " + new Date(l) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
            CSMail cSMail = new CSMail(string, null, null, "Task Timeout Notification", string2, false);
            ((JRTask)taskIntf).execTimeoutNotification(cSMail);
        }
    }

    public boolean stopActiveTaskByUser(String string, String string2) {
        boolean bl = false;
        LaunchableObj launchableObj = null;
        TaskIntf taskIntf = null;
        Enumeration enumeration = this.addClusterListener.keys();
        while (enumeration.hasMoreElements()) {
            launchableObj = (LaunchableObj)enumeration.nextElement();
            if (ServerEnv.needSecurity() && !launchableObj.getUid().equalsIgnoreCase(string2) || (taskIntf = launchableObj.getTask()) == null || !taskIntf.getId().equals(string)) continue;
            if (taskIntf instanceof RunRptTask && !((RunRptTask)taskIntf).canCancelRecoveryTask() && ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600148, taskIntf.getId(), 6);
            }
            taskIntf.stopExec();
            this.cancelTask(launchableObj);
            bl = true;
        }
        return bl;
    }

    public synchronized void addStartListener(StartListener startListener) {
        if (!this.available.contains(startListener)) {
            this.available.addElement(startListener);
        }
    }

    public synchronized void removeStartListener(StartListener startListener) {
        this.available.removeElement(startListener);
    }

    private synchronized void addFailedTaskToMonitor(Object object) {
        StartListener startListener = null;
        int n = this.available.size() - 1;
        while (n >= 0) {
            startListener = (StartListener)this.available.elementAt(n);
            startListener.started(object);
            --n;
        }
    }

    public synchronized void addTerminationListener(TerminationListener terminationListener) {
        if (!this.beforeStopLaunch.contains(terminationListener)) {
            this.beforeStopLaunch.addElement(terminationListener);
        }
    }

    public synchronized void removeTerminationListener(TerminationListener terminationListener) {
        this.beforeStopLaunch.removeElement(terminationListener);
    }

    public JRResourceManager getResourceManager() {
        return this.addElement;
    }

    public MonitorThread getMonitorRunning() {
        return this.addFailedTask;
    }

    public void setMonitorRunning(MonitorThread monitorThread) {
        this.addFailedTask = monitorThread;
    }

    public void addMonitorThreadRunningReport(ViewRptTask viewRptTask) {
        if (this.addFailedTask == null) {
            this.addFailedTask = new MonitorThread();
        }
        if (viewRptTask.getCatalog() != null && viewRptTask.getReport() != null) {
            this.addFailedTask.notifyAddRunningReport(viewRptTask.getLaunchType(), viewRptTask.getTaskClass(), new Date(), viewRptTask.getSubmitTime(), viewRptTask.getUid(), viewRptTask.getCatalog(), viewRptTask.getReport(), viewRptTask.getParamFile(), viewRptTask.getId(), viewRptTask.getRunName(), viewRptTask.getRunPort(), viewRptTask.getPublishType());
        }
    }

    public void addMonitorThreadRunningReport(int n, String string, Date date, Date date2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this.getMonitorRunning().notifyAddRunningReport(n, string, date, date2, string2, string3, string4, string5, string6, string7, string8, string9);
    }

    public void delToMonitorRunningReport(String string) {
        if (this.addFailedTask == null) {
            this.addFailedTask = new MonitorThread();
        }
        if (string != null) {
            this.addFailedTask.notifyDelRunningReport(string);
        }
    }

    public void addToMonitorFinishedReport(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, Vector vector, Vector vector2, int n2, String string9, long l, long l2, long l3, long l4, String string10, String string11, String string12) {
        if (this.addFailedTask == null) {
            this.addFailedTask = new MonitorThread();
            this.setMonitorRunning(this.addFailedTask);
        }
        this.addFailedTask.notifyaddFinishedReport(string, string2, n, string3, string4, string5, string6, string7, string8, vector, vector2, n2, string9, l, l2, l3, l4, string10, string11, string12);
    }

    public void notifyAddQueueToMonitor(String string, long l) {
        this.addFailedTask.notifyAddQueueReport(string, l);
    }

    public void notifyAddRunPort(String string, String string2, String string3) {
        this.addFailedTask.notifyAddRunPort(string, string2, string3);
    }

    public Object makeTask(Properties properties) throws Exception {
        Object object;
        Object object2;
        int n;
        String[] stringArray;
        Object object3;
        Object object4;
        Object object5;
        properties = (Properties)properties.clone();
        boolean bl = CSUtil.getBoolean((String)properties.get("exportResultInAType"), false);
        String string = (String)properties.get("jrs.report");
        String string2 = (String)properties.get("jrs.catalog");
        String string3 = properties.getProperty("jrs.uid");
        String string4 = (String)properties.get("jrs.task_class");
        if (string4 == null || string4.trim().length() == 0) {
            throw new JSException(600039, new Object[]{properties}, null);
        }
        boolean bl2 = false;
        if (!string4.equals((class$jet$server$schedule$jrtasks$ExportInATypeTask == null ? (class$jet$server$schedule$jrtasks$ExportInATypeTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ExportInATypeTask")) : class$jet$server$schedule$jrtasks$ExportInATypeTask).getName()) && string2 == null && string != null && (object5 = this.addElement.getPathInfo(string3, string)).isEnableLinkedCatalog()) {
            if (!object5.isUseInherited()) {
                string2 = object5.getLinkedCatalog();
            }
            if (string2 == null) {
                string2 = this.addElement.getInheritedLinkedCatalog(string3, string);
            }
            if (string2 != null) {
                bl2 = true;
                properties.put("jrs.catalog", string2);
            }
        }
        if (string != null && string2 != null) {
            int n2 = CSUtil.parseInt((String)properties.get("jrs.cat_version"), -1);
            int n3 = CSUtil.parseInt((String)properties.get("jrs.rpt_version"), -1);
            if (!bl) {
                if (bl2 || n2 == -1 && properties.get("jrs.catalog") != null) {
                    n2 = this.addElement.getLatestVersionNumber((String)properties.get("jrs.catalog"), string3);
                    properties.put("jrs.cat_version", String.valueOf(n2));
                }
                String string5 = (String)properties.get("jrs.report");
                object4 = (String)properties.get("jrs.catalog");
                if (string5 != null && string5.indexOf("/") == -1) {
                    if (object4 != null) {
                        object4 = ((String)object4).substring(0, ((String)object4).lastIndexOf("/") + 1);
                        string5 = (String)object4 + string5;
                    }
                    properties.put("jrs.report", string5);
                }
                if (n3 == -1) {
                    n3 = this.addElement.getLatestVersionNumber((String)properties.get("jrs.report"), string3);
                    properties.put("jrs.rpt_version", String.valueOf(n3));
                }
            }
        }
        object5 = null;
        JRServerInfo jRServerInfo = null;
        if (string4.equals((class$jet$server$schedule$jrtasks$ViewRptTask == null ? (class$jet$server$schedule$jrtasks$ViewRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewRptTask")) : class$jet$server$schedule$jrtasks$ViewRptTask).getName())) {
            boolean bl3;
            boolean bl4 = CSUtil.getBoolean(properties.getProperty("jrs.has_task_listener"), false);
            object4 = properties.getProperty("jrs.task_listener_class");
            if (bl4 && object4 != null && ((String)object4).trim().length() > 0) {
                object5 = (TaskListener)Class.forName(((String)object4).trim()).newInstance();
            }
            object3 = properties.get("jrs.schd_props");
            stringArray = new Properties();
            if (object3 instanceof String) {
                stringArray = CSUtil.parseQuery((String)object3);
            } else if (object3 instanceof Properties) {
                stringArray.putAll((Map<?, ?>)((Properties)object3));
            }
            jRServerInfo = new JRServerInfo((Properties)stringArray);
            if (properties.get("jrs.request_url") != null) {
                jRServerInfo.setRequestURL((String)properties.get("jrs.request_url"));
            }
            if (properties.get("jrs.remote_addr") != null) {
                jRServerInfo.setRemoteAddr((String)properties.get("jrs.remote_addr"));
            }
            n = (bl3 = CSUtil.getBoolean((String)properties.get("is_direct_run"), false)) ? 0 : 2;
            JRTUtil.validateParameter(properties, n, this.getResourceManager(), (TaskListener)object5, jRServerInfo);
        }
        if ((object2 = Class.forName(string4.trim()).newInstance()) instanceof JRTask) {
            ((JRTask)object2).setJRTaskManager(this);
            ((JRTask)object2).setTaskListener((TaskListener)object5);
            ((JRTask)object2).setServerInfo(jRServerInfo);
        }
        if (object2 instanceof CustomTaskIntf) {
            ((CustomTaskIntf)object2).init((Properties)properties.clone());
        }
        if (object2 instanceof InternalStorableTask) {
            ((InternalStorableTask)object2).init((Properties)properties.clone());
            ((InternalStorableTask)object2).setDataService(this.J);
        }
        if (object2 instanceof UserTask) {
            object4 = (Properties)properties.clone();
            object3 = (Properties)((Properties)object4).get("jrs.schd_props");
            if (object3 != null) {
                stringArray = new String[]{"jrs.report", "jrs.rpt_version", "jrs.catalog", "jrs.cat_version"};
                String string6 = null;
                n = 0;
                while (n < stringArray.length) {
                    string6 = stringArray[n];
                    if (((Properties)object3).containsKey(string6)) {
                        ((Properties)object4).put(string6, ((Properties)object3).remove(string6));
                    }
                    ++n;
                }
                object = ((Properties)object4).keys();
                while (object.hasMoreElements()) {
                    string6 = (String)object.nextElement();
                    if (!((Properties)object3).containsKey(string6)) continue;
                    ((Properties)object4).remove(string6);
                }
            }
            ((Properties)object4).remove("jrs.schd_props");
            ((UserTask)object2).initReportProperties((Properties)object4);
            stringArray = (String)((Properties)object4).get("jrs.user_task_prop");
            if (stringArray != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray, "\t\n\r\f&");
                String string7 = null;
                object = null;
                String string8 = null;
                int n4 = 0;
                Properties properties2 = new Properties();
                while (stringTokenizer.hasMoreTokens()) {
                    string7 = stringTokenizer.nextToken();
                    n4 = string7.indexOf("=");
                    if (n4 <= 0) continue;
                    object = CSUtil.convertEscapes(string7.substring(0, n4).trim());
                    string8 = n4 > string7.length() - 1 ? null : CSUtil.convertEscapes(string7.substring(n4 + 1).trim());
                    if (string8 == null) continue;
                    properties2.setProperty((String)object, string8);
                }
                if (!properties2.isEmpty()) {
                    ((UserTask)object2).initUserTaskProperties(properties2);
                }
            }
            UserTaskProxy userTaskProxy = new UserTaskProxy((UserTask)object2);
            userTaskProxy.setJRTaskManager(this);
            userTaskProxy.init((Properties)object4);
            object2 = userTaskProxy;
        }
        object4 = (TaskIntf)object2;
        object3 = null;
        object3 = (Long)properties.remove("TS_tsk_submit");
        if (object3 == null) {
            object3 = new Long(System.currentTimeMillis());
        }
        object4.putValue("TS_tsk_submit", object3);
        if (string4.trim().equals((class$jet$server$schedule$jrtasks$ViewRptTask == null ? (class$jet$server$schedule$jrtasks$ViewRptTask = JRTaskManager.class$("jet.server.schedule.jrtasks.ViewRptTask")) : class$jet$server$schedule$jrtasks$ViewRptTask).getName())) {
            object4.putValue("VI_tsk_type", new Integer(0));
        } else {
            object4.putValue("VI_tsk_type", new Integer(1));
        }
        long l = this.addRunningTaskToMonitor == null ? 0L : (long)this.addRunningTaskToMonitor.getActiveAndWaitReportsCount();
        object3 = new Long((long)this.canCancelRecoveryTask.size() + l);
        object4.putValue("NC_que_length", object3);
        object4.putValue("TS_eng_start", new Long(System.currentTimeMillis()));
        object4.putValue("TS_eng_exits", new Long(System.currentTimeMillis()));
        object4.putValue("TC_eng_total", new Long(0L));
        object4.putValue("TC_eng_load", new long[]{0L});
        object4.putValue("TC_eng_export", new long[]{0L});
        object4.putValue("TC_eng_other", new Long(0L));
        object4.putValue("NC_rpt_pages", new Long(0L));
        object4.putValue("NC_rpt_formats", new Long(0L));
        object4.putValue("NC_eng_concurrent", new Long(0L));
        object4.putValue("VS_rpt_name", "null");
        String string9 = properties.getProperty("jrs.triggers");
        if (string9 != null && string9.trim().length() > 0) {
            object4.putValue("jrs.triggers", string9);
        }
        if ((object = properties.getProperty("jrs.triggers.logic")) != null && ((String)object).trim().length() > 0) {
            object4.putValue("jrs.triggers.logic", object);
        }
        object4.putValue("jrs.task_duration", new Long(CSUtil.parseLong(properties.getProperty("jrs.task_duration"), 0L) * 60L * 1000L));
        object4.putValue("jrs.need_notify_duration", new Boolean(CSUtil.getBoolean(properties.getProperty("jrs.need_notify_duration"), false)));
        if (properties.getProperty("jrs.duration_notify_mail") != null) {
            object4.putValue("jrs.duration_notify_mail", properties.getProperty("jrs.duration_notify_mail"));
        }
        object4.putValue("jrs.auto_cancel_task", new Boolean(CSUtil.getBoolean(properties.getProperty("jrs.auto_cancel_task"), false)));
        return object2;
    }

    private void addFinishedTask() {
        while (this.canCancelRecoveryTask.size() > 0 && this.addClusterListener.size() < this.canRunReport) {
            try {
                Properties properties = (Properties)this.canCancelRecoveryTask.pull();
                LaunchableObj launchableObj = this.J(properties);
                launchableObj.addTerminationListener(this);
                Thread thread = new Thread(launchableObj);
                thread.start();
                this.addClusterListener.put(launchableObj, thread);
                this.addFailedTaskToMonitor(launchableObj);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public synchronized void sendTaskContext(TaskIntf taskIntf) {
        Hashtable hashtable = taskIntf.getTaskContext();
        hashtable.put("VI_tsk_status", new Integer(taskIntf.hasError() ? 0 : 1));
        long l = (Long)hashtable.get("TS_tsk_submit");
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        hashtable.put("TC_tsk_total", new Long(l3));
        long l4 = (Long)hashtable.get("TS_eng_start") - l;
        hashtable.put("TC_tsk_waited", new Long(l4));
        long l5 = (Long)hashtable.get("TC_eng_total");
        hashtable.put("TC_tsk_other", new Long(l3 - l4 - l5));
        hashtable.put("TS_tsk_complete", new Long(l2));
        long[] lArray = (long[])hashtable.remove("TC_eng_load");
        long[] lArray2 = (long[])hashtable.remove("TC_eng_export");
        int n = 0;
        while (n < lArray.length) {
            hashtable.put("TC_eng_load", new Long(lArray[n]));
            hashtable.put("TC_eng_export", new Long(lArray2[n]));
            long l6 = l5 - lArray[n] - lArray2[n];
            hashtable.put("TC_eng_other", new Long(l6));
            try {
                ServerEnv.getEventQueue().postEvent("TaskContext", 0, hashtable, 1);
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
            }
            ++n;
        }
    }

    public void deleteOndemandReport(String string) {
        this.deleteOndemandReport(string, false);
    }

    public void deleteOndemandReport(String string, boolean bl) {
        ViewRptTask viewRptTask = (ViewRptTask)this.QOIV.remove(string);
        RunRptThread runRptThread = (RunRptThread)this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.remove(string);
        this.addRecord(viewRptTask, runRptThread, bl);
        if (viewRptTask.isHtmlPipeLine()) {
            this.removePipelineFilenames(viewRptTask.getHtmName());
        }
        this.QOIV.remove(string);
    }

    private void addFinishedTaskToMonitor(ViewRptTask viewRptTask, RunRptThread runRptThread) {
        this.addRecord(viewRptTask, runRptThread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecord(ViewRptTask viewRptTask, RunRptThread runRptThread, boolean bl) {
        Object object = this.contains;
        synchronized (object) {
            if (viewRptTask != null) {
                viewRptTask.stopExec(bl);
            }
            if (runRptThread != null && runRptThread.isAlive()) {
                runRptThread.interrupt();
                try {
                    runRptThread.join(3000L);
                }
                catch (InterruptedException interruptedException) {
                    ServiceLogger.logError(interruptedException, 3);
                }
                if (runRptThread.isAlive()) {
                    ServiceLogger.logDebug(5600149, runRptThread.getName(), 5);
                    runRptThread.stop();
                } else {
                    ServiceLogger.logDebug(5600150, runRptThread.getName(), 5);
                }
                runRptThread = null;
            }
        }
    }

    public void checkOndemandDuration() {
        Enumeration enumeration = this.QOIV.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            ViewRptTask viewRptTask = (ViewRptTask)this.QOIV.get(string);
            OndemandReportRecord ondemandReportRecord = this.ondemandManager.getOndemandReportRecord(string);
            if (ondemandReportRecord.isCompleted() || ondemandReportRecord.isCancelled() || viewRptTask.hasHandledDuration()) continue;
            long l = ondemandReportRecord.getStartedTime();
            long l2 = (Long)viewRptTask.getValue("jrs.task_duration");
            if (l2 <= 0L || System.currentTimeMillis() - l <= l2) continue;
            viewRptTask.setHandledDuration(true);
            boolean bl = (Boolean)viewRptTask.getValue("jrs.need_notify_duration");
            boolean bl2 = (Boolean)viewRptTask.getValue("jrs.auto_cancel_task");
            if (bl2) {
                object = (RunRptThread)this.TASK_PUBLISH_ANALYSIS_DISPLAY_NAME.remove(string);
                this.addFinishedTaskToMonitor(viewRptTask, (RunRptThread)object);
                ((JROndemandReportRecord)ondemandReportRecord).setDuration(l2);
                ((JROndemandReportRecord)ondemandReportRecord).setCancelled(true);
                ServiceLogger.logEvent("Cancelled ondemand report: " + viewRptTask.getReport() + ", catalog: " + viewRptTask.getCatalog() + ", started time: " + new Date(l));
            }
            if (!bl || (object = (String)viewRptTask.getValue("jrs.duration_notify_mail")) == null || ((String)object).length() <= 0) continue;
            String string2 = " Task Type: Ondemand Run\nTask ID: " + viewRptTask.getId() + "\nReport: " + viewRptTask.getReport() + "\nCatalog:" + viewRptTask.getCatalog() + "\nTask Status: " + viewRptTask.getStatus() + "\nTask Start Time: " + new Date(l) + "\nNotify Time: " + new Date(System.currentTimeMillis()) + "\nDuration: " + l2 / 60000L + " minute(s)" + "\nActive: " + (bl2 ? "false, the task has been auto canceled" : "true, the task still running") + "\nTemp Result: " + viewRptTask.getResult() + "\nDescription: Running this report will require more time than the specified minutes in 'Duration'!";
            CSMail cSMail = new CSMail((String)object, null, null, "Task Timeout Notification", string2, false);
            viewRptTask.execTimeoutNotification(cSMail);
        }
    }

    public void postEventToQueue(int n, Properties properties) {
        int n2 = n == 0 || n == 1 ? 0 : 1;
        try {
            ServerEnv.getEventQueue().postEvent(TASK_TOPIC, n, properties, n2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void addWaitingTaskToMonitor(String string, String string2, int n, String string3, long l, String string4, String string5, int n2) {
        this.assertCheck(new String[]{string, string2, string3, string4, string5});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        if (string2 != null) {
            properties.put(RPT_NAME, string2);
        }
        properties.put(TASK_TYPE, String.valueOf(n));
        if (string3 != null) {
            properties.put(SERVER_NAME, string3);
        }
        properties.put(SUBMIT_TIME, String.valueOf(l));
        if (string4 != null) {
            properties.put(RPT_SOURCE, string4);
        }
        if (string5 != null) {
            properties.put(USER_NAME, string5);
        }
        properties.put(TASK_STATUS, String.valueOf(n2));
        if (n2 == 1) {
            this.currentThread.addTask(properties);
        }
        this.postEventToQueue(0, properties);
    }

    public void addWaitingTaskToMonitor(String string, String string2, String string3, int n, String string4, long l, String string5, String string6, int n2) {
        Tracker.getInstance().getTaskStatus().addWaitingTask(string, string2, string3, n, string4, l, string5, string6, n2);
        this.addWaitingTaskToMonitor(string2, string3, n, string4, l, string5, string6, n2);
    }

    public void addRunningTaskToMonitor(String string, long l) {
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string2 = "localhost";
        }
        this.addRunningTaskToMonitor(string, string2, String.valueOf(ServerEnv.getActiveRMIPort()), l);
    }

    public void addRunningTaskToMonitor(String string, String string2, long l) {
        String string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string3 = "localhost";
        }
        this.addRunningTaskToMonitor(string, string2, string3, String.valueOf(ServerEnv.getActiveRMIPort()), l);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, long l) {
        this.addRunningTaskToMonitor(string, string2, string3, l, 4);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, String string4, long l) {
        this.addRunningTaskToMonitor(string, string2, string3, string4, l, 4);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, long l, int n) {
        this.assertCheck(new String[]{string, string2, string3});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RUN_HOST, string2);
        properties.put(RUN_PORT, string3);
        properties.put(START_TIME, String.valueOf(l));
        properties.put(TASK_STATUS, String.valueOf(n));
        this.postEventToQueue(1, properties);
    }

    public void addRunningTaskToMonitor(String string, String string2, String string3, String string4, long l, int n) {
        Tracker.getInstance().getTaskStatus().addRunningTask(string, string2, string3, string4, l, n);
        this.addRunningTaskToMonitor(string2, string3, string4, l, n);
    }

    public void addFinishedTaskToMonitor(String string, String string2, String string3, long l, int n, String string4, String string5, String string6, String string7) {
        this.assertCheck(new String[]{string, string2, string3, string4, string5, string6});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(RUN_HOST, string2);
        properties.put(RUN_PORT, string3);
        properties.put(FINISH_TIME, String.valueOf(l));
        properties.put(RPT_PAGES, String.valueOf(n));
        properties.put(RST_FILE_NAME, string4);
        properties.put(REASON, string5);
        properties.put(ENGINE_INFO, string6);
        properties.put(TASK_STATUS, String.valueOf(9));
        this.currentThread.updateTask(string7, n);
        this.postEventToQueue(2, properties);
    }

    public void addFinishedTaskToMonitor(String string, String string2, String string3, String string4, long l, int n, String string5, String string6, String string7, String string8) {
        Tracker.getInstance().getTaskStatus().addFinishedTask(string, string2, string3, string4, l, n, string5, string6, string7);
        this.addFinishedTaskToMonitor(string2, string3, string4, l, n, string5, string6, string7, string8);
    }

    public void addFailedTaskToMonitor(String string, String string2) {
        this.assertCheck(new String[]{string, string2});
        Properties properties = new Properties();
        properties.put(TASK_ID, string);
        properties.put(FAILED_INFO, string2);
        properties.put(TASK_STATUS, String.valueOf(10));
        this.postEventToQueue(3, properties);
    }

    public void addFailedTaskToMonitor(String string, String string2, String string3) {
        Tracker.getInstance().getTaskStatus().addFailedTask(string, string2, string3);
        this.addFailedTaskToMonitor(string2, string3);
    }

    public void assertCheck(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                ServiceLogger.logDebug(6600111, String.valueOf(n), 6);
            }
            ++n;
        }
    }

    public SecurityContext getSecurityContext(String string, String string2, String string3, int n) {
        if (this.clone == null) {
            return null;
        }
        return this.clone.getSecurityContext(string, string2, string3, n);
    }

    public void setConnectionInfoProvider(ConnectionInfoProvider connectionInfoProvider) {
        this.close = connectionInfoProvider;
    }

    public ConnectionInfoProvider getConnectionInfoProvider() {
        return this.close;
    }

    public void dumpEnginesInfo() {
        Vector vector = (Vector)this.addWaitingTask.clone();
        Tracker.dump(4600168, new Object[]{new Integer(vector.size())}, 4);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Object e = vector.elementAt(n);
            if (e instanceof JREngine) {
                try {
                    ReportsetEngineInfo reportsetEngineInfo = new ReportsetEngineInfo();
                    ((JREngine)e).getEngineInfo(reportsetEngineInfo);
                    Tracker.dump(reportsetEngineInfo.toString());
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
            ++n;
        }
    }

    public int getActiveReportsInQueue() {
        return this.addRunningTaskToMonitor == null ? -1 : this.addRunningTaskToMonitor.getActiveReportsCount();
    }

    public int getWaitingReports() {
        return this.canCancelRecoveryTask.size();
    }

    public int getQueuingReports() {
        return this.addRunningTaskToMonitor == null ? -1 : this.addRunningTaskToMonitor.getWaitReportsCount();
    }

    public synchronized void registeredMember(ReportMember reportMember) {
        if (this.addRunningTaskToMonitor != null) {
            int n = reportMember.getMaxConcurrentReports();
            this.canRunReport += n;
        }
    }

    public synchronized void removeMember(ReportMember reportMember) {
        if (this.addRunningTaskToMonitor != null) {
            int n = reportMember.getMaxConcurrentReports();
            this.canRunReport -= n;
        }
    }

    public Vector getAllTaskStatistics() {
        if (this.currentThread != null) {
            return this.currentThread.getStatistics();
        }
        return new Vector(0);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

