/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import guitools.GuiUtil;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.admin.ResourceAdminService;
import jet.server.api.admin.ResourceNodeInfo;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.ResourceAdminServiceException;
import jet.server.api.exception.ResourceInfoException;
import jet.server.api.exception.UnknownMIMEType;
import jet.server.api.exception.UnknownResource;
import jet.server.jrc.admin.JRResourceNodeInfo;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.log.ServiceLogger;
import jet.server.resource.JRptUtil;
import jet.server.resource.NodeInfo;
import jet.server.resource.RptResourceManager;
import jet.server.resource.RptResourceNode;
import jet.server.resource.RptResourceRoot;
import jet.server.userman.UserDataToolkit;
import jet.server.util.MIMETypeTable;

public class JRResourceAdminService
implements ResourceAdminService {
    private RptResourceNode I(RptResourceManager rptResourceManager, String string) throws UnknownMIMEType, UnknownResource {
        if (!string.startsWith("(R)/")) {
            RptResourceRoot rptResourceRoot;
            RptResourceNode rptResourceNode = rptResourceRoot = rptResourceManager.getResourceRoot();
            if (string != null && string.startsWith("/")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = (String)stringTokenizer.nextElement();
                    if ((rptResourceNode = rptResourceNode.getRscByName(string2)) != null) continue;
                    throw new UnknownResource(string);
                }
            } else {
                throw new UnknownResource(string);
            }
            return rptResourceNode;
        }
        NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string);
        if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
            throw new UnknownResource(string);
        }
        RptResourceNode rptResourceNode = nodeInfo.rscNode;
        return rptResourceNode;
    }

    public String addResourceNode(String string, String string2, String string3, String string4) throws NoSuchRealmException, UnknownMIMEType, ResourceInfoException, ResourceAdminServiceException, UnknownResource {
        RptResourceManager rptResourceManager = null;
        if (string == null) {
            string = ServerEnv.getActiveRealm();
        }
        if ((rptResourceManager = UserDataToolkit.getManager(string)) == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        RptResourceNode rptResourceNode = null;
        rptResourceNode = this.I(rptResourceManager, string2);
        String string5 = JRptUtil.canCreateNew(rptResourceNode);
        if (string5 == null) {
            Object object;
            String string6;
            RptResourceNode rptResourceNode2;
            block21: {
                if (rptResourceNode == null) {
                    return null;
                }
                rptResourceNode2 = rptResourceNode;
                if (rptResourceNode2 == null) {
                    return null;
                }
                int n = 0;
                string6 = null;
                if (string3 == null) {
                    string6 = "resource";
                    while (rptResourceNode2.getRscByName(string6 + n) != null) {
                        ++n;
                    }
                    string6 = string6 + n;
                } else {
                    string6 = string3;
                    if (rptResourceNode2.getRscByName(string6) != null) {
                        throw new ResourceAdminServiceException(660001, new Object[]{string6}, null);
                    }
                }
                if (string4 != null) {
                    object = new File(string4);
                    if (((File)object).exists()) {
                        try {
                            if (rptResourceManager.getMIMETypeTable().mimeCheck("application/x-jrreport", string4)) {
                                File file = new File(string4);
                                try {
                                    String string7 = file.getCanonicalPath();
                                    String string8 = rptResourceNode2.getRealPath();
                                    if (rptResourceNode2.isCatNode() && !JRptUtil.isRptBelongsToCat(string8, string7, rptResourceManager.getMIMETypeTable())) {
                                        throw new ResourceAdminServiceException(660002);
                                    }
                                    break block21;
                                }
                                catch (IOException iOException) {
                                    throw new ResourceAdminServiceException(660002);
                                }
                            }
                            if (rptResourceNode2.isCatNode()) {
                                throw new ResourceAdminServiceException(660003);
                            }
                            break block21;
                        }
                        catch (UnknownMIMEType unknownMIMEType) {
                            throw new ResourceAdminServiceException(660004, new Object[]{unknownMIMEType.getMessage()}, null);
                        }
                    }
                    throw new ResourceAdminServiceException(660005, new Object[]{string4}, null);
                }
            }
            if (string5 != null) {
                throw new ResourceAdminServiceException(string5);
            }
            object = new RptResourceNode(string6, string4, true);
            rptResourceNode2.insert((RptResourceNode)object, -1);
            ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_New_Succ", ((RptResourceNode)object).getFullName()), 5);
            try {
                rptResourceManager.save();
                ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
                return string6;
            }
            catch (ResourceInfoException resourceInfoException) {
                ServiceLogger.logManageFailEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
                throw resourceInfoException;
            }
        }
        throw new ResourceAdminServiceException(string5);
    }

    public void deleteResourceNode(String string, String string2) throws NoSuchRealmException, UnknownMIMEType, UnknownResource, ResourceAdminServiceException, ResourceInfoException {
        RptResourceManager rptResourceManager = null;
        rptResourceManager = string == null ? UserDataToolkit.getManager(ServerEnv.getActiveRealm()) : UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        RptResourceNode rptResourceNode = null;
        rptResourceNode = this.I(rptResourceManager, string2);
        RptResourceNode rptResourceNode2 = rptResourceNode;
        RptResourceNode rptResourceNode3 = (RptResourceNode)rptResourceNode2.getParent();
        if (rptResourceNode3 == null) {
            throw new ResourceAdminServiceException(660006, new Object[]{string2}, null);
        }
        rptResourceNode2.deleted();
        try {
            rptResourceManager.save();
            ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
        }
        catch (ResourceInfoException resourceInfoException) {
            ServiceLogger.logManageFailEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
            throw resourceInfoException;
        }
    }

    private void INFO(String string, int n) {
        ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), null, string, n);
    }

    public void declareVirtualNode(String string, String string2, boolean bl) throws NoSuchRealmException, UnknownResource, UnknownMIMEType, IOException, ResourceInfoException {
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        if (string2.startsWith("/")) {
            throw new UnknownResource(string2);
        }
        NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2);
        if (nodeInfo == null || nodeInfo.nodetype.equals("R")) {
            throw new UnknownResource(string2);
        }
        RptResourceNode rptResourceNode = rptResourceManager.getResourceTreeMan().declare(nodeInfo.rscNode, nodeInfo.relativePath, bl);
        try {
            rptResourceManager.save();
            ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
        }
        catch (ResourceInfoException resourceInfoException) {
            ServiceLogger.logManageFailEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
            throw resourceInfoException;
        }
    }

    public void editResourceNode(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws NoSuchRealmException, IOException, UnknownResource, UnknownMIMEType, ResourceAdminServiceException, ResourceInfoException {
        String string6 = null;
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        RptResourceNode rptResourceNode = this.I(rptResourceManager, string2);
        if (string3 == null || string3.trim().length() == 0) {
            throw new ResourceAdminServiceException(660007);
        }
        string6 = JRptUtil.checkNewName(rptResourceNode, string3);
        if (string6 != null) {
            throw new ResourceAdminServiceException(string6);
        }
        string6 = JRptUtil.checkNewRealPath(rptResourceManager, rptResourceNode, string4, rptResourceManager.getMIMETypeTable());
        if (string6 != null) {
            throw new ResourceAdminServiceException(string6);
        }
        int n = rptResourceNode.getDefReachableOfSubnodes();
        boolean bl3 = false;
        rptResourceNode.setMapSharedDisk(bl2);
        int n2 = bl ? 0 : 2;
        boolean bl4 = false;
        if (!GuiUtil.areEqual((String)rptResourceNode.getRealPath(), (String)string4)) {
            File file = new File(string4);
            if (string4 != null && string4.length() > 0) {
                MIMETypeTable mIMETypeTable = rptResourceManager.getMIMETypeTable();
                if (mIMETypeTable.mimeCheck("application/x-jrcatalog", string4)) {
                    if (file.exists()) {
                        Vector vector = JRptUtil.getValidRptNodesName(rptResourceNode, string4, mIMETypeTable);
                        String[] stringArray = rptResourceManager.getAliasManager().checkAlias(rptResourceNode.getFullName(), vector, null, true);
                        if (stringArray != null) {
                            if (stringArray[0].equals("0")) {
                                String[] stringArray2 = new String[]{string4, stringArray[4], stringArray[1]};
                                throw new ResourceAdminServiceException(660008, (Object[])stringArray2, null);
                            }
                            String[] stringArray3 = new String[]{string4, stringArray[4], stringArray[1], stringArray[3], stringArray[2]};
                            throw new ResourceAdminServiceException(660009, (Object[])stringArray3, null);
                        }
                        if (n != n2) {
                            rptResourceNode.setDefReachableOfSubnodes(n2);
                        }
                        this.QOIV(rptResourceNode, string4);
                        JRptUtil.arrangeCatSubNodes(rptResourceNode, vector, null);
                        bl4 = true;
                    } else {
                        String[] stringArray = rptResourceManager.getAliasManager().checkAlias(rptResourceNode.getFullName(), null, null, true);
                        if (stringArray != null) {
                            if (stringArray[0].equals("0")) {
                                String[] stringArray4 = new String[]{string4, stringArray[4], stringArray[1]};
                                throw new ResourceAdminServiceException(660008, (Object[])stringArray4, null);
                            }
                            String[] stringArray5 = new String[]{string4, stringArray[4], stringArray[1], stringArray[3], stringArray[2]};
                            throw new ResourceAdminServiceException(660009, (Object[])stringArray5, null);
                        }
                        if (n != n2) {
                            rptResourceNode.setDefReachableOfSubnodes(n2);
                        }
                        this.QOIV(rptResourceNode, string4);
                        JRptUtil.arrangeCatSubNodes(rptResourceNode, null, null);
                        bl4 = true;
                    }
                } else {
                    if (n != n2) {
                        rptResourceNode.setDefReachableOfSubnodes(n2);
                    }
                    this.QOIV(rptResourceNode, string4);
                    bl4 = true;
                }
            } else {
                if (n != n2) {
                    rptResourceNode.setDefReachableOfSubnodes(n2);
                }
                this.QOIV(rptResourceNode, string4);
                bl4 = true;
            }
        }
        if (bl4) {
            bl3 = true;
        } else if (n != n2) {
            rptResourceNode.setDefReachableOfSubnodes(n2);
            bl3 = true;
        }
        if (!GuiUtil.areEqual((String)rptResourceNode.getName(), (String)string3)) {
            JDebug.INFO((String)" Setting new mapping name...");
            rptResourceNode.setText(string3);
            bl3 = true;
        }
        if (!GuiUtil.areEqual((String)rptResourceNode.getName(), (String)string5)) {
            JDebug.INFO((String)" Setting new description...");
            rptResourceNode.setDescription(string5);
            bl3 = true;
        }
        if (bl3) {
            try {
                rptResourceManager.save();
                ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
            }
            catch (ResourceInfoException resourceInfoException) {
                ServiceLogger.logManageFailEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
                throw resourceInfoException;
            }
        }
    }

    private boolean QOIV(RptResourceNode rptResourceNode, String string) {
        if (string != null && string.length() > 0) {
            File file = new File(string);
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        rptResourceNode.setRealPath(string);
        return true;
    }

    public void setVirtualReachable(String string, String string2, boolean bl) throws NoSuchRealmException, UnknownResource, UnknownMIMEType, IOException, ResourceInfoException {
        boolean bl2;
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        if (string2.startsWith("/")) {
            throw new UnknownResource(string2);
        }
        NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2);
        if (nodeInfo == null || nodeInfo.nodetype.equals("R")) {
            throw new UnknownResource(string2);
        }
        boolean bl3 = bl2 = nodeInfo.reachable == 1;
        if (bl2 != bl) {
            nodeInfo.rscNode.setVrtFileReachable(nodeInfo.name, bl);
            try {
                rptResourceManager.save();
                ServiceLogger.logManageSuccessEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
            }
            catch (ResourceInfoException resourceInfoException) {
                ServiceLogger.logManageFailEvent(rptResourceManager.getRealm(), null, JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
                throw resourceInfoException;
            }
        }
    }

    public void addResourceReachable(String string, String string2, Vector vector) throws NoSuchRealmException, UnknownResource, UnknownMIMEType, ResourceAdminServiceException, IOException {
        if (vector != null) {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            RptResourceNode rptResourceNode = this.I(rptResourceManager, string2);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                String string3 = (String)vector.elementAt(n3);
                if (rptResourceNode.setVrtFileReachable(string3, true)) {
                    stringBuffer.append("'" + string3 + "'");
                    ++n;
                } else {
                    stringBuffer2.append(string3 + "\n");
                }
                ++n3;
            }
            if (stringBuffer2.length() > 0) {
                throw new ResourceAdminServiceException(660010, new Object[]{stringBuffer2}, null);
            }
            if (n > 0) {
                this.INFO(JSvrResource.getMessage("RscEd_Log_AddReachable_Succ", stringBuffer.toString()), 5);
            }
        }
    }

    public ResourceNodeInfo getResourceNodeInfo(String string, String string2) throws NoSuchRealmException, UnknownResource, UnknownMIMEType, IOException {
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        if (string2.startsWith("/")) {
            throw new UnknownResource(string2);
        }
        NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2);
        if (nodeInfo == null) {
            throw new UnknownResource(string2);
        }
        return new JRResourceNodeInfo(nodeInfo, string2.substring(string2.indexOf(")") + 1));
    }

    public Vector getSubRscNodesInfo(String string, String string2, int n) throws NoSuchRealmException, UnknownResource, UnknownMIMEType, IOException {
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        if (string2.startsWith("/")) {
            throw new UnknownResource(string2);
        }
        Vector vector = rptResourceManager.getResourceTreeMan().getFmtdSbndNmsOfSpcNd(string2, n);
        Vector<JRResourceNodeInfo> vector2 = new Vector<JRResourceNodeInfo>();
        int n2 = 0;
        while (n2 < vector.size()) {
            NodeInfo nodeInfo;
            String string3 = (String)vector.elementAt(n2);
            if (!string2.endsWith("/")) {
                string3 = "/" + string3;
            }
            if ((nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2 + string3)) != null) {
                JRResourceNodeInfo jRResourceNodeInfo = new JRResourceNodeInfo(nodeInfo, string2 + string3);
                vector2.addElement(jRResourceNodeInfo);
            }
            ++n2;
        }
        return vector2;
    }

    public String addNode(String string, String string2, byte by, Hashtable hashtable) throws NoSuchRealmException, UnknownMIMEType, UnknownResource, ResourceAdminServiceException, ResourceInfoException {
        return null;
    }

    public void deleteNode(String string, String string2) throws NoSuchRealmException, UnknownMIMEType, UnknownResource, ResourceAdminServiceException, ResourceInfoException {
    }

    public void editNode(String string, String string2, Hashtable hashtable) throws NoSuchRealmException, IOException, UnknownResource, UnknownMIMEType, ResourceAdminServiceException, ResourceInfoException {
    }

    public String convertReports(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws NoSuchRealmException {
        ResourceTreeManagerImpl resourceTreeManagerImpl = jet.server.jrc.security.UserDataToolkit.getResourceManager(string);
        if (resourceTreeManagerImpl == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        return resourceTreeManagerImpl.convertReports(string2, bl, bl2, bl3);
    }
}

