/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.io.IOException;
import java.security.acl.Acl;
import java.security.acl.NotOwnerException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.security.JGroup;
import jet.server.api.admin.security.JRole;
import jet.server.api.admin.security.JUser;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityProvider;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.SharedPasswordRealm2;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.admin.JGroupImpl;
import jet.server.jrc.security.admin.JRoleImpl;
import jet.server.jrc.security.admin.JUserImpl;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;

public class JRSecurityAdminService
implements SecurityAdminService {
    private static String QOIV = null;
    static Class class$jet$server$jrc$security$Realm;

    public void setCurRealm(String string) {
        QOIV = string;
    }

    public String getCurRealm() {
        try {
            Realm.get(QOIV);
        }
        catch (Exception exception) {
            QOIV = null;
        }
        if (QOIV == null) {
            QOIV = this.getActiveRealm();
        }
        return QOIV;
    }

    public String getActiveRealm() {
        return ServerEnv.getActiveRealm();
    }

    private boolean isAdminUser(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            return false;
        }
        return securityService.isAdminUser(string2);
    }

    public Enumeration getAllRealmNames() {
        Vector vector = new Vector();
        Iterator iterator = UserDataToolkit.getRealmNames();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addRealm(String string, String string2, int n) throws NoSuchRealmException, BadRealmException, NoSuchAclException, NotOwnerException, NoSuchUserException, InUseException {
        String string3 = ServerEnv.getActiveRealm();
        if (string == null || string.trim().equals("")) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660055, string, 6);
            return JSvrResource.getMessage("SVR_130");
        }
        if (!this.isAdminUser(string3, string2)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660056, string, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        if (!UserDataToolkit.isValidName(string)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660057, string, 6);
            return JSvrResource.getMessage("SVR_131");
        }
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = JRSecurityAdminService.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            try {
                Realm.get(string);
                return JSvrResource.getMessage("SVR_132") + string + " " + JSvrResource.getMessage("SVR_133");
            }
            catch (NoSuchRealmException noSuchRealmException) {
                SharedPasswordRealm2 sharedPasswordRealm2 = new SharedPasswordRealm2(string);
                sharedPasswordRealm2.setScheme(n);
                Realm.add(sharedPasswordRealm2);
                sharedPasswordRealm2.save();
                SecurityDBEnv.addOriginalDBGetter(string);
                try {
                    UserDataToolkit.addAllManager(string);
                    ServiceLogger.logManageSuccessEvent(string3, string2, 6660057, string, 6);
                }
                catch (Exception exception) {
                    throw new NoSuchRealmException(exception.getMessage());
                }
                return null;
            }
        }
    }

    public String removeRealm(String string, String string2) {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660059, string, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        if (string.equals(string3)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660060, string, 6);
            return JSvrResource.getMessage("SVR_134");
        }
        Realm.remove(string);
        UserDataToolkit.deleteRealmData(string);
        UserDataToolkit.removeManager(string);
        ServiceLogger.logManageSuccessEvent(string3, string2, 6660061, string, 6);
        return null;
    }

    public String addGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, InUseException, IOException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660062, string2, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660063, new Object[]{string2, string}, 6);
            throw new NoSuchRealmException("The realm " + string + " is not exist.");
        }
        String string6 = null;
        try {
            string6 = securityProvider.addNewGroup(string2, string3);
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logError(groupExistsException, 6);
            string6 = groupExistsException.getMessage();
        }
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string4, 6660064, string2, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string4, 6660065, new Object[]{string2, string6}, 6);
        return string6;
    }

    public String removeGroup(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, InUseException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660066, string2, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660067, new Object[]{string2, string}, 6);
            throw new NoSuchRealmException("The realm " + string + " is not exist.");
        }
        String string5 = null;
        string5 = securityProvider.removeGroup(string2);
        if (string5 == null) {
            UserDataToolkit.getResourceManager(string).getResourceAliasManager().deleteAllAliasesOfGroup(string3, string2);
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660068, string2, 6);
            return string5;
        }
        ServiceLogger.logManageFailEvent(string4, string3, 6660069, new Object[]{string2, string5}, 6);
        return string5;
    }

    public Enumeration getAllGroups(String string) throws NoSuchRealmException, BadRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllGroups();
        return vector.elements();
    }

    public Vector getAllGroups(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660070, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660071, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllGroups();
        ServiceLogger.logManageSuccessEvent(string3, string2, 6660072, 6);
        return vector;
    }

    public JGroup[] getAllJGroups(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660070, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string3, string2, 6660071, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllGroups();
        ServiceLogger.logManageSuccessEvent(string3, string2, 6660072, 6);
        JGroup[] jGroupArray = new JGroup[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Group group = (Group)vector.elementAt(n);
            jGroupArray[n] = new JGroupImpl(group);
            ++n;
        }
        return jGroupArray;
    }

    public Enumeration getAllGroupNames(String string) throws NoSuchRealmException, BadRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllGroupsName();
        return vector.elements();
    }

    public int getGroupMemberCount(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Group group = securityService.getGroup(string2);
        if (group != null) {
            return group.getMembersCount();
        }
        return 0;
    }

    public java.security.acl.Group getGroup(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        return null;
    }

    public Group getGroupByName(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660073, string3, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660074, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Group group = securityService.getGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660075, string3, 6);
        return group;
    }

    public JGroup getJGroupByName(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660073, string3, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660074, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Group group = securityService.getGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660075, string3, 6);
        JGroupImpl jGroupImpl = new JGroupImpl(group);
        return jGroupImpl;
    }

    public String addUserIntoGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchUserException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660076, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660077, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addUserToGroup(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660078, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660079, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public String addSubGroupIntoGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660080, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660081, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addSubGroupToGroup(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660082, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660083, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public String addGroupIntoRole(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchRoleException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660084, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660085, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addGroupToRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660086, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660087, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public String removeUserFromGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchUserException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660088, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660089, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.removeUserFromGroup(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660090, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660091, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public String removeSubGroupFromGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660092, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660093, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.removeSubGroupFromGroup(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660094, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660095, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public String removeGroupFromRole(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchRoleException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660096, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660097, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.removeGroupFromRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660098, new Object[]{string3, string4}, 6);
            return string6;
        }
        ServiceLogger.logManageFailEvent(string5, string2, 6660099, new Object[]{string3, string4, string6}, 6);
        return string6;
    }

    public Vector getSubGroupsByGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660100, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660101, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getSubGroupsByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660102, string3, 6);
        return vector;
    }

    public JGroup[] getSubJGroupsByJGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660100, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660101, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getSubGroupsByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660102, string3, 6);
        JGroup[] jGroupArray = new JGroup[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Group group = (Group)vector.elementAt(n);
            jGroupArray[n] = new JGroupImpl(group);
            ++n;
        }
        return jGroupArray;
    }

    public Vector getUsersByGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660103, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660104, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getUsersByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660105, string3, 6);
        return vector;
    }

    public JUser[] getJUsersByJGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660103, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660104, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getUsersByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660105, string3, 6);
        JUser[] jUserArray = new JUser[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            User user = (User)vector.elementAt(n);
            jUserArray[n] = new JUserImpl(user);
            ++n;
        }
        return jUserArray;
    }

    public Vector getRolesByGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660106, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660107, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getRolesByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660108, string3, 6);
        return vector;
    }

    public JRole[] getJRolesByJGroup(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660106, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660107, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getRolesByGroup(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660108, string3, 6);
        JRole[] jRoleArray = new JRole[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Role role = (Role)vector.elementAt(n);
            jRoleArray[n] = new JRoleImpl(role);
            ++n;
        }
        return jRoleArray;
    }

    public Vector getGroupsByRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660109, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660110, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getGroupsByRole(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660111, string3, 6);
        return vector;
    }

    public JGroup[] getJGroupsByJRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660109, string3, 6);
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660110, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getGroupsByRole(string3);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660111, string3, 6);
        JGroup[] jGroupArray = new JGroup[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Group group = (Group)vector.elementAt(n);
            jGroupArray[n] = new JGroupImpl(group);
            ++n;
        }
        return jGroupArray;
    }

    public User getUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string)) {
            ServiceLogger.logManageFailEvent(string4, string, 6660112, string3, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string4, string, 6660113, new Object[]{string3, string2}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        User user = securityService.getIntegrityUser(string3);
        ServiceLogger.logManageSuccessEvent(string4, string, 6660114, string3, 6);
        return user;
    }

    public JUser getJUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string)) {
            ServiceLogger.logManageFailEvent(string4, string, 6660112, string3, 6);
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        if (securityService == null) {
            ServiceLogger.logManageFailEvent(string4, string, 6660113, new Object[]{string3, string2}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        User user = securityService.getIntegrityUser(string3);
        ServiceLogger.logManageSuccessEvent(string4, string, 6660114, string3, 6);
        return new JUserImpl(user);
    }

    public Vector getParentRolesByUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getParentRolesByUser(string3);
    }

    public JRole[] getParentJRolesByJUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getParentRolesByUser(string3);
        JRole[] jRoleArray = new JRole[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Role role = (Role)vector.elementAt(n);
            jRoleArray[n] = new JRoleImpl(role);
            ++n;
        }
        return jRoleArray;
    }

    public Vector getGroupsByUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getGroupsByUser(string3);
    }

    public JGroup[] getJGroupsByJUser(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getGroupsByUser(string3);
        JGroup[] jGroupArray = new JGroup[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Group group = (Group)vector.elementAt(n);
            jGroupArray[n] = new JGroupImpl(group);
            ++n;
        }
        return jGroupArray;
    }

    public String addUser(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n, boolean bl2, int n2, boolean bl3, String string7) throws NoSuchRealmException, BadRealmException, NoSuchUserException, InUseException, IOException {
        String string8 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string8, string7)) {
            ServiceLogger.logManageFailEvent(string8, string7, 6660115, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Date date = new Date(System.currentTimeMillis());
        String string9 = null;
        try {
            string9 = securityProvider.addNewUser(string7, string2, string4, string5, string6, date, string3, bl2, n2, date, bl, n, bl3);
        }
        catch (UserExistsException userExistsException) {
            string9 = userExistsException.getMessage();
            ServiceLogger.logError(userExistsException);
        }
        if (string9 == null) {
            ServiceLogger.logManageSuccessEvent(string8, string7, 6660116, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string8, string7, 6660117, new Object[]{string2, string9}, 6);
        }
        return string9;
    }

    public String addUser(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, int n, boolean bl2, int n2, boolean bl3) throws NoSuchRealmException, UserExistsException {
        String string8 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string8, string2)) {
            ServiceLogger.logManageFailEvent(string8, string2, 6660115, string3, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Date date = new Date(System.currentTimeMillis());
        String string9 = securityProvider.addNewUser(string2, string3, string5, string6, string7, date, string4, bl2, n2, date, bl, n, bl3);
        if (string9 == null) {
            ServiceLogger.logManageSuccessEvent(string8, string2, 6660116, string3, 6);
        } else {
            ServiceLogger.logManageFailEvent(string8, string2, 6660117, new Object[]{string3, string9}, 6);
        }
        return string9;
    }

    public String removeUser(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, InUseException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660118, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string5 = securityProvider.removeUser(string2, string3);
        if (string5 == null) {
            UserDataToolkit.getResourceManager(string).getResourceAliasManager().deleteAllAliasesOfUser(string3, string2);
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660119, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660120, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public String getUserFullname(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.getFullName();
    }

    public String getUserDescription(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.getDescription();
    }

    public String getUserEmail(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.getEmail();
    }

    public boolean isUserAccountDisable(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isAccountDisable();
    }

    public boolean isUserPasswordNeverExpire(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isNeverExpire();
    }

    public int getUserPasswordExpireTime(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.getExpireTime();
    }

    public boolean isUserPasswordPermitBlank(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isEnableNullPS();
    }

    public int getUserPasswordMinLength(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.getMinPSLength();
    }

    public String addNewParentRolesToUser(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchUserException, NoSuchRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660121, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660122, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addUserToParentRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660123, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string2, 6660124, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public String changePassword(String string, String string2, String string3, String string4, String string5) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        String string6 = ServerEnv.getActiveRealm();
        if (!string5.equals(string2) && !this.isAdminUser(string6, string5)) {
            ServiceLogger.logManageFailEvent(string6, string5, 6660125, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string7 = securityService.changePassword(true, string5, string3, string2, string4);
        if (string7 == null) {
            ServiceLogger.logManageSuccessEvent(string6, string5, 6660126, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string6, string5, 6660127, new Object[]{string2, string7}, 6);
        }
        return string7;
    }

    public String editUser(String string, String string2, String string3, String string4, String string5, boolean bl, int n, boolean bl2, int n2, boolean bl3, String string6) throws NoSuchRealmException, BadRealmException, NoSuchUserException, InUseException, IOException {
        String string7 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string7, string6)) {
            ServiceLogger.logManageFailEvent(string7, string6, 6660128, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Date date = new Date(System.currentTimeMillis());
        String string8 = securityProvider.updateAttributes(string2, string3, string4, string5, bl2, n2, date, bl, n, bl3);
        if (string8 == null) {
            ServiceLogger.logManageSuccessEvent(string7, string6, 6660129, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string7, string6, 6660130, new Object[]{string2, string8}, 6);
        }
        return string8;
    }

    public String editLDAPUser(String string, String string2, String string3, String string4, String string5, String string6) throws NoSuchRealmException, BadRealmException, NoSuchUserException, InUseException, IOException {
        String string7 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string7, string6)) {
            ServiceLogger.logManageFailEvent(string7, string6, 6660128, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Date date = new Date(System.currentTimeMillis());
        String string8 = securityProvider.updateAttributes(string2, string3, string4, string5, true, 6, date, false, 30, false);
        if (string8 == null) {
            ServiceLogger.logManageSuccessEvent(string7, string6, 6660129, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string7, string6, 6660130, new Object[]{string2, string8}, 6);
        }
        return string8;
    }

    public Enumeration getAllUserNames(String string) throws NoSuchRealmException, BadRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        if (securityService.getAllUsersName() != null) {
            return securityService.getAllUsersName().elements();
        }
        return null;
    }

    public Vector getAllUser(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getAllUsers();
    }

    public JUser[] getAllJUser(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllUsers();
        JUser[] jUserArray = new JUser[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            User user = (User)vector.elementAt(n);
            jUserArray[n] = new JUserImpl(user);
            ++n;
        }
        return jUserArray;
    }

    public Enumeration getAllUserNames(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        return null;
    }

    public Enumeration getAllUserNamesByRole(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchRoleException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        return securityProvider.getSubUsersNameByRole(string3).elements();
    }

    public String addMemberIntoGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchUserException, IOException {
        return null;
    }

    public String addUserIntoRole(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchUserException, NoSuchRoleException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660121, new Object[]{string3, string2}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660122, new Object[]{string3, string2, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addSubUserToRole(string3, string2);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string4, 6660123, new Object[]{string3, string2}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string4, 6660124, new Object[]{string3, string2, string6}, 6);
        }
        return string6;
    }

    public String removeMemberFromGroup(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchGroupException, NoSuchUserException, IOException {
        return null;
    }

    public String removeUserFromRole(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchRoleException, NoSuchUserException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660131, new Object[]{string3, string2}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660132, new Object[]{string3, string2, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.removeUserFromParentRole(string3, string2);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string4, 6660133, new Object[]{string3, string2}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string4, 6660134, new Object[]{string3, string2, string6}, 6);
        }
        return string6;
    }

    public int getUserParentRolesCount(String string, String string2) throws NoSuchUserException {
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            return -1;
        }
        return securityProvider.getUserParentRolesCount(string2);
    }

    public int getUserParentGroupsCount(String string, String string2) throws NoSuchRealmException, NoSuchUserException {
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getGroupsByUser(string2).size();
    }

    public String removeParentRolesFromUser(String string, String string2, String string3, String string4) throws NoSuchUserException, NoSuchRoleException, NoSuchRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660131, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660132, new Object[]{string3, string4, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.removeUserFromParentRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660133, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string2, 6660134, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public String addAcl(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, IOException {
        return null;
    }

    public String removeAcl(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchAclException {
        return null;
    }

    public String addMemberIntoAcl(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchAclException, NotOwnerException, IOException {
        return null;
    }

    public String setMemberPermissions(String string, String string2, String string3, Vector vector, boolean bl, String string4) throws NoSuchRealmException, BadRealmException, NoSuchAclException, NotOwnerException, IOException {
        return null;
    }

    public String removeMemberFromAcl(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchAclException, NotOwnerException, IOException {
        return null;
    }

    public Enumeration getAcls(String string) throws NoSuchRealmException, BadRealmException {
        return null;
    }

    public Enumeration getAclNames(String string) throws NoSuchRealmException, BadRealmException {
        return null;
    }

    public Acl getAcl(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchAclException {
        return null;
    }

    public String addProtection(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, IOException {
        return null;
    }

    public String removeProtection(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, IOException {
        return null;
    }

    public String editProtection(String string, String string2, String string3, String string4) throws NoSuchRealmException, BadRealmException, NoSuchAclException {
        return null;
    }

    public Enumeration getProtections(String string) throws NoSuchRealmException, BadRealmException {
        return null;
    }

    public String getCombinedAclName(String string, String string2) throws NoSuchRealmException, BadRealmException {
        return null;
    }

    public String setNoAudit(String string, String string2, boolean bl, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, IOException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660135, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        boolean bl2 = bl;
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        String string5 = securityProvider.updataEvent(string2, user.isAccessEventSuc(), user.isAccessEventFail(), user.isManagementEventSuc(), user.isManagementEventFail(), bl2);
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660136, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660137, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public String setAuditFileAccessSuccess(String string, String string2, boolean bl, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, IOException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660138, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        boolean bl2 = bl;
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        User user = securityService.getIntegrityUser(string2);
        String string5 = securityProvider.updataEvent(string2, bl2, user.isAccessEventFail(), user.isManagementEventSuc(), user.isManagementEventFail(), user.isNoAudit());
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660139, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660140, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public String setAuditFileAccessFail(String string, String string2, boolean bl, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, IOException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660141, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        User user = securityService.getIntegrityUser(string2);
        boolean bl2 = bl;
        String string5 = securityProvider.updataEvent(string2, user.isAccessEventSuc(), bl2, user.isManagementEventSuc(), user.isManagementEventFail(), user.isNoAudit());
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660142, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660143, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public String setAuditManageSuccess(String string, String string2, boolean bl, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, IOException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660144, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        User user = securityService.getIntegrityUser(string2);
        boolean bl2 = bl;
        String string5 = securityProvider.updataEvent(string2, user.isAccessEventSuc(), user.isAccessEventFail(), bl2, user.isManagementEventFail(), user.isNoAudit());
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660145, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660146, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public String setAuditManageFail(String string, String string2, boolean bl, String string3) throws NoSuchRealmException, BadRealmException, NoSuchUserException, IOException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string3)) {
            ServiceLogger.logManageFailEvent(string4, string3, 6660147, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        User user = securityService.getIntegrityUser(string2);
        boolean bl2 = bl;
        String string5 = securityProvider.updataEvent(string2, user.isAccessEventSuc(), user.isAccessEventFail(), user.isManagementEventSuc(), bl2, user.isNoAudit());
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(string4, string3, 6660148, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string4, string3, 6660149, new Object[]{string2, string5}, 6);
        }
        return string5;
    }

    public boolean isNoAudit(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isNoAudit();
    }

    public boolean isAuditFileAccessSuccess(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isAccessEventSuc();
    }

    public boolean isAuditFileAccessFail(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getUser(string2);
        return user.isAccessEventFail();
    }

    public boolean isAuditManageSuccess(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isManagementEventSuc();
    }

    public boolean isAuditManageFail(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchUserException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = securityService.getIntegrityUser(string2);
        return user.isManagementEventFail();
    }

    public String addRole(String string, String string2, String string3, String string4, String string5) throws NoSuchRealmException, RoleExistsException {
        String string6 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string6, string5)) {
            ServiceLogger.logManageFailEvent(string6, string5, 6660150, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        if (string2 == null || string2.trim().equals("")) {
            ServiceLogger.logManageFailEvent(string6, string5, 6660151, string2, 6);
            return JSvrResource.getMessage("SVR_124");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string7 = securityProvider.addNewRole(string2, string3);
        if (string7 == null) {
            try {
                string7 = securityProvider.addSubRoleToRole(string2, string4);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                string7 = "The parent role: " + string4 + " does not exist.";
            }
            if (string7 == null) {
                ServiceLogger.logManageSuccessEvent(string6, string5, 6660153, string2, 6);
            } else {
                ServiceLogger.logManageFailEvent(string6, string5, 6660154, new Object[]{string2, string7}, 6);
            }
        } else {
            ServiceLogger.logManageFailEvent(string6, string5, 6660154, new Object[]{string2, string7}, 6);
        }
        return string7;
    }

    public String addRole(String string, String string2, String string3, String string4) throws NoSuchRealmException, RoleExistsException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string4)) {
            ServiceLogger.logManageFailEvent(string5, string4, 6660150, string2, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        if (string2 == null || string2.trim().equals("")) {
            ServiceLogger.logManageFailEvent(string5, string4, "add role " + string2 + ", role name cannot be blank");
            return JSvrResource.getMessage("SVR_124");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addNewRole(string2, string3);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string4, 6660153, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string4, 6660154, new Object[]{string2, string6}, 6);
        }
        return string6;
    }

    public String removeRole(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchRoleException {
        String string4;
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string3)) {
            ServiceLogger.logManageFailEvent(string5, string3, 6660155, string2, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        try {
            string4 = securityProvider.removeRole(string2);
        }
        catch (InUseException inUseException) {
            ServiceLogger.logError(inUseException);
            return JSvrResource.getMessage("SVR_126");
        }
        if (string4 == null) {
            UserDataToolkit.getResourceManager(string).getResourceAliasManager().deleteAllAliasesOfRole(string3, string2);
            ServiceLogger.logManageSuccessEvent(string5, string3, 6660156, string2, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string3, 6660157, new Object[]{string2, string4}, 6);
        }
        return string4;
    }

    public Vector getAllRoles(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getAllRoles();
    }

    public JRole[] getAllJRoles(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityService.getAllRoles();
        JRole[] jRoleArray = new JRole[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Role role = (Role)vector.elementAt(n);
            jRoleArray[n] = new JRoleImpl(role);
            ++n;
        }
        return jRoleArray;
    }

    public Vector getAllRoleNames(String string, String string2) throws NoSuchRealmException, BadRealmException {
        String string3 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string3, string2)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getAllRolesName();
    }

    public Role getRole(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchRoleException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        return securityService.getRole(string3);
    }

    public JRole getJRole(String string, String string2, String string3) throws NoSuchRealmException, BadRealmException, NoSuchRoleException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string)) {
            return null;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        Role role = securityService.getRole(string3);
        JRoleImpl jRoleImpl = null;
        if (role != null) {
            jRoleImpl = new JRoleImpl(role);
        }
        return jRoleImpl;
    }

    public int getRoleMemberCount(String string, String string2) throws NoSuchRealmException, BadRealmException, NoSuchRoleException {
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getRoleSubMembersCount(string2);
    }

    public Vector getSubRolesByRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getSubRolesByRole(string3);
    }

    public JRole[] getSubJRolesByJRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getSubRolesByRole(string3);
        JRole[] jRoleArray = new JRole[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Role role = (Role)vector.elementAt(n);
            jRoleArray[n] = new JRoleImpl(role);
            ++n;
        }
        return jRoleArray;
    }

    public Vector getSubUsersByRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getSubUsersByRole(string3);
    }

    public JUser[] getSubJUsersByJRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Vector vector = securityProvider.getSubUsersByRole(string3);
        JUser[] jUserArray = new JUser[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            User user = (User)vector.elementAt(n);
            jUserArray[n] = new JUserImpl(user);
            ++n;
        }
        return jUserArray;
    }

    public String removeRoleFromParentRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string)) {
            ServiceLogger.logManageFailEvent(string5, string, 6660158, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        String string6 = securityProvider.removeRoleFromParentRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string, 6660159, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string, 6660160, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public String removeUserFromParentRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchUserException, NoSuchRealmException, BadRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string)) {
            ServiceLogger.logManageFailEvent(string5, string, 6660161, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string2}, null);
        }
        String string6 = securityProvider.removeUserFromParentRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string, 6660162, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string, 6660163, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public Vector getSubUsersNameByRole(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            return null;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityProvider.getSubUsersNameByRole(string3);
    }

    public String addSubUserToRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchUserException, NoSuchRealmException, BadRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660164, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addSubUserToRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660165, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string2, 6660166, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public String addSubRoleToRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string5, string2, 6660167, new Object[]{string3, string4}, 6);
            return JSvrResource.getMessage("SVR_123");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        String string6 = securityProvider.addSubRoleToRole(string3, string4);
        if (string6 == null) {
            ServiceLogger.logManageSuccessEvent(string5, string2, 6660168, new Object[]{string3, string4}, 6);
        } else {
            ServiceLogger.logManageFailEvent(string5, string2, 6660169, new Object[]{string3, string4, string6}, 6);
        }
        return string6;
    }

    public Vector getReferUsers(String string, String string2) throws NoSuchUserException, NoSuchRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getReferUsers(string2);
    }

    public Vector getReferRoles(String string, String string2) throws NoSuchUserException, NoSuchRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        return securityService.getReferRoles(string2);
    }

    public boolean isAdminUser(String string) {
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        return securityService.isAdminUser(string);
    }

    public void setUserPrivileges(String string, Vector vector) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        User user = null;
        try {
            user = securityService.getIntegrityUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        securityProvider.setPrincipalPrivileges(user, vector);
    }

    public String setUserPrivileges(String string, String string2, String string3, Vector vector) throws NoSuchUserException, NoSuchRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660170, string3, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660171, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = this.getUser(string2, string, string3);
        securityProvider.setPrincipalPrivileges(user, vector);
        ServiceLogger.logManageSuccessEvent(string4, string2, 6660172, string3, 6);
        return null;
    }

    public void setRolePrivileges(String string, Vector vector) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        try {
            Role role = securityService.getRole(string);
            SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
            securityProvider.setPrincipalPrivileges(role, vector);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return;
        }
    }

    public String setRolePrivileges(String string, String string2, String string3, Vector vector) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660173, string3, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660174, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Role role = securityService.getRole(string3);
        securityProvider.setPrincipalPrivileges(role, vector);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660175, string3, 6);
        return null;
    }

    public String setGroupPrivileges(String string, String string2, String string3, Vector vector) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660176, string3, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660177, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Group group = this.getGroupByName(string, string2, string3);
        securityProvider.setPrincipalPrivileges(group, vector);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660178, string3, 6);
        return null;
    }

    public Vector getUserPrivileges(String string) {
        Vector vector = new Vector();
        if (string == null || string.length() == 0) {
            return vector;
        }
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        User user = null;
        try {
            user = securityService.getIntegrityUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        return securityProvider.getPrincipalPrivileges(user);
    }

    public Vector getUserPrivileges(String string, String string2, String string3) throws NoSuchUserException, NoSuchRealmException {
        Vector vector = new Vector();
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660179, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660180, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        User user = this.getUser(string2, string, string3);
        vector = securityProvider.getPrincipalPrivileges(user);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660181, string3, 6);
        return vector;
    }

    public Vector getRolePrivileges(String string) {
        Vector vector = new Vector();
        if (string == null || string.length() == 0) {
            return vector;
        }
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        try {
            Role role = securityService.getRole(string);
            SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
            vector = securityProvider.getPrincipalPrivileges(role);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return vector;
        }
        return vector;
    }

    public Vector getRolePrivileges(String string, String string2, String string3) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        Vector vector = new Vector();
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660182, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660183, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Role role = this.getRole(string2, string, string3);
        vector = securityProvider.getPrincipalPrivileges(role);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660184, string3, 6);
        return vector;
    }

    public Vector getGroupPrivileges(String string, String string2, String string3) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        Vector vector = new Vector();
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660185, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660186, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        Group group = this.getGroupByName(string, string2, string3);
        vector = securityProvider.getPrincipalPrivileges(group);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660187, string3, 6);
        return vector;
    }

    public Hashtable[] getPrivileges(String string, String string2) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        Hashtable[] hashtableArray = null;
        try {
            Object object;
            Object object2;
            hashtableArray = new Hashtable[3];
            hashtableArray[0] = null;
            String string3 = null;
            Enumeration enumeration = this.getAllUserNames(string);
            if (enumeration != null) {
                hashtableArray[0] = new Hashtable();
                object2 = null;
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    object2 = this.getUserPrivileges(string, string2, string3);
                    if (string3 == null) continue;
                    hashtableArray[0].put(string3, object2);
                }
            }
            hashtableArray[1] = null;
            object2 = null;
            Vector vector = this.getAllRoleNames(string, string2);
            if (vector != null && vector.size() > 0) {
                hashtableArray[1] = new Hashtable();
                object = null;
                int n = 0;
                while (n < vector.size()) {
                    object2 = (String)vector.elementAt(n);
                    object = this.getRolePrivileges(string, string2, (String)object2);
                    if (object2 != null) {
                        hashtableArray[1].put(object2, object);
                    }
                    ++n;
                }
            }
            hashtableArray[2] = null;
            object = null;
            Enumeration enumeration2 = this.getAllGroupNames(string);
            if (enumeration2 != null) {
                hashtableArray[2] = new Hashtable();
                Vector vector2 = null;
                while (enumeration2.hasMoreElements()) {
                    object = (String)enumeration2.nextElement();
                    vector2 = this.getGroupPrivileges(string, string2, (String)object);
                    if (object == null) continue;
                    hashtableArray[2].put(object, vector2);
                }
            }
            return hashtableArray;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public void setPrivileges(String string, String string2, Hashtable[] hashtableArray) throws NoSuchUserException, NoSuchRealmException {
        if (hashtableArray == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Hashtable hashtable = hashtableArray[0];
            if (hashtable != null && !hashtable.isEmpty()) {
                object4 = null;
                object3 = null;
                object2 = hashtable.keys();
                while (object2.hasMoreElements()) {
                    object4 = (String)object2.nextElement();
                    object3 = (Vector)hashtable.get(object4);
                    this.setUserPrivileges(string, string2, (String)object4, (Vector)object3);
                }
            }
            if ((object4 = hashtableArray[1]) != null && !((Hashtable)object4).isEmpty()) {
                object3 = null;
                object2 = null;
                object = ((Hashtable)object4).keys();
                while (object.hasMoreElements()) {
                    object3 = (String)object.nextElement();
                    object2 = (Vector)((Hashtable)object4).get(object3);
                    this.setRolePrivileges(string, string2, (String)object3, (Vector)object2);
                }
            }
            if ((object3 = hashtableArray[2]) != null && !((Hashtable)object3).isEmpty()) {
                object2 = null;
                object = null;
                Enumeration enumeration = ((Hashtable)object3).keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    object = (Vector)((Hashtable)object3).get(object2);
                    this.setGroupPrivileges(string, string2, (String)object2, (Vector)object);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public Vector getPrivilegedUsers(String string) {
        byte by = 1;
        String string2 = ServerEnv.getActiveRealm();
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        return securityProvider.getPrivilegedPrincipals(by, string);
    }

    public Vector getPrivilegedUsers(String string, String string2, String string3) throws NoSuchRealmException {
        Vector vector = new Vector();
        byte by = 1;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660188, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660189, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        vector = securityProvider.getPrivilegedPrincipals(by, string3);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660190, string3, 6);
        return vector;
    }

    public Vector getPrivilegedRoles(String string) {
        byte by = 2;
        String string2 = ServerEnv.getActiveRealm();
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string2);
        return securityProvider.getPrivilegedPrincipals(by, string);
    }

    public Vector getPrivilegedRoles(String string, String string2, String string3) throws NoSuchRealmException {
        Vector vector = new Vector();
        byte by = 2;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660191, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660192, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        vector = securityProvider.getPrivilegedPrincipals(by, string3);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660193, string3, 6);
        return vector;
    }

    public Vector getPrivilegedGroups(String string, String string2, String string3) throws NoSuchRealmException {
        Vector vector = new Vector();
        byte by = 3;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660194, string3, 6);
            return vector;
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660195, new Object[]{string3, string}, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        vector = securityProvider.getPrivilegedPrincipals(by, string3);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660196, string3, 6);
        return vector;
    }

    public void addPrivilegedUsers(String string, Vector vector) {
        Object object;
        byte by = 1;
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            try {
                securityService.getUser((String)object);
            }
            catch (NoSuchUserException noSuchUserException) {
                return;
            }
            ++n;
        }
        object = UserDataToolkit.getSecurityProvider(string2);
        object.addPrivilegedPrincipal(string, vector, by);
    }

    public String addPrivilegedUsers(String string, String string2, String string3, Vector vector) throws NoSuchUserException, NoSuchRealmException {
        byte by = 1;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660197, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660198, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            this.getUser(string2, string, string5);
            ++n;
        }
        securityProvider.addPrivilegedPrincipal(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660199, 6);
        return null;
    }

    public void addPrivilegedRoles(String string, Vector vector) {
        Object object;
        byte by = 2;
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            try {
                securityService.getRole((String)object);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return;
            }
            ++n;
        }
        object = UserDataToolkit.getSecurityProvider(string2);
        object.addPrivilegedPrincipal(string, vector, by);
    }

    public String addPrivilegedRoles(String string, String string2, String string3, Vector vector) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        byte by = 2;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660200, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660201, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            this.getRole(string2, string, string5);
            ++n;
        }
        securityProvider.addPrivilegedPrincipal(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660202, 6);
        return null;
    }

    public String addPrivilegedGroups(String string, String string2, String string3, Vector vector) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        byte by = 3;
        String string4 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string4, string2)) {
            ServiceLogger.logManageFailEvent(string4, string2, 6660203, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660204, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            this.getGroupByName(string, string2, string5);
            ++n;
        }
        securityProvider.addPrivilegedPrincipal(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660205, 6);
        return null;
    }

    public String removePrivilegedUsers(String string, Vector vector) {
        Object object;
        byte by = 1;
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            try {
                securityService.getUser((String)object);
            }
            catch (NoSuchUserException noSuchUserException) {
                return JSvrResource.getMessage("SVR_127") + (String)object + " " + JSvrResource.getMessage("SVR_128");
            }
            ++n;
        }
        object = UserDataToolkit.getSecurityProvider(string2);
        return object.removePrivilegedPrincipals(string, vector, by);
    }

    public String removePrivilegedUsers(String string, String string2, String string3, Vector vector) throws NoSuchUserException, NoSuchRealmException {
        String string4;
        byte by = 1;
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660206, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660207, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            string4 = (String)vector.elementAt(n);
            this.getUser(string2, string, string4);
            ++n;
        }
        string4 = securityProvider.removePrivilegedPrincipals(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660208, 6);
        return string4;
    }

    public String removePrivilegedRoles(String string, Vector vector) {
        Object object;
        byte by = 2;
        String string2 = ServerEnv.getActiveRealm();
        SecurityService securityService = UserDataToolkit.getSecurityService(string2);
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            try {
                securityService.getRole((String)object);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return JSvrResource.getMessage("SVR_129") + (String)object + JSvrResource.getMessage("SVR_128");
            }
            ++n;
        }
        object = UserDataToolkit.getSecurityProvider(string2);
        return object.removePrivilegedPrincipals(string, vector, by);
    }

    public String removePrivilegedRoles(String string, String string2, String string3, Vector vector) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        String string4;
        byte by = 2;
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660209, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660210, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            string4 = (String)vector.elementAt(n);
            this.getRole(string2, string, string4);
            ++n;
        }
        string4 = securityProvider.removePrivilegedPrincipals(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660211, 6);
        return string4;
    }

    public String removePrivilegedGroups(String string, String string2, String string3, Vector vector) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        String string4;
        byte by = 3;
        String string5 = ServerEnv.getActiveRealm();
        if (!this.isAdminUser(string5, string2)) {
            ServiceLogger.logManageFailEvent(string, string2, 6660212, 6);
            return JSvrResource.getMessage("SVR_125");
        }
        SecurityProvider securityProvider = UserDataToolkit.getSecurityProvider(string);
        if (securityProvider == null) {
            ServiceLogger.logManageFailEvent(string, string2, 6660213, string, 6);
            throw new NoSuchRealmException(630091, new Object[]{string}, null);
        }
        int n = 0;
        while (n < vector.size()) {
            string4 = (String)vector.elementAt(n);
            this.getGroupByName(string, string2, string4);
            ++n;
        }
        string4 = securityProvider.removePrivilegedPrincipals(string3, vector, by);
        ServiceLogger.logManageSuccessEvent(string, string2, 6660214, 6);
        return string4;
    }

    public boolean isEditing(String string, int n) throws NoSuchRealmException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (securityService == null) {
            return false;
        }
        return securityService.isEditing(n);
    }

    private void QOIV(String string, String string2, String string3, Vector vector) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        JRole[] jRoleArray = this.getSubJRolesByJRole(string, string2, string3);
        String string4 = null;
        int n = 0;
        while (n < jRoleArray.length) {
            string4 = jRoleArray[n].getName();
            if (!vector.contains(string4)) {
                vector.add(string4);
            }
            this.QOIV(string, string2, string4, vector);
            ++n;
        }
    }

    private void add(String string, String string2, String string3, Vector vector) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        JGroup[] jGroupArray = this.getSubJGroupsByJGroup(string, string2, string3);
        String string4 = null;
        int n = 0;
        while (n < jGroupArray.length) {
            string4 = jGroupArray[n].getName();
            if (!vector.contains(string4)) {
                vector.add(string4);
            }
            this.add(string, string2, string4, vector);
            ++n;
        }
    }

    private void addAllManager(String string, String string2, String string3, Vector vector) throws NoSuchRoleException, NoSuchRealmException, NoSuchGroupException, BadRealmException {
        JGroup[] jGroupArray = this.getJGroupsByJRole(string, string2, string3);
        String string4 = null;
        int n = 0;
        while (n < jGroupArray.length) {
            string4 = jGroupArray[n].getName();
            if (!vector.contains(string4)) {
                vector.add(string4);
            }
            this.add(string, string2, string4, vector);
            ++n;
        }
    }

    public boolean isJUserInJRole(String string, String string2, String string3, String string4) throws NoSuchUserException, NoSuchRoleException, NoSuchGroupException, NoSuchRealmException, BadRealmException {
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        JUser[] jUserArray = this.getSubJUsersByJRole(string, string2, string4);
        String string5 = null;
        int n = 0;
        while (n < jUserArray.length) {
            string5 = jUserArray[n].getName();
            if (string3.equals(string5)) {
                return true;
            }
            ++n;
        }
        Vector vector = new Vector();
        String string6 = null;
        this.addAllManager(string, string2, string4, vector);
        int n2 = 0;
        while (n2 < vector.size()) {
            string6 = (String)vector.elementAt(n2);
            jUserArray = this.getJUsersByJGroup(string, string2, string6);
            int n3 = 0;
            while (n3 < jUserArray.length) {
                string5 = jUserArray[n3].getName();
                if (string3.equals(string5)) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        Vector vector2 = new Vector();
        this.QOIV(string, string2, string4, vector2);
        String string7 = null;
        int n4 = 0;
        while (n4 < vector2.size()) {
            string7 = (String)vector2.elementAt(n4);
            jUserArray = this.getSubJUsersByJRole(string, string2, string7);
            int n5 = 0;
            while (n5 < jUserArray.length) {
                string5 = jUserArray[n5].getName();
                if (string3.equals(string5)) {
                    return true;
                }
                ++n5;
            }
            vector = new Vector();
            this.addAllManager(string, string2, string7, vector);
            int n6 = 0;
            while (n6 < vector.size()) {
                string6 = (String)vector.elementAt(n6);
                jUserArray = this.getJUsersByJGroup(string, string2, string6);
                int n7 = 0;
                while (n7 < jUserArray.length) {
                    string5 = jUserArray[n7].getName();
                    if (string3.equals(string5)) {
                        return true;
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n4;
        }
        return false;
    }

    public boolean isJUserInJGroup(String string, String string2, String string3, String string4) throws NoSuchUserException, NoSuchGroupException, NoSuchRealmException, NoSuchRoleException, BadRealmException {
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        JUser[] jUserArray = this.getJUsersByJGroup(string, string2, string4);
        String string5 = null;
        int n = 0;
        while (n < jUserArray.length) {
            string5 = jUserArray[n].getName();
            if (string3.equals(string5)) {
                return true;
            }
            ++n;
        }
        Vector vector = new Vector();
        String string6 = null;
        this.add(string, string2, string4, vector);
        int n2 = 0;
        while (n2 < vector.size()) {
            string6 = (String)vector.elementAt(n2);
            jUserArray = this.getJUsersByJGroup(string, string2, string6);
            int n3 = 0;
            while (n3 < jUserArray.length) {
                string5 = jUserArray[n3].getName();
                if (string3.equals(string5)) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public boolean isJGroupInJRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchGroupException, NoSuchRealmException, BadRealmException {
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        Vector vector = new Vector();
        String string5 = null;
        this.addAllManager(string, string2, string4, vector);
        int n = 0;
        while (n < vector.size()) {
            string5 = (String)vector.elementAt(n);
            if (string3.equals(string5)) {
                return true;
            }
            ++n;
        }
        Vector vector2 = new Vector();
        this.QOIV(string, string2, string4, vector2);
        String string6 = null;
        int n2 = 0;
        while (n2 < vector2.size()) {
            string6 = (String)vector2.elementAt(n2);
            vector = new Vector();
            this.addAllManager(string, string2, string6, vector);
            int n3 = 0;
            while (n3 < vector.size()) {
                string5 = (String)vector.elementAt(n3);
                if (string3.equals(string5)) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public boolean isJGroupInJGroup(String string, String string2, String string3, String string4) throws NoSuchGroupException, NoSuchRealmException, BadRealmException {
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        Vector vector = new Vector();
        String string5 = null;
        this.add(string, string2, string4, vector);
        int n = 0;
        while (n < vector.size()) {
            string5 = (String)vector.elementAt(n);
            if (string3.equals(string5)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isJRoleInJRole(String string, String string2, String string3, String string4) throws NoSuchRoleException, NoSuchRealmException, BadRealmException {
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        Vector vector = new Vector();
        this.QOIV(string, string2, string4, vector);
        String string5 = null;
        int n = 0;
        while (n < vector.size()) {
            string5 = (String)vector.elementAt(n);
            if (string3.equals(string5)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

