/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.engine;

import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.report.convert.ConverterFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.bean.EngineProperties;
import jet.bean.JREngine;
import jet.bean.ReportInfo;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.DataBlockSet;
import jet.datasource.InputStreamFactory;
import jet.datasource.JRExternalQueryRunner;
import jet.jetc.ReadFailureException;
import jet.report.JetRptReportPanel;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.rptengine.EngineMsgListener;
import jet.rptservice.api.exception.JRScheduleException;
import jet.security.PageACL;
import jet.server.ServerEnv;
import jet.server.api.ReportSheetInfo;
import jet.server.api.SecurityContext;
import jet.server.api.ServerInfo;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.intf.engine.EngineContext;
import jet.server.intf.engine.ReportEngine;
import jet.server.intf.engine.ReportSetEngine;
import jet.server.jrc.engine.EngineManager;
import jet.server.jrc.engine.EngineQueueElement;
import jet.server.jrc.engine.JRRemoteTaskListener;
import jet.server.jrc.engine.JRReportEngine;
import jet.server.jrc.engine.JRReportSetEngine;
import jet.server.jrc.engine.NonBurstingResultTaskThread;
import jet.server.jrc.engine.PrepareBurstingDataThread;
import jet.server.jrc.engine.RemoteEngineBase;
import jet.server.jrc.engine.ReportSetEngineFactory;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrserver.JRReportSheetInfo;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.bursting.MultiBurstingExecutor;
import jet.server.schedule.bursting.SubTaskThreadListener;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.TaskCanceledException;
import jet.universe.JetUUniverse;
import jet.util.EngineErrorListener;
import jet.util.EngineRuntimeInfo;
import jet.util.NLSBundleInfo;
import jet.util.RuntimeInfo;

public class JREngineContext
extends RemoteEngineBase
implements EngineMsgListener,
EngineContext,
EngineErrorListener {
    protected JREngine jrengine = null;
    private JRReportSetEngine NLS_ENCODING = null;
    String QOIV = null;
    String ThreadException = null;
    private String add = null;
    private String[] addEngineListener = null;
    private EngineQueueElement[] addNonBurstingResultListener = null;
    private ReportEngine[] append = null;
    private PageACL arraycopy = null;
    private ServerInfo available = null;
    private boolean clear = false;
    MultiBurstingExecutor I = null;
    private PrepareBurstingDataThread close = null;
    private NonBurstingResultTaskThread containsKey = null;
    private String[] convertingOldReport = null;
    private Hashtable copyFromRemote;
    private Hashtable createDefaultRuntimeInfo;
    private String createEngine;
    private boolean createRemoteTaskListener = true;
    private String currentThread;
    private String decRptEngineRef;
    private int decRptSetEngineRef = -1;
    private Hashtable delete = new Hashtable();
    private Hashtable dequeueEngine;
    private boolean destroy = false;
    private String elementAt = null;
    private SubTaskThreadListener elements = null;

    public JREngineContext(JRResourceManager jRResourceManager, EngineManager engineManager) throws RemoteException {
        super(jRResourceManager, engineManager);
    }

    public JREngineContext(String string, String string2, JRResourceManager jRResourceManager) throws RemoteException {
        super(string, string2, jRResourceManager);
    }

    public JREngine getJREngine() {
        return this.jrengine;
    }

    public ReportEngine createReportEngine(String string) throws TaskCanceledException, JRScheduleException, RemoteException {
        if (this.addEngineListener == null) {
            this.addEngineListener = new String[1];
            this.addEngineListener[0] = string;
        }
        JRReportEngine jRReportEngine = new JRReportEngine(this, this.NLS_ENCODING, string);
        jRReportEngine.createEngine(this.QOIV(string));
        this.append[this.NLS_ENCODING((String)string)] = jRReportEngine;
        return jRReportEngine;
    }

    private int NLS_ENCODING(String string) {
        int n = 0;
        while (n < this.addEngineListener.length) {
            if (this.addEngineListener[n].equals(string)) break;
            ++n;
        }
        if (n >= this.addEngineListener.length) {
            n = 0;
        }
        return n;
    }

    public void decRptEngineRef() {
        super.decRptEngineRef(this.append[0], this.addNonBurstingResultListener[0]);
    }

    public void setRunningSheets(String[] stringArray) {
        this.addEngineListener = stringArray;
        if (stringArray == null) {
            this.append = new ReportEngine[1];
            this.addNonBurstingResultListener = new EngineQueueElement[1];
            this.addNonBurstingResultListener[0] = new EngineQueueElement(null);
        } else {
            this.append = new ReportEngine[stringArray.length];
            this.addNonBurstingResultListener = new EngineQueueElement[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.addNonBurstingResultListener[n] = new EngineQueueElement(stringArray[n]);
                ++n;
            }
        }
    }

    public void setRunningSheets(String[] stringArray, int n) throws RemoteException {
        this.decRptSetEngineRef = n;
        this.setRunningSheets(stringArray);
        int n2 = 0;
        while (n2 < this.addNonBurstingResultListener.length) {
            this.addNonBurstingResultListener[n2].setPriority(n);
            this.addNonBurstingResultListener[n2].setTaskID(this.getTaskID());
            ++n2;
        }
    }

    private EngineQueueElement QOIV(String string) {
        if (this.addEngineListener == null) {
            return this.addNonBurstingResultListener[0];
        }
        int n = 0;
        while (n < this.addEngineListener.length) {
            if (this.addEngineListener[n].equals(string)) {
                return this.addNonBurstingResultListener[n];
            }
            ++n;
        }
        return null;
    }

    public void createJREngine(String string, String string2, String string3, boolean bl) throws TaskCanceledException, RemoteException {
        this.createEngine = string;
        if (!this.localManager.incThreadQueueController(this.addNonBurstingResultListener) && this.clear) {
            throw new TaskCanceledException(600032);
        }
        Object object = DriverConfigFactory.getJdbcDriversConfig();
        this.jrengine = new JREngine(new EngineProperties(string, string2, string3, object, ServerEnv.getCompressIO()));
        ServiceLogger.logDebug(4600195, new Object[]{new Integer(this.jrengine.getID())}, 4);
        object = null;
        String string4 = null;
        try {
            object = this.getSequenceID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string4 = this.getCurrentReport() == null ? this.QOIV : this.getCurrentReport().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            ServiceLogger.logDump(5600151, new Object[]{String.valueOf(this.jrengine.getID()), object, string4}, 5);
        }
        int n = this.jrengine.getID();
        int n2 = 0;
        while (n2 < this.addNonBurstingResultListener.length) {
            this.addNonBurstingResultListener[n2].setEngineID(n);
            ++n2;
        }
        this.localManager.incRptSetEngineRef(this.jrengine);
    }

    public boolean hasPageSecurity() throws RemoteException {
        return this.jrengine.hasPageSecurity();
    }

    public void setSingleThread(boolean bl) throws RemoteException {
        this.createRemoteTaskListener = bl;
        this.jrengine.setSingleThread(bl);
    }

    public void setPriority(int n) throws RemoteException {
        this.jrengine.setPriority(n);
    }

    public void setLocale(Locale locale) throws RemoteException {
        Properties properties = NLSUtil.getFontMapInfo(locale);
        if (properties == null) {
            this.jrengine.setLocale(locale);
        } else {
            String string = properties.getProperty(NLSUtil.NLS_ENCODING);
            properties.remove(NLSUtil.NLS_ENCODING);
            this.jrengine.setBoundleInfo(properties, locale, string);
        }
    }

    public void setLocale(String string) throws RemoteException {
        Locale locale = new Locale(string);
        Properties properties = NLSUtil.getFontMapInfo(locale);
        if (properties == null) {
            this.jrengine.setLocale(string);
        } else {
            String string2 = properties.getProperty(NLSUtil.NLS_ENCODING);
            properties.remove(NLSUtil.NLS_ENCODING);
            this.jrengine.setBoundleInfo(properties, locale, string2);
        }
    }

    public void setEncoding(String string) throws RemoteException {
        this.jrengine.setEncoding(string);
    }

    public void setConvertEncoding(int n, int n2) throws RemoteException {
        this.jrengine.setConvertEncoding(n, n2);
    }

    public void setStyleGroup(String string) throws RemoteException {
        this.jrengine.setStyleGroup(string);
    }

    public void setUserName(String string) throws RemoteException {
        this.jrengine.setUserName(string);
    }

    public void setClientName(String string) throws RemoteException {
        this.jrengine.setClientName(string);
    }

    public void setParamFile(String string) throws RemoteException {
        boolean bl = this.isSharedDir(string);
        String string2 = this.getLocalName(string);
        if (!bl) {
            string2 = this.getLocalName(string);
            try {
                if (!this.isLocal) {
                    this.fileService.copyFromRemote(string, string2);
                }
                this.add = string;
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
        } else {
            string2 = string;
        }
        this.jrengine.setParamFile(string2);
    }

    public void deleteParamFile() throws RemoteException {
        if (this.add != null) {
            File file = new File(this.add);
            file.delete();
        }
    }

    public void setConnection(String string, String string2, String string3, String string4, boolean bl) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3, string4, bl);
    }

    public void setConnection(Connection connection, boolean bl) throws RemoteException {
        this.jrengine.setConnection(connection, bl);
    }

    public void setConnection(String string, Connection connection) throws RemoteException {
        this.jrengine.setConnection(string, connection);
    }

    public void setConnection(String string, String string2, String string3) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3);
    }

    public void setConnection(String string, String string2, String string3, String string4, String string5) throws RemoteException {
        this.jrengine.setConnection(string, string2, string3, string4, string5);
    }

    public void setThrowException(boolean bl) throws RemoteException {
        this.jrengine.setThrowException(bl);
    }

    public void addEngineListener(String string) throws RemoteException {
        if (this.taskListener == null) {
            this.taskListener = this.manager.createRemoteTaskListener(string);
        }
        this.jrengine.addEngineListener((EngineErrorListener)this);
    }

    public void setServerInfo(ServerInfo serverInfo) throws RemoteException {
        this.jrengine.setServerInfo(serverInfo);
        this.available = serverInfo;
    }

    public ServerInfo getServerInfo() throws RemoteException {
        return this.available;
    }

    public void setReportName(String string, String string2, String string3) throws TaskCanceledException, UnknownResource, RemoteException {
        try {
            Object object;
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            String string4 = this.rscMan.getRptRealPath(string, string2, string3, true);
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            if (!string4.endsWith(".clx")) {
                object = this.rscMan.getRealPath(string, string2);
                this.ThreadException = object;
                this.jrengine.setCatName((String)object);
            }
            object = ConverterFactory.getConverter();
            boolean bl = object.isPreviousReportSchema(string4);
            ConverterFactory.destroy();
            if (bl) {
                String string5 = ResourceToolkit.convertingOldReport(this.ThreadException, string4);
                this.jrengine.setReportName(string5);
                this.QOIV = string5;
            } else {
                this.jrengine.setReportName(string4);
                this.QOIV = string4;
            }
        }
        catch (TaskCanceledException taskCanceledException) {
            throw taskCanceledException;
        }
        catch (UnknownResource unknownResource) {
            throw unknownResource;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setReportName(String string, String string2, int n, String string3, int n2) throws TaskCanceledException, UnknownResource, RemoteException {
        try {
            Object object;
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            String string4 = this.rscMan.getRptRealPath(string, string3, n2);
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            if (!string4.endsWith(".clx")) {
                object = this.rscMan.getRealPath(string, string2, n);
                this.ThreadException = object;
                if (this.clear) {
                    throw new TaskCanceledException(600032);
                }
                this.jrengine.setCatName((String)object);
            }
            object = ConverterFactory.getConverter();
            boolean bl = object.isPreviousReportSchema(string4);
            ConverterFactory.destroy();
            ServiceLogger.logDebug(5600166, new Object[]{string4, new Boolean(bl)}, 5);
            if (bl) {
                String string5 = ResourceToolkit.convertingOldReport(this.ThreadException, string4);
                this.jrengine.setReportName(string5);
                this.QOIV = string5;
            } else {
                this.jrengine.setReportName(string4);
                this.QOIV = string4;
            }
            ServiceLogger.logDebug(6600165, new Object[]{this.QOIV, this.ThreadException}, 6);
        }
        catch (TaskCanceledException taskCanceledException) {
            throw taskCanceledException;
        }
        catch (UnknownResource unknownResource) {
            throw unknownResource;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setParamValues(String string) throws RemoteException {
        this.jrengine.setParamValues(string);
    }

    public void setParamValues(Properties properties) throws RemoteException {
        this.jrengine.setParamValues(properties);
    }

    public void setNamedWherePortion(String string) throws RemoteException {
        this.jrengine.setNamedWherePortion(string);
    }

    public void setWherePortion(String string) throws RemoteException {
        this.jrengine.setWherePortion(string);
    }

    public void setExternalQueryRunner(JRExternalQueryRunner jRExternalQueryRunner) {
        this.jrengine.setExternalQueryRunner(jRExternalQueryRunner);
    }

    public void setDHTML(boolean bl) throws RemoteException {
        this.jrengine.setDHTML(bl);
    }

    public boolean loadReport() throws Exception {
        try {
            boolean bl = false;
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            bl = this.jrengine.loadReport();
            if (this.clear) {
                throw new TaskCanceledException(600032);
            }
            return bl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
    }

    public String getStatus() throws RemoteException {
        return this.jrengine.getStatus();
    }

    public String getReason() throws RemoteException {
        return this.jrengine.getReason();
    }

    public String getReasonWithThrowable() throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer(this.jrengine.getReason());
        Throwable throwable = this.jrengine.getThrowable();
        if (throwable != null) {
            stringBuffer.append("\n").append(SchdTools.getStackTraceString(throwable));
        }
        return stringBuffer.toString();
    }

    public void getPageAcl() throws RemoteException {
        this.arraycopy = this.jrengine.getPageACL();
    }

    public boolean isPageAcl() throws RemoteException {
        return this.arraycopy != null;
    }

    public void writeACL(String string) throws RemoteException, Exception {
        this.arraycopy.write((OutputStream)new FileOutputStream(string));
    }

    public int[] getPages() throws RemoteException {
        return this.jrengine.getPages();
    }

    public void engineExit() throws RemoteException {
        if (this.clear) {
            return;
        }
        this.engineExit(false, true);
    }

    public void engineExit(boolean bl, boolean bl2) throws RemoteException {
        this.clear = bl;
        if (this.NLS_ENCODING != null && bl2) {
            try {
                this.NLS_ENCODING.free(bl);
                try {
                    UnicastRemoteObject.unexportObject(this.NLS_ENCODING, false);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    ServiceLogger.logError(noSuchObjectException, 3);
                }
                this.NLS_ENCODING = null;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        if (bl && this.containsKey != null) {
            this.containsKey.I();
        }
        if (this.jrengine != null) {
            this.jrengine.removeEngineListener((EngineErrorListener)this);
            if (bl2) {
                try {
                    this.jrengine.exit();
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            ServiceLogger.logDebug(4600196, new Object[]{new Integer(this.jrengine.getID())}, 4);
        }
        if (this.I != null) {
            this.I.exit();
        } else {
            this.dequeueEngine();
        }
        if (this.taskListener != null) {
            this.taskListener.quit();
            if (this.taskListener instanceof JRRemoteTaskListener) {
                try {
                    UnicastRemoteObject.unexportObject(this.taskListener, false);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    ServiceLogger.logError(noSuchObjectException, 3);
                }
            }
            this.taskListener = null;
        }
        if (this.append != null) {
            int n = 0;
            while (n < this.append.length) {
                if (this.append[n] != null) {
                    try {
                        UnicastRemoteObject.unexportObject(this.append[n], false);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        ServiceLogger.logError(noSuchObjectException, 3);
                    }
                    this.append[n] = null;
                }
                ++n;
            }
            if (this.I == null) {
                this.append = null;
            }
        }
        this.I = null;
        this.jrengine = null;
        this.available = null;
        this.delete.clear();
        this.delete = null;
    }

    public void dequeueEngine() {
        this.decRptSetEngineRef();
        int n = 0;
        while (n < this.addNonBurstingResultListener.length) {
            if (this.addNonBurstingResultListener[n].getStatus() != 4) {
                this.decRptEngineRef(this.append[n], this.addNonBurstingResultListener[n]);
            }
            ++n;
        }
    }

    public void stopEngineReport() throws RemoteException {
        this.jrengine.stopReport();
    }

    public int getIOTime() throws RemoteException {
        return this.jrengine.getIOTime();
    }

    public int getProcessTime() throws RemoteException {
        return this.jrengine.getProcessTime();
    }

    public boolean getBooleanReturnValue(String string) throws RemoteException {
        return this.jrengine.getBooleanReturnValue(string);
    }

    public Hashtable getJREngineProperty() {
        if (this.jrengine == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("SingleThread", String.valueOf(this.jrengine.getSingleThread()));
        String string = this.jrengine.getSID();
        if (string != null) {
            hashtable.put("SID", string);
        }
        hashtable.put("totalPageNumber", String.valueOf(this.jrengine.getTotalPageNumber()));
        hashtable.put("reason", String.valueOf(this.jrengine.getReason()));
        hashtable.put("IOTime", String.valueOf(this.jrengine.getIOTime()));
        hashtable.put("processTime", String.valueOf(this.jrengine.getProcessTime()));
        hashtable.put("status", this.jrengine.getStatus());
        return hashtable;
    }

    public void setAllowFFP(boolean bl) throws RemoteException {
        this.jrengine.setAllowFFP(bl);
    }

    public void setSecurityContext(SecurityContext securityContext) throws RemoteException {
        this.jrengine.setSecurityContext(securityContext);
    }

    public void setAuthencatorMessage(String string, String string2, String string3) throws RemoteException {
        this.jrengine.setAuthencatorMessage(string, string2, string3);
    }

    public void setJndiConnection(String string, String string2, String string3, String string4) throws RemoteException, Exception {
        this.jrengine.setJNDIConnection(string, string2, string3, string4);
    }

    public void setConnectionInfoProvider(ConnectionInfoProvider connectionInfoProvider) throws RemoteException {
        this.jrengine.setConnectionInfoProvider(connectionInfoProvider);
    }

    public ReportSheetInfo getCurrentReport() throws RemoteException {
        ReportInfo reportInfo = this.jrengine.getCurrentReport();
        if (reportInfo != null) {
            return new JRReportSheetInfo(reportInfo);
        }
        return null;
    }

    public Vector getReportsOfReportSet() throws RemoteException {
        Vector vector;
        Vector<JRReportSheetInfo> vector2 = null;
        try {
            vector = this.jrengine.getReportsOfReportSet();
        }
        catch (ReadFailureException readFailureException) {
            throw new RemoteException(readFailureException.getMessage());
        }
        if (vector != null) {
            vector2 = new Vector<JRReportSheetInfo>();
            int n = 0;
            while (n < vector.size()) {
                ReportInfo reportInfo = (ReportInfo)vector.elementAt(n);
                vector2.add(new JRReportSheetInfo(reportInfo));
                ++n;
            }
        }
        return vector2;
    }

    public ReportSetEngine getReportSetEngine(String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception, RemoteException {
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        if (this.NLS_ENCODING == null) {
            this.NLS_ENCODING = new JRReportSetEngine(this, ReportSetEngineFactory.getReportSetEngine(this.jrengine, stringArray, stringArray2, stringArray3));
        }
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.NLS_ENCODING;
    }

    private String[] ThreadException(String[] stringArray, boolean[] blArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                bl = blArray[n];
                if (!bl) {
                    bl = this.isSharedDir(stringArray[n]);
                }
                stringArray2[n] = !bl ? this.getLocalName(stringArray[n]) : stringArray[n];
                ++n;
            }
        }
        return stringArray2;
    }

    public ReportSetEngine getReportSetEngine(String[] stringArray, String[] stringArray2, boolean[] blArray, boolean[] blArray2, String[] stringArray3, boolean[] blArray3, boolean[] blArray4, String string, boolean bl) throws Exception, RemoteException {
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        if (this.NLS_ENCODING == null) {
            String[] stringArray4 = this.ThreadException(stringArray2, blArray2);
            String[] stringArray5 = this.ThreadException(stringArray3, blArray4);
            this.NLS_ENCODING = new JRReportSetEngine(this, ReportSetEngineFactory.getReportSetEngine(this.jrengine, stringArray, stringArray4, blArray, stringArray5, blArray3, string, bl));
        }
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.NLS_ENCODING;
    }

    public ReportSetEngine getBurstingReportSetEngine(String[] stringArray, boolean[] blArray, boolean[] blArray2, String[] stringArray2, boolean[] blArray3, boolean[] blArray4, DataBlock[] dataBlockArray, boolean bl) throws Exception, RemoteException {
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        String[] stringArray3 = this.ThreadException(stringArray, blArray2);
        String[] stringArray4 = this.ThreadException(stringArray2, blArray4);
        this.NLS_ENCODING = new JRReportSetEngine(this, ReportSetEngineFactory.getBurstingReportSetEngine(this.jrengine, this.elementAt, stringArray3, blArray, stringArray4, blArray3, bl ? this.convertingOldReport : this.elements.getSelectedSchemas(), dataBlockArray, bl));
        if (this.clear) {
            throw new TaskCanceledException(600032);
        }
        return this.NLS_ENCODING;
    }

    public void getTaskListener(String string) throws RemoteException {
        if (this.taskListener == null) {
            this.taskListener = this.manager.createRemoteTaskListener(string);
        }
    }

    public String getReportName() {
        return this.QOIV;
    }

    public void noteError(Thread thread, Throwable throwable, int n, String string) {
        try {
            String string2 = "errorType=" + n + ";detectorThread=" + thread + ";msg=" + string;
            ServiceLogger.logError(throwable);
            this.taskListener.noteError(string2, throwable);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void notifyReceiver(EngineErrorListener engineErrorListener) {
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        try {
            if (thread != null) {
                this.taskListener.ThreadException(thread.toString(), throwable);
            } else {
                this.taskListener.ThreadException(null, throwable);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void engineMassage(String string) {
        try {
            this.taskListener.engineMassage(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void started() {
        try {
            this.taskListener.started();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
    }

    public void finished() {
        try {
            this.taskListener.finished();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setUnvAndRpt(JetUUniverse jetUUniverse, JetRptReportPanel jetRptReportPanel) {
        this.jrengine.setUnvAndRpt(jetUUniverse, jetRptReportPanel);
    }

    public String toString() {
        return super.toString() + "-[jrengine:" + this.jrengine + "]";
    }

    public String getTempDir() {
        return this.rscMan.getTempDir();
    }

    public void setIsHtmlPipeLine(boolean bl) {
        this.jrengine.setIsPipe(bl);
    }

    public void setNLSBundleInfo(NLSBundleInfo nLSBundleInfo) throws RemoteException {
        this.jrengine.setNLSBundleInfo(nLSBundleInfo);
    }

    public boolean getRuntimePrecision(String string) throws RemoteException {
        RuntimeInfo runtimeInfo = this.jrengine.getRuntimeInfo(string);
        if (runtimeInfo == null) {
            runtimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
        }
        return runtimeInfo.isHighPrecision();
    }

    public void setRuntimeInfo(String string, boolean bl, String string2) throws RemoteException {
        RuntimeInfo runtimeInfo = this.jrengine.getRuntimeInfo(string);
        if (runtimeInfo == null) {
            runtimeInfo = EngineRuntimeInfo.createDefaultRuntimeInfo();
        }
        runtimeInfo.setHighPrecision(bl);
        runtimeInfo.setExportStyleGroup(string2);
        this.jrengine.setRuntimeInfo(string, runtimeInfo);
    }

    public void setXmlStreamFactory(String string, InputStreamFactory inputStreamFactory) throws RemoteException {
        try {
            this.jrengine.setXmlStreamFactory(string, inputStreamFactory);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RemoteException(jRScheduleException.getMessage());
        }
    }

    public void setHDSStreamFactory(String string, String string2, InputStreamFactory inputStreamFactory) throws RemoteException {
        try {
            this.jrengine.setHDSStreamFactory(string, string2, inputStreamFactory);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new RemoteException(jRScheduleException.getMessage());
        }
    }

    public boolean prepareBurstingData(String string, String[] stringArray, Properties properties, boolean bl, Properties properties2) throws ReadFailureException {
        this.currentThread = string;
        this.decRptEngineRef = this.add(this.currentThread);
        try {
            this.jrengine.initBurstingReportSetEngine(string);
        }
        catch (JRScheduleException jRScheduleException) {
            ServiceLogger.logError(2600231, jRScheduleException.getMessage(), 2);
            ServiceLogger.logError(jRScheduleException, 3);
            return false;
        }
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (stringArray2 == null) {
            bl2 = true;
            ReportInfo reportInfo = JRTUtil.getReportOfReportSet(this.jrengine, this.currentThread);
            BurstingSchema[] burstingSchemaArray = reportInfo.getBurstingSchemas();
            stringArray2 = new String[]{burstingSchemaArray[0].getName()};
        }
        this.I = new MultiBurstingExecutor(this.jrengine, this.createEngine, this.createRemoteTaskListener, string, properties, stringArray2, bl, bl2);
        if (bl) {
            this.containsKey = new NonBurstingResultTaskThread(properties2, stringArray2, this);
            this.I.addNonBurstingResultListener(this.containsKey);
        }
        this.I.setMaxFileNumberInFolder(ServerEnv.getMaxTempFileNumberInFolder());
        this.copyFromRemote = new Hashtable();
        this.createDefaultRuntimeInfo = new Hashtable();
        this.dequeueEngine = new Hashtable();
        this.close = new PrepareBurstingDataThread(this);
        this.close.setPriority(this.decRptSetEngineRef);
        this.close.start();
        if (this.containsKey != null) {
            this.containsKey.setPriority(this.decRptSetEngineRef - 1);
            this.containsKey.setName(Thread.currentThread().getName() + " Non-Bursting Result");
            this.containsKey.start();
        }
        return true;
    }

    public String getDefaultSchema(String string) throws ReadFailureException {
        ReportInfo reportInfo = JRTUtil.getReportOfReportSet(this.jrengine, string);
        BurstingSchema[] burstingSchemaArray = reportInfo.getBurstingSchemas();
        return burstingSchemaArray[0].getName();
    }

    public void setSelectedSchemas(String[] stringArray) throws RemoteException {
        this.convertingOldReport = stringArray;
    }

    public Object[] hasNextDataBlockSet() throws DSException {
        DataBlockSet dataBlockSet = this.I.getNextBurstingDataBlockSet();
        if (dataBlockSet != null) {
            Object[] objectArray = new Object[]{new Integer(dataBlockSet.getId()), dataBlockSet.getRecipients(), new Integer(dataBlockSet.getDataBlocks().length), this.addNonBurstingResultListener(dataBlockSet.getKeyStr()), dataBlockSet.getBurstingSchemaName()};
            ServiceLogger.logDebug(6600239, new Object[]{objectArray[0], dataBlockSet.getKeyStr(), objectArray[2]}, 6);
            this.copyFromRemote.put(objectArray[0], dataBlockSet);
            DataBlock[] dataBlockArray = dataBlockSet.getDataBlocks();
            InputStream[] inputStreamArray = new InputStream[dataBlockArray.length];
            int n = 0;
            while (n < dataBlockArray.length) {
                try {
                    inputStreamArray[n] = dataBlockArray[n].getStream();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 2);
                }
                ++n;
            }
            this.createDefaultRuntimeInfo.put(objectArray[0], inputStreamArray);
            return objectArray;
        }
        return null;
    }

    private String add(String string) {
        Vector vector;
        try {
            vector = this.jrengine.getReportsOfReportSet();
        }
        catch (ReadFailureException readFailureException) {
            return "";
        }
        int n = 0;
        while (n < vector.size()) {
            ReportInfo reportInfo = (ReportInfo)vector.elementAt(n);
            if (reportInfo.getRptName().equals(string)) {
                return reportInfo.getRptDisplayName();
            }
            ++n;
        }
        return "";
    }

    private String addNonBurstingResultListener(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.decRptEngineRef);
        stringBuffer.append("_").append(string);
        String string2 = stringBuffer.length() <= 60 ? stringBuffer.toString() : stringBuffer.substring(0, 60);
        return string2;
    }

    public byte[] readDataBlock(int n, int n2) throws IOException {
        InputStream[] inputStreamArray = (InputStream[])this.createDefaultRuntimeInfo.get(new Integer(n));
        return this.append(inputStreamArray[n2]);
    }

    private byte[] append(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n = inputStream.read(byArray, 0, 32768);
        if (n <= 32768) {
            if (n == -1) {
                n = 0;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public String getDataSetName(int n, int n2) throws RemoteException {
        DataBlockSet dataBlockSet = (DataBlockSet)this.copyFromRemote.get(new Integer(n));
        DataBlock dataBlock = dataBlockSet.getDataBlocks()[n2];
        return dataBlock.getDataSetName();
    }

    public String getSharedDataSetName(String string, int n) throws Exception, RemoteException {
        DataBlock[] dataBlockArray = this.I.getSharedDataBlocks(string);
        if (dataBlockArray[n] != null) {
            return dataBlockArray[n].getDataSetName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readSharedDataBlock(String string, int n, int n2) throws Exception, RemoteException {
        BufferedInputStream[] bufferedInputStreamArray;
        Object object;
        Hashtable hashtable = this.dequeueEngine;
        synchronized (hashtable) {
            if (!this.dequeueEngine.containsKey(string)) {
                object = this.I.getSharedDataBlocks(string);
                bufferedInputStreamArray = new BufferedInputStream[((DataBlock[])object).length];
                int n3 = 0;
                while (n3 < ((DataBlock[])object).length) {
                    if (object[n3] != null) {
                        bufferedInputStreamArray[n3] = new BufferedInputStream(object[n3].getStream());
                        bufferedInputStreamArray[n3].mark(bufferedInputStreamArray[n3].available() + 1);
                    }
                    ++n3;
                }
                this.dequeueEngine.put(string, bufferedInputStreamArray);
            }
            bufferedInputStreamArray = (BufferedInputStream[])this.dequeueEngine.get(string);
        }
        object = bufferedInputStreamArray[n];
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                ((BufferedInputStream)object).reset();
                ((BufferedInputStream)object).skip(n2);
                byte[] byArray = this.append((InputStream)object);
                return byArray;
            }
        }
        return null;
    }

    public int getSharedDataBlockNumber(String string) throws Exception, RemoteException {
        DataBlock[] dataBlockArray = this.I.getSharedDataBlocks(string);
        return dataBlockArray.length;
    }

    public void notifyFinishedRunDataBlock(int n) throws RemoteException {
        this.copyFromRemote.remove(new Integer(n));
        InputStream[] inputStreamArray = (InputStream[])this.createDefaultRuntimeInfo.remove(new Integer(n));
        int n2 = 0;
        while (n2 < inputStreamArray.length) {
            if (inputStreamArray[n2] != null) {
                try {
                    inputStreamArray[n2].close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 3);
                }
            }
            ++n2;
        }
        this.I.runBurstingDataBlockFinished(n);
    }

    void failToPrepareData(Exception exception) throws RemoteException {
        this.taskListener.failToPrepareData(exception);
    }

    public void setIsSubBurstingTask(String string) {
        this.destroy = true;
        this.elementAt = string;
    }

    public void setIsNonBurstingTask(String string) {
        this.elementAt = string;
    }

    public boolean getIsSubBurstingTask() {
        return this.destroy;
    }

    public void addSubTaskThreadListener(SubTaskThreadListener subTaskThreadListener) {
        this.elements = subTaskThreadListener;
    }

    public boolean[][] isHasPLSandSecConstraint(String[] stringArray) throws RemoteException {
        boolean[][] blArray = new boolean[2][stringArray.length];
        try {
            Vector vector = this.jrengine.getReportsOfReportSet();
            int n = 0;
            while (n < stringArray.length) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ReportInfo reportInfo = (ReportInfo)enumeration.nextElement();
                    if (!reportInfo.getRptName().equals(stringArray[n])) continue;
                    blArray[0][n] = reportInfo.hasPLS();
                    boolean bl = blArray[1][n] = reportInfo.hasCLS() || reportInfo.hasRLS();
                }
                ++n;
            }
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        return blArray;
    }
}

