/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.engine;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import jet.bean.JREngine;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.jrc.JRRemoteFileService;
import jet.server.jrc.engine.EngineManager;
import jet.server.jrc.engine.EngineQueueElement;
import jet.server.jrc.engine.JREngineContext;
import jet.server.jrc.engine.JREngineManager;
import jet.server.jrc.engine.RemoteTaskListener;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class RemoteEngineBase
extends UnicastRemoteObject {
    protected boolean isLocal = false;
    protected JRResourceManager rscMan = null;
    protected String host = null;
    protected String port = null;
    protected JRRemoteFileService fileService = null;
    protected EngineManager manager = null;
    protected JREngineManager localManager = null;
    protected RemoteTaskListener taskListener = null;
    private String copyToRemote = null;
    private String equalsIgnoreCase = null;

    public RemoteEngineBase(JRResourceManager jRResourceManager, EngineManager engineManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.rscMan = jRResourceManager;
        this.isLocal = true;
        this.manager = engineManager;
        this.host = engineManager.getHost();
        this.port = engineManager.getPort();
    }

    public void setJREngineManager(JREngineManager jREngineManager) {
        this.localManager = jREngineManager;
    }

    public RemoteEngineBase(String string, String string2, JRResourceManager jRResourceManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.rscMan = jRResourceManager;
        this.isLocal = false;
        this.host = string;
        this.port = string2;
        try {
            this.fileService = new JRRemoteFileService(string, Integer.parseInt(string2));
        }
        catch (Exception exception) {
            throw new RemoteException("", exception);
        }
        try {
            this.manager = (EngineManager)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "EngineManager");
        }
        catch (Exception exception) {
            throw new RemoteException("", exception);
        }
    }

    public JRRemoteFileService getRemoteFileService() {
        return this.fileService;
    }

    public JREngineManager getJREngineManager() {
        return this.localManager;
    }

    public EngineManager getEngineManager() {
        return this.manager;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getLocalName(String string) {
        if (this.isLocal) {
            return string;
        }
        String string2 = null;
        int n = string.lastIndexOf(CSUtil.fileSep);
        if (n >= 0) {
            string2 = this.rscMan.getTempDir() + string.substring(n + 1);
        }
        return string2;
    }

    public String getLocalHistName(String string) {
        if (this.isLocal) {
            return string;
        }
        String string2 = null;
        int n = string.lastIndexOf(CSUtil.fileSep);
        if (n >= 0) {
            string2 = this.rscMan.getHistDir() + string.substring(n + 1);
        }
        return string2;
    }

    public String getRemoteName(String string) throws RemoteException {
        if (this.isLocal) {
            return string;
        }
        String string2 = this.fileService.getRemoteHomePath();
        String string3 = ServerEnv.homePath;
        int n = string3.length();
        return string2 + string.substring(n);
    }

    public void copyFiles(List list, String string) throws RemoteException {
        String[] stringArray = CSUtil.getPathAndName(string);
        String string2 = stringArray[0] + CSUtil.fileSep;
        try {
            if (list != null) {
                int n = 0;
                while (n < list.size()) {
                    String string3 = (String)list.get(n);
                    File file = new File(string3);
                    String string4 = file.getName();
                    this.fileService.copyToRemote(string3, string2 + string4);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw new RemoteException("", exception);
        }
    }

    public boolean isSharedDir(String string) {
        String[] stringArray = CSUtil.getPathAndName(string);
        String string2 = stringArray[0] + CSUtil.fileSep;
        if (string2.equalsIgnoreCase(this.rscMan.getTempDir()) && ServerEnv.isSharedTempDir()) {
            return true;
        }
        return ServerEnv.isSharedHistDir() && string2.startsWith(this.rscMan.getHistDir());
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getLocalHost() throws RemoteException {
        return this.localManager == null ? null : this.localManager.getHost();
    }

    public String getLocalPort() throws RemoteException {
        return this.localManager == null ? null : this.localManager.getPort();
    }

    public void setTaskID(String string) throws RemoteException {
        this.copyToRemote = string;
    }

    public String getTaskID() throws RemoteException {
        return this.copyToRemote;
    }

    public void setSequenceID(String string) throws RemoteException {
        this.equalsIgnoreCase = string;
    }

    public String getSequenceID() throws RemoteException {
        return this.equalsIgnoreCase;
    }

    public void decRptSetEngineRef() {
        this.localManager.decRptSetEngineRef(this);
        JREngine jREngine = null;
        String string = null;
        String string2 = null;
        Object var4_4 = null;
        if (this instanceof JREngineContext) {
            jREngine = ((JREngineContext)this).getJREngine();
        }
        if (jREngine instanceof JREngine) {
            string = String.valueOf(jREngine.getID());
        }
        try {
            string2 = this.getSequenceID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ServiceLogger.isLoggable(6, 5)) {
            ServiceLogger.logDump(5600152, new Object[]{string, string2, var4_4}, 5);
        }
    }

    public void decRptEngineRef(Object object, EngineQueueElement engineQueueElement) {
        this.localManager.decRptEngineRef(object, engineQueueElement);
    }

    public RemoteTaskListener getTaskListener() {
        return this.taskListener;
    }
}

