/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.FolderRecord;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.security.User;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;

public class FolderImpl
extends NodeImpl
implements Folder {
    private FolderRecord QOIV;
    private Hashtable addElement;
    private boolean append = false;
    private boolean clear = false;

    public FolderImpl() {
        this(new FolderRecord());
        this.append = true;
    }

    public FolderImpl(String string) {
        super(string);
        this.setNodeType((byte)1);
    }

    public FolderImpl(FolderRecord folderRecord) {
        super(folderRecord);
        this.QOIV = folderRecord;
        this.addElement = new Hashtable();
    }

    public void remove() {
        this.QOIV = null;
        this.addElement.clear();
        super.remove();
    }

    public String getRealPath() {
        return this.QOIV.getRealPath();
    }

    public void setRealPath(String string) {
        this.QOIV.setRealPath(string);
    }

    public void addChild(Node node) {
        if (!this.addElement.contains(node)) {
            if (this.clear) {
                this.addElement.put(node.getName(), node);
            } else {
                this.addElement.put(node.getName().toUpperCase(), node);
            }
        }
    }

    public Vector getChildren(User user) {
        Vector vector = new Vector();
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public synchronized Vector getChildren() {
        Vector vector = new Vector();
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public boolean removeChild(Node node) {
        if (this.addElement.containsKey(node.getName().toUpperCase())) {
            this.addElement.remove(node.getName().toUpperCase());
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        return this.QOIV.getOwnerName();
    }

    public void setOwnerName(String string) {
        this.QOIV.setOwnerName(string);
    }

    public boolean checkPermission(User user, Permission permission) {
        String string = this.getOwnerName();
        return string != null && string.equals(user.getName()) || this.isValidAdminUser(user);
    }

    public String toString() {
        return "FolderImpl@" + this.hashCode() + "[" + super.toString() + ", childNum=" + this.addElement.size() + ", isRoot=" + this.isRoot() + "]";
    }

    public boolean hasChild(String string) {
        return this.addElement.containsKey(string.toUpperCase());
    }

    public Node getChild(String string) {
        if (this.clear) {
            return (Node)this.addElement.get(string);
        }
        return (Node)this.addElement.get(string.toUpperCase());
    }

    public void setParent(Node node) {
        super.setParent(node);
        String string = node.getAbsolutePath();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.setAbsolutePath(string + this.QOIV.getName());
    }

    public PathInfo toPathInfo(String string) {
        PathInfoImpl pathInfoImpl = super.getPathInfo(string);
        pathInfoImpl.setRealPath(this.getRealPath());
        pathInfoImpl.setArchiveNewVersion(this.isArchiveNewVersion());
        pathInfoImpl.setMaxVersionAmount(this.getMaxVersionAmount());
        pathInfoImpl.setEnableArchivePolicy(this.isEnableArchivePolicy());
        pathInfoImpl.setShared(this.isShared());
        pathInfoImpl.setEnableDynamicResource(this.isEnableDynamicResource());
        return pathInfoImpl;
    }

    public Vector getPublicChildren() {
        Vector vector = new Vector();
        String string = "/USERFOLDERPATH".substring(1);
        Enumeration enumeration = this.addElement.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(string.toUpperCase())) continue;
            vector.addElement(this.addElement.get(string2));
        }
        return vector;
    }

    public boolean setProperties(Hashtable hashtable) {
        int n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), false);
        String string = (String)hashtable.get("jrs.node_real_path");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.node_share"), false);
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_dynamic_resource"), false);
        boolean bl5 = false;
        if (n != this.QOIV.getMaxVersionAmount() || bl != this.QOIV.isArchiveNewVersion() || string == null && this.QOIV.getRealPath() != null || string != null && !string.equalsIgnoreCase(this.QOIV.getRealPath()) || bl2 != this.QOIV.isEnableArchivePolicy() || bl3 != this.QOIV.isShared() || bl4 != this.QOIV.isEnableDynamicResource()) {
            bl5 = true;
            this.QOIV.setMaxVersionAmount(n);
            this.QOIV.setArchiveNewVersion(bl);
            this.QOIV.setRealPath(string);
            this.QOIV.setEnableArchivePolicy(bl2);
            this.QOIV.setShared(bl3);
            this.QOIV.setEnalbeDynamicResource(bl4);
        }
        return bl5;
    }

    public boolean isArchiveNewVersion() {
        if (this.isEnableArchivePolicy()) {
            return this.QOIV.isArchiveNewVersion();
        }
        return true;
    }

    public boolean isEnableArchivePolicy() {
        return this.QOIV.isEnableArchivePolicy();
    }

    public int getMaxVersionAmount() {
        if (this.isArchiveNewVersion()) {
            return this.QOIV.getMaxVersionAmount();
        }
        return 0;
    }

    public void setMaxVersionAmount(int n) {
        this.QOIV.setMaxVersionAmount(n);
    }

    public boolean isShared() {
        return this.QOIV.isShared();
    }

    public void setShared(boolean bl) {
        this.QOIV.setShared(bl);
    }

    public void replaceChildName(String string, String string2) {
        Object v = this.addElement.remove(string.toUpperCase());
        if (v != null) {
            this.addElement.put(string2.toUpperCase(), v);
        }
    }

    public boolean isEnableDynamicResource() {
        return this.QOIV.isEnableDynamicResource();
    }

    public void setEnableDynamicResource(boolean bl) {
        this.QOIV.setEnalbeDynamicResource(bl);
    }

    public boolean isFakeFolder() {
        return this.append;
    }

    public void setAbsolutePath(String string) {
        super.setAbsolutePath(string);
        if (this.getAbsolutePath().equals("/USERFOLDERPATH")) {
            this.clear = true;
        }
    }
}

