/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.ResourceNodeRecord;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.intf.security.User;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;
import jet.util.IntKeyHashtable;

public class ResourceImpl
extends NodeImpl
implements Resource {
    private ResourceNodeRecord QOIV;
    private IntKeyHashtable append;
    private ResourceInfo clear = null;
    private Resource elements = null;

    public ResourceImpl(String string) {
        super(string);
        this.setNodeType((byte)2);
    }

    public ResourceImpl(ResourceNodeRecord resourceNodeRecord) {
        super(resourceNodeRecord);
        this.QOIV = resourceNodeRecord;
        this.append = new IntKeyHashtable();
    }

    public void remove() {
        this.QOIV = null;
    }

    public Vector getVersions(User user) {
        return this.append.elements();
    }

    public Vector getVersions() {
        return this.append.elements();
    }

    public Version getVersion(int n, User user) {
        return (Version)this.append.get(n);
    }

    public Version getVersion(int n) {
        return (Version)this.append.get(n);
    }

    public void addVersion(Version version, User user) {
        this.append.put(version.getVersionNumber(), (Object)version);
    }

    public void addVersion(Version version) {
        this.append.put(version.getVersionNumber(), (Object)version);
    }

    public void removeVersion(int n, User user) {
        this.append.remove(n);
    }

    public ResourceInfo getEntity() {
        return this.clear;
    }

    public void setEntity(ResourceInfo resourceInfo) {
        this.clear = resourceInfo;
    }

    public String getRealDir() {
        return this.QOIV.getRealPath();
    }

    public void setRealDir(String string) {
        this.QOIV.setRealPath(string);
    }

    public int getMaxVersionAmount() {
        if (this.isArchiveNewVersion()) {
            return this.QOIV.getMaxVersionAmount();
        }
        return 0;
    }

    public void setMaxVersionAmount(int n) {
        this.QOIV.setMaxVersionAmount(n);
    }

    public byte getResourceType() {
        return this.QOIV.getResourceType();
    }

    public Resource getResult() {
        return this.elements;
    }

    public void setParent(Node node) {
        super.setParent(node);
        String string = node.getAbsolutePath();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.setAbsolutePath(string + this.QOIV.getName());
    }

    public PathInfo toPathInfo(String string) {
        PathInfoImpl pathInfoImpl = super.getPathInfo(string);
        pathInfoImpl.setResourceType(this.getResourceType());
        pathInfoImpl.setMaxVersionAmount(this.getMaxVersionAmount());
        pathInfoImpl.setLatestVersionNumber(this.getLatestVersionNumber());
        pathInfoImpl.setArchiveNewVersion(this.isArchiveNewVersion());
        pathInfoImpl.setEnableArchivePolicy(this.isEnableArchivePolicy());
        String string2 = this.clear == null ? "" : this.clear.getRealPath();
        pathInfoImpl.setRealPath(string2);
        pathInfoImpl.setProfileName(this.QOIV.getProfileName());
        return pathInfoImpl;
    }

    public void setResult(Resource resource) {
        this.elements = resource;
    }

    public void removeVersions() {
        this.append.clear();
        this.append = null;
    }

    public String toString() {
        return "ResourceImpl[" + super.toString() + "]";
    }

    public int getLatestVersionNumber() {
        if (this.clear != null) {
            return this.clear.getVersionNumber();
        }
        return 0;
    }

    public boolean setProperties(Hashtable hashtable) {
        int n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), false);
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        String string = (String)hashtable.get("jrs.profile");
        boolean bl3 = false;
        if (n != this.QOIV.getMaxVersionAmount() || bl != this.QOIV.isArchiveNewVersion() || bl2 != this.QOIV.isEnableArchivePolicy() || string != this.QOIV.getProfileName()) {
            bl3 = true;
            this.QOIV.setMaxVersionAmount(n);
            this.QOIV.setArchiveNewVersion(bl);
            this.QOIV.setEnableArchivePolicy(bl2);
            this.QOIV.setProfileName(string);
        }
        return bl3;
    }

    public boolean isArchiveNewVersion() {
        if (this.isEnableArchivePolicy()) {
            return this.QOIV.isArchiveNewVersion();
        }
        return true;
    }

    public boolean isEnableArchivePolicy() {
        return this.QOIV.isEnableArchivePolicy();
    }
}

