/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import com.jinfonet.report.convert.Converter;
import com.jinfonet.report.convert.ConverterFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.server.ServerEnv;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.util.RefResource;
import jet.server.util.ServerUtil;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.util.WildcardMatcher;

public class ResourceToolkit {
    private static String QOIV = null;
    private static String add = ServerEnv.homePath;
    private static final Properties addElement = new Properties();
    private static long addResource = 0L;

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResources(file, folder, bl, bl2, false, resourceTreeManagerImpl, string);
    }

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResources(file, folder, bl, bl2, false, resourceTreeManagerImpl, string, false, null);
    }

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl4, Hashtable hashtable) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            Folder folder2 = null;
            ResourceInfo resourceInfo = null;
            boolean bl5 = CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false);
            Vector vector = new Vector();
            if (hashtable != null) {
                ResourceToolkit.saveStyleFiles((String)hashtable.get("jrs.deploy_local_style_dir"));
            }
            String string2 = hashtable == null ? null : (String)hashtable.get("jrs.deploy_local_font_dir");
            int n = 0;
            while (n < stringArray.length) {
                block19: {
                    File file2 = new File(file, stringArray[n]);
                    try {
                        Hashtable<String, String> hashtable2;
                        if (file2.isDirectory() && !bl4) {
                            block18: {
                                hashtable2 = new Hashtable<String, String>();
                                hashtable2.put("jrs.node_name", stringArray[n]);
                                if (!bl5 && hashtable.get("jrs.permission_values") != null) {
                                    hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
                                }
                                if (!bl3) {
                                    // empty if block
                                }
                                try {
                                    folder2 = null;
                                    folder2 = resourceTreeManagerImpl.addSubFolder(folder, hashtable2, string);
                                }
                                catch (NodeExistsException nodeExistsException) {
                                    Node node = folder.getChild(stringArray[n]);
                                    if (node == null || node.getNodeType() != 1) break block18;
                                    folder2 = (Folder)node;
                                }
                            }
                            if (folder2 != null && bl) {
                                ResourceToolkit.importResources(file2, folder2, bl, bl2, bl3, resourceTreeManagerImpl, string, false, hashtable);
                            }
                            break block19;
                        }
                        boolean bl6 = false;
                        boolean bl7 = false;
                        if (CSUtil.isCatalogFile(stringArray[n])) {
                            bl6 = true;
                        } else if (CSUtil.isOrdinaryReportFile(stringArray[n])) {
                            bl7 = true;
                        }
                        if ((bl6 || bl7) && (bl2 || !folder.hasChild(stringArray[n]))) {
                            hashtable2 = new Hashtable();
                            hashtable2.put("jrs.node_name", stringArray[n]);
                            if (bl6) {
                                hashtable2.put("jrs.node_type", String.valueOf(2));
                            } else {
                                hashtable2.put("jrs.node_type", String.valueOf(0));
                            }
                            if (!bl5 && hashtable.get("jrs.permission_values") != null) {
                                hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
                            }
                            resourceInfo = ResourceToolkit.addElement(file2.getCanonicalPath(), string, string2, resourceTreeManagerImpl);
                            resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                ++n;
            }
        }
    }

    public static void importResourcesWithConvert(File file, Folder folder, boolean bl, boolean bl2, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResourcesWihtConvert(file, folder, bl, bl2, false, resourceTreeManagerImpl, string, false, null);
    }

    public static void importResourcesWihtConvert(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl4, Hashtable hashtable) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            Folder folder2 = null;
            ResourceInfo resourceInfo = null;
            Vector vector = new Vector();
            if (hashtable != null) {
                ResourceToolkit.saveStyleFiles((String)hashtable.get("jrs.deploy_local_style_dir"));
            }
            String string2 = hashtable == null ? null : (String)hashtable.get("jrs.deploy_local_font_dir");
            int n = 0;
            while (n < stringArray.length) {
                block22: {
                    File file2 = new File(file, stringArray[n]);
                    try {
                        Hashtable<String, String> hashtable2;
                        if (file2.isDirectory() && !bl4) {
                            block21: {
                                hashtable2 = new Hashtable<String, String>();
                                hashtable2.put("jrs.node_name", stringArray[n]);
                                if (!bl3) {
                                    // empty if block
                                }
                                try {
                                    folder2 = null;
                                    folder2 = resourceTreeManagerImpl.addSubFolder(folder, hashtable2, string);
                                }
                                catch (NodeExistsException nodeExistsException) {
                                    Node node = folder.getChild(stringArray[n]);
                                    if (node == null || node.getNodeType() != 1) break block21;
                                    folder2 = (Folder)node;
                                }
                            }
                            if (folder2 != null && bl) {
                                ResourceToolkit.importResourcesWihtConvert(file2, folder2, bl, bl2, bl3, resourceTreeManagerImpl, string, false, hashtable);
                            }
                            break block22;
                        }
                        boolean bl5 = false;
                        boolean bl6 = false;
                        if (CSUtil.isCatalogFile(stringArray[n])) {
                            bl5 = true;
                        } else if (CSUtil.isOrdinaryReportFile(stringArray[n])) {
                            bl6 = true;
                        }
                        if ((bl5 || bl6) && (bl2 || !folder.hasChild(stringArray[n]))) {
                            hashtable2 = new Hashtable();
                            hashtable2.put("jrs.node_name", stringArray[n]);
                            if (bl5) {
                                hashtable2.put("jrs.node_type", String.valueOf(2));
                            } else {
                                hashtable2.put("jrs.node_type", String.valueOf(0));
                            }
                            if (!bl5 && bl6) {
                                String string3 = file2.getCanonicalPath();
                                Converter converter = ConverterFactory.getConverter();
                                boolean bl7 = converter.isPreviousReportSchema(string3);
                                if (bl7) {
                                    String string4 = ResourceToolkit.add(string3);
                                    if (string4 == null) {
                                        string4 = ResourceToolkit.QOIV(folder);
                                    }
                                    resourceInfo = ResourceToolkit.addResource(string3, string4, string, null, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                                } else {
                                    resourceInfo = ResourceToolkit.addElement(string3, string, null, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                                }
                                ConverterFactory.destroy();
                            } else {
                                resourceInfo = ResourceToolkit.addElement(file2.getCanonicalPath(), string, string2, resourceTreeManagerImpl);
                                resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                            }
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                ++n;
            }
        }
    }

    public static void importResources(File file, Folder folder, boolean bl, ResourceTreeManagerImpl resourceTreeManagerImpl, String string) {
        ResourceToolkit.importResources(file, folder, bl, true, resourceTreeManagerImpl, string);
    }

    public static void importResources(File file, Folder folder, String string, ResourceTreeManagerImpl resourceTreeManagerImpl, String string2) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            ResourceInfo resourceInfo = null;
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                try {
                    if (!file2.isDirectory() && !stringArray[n].equalsIgnoreCase(string)) {
                        boolean bl = false;
                        boolean bl2 = false;
                        if (CSUtil.isCatalogFile(stringArray[n])) {
                            bl = true;
                        } else if (CSUtil.isOrdinaryReportFile(stringArray[n])) {
                            bl2 = true;
                        }
                        if (bl || bl2) {
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("jrs.node_name", stringArray[n]);
                            if (bl) {
                                hashtable.put("jrs.node_type", String.valueOf(2));
                            } else {
                                hashtable.put("jrs.node_type", String.valueOf(0));
                            }
                            resourceInfo = ResourceToolkit.addElement(file2.getCanonicalPath(), string2, null, resourceTreeManagerImpl);
                            resourceTreeManagerImpl.addResource(folder, hashtable, resourceInfo, string2);
                        }
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                ++n;
            }
        }
    }

    public static void importResources(File file, Folder folder, String string, boolean bl, ResourceTreeManagerImpl resourceTreeManagerImpl, String string2) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            ResourceInfo resourceInfo = null;
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                try {
                    if (!file2.isDirectory() && !stringArray[n].equalsIgnoreCase(string)) {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (CSUtil.isCatalogFile(stringArray[n])) {
                            bl2 = true;
                        } else if (CSUtil.isOrdinaryReportFile(stringArray[n])) {
                            bl3 = true;
                        }
                        if (bl2 || bl3) {
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("jrs.node_name", stringArray[n]);
                            if (bl2) {
                                hashtable.put("jrs.node_type", String.valueOf(2));
                            } else {
                                hashtable.put("jrs.node_type", String.valueOf(0));
                            }
                            if (bl3 && bl) {
                                String string3 = file2.getCanonicalPath();
                                Converter converter = ConverterFactory.getConverter();
                                boolean bl4 = converter.isPreviousReportSchema(string3);
                                if (bl4) {
                                    String string4 = ResourceToolkit.add(string3);
                                    if (string4 == null) {
                                        string4 = ResourceToolkit.QOIV(folder);
                                    }
                                    resourceInfo = ResourceToolkit.addResource(string3, string4, string2, string3, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable, resourceInfo, string2);
                                } else {
                                    resourceInfo = ResourceToolkit.addElement(string3, string2, string3, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable, resourceInfo, string2);
                                }
                                ConverterFactory.destroy();
                            }
                            if (bl2 || bl3 && !bl) {
                                resourceInfo = ResourceToolkit.addElement(file2.getCanonicalPath(), string2, file2.getCanonicalPath(), resourceTreeManagerImpl);
                                resourceTreeManagerImpl.addResource(folder, hashtable, resourceInfo, string2);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                ++n;
            }
        }
    }

    public static void importResources(File file, Folder folder, boolean bl, boolean bl2, boolean bl3, boolean bl4, ResourceTreeManagerImpl resourceTreeManagerImpl, String string, boolean bl5, Hashtable hashtable) {
        String[] stringArray;
        String string2 = "";
        File file2 = null;
        boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false);
        if (bl4 && !(file2 = new File(string2 = !(stringArray = ServerEnv.getReportHome()).endsWith(File.separator) ? (String)stringArray + File.separator + "temp" + File.separator + "convertFiles" : (String)stringArray + "temp" + File.separator + "convertFiles")).exists()) {
            file2.mkdirs();
        }
        if (file.exists() && file.isDirectory()) {
            stringArray = file.list();
            Folder folder2 = null;
            ResourceInfo resourceInfo = null;
            Vector vector = new Vector();
            if (hashtable != null) {
                ResourceToolkit.saveStyleFiles((String)hashtable.get("jrs.deploy_local_style_dir"));
            }
            String string3 = hashtable == null ? null : (String)hashtable.get("jrs.deploy_local_font_dir");
            int n = 0;
            while (n < stringArray.length) {
                block25: {
                    File file3 = new File(file, stringArray[n]);
                    try {
                        Hashtable<String, String> hashtable2;
                        if (file3.isDirectory() && !bl5) {
                            block24: {
                                hashtable2 = new Hashtable<String, String>();
                                hashtable2.put("jrs.node_name", stringArray[n]);
                                if (!bl6 && hashtable.get("jrs.permission_values") != null) {
                                    hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
                                }
                                if (!bl3) {
                                    // empty if block
                                }
                                try {
                                    folder2 = null;
                                    folder2 = resourceTreeManagerImpl.addSubFolder(folder, hashtable2, string);
                                }
                                catch (NodeExistsException nodeExistsException) {
                                    Node node = folder.getChild(stringArray[n]);
                                    if (node == null || node.getNodeType() != 1) break block24;
                                    folder2 = (Folder)node;
                                }
                            }
                            if (folder2 != null && bl) {
                                ResourceToolkit.importResources(file3, folder2, bl, bl2, bl3, resourceTreeManagerImpl, string, false, hashtable);
                            }
                            break block25;
                        }
                        boolean bl7 = false;
                        boolean bl8 = false;
                        if (CSUtil.isCatalogFile(stringArray[n])) {
                            bl7 = true;
                        } else if (CSUtil.isOrdinaryReportFile(stringArray[n])) {
                            bl8 = true;
                        }
                        if ((bl7 || bl8) && (bl2 || !folder.hasChild(stringArray[n]))) {
                            hashtable2 = new Hashtable();
                            hashtable2.put("jrs.node_name", stringArray[n]);
                            if (bl7) {
                                hashtable2.put("jrs.node_type", String.valueOf(2));
                            } else {
                                hashtable2.put("jrs.node_type", String.valueOf(0));
                            }
                            if (!bl6 && hashtable.get("jrs.permission_values") != null) {
                                hashtable2.put("jrs.permission_values", (String)hashtable.get("jrs.permission_values"));
                            }
                            if (bl8 && bl4) {
                                String string4 = file3.getCanonicalPath();
                                Converter converter = ConverterFactory.getConverter();
                                boolean bl9 = converter.isPreviousReportSchema(string4);
                                if (bl9) {
                                    String string5 = ResourceToolkit.add(string4);
                                    if (string5 == null) {
                                        string5 = ResourceToolkit.QOIV(folder);
                                    }
                                    resourceInfo = ResourceToolkit.addResource(string4, string5, string, string3, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                                } else {
                                    resourceInfo = ResourceToolkit.addElement(string4, string, string3, resourceTreeManagerImpl);
                                    resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                                }
                                ConverterFactory.destroy();
                            }
                            if (bl7 || bl8 && !bl4) {
                                resourceInfo = ResourceToolkit.addElement(file3.getCanonicalPath(), string, string3, resourceTreeManagerImpl);
                                resourceTreeManagerImpl.addResource(folder, hashtable2, resourceInfo, string);
                            }
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                ++n;
            }
        }
    }

    private static String QOIV(Folder folder) {
        Vector vector = folder.getChildren();
        int n = 0;
        while (n < vector.size()) {
            Resource resource;
            ResourceInfo resourceInfo;
            int n2;
            Node node = (Node)vector.elementAt(n);
            byte by = node.getNodeType();
            if (by == 2 && (n2 = (resourceInfo = (resource = (Resource)node).getEntity()).getResourceType()) == 1) {
                return resourceInfo.getRealPath();
            }
            ++n;
        }
        return null;
    }

    private static String add(String string) {
        File file;
        String string2;
        File file2 = new File(string);
        if (file2.exists() && (string2 = file2.getParent()) != null && (file = new File(string2)).isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                block5: {
                    String string3;
                    try {
                        string3 = fileArray[n].getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        break block5;
                    }
                    if (CSUtil.isCatalogFile(string3)) {
                        return string3;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public static ResourceInfo createResourceInfo(Hashtable hashtable, String string, ResourceTreeManagerImpl resourceTreeManagerImpl) throws UnknownResource {
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        if (by == -1) {
            return null;
        }
        String string2 = (String)hashtable.get("jrs.node_name");
        if (string2 == null || string2.trim().length() == 0 || !CSUtil.isValidNodeName(string2)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string2), 3);
            return null;
        }
        if (hashtable != null) {
            ResourceToolkit.saveStyleFiles((String)hashtable.get("jrs.deploy_local_style_dir"));
        }
        switch (by) {
            case 2: {
                CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
                catalogInfoImpl.setName(string2);
                String string3 = (String)hashtable.get("jrs.deploy_from_file");
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = (String)hashtable.get("jrs.catalog");
                }
                if (string3 == null || string3.trim().length() == 0) {
                    return null;
                }
                File file = new File(string3);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                catalogInfoImpl.setCatalog(ResourceToolkit.convertRptSchema(string3, string, resourceTreeManagerImpl));
                return catalogInfoImpl;
            }
            case 0: {
                ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
                reportInfoImpl.setName(string2);
                String string4 = (String)hashtable.get("jrs.deploy_from_file");
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = (String)hashtable.get("jrs.report");
                }
                if (string4 == null || string4.trim().length() == 0) {
                    return null;
                }
                File file = new File(string4);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.report_from_adhoc"), false);
                if (!bl || !string4.startsWith(ResourceToolkit.getHistDir())) {
                    reportInfoImpl.setReportFile(ResourceToolkit.currentTimeMillis(string4, string, null, (String)hashtable.get("jrs.deploy_local_font_dir"), resourceTreeManagerImpl));
                } else {
                    reportInfoImpl.setReportFile(string4);
                }
                return reportInfoImpl;
            }
            case 1: {
                String string5;
                Object object;
                Object object2;
                ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
                resultInfoImpl.setName(string2);
                int n = -1;
                String string6 = (String)hashtable.get("jrs.catalog");
                if (string6 != null && string6.trim().length() != 0) {
                    try {
                        resultInfoImpl.setCatalogReourceId(n);
                        int n2 = resourceTreeManagerImpl.getNodeByPath((String)hashtable.get("jrs.report"), string).getID();
                        resultInfoImpl.setReportResourceId(n2);
                        n = resourceTreeManagerImpl.getNodeByPath(string6, string).getID();
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        ServiceLogger.logError(noPrivilegeException.getMessage());
                    }
                }
                resultInfoImpl.setParamFile((String)hashtable.get("jrs.param_file"));
                Enumeration enumeration = hashtable.keys();
                Hashtable<Object, ResultDetailedInfo> hashtable2 = new Hashtable<Object, ResultDetailedInfo>();
                long l = 0L;
                long l2 = 0L;
                ResultDetailedInfo resultDetailedInfo = null;
                while (enumeration.hasMoreElements()) {
                    String string7;
                    boolean bl;
                    object2 = (String)enumeration.nextElement();
                    if (!((String)object2).startsWith("jrs.report_sheet$") || !(bl = CSUtil.getBoolean(string7 = (String)hashtable.get(object2), true))) continue;
                    object = object2 = ((String)object2).substring("jrs.report_sheet".length() + 1);
                    String string8 = (String)hashtable.get("SheetDisplayName:$" + (String)object2);
                    string5 = (String)hashtable.get(object2);
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$" + (String)object2), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$" + (String)object2), 0L);
                    resultDetailedInfo = new ResultDetailedInfo((String)object, string8, string5, 0L, l, l2);
                    hashtable2.put(object2, resultDetailedInfo);
                }
                if (hashtable.get("jrs.rst_result") != null) {
                    string5 = (String)hashtable.get("jrs.rst_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.rst_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.rst_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.rst_result", null, string5, 0L, l, l2);
                    hashtable2.put("jrs.rst_result", resultDetailedInfo);
                }
                if (hashtable.get("jrs.rsd_result") != null) {
                    string5 = (String)hashtable.get("jrs.rsd_result");
                    l = CSUtil.parseLong((String)hashtable.get("jrs.pls_result_fmts$jrs.rsd_result"), 0L);
                    l2 = CSUtil.parseLong((String)hashtable.get("jrs.sec_constraint_fmts$jrs.rsd_result"), 0L);
                    resultDetailedInfo = new ResultDetailedInfo("jrs.rsd_result", null, string5, 0L, l, l2);
                    hashtable2.put("jrs.rsd_result", resultDetailedInfo);
                }
                resultInfoImpl.setSheetsResultDetails(hashtable2);
                resultInfoImpl.setResultFile((String)hashtable.get("jrs.result"));
                resultInfoImpl.setResultFormats(CSUtil.parseLong((String)hashtable.get("jrs.result_type"), 0L));
                resultInfoImpl.setReportAmount(CSUtil.parseInt((String)hashtable.get("jrs.result_report_amount"), -1));
                resultInfoImpl.setLaunchType(CSUtil.parseInt((String)hashtable.get("jrs.launch_type"), 0));
                resultInfoImpl.setTaskId((String)hashtable.get("jrs.task_id"));
                object2 = (Date)hashtable.get("jrs.expired_time");
                if (object2 != null) {
                    resultInfoImpl.setExpire(true);
                    resultInfoImpl.setExpireationTime((Date)object2);
                    resultInfoImpl.setExpireationMethod(CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 1));
                } else {
                    object = new GregorianCalendar();
                    ((GregorianCalendar)object).add(1, 100);
                    resultInfoImpl.setExpireationTime(((Calendar)object).getTime());
                }
                object = (String)hashtable.get("jrs.archive_specified_destination");
                resultInfoImpl.setSpecifiedFolder((String)object);
                resultInfoImpl.setCatalogVerNum(CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), 0));
                resultInfoImpl.setReportVerNum(CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), 0));
                return resultInfoImpl;
            }
        }
        return null;
    }

    public static ResourceInfo createResourceInfo(Hashtable hashtable, String string, Folder folder, boolean bl, ResourceTreeManagerImpl resourceTreeManagerImpl) throws UnknownResource {
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        if (by == -1) {
            return null;
        }
        String string2 = (String)hashtable.get("jrs.node_name");
        if (string2 == null || string2.trim().length() == 0 || !CSUtil.isValidNodeName(string2)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string2), 3);
            return null;
        }
        if (hashtable != null) {
            ResourceToolkit.saveStyleFiles((String)hashtable.get("jrs.deploy_local_style_dir"));
        }
        switch (by) {
            case 2: {
                CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
                catalogInfoImpl.setName(string2);
                String string3 = (String)hashtable.get("jrs.deploy_from_file");
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = (String)hashtable.get("jrs.catalog");
                }
                if (string3 == null || string3.trim().length() == 0) {
                    return null;
                }
                File file = new File(string3);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                catalogInfoImpl.setCatalog(ResourceToolkit.convertRptSchema(string3, string, resourceTreeManagerImpl));
                return catalogInfoImpl;
            }
            case 0: {
                if (bl) {
                    String string4 = "";
                    File file = null;
                    String string5 = ServerEnv.getReportHome();
                    string4 = !string5.endsWith(File.separator) ? string5 + File.separator + "temp" + File.separator + "convertFiles" : string5 + "temp" + File.separator + "convertFiles";
                    file = new File(string4);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
                    reportInfoImpl.setName(string2);
                    String string6 = (String)hashtable.get("jrs.deploy_from_file");
                    if (string6 == null || string6.trim().length() == 0) {
                        string6 = (String)hashtable.get("jrs.report");
                    }
                    if (string6 == null || string6.trim().length() == 0) {
                        return null;
                    }
                    Converter converter = ConverterFactory.getConverter();
                    boolean bl2 = false;
                    try {
                        bl2 = converter.isPreviousReportSchema(string6);
                    }
                    catch (JetRptReportIOException jetRptReportIOException) {
                        ServiceLogger.logError(jetRptReportIOException);
                    }
                    ConverterFactory.destroy();
                    if (bl2) {
                        File file2;
                        String string7 = ResourceToolkit.add(string6);
                        if (string7 == null) {
                            string7 = ResourceToolkit.QOIV(folder);
                        }
                        if (!(file2 = new File(string6)).exists() || !file2.isFile()) {
                            return null;
                        }
                        reportInfoImpl.setReportFile(ResourceToolkit.addSubFolder(string6, string7, string, null, (String)hashtable.get("jrs.deploy_local_font_dir"), null, resourceTreeManagerImpl));
                        return reportInfoImpl;
                    }
                    File file3 = new File(string6);
                    if (!file3.exists() || !file3.isFile()) {
                        return null;
                    }
                    boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.report_from_adhoc"), false);
                    if (!bl3 || !string6.startsWith(ResourceToolkit.getHistDir())) {
                        reportInfoImpl.setReportFile(ResourceToolkit.currentTimeMillis(string6, string, null, (String)hashtable.get("jrs.deploy_local_font_dir"), resourceTreeManagerImpl));
                    } else {
                        reportInfoImpl.setReportFile(string6);
                    }
                    return reportInfoImpl;
                }
                ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
                reportInfoImpl.setName(string2);
                String string8 = (String)hashtable.get("jrs.deploy_from_file");
                if (string8 == null || string8.trim().length() == 0) {
                    string8 = (String)hashtable.get("jrs.report");
                }
                if (string8 == null || string8.trim().length() == 0) {
                    return null;
                }
                File file = new File(string8);
                if (!file.exists() || !file.isFile()) {
                    return null;
                }
                boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.report_from_adhoc"), false);
                if (!bl4 || !string8.startsWith(ResourceToolkit.getHistDir())) {
                    reportInfoImpl.setReportFile(ResourceToolkit.currentTimeMillis(string8, string, null, (String)hashtable.get("jrs.deploy_local_font_dir"), resourceTreeManagerImpl));
                } else {
                    reportInfoImpl.setReportFile(string8);
                }
                return reportInfoImpl;
            }
            case 1: {
                Object object;
                ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
                resultInfoImpl.setName(string2);
                int n = -1;
                String string9 = (String)hashtable.get("jrs.catalog");
                if (string9 != null && string9.trim().length() != 0) {
                    try {
                        int n2 = resourceTreeManagerImpl.getNodeByPath((String)hashtable.get("jrs.report"), string).getID();
                        resultInfoImpl.setReportResourceId(n2);
                        n = resourceTreeManagerImpl.getNodeByPath(string9, string).getID();
                        resultInfoImpl.setCatalogReourceId(n);
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        ServiceLogger.logError(noPrivilegeException.getMessage());
                    }
                }
                resultInfoImpl.setParamFile((String)hashtable.get("jrs.param_file"));
                resultInfoImpl.setResultFile((String)hashtable.get("jrs.result"));
                resultInfoImpl.setResultFormats(CSUtil.parseLong((String)hashtable.get("jrs.result_type"), 0L));
                resultInfoImpl.setReportAmount(CSUtil.parseInt((String)hashtable.get("jrs.result_report_amount"), -1));
                resultInfoImpl.setLaunchType(CSUtil.parseInt((String)hashtable.get("jrs.launch_type"), 0));
                resultInfoImpl.setTaskId((String)hashtable.get("jrs.task_id"));
                Date date = (Date)hashtable.get("jrs.expired_time");
                if (date != null) {
                    resultInfoImpl.setExpire(true);
                    resultInfoImpl.setExpireationTime(date);
                    resultInfoImpl.setExpireationMethod(CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 1));
                } else {
                    object = new GregorianCalendar();
                    ((GregorianCalendar)object).add(1, 100);
                    resultInfoImpl.setExpireationTime(((Calendar)object).getTime());
                }
                object = (String)hashtable.get("jrs.archive_specified_destination");
                resultInfoImpl.setSpecifiedFolder((String)object);
                resultInfoImpl.setCatalogVerNum(CSUtil.parseInt((String)hashtable.get("jrs.cat_version"), 0));
                resultInfoImpl.setReportVerNum(CSUtil.parseInt((String)hashtable.get("jrs.rpt_version"), 0));
                return resultInfoImpl;
            }
        }
        return null;
    }

    private static ResourceInfo addElement(String string, String string2, String string3, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        int n = string.lastIndexOf(File.separator);
        String string4 = string.substring(n + 1);
        if (string4 == null || string4.trim().length() == 0 || !CSUtil.isValidNodeName(string4)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string4), 3);
            return null;
        }
        String string5 = null;
        if (string4.endsWith(".cat") || string4.endsWith(".cat.xml")) {
            string5 = ResourceToolkit.convertRptSchema(string, string2, resourceTreeManagerImpl);
            CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
            catalogInfoImpl.setName(string4);
            catalogInfoImpl.setCatalog(string5);
            return catalogInfoImpl;
        }
        string5 = ResourceToolkit.currentTimeMillis(string, string2, null, string3, resourceTreeManagerImpl);
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setName(string4);
        reportInfoImpl.setReportFile(string5);
        return reportInfoImpl;
    }

    private static ResourceInfo addResource(String string, String string2, String string3, String string4, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        int n = string.lastIndexOf(File.separator);
        String string5 = string.substring(n + 1);
        if (string5 == null || string5.trim().length() == 0 || !CSUtil.isValidNodeName(string5)) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string5), 3);
            return null;
        }
        String string6 = null;
        if (string5.endsWith(".cat") || string5.endsWith(".cat.xml")) {
            string6 = ResourceToolkit.convertRptSchema(string, string3, resourceTreeManagerImpl);
            CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
            catalogInfoImpl.setName(string5);
            catalogInfoImpl.setCatalog(string6);
            return catalogInfoImpl;
        }
        string6 = ResourceToolkit.addSubFolder(string, string2, string3, null, string4, null, resourceTreeManagerImpl);
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setName(string5);
        reportInfoImpl.setReportFile(string6);
        return reportInfoImpl;
    }

    private static String addSubFolder(String string, String string2, String string3, String string4, String string5, Vector vector, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        String string6 = string4;
        if (string6 == null) {
            string6 = resourceTreeManagerImpl.getVersionService().getArchivePath(string3);
        }
        if (!string6.endsWith(File.separator)) {
            string6 = string6 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string7 = string.substring(n + 1);
        String string8 = string.substring(0, n);
        String string9 = ResourceToolkit.contains(string, string2);
        if (string9 == null) {
            string9 = string;
        }
        SchdTools.copyFile(new File(string9), new File(string6, string7));
        try {
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml")) {
                Vector[] vectorArray = RefResource.getRptFilesWithoutEnv(string, string5);
                if (vectorArray != null) {
                    Vector vector2;
                    Vector vector3;
                    if (vectorArray[0] != null) {
                        ResourceToolkit.append(string8, string6, vectorArray[0], string2);
                    }
                    if (vectorArray[1] != null) {
                        ResourceToolkit.elementAt(string8, string6, vectorArray[1]);
                    }
                    if (vectorArray[4] != null) {
                        ResourceToolkit.elementAt(string8, string6, vectorArray[4]);
                    }
                    if (vectorArray[6] != null) {
                        ResourceToolkit.append(string8, string6, vectorArray[6], string2);
                    }
                    ResourceToolkit.equalsIgnoreCase(string8, string, string5, vectorArray[2]);
                    Vector vector4 = vectorArray[3];
                    if (vector4 != null && vector4.size() > 0) {
                        ResourceToolkit.endsWith(string8, vector4, ServerEnv.stylePath, "");
                    }
                    if ((vector3 = vectorArray[0]) != null && vector3.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        int n2 = 0;
                        while (n2 < vector3.size()) {
                            if (!vector.contains(vector3.elementAt(n2))) {
                                vector.add(vector3.elementAt(n2));
                                ResourceToolkit.addSubFolder(string8 + File.separator + (String)vector3.elementAt(n2), string2, string3, string6, string5, vector, resourceTreeManagerImpl);
                            }
                            ++n2;
                        }
                    }
                    if ((vector2 = vectorArray[6]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            if (!vector.contains(vector2.elementAt(n3))) {
                                vector.add(vector2.elementAt(n3));
                                ResourceToolkit.addSubFolder(string8 + File.separator + (String)vector2.elementAt(n3), string2, string3, string6, string5, vector, resourceTreeManagerImpl);
                            }
                            ++n3;
                        }
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                String string10 = string7.substring(0, string7.lastIndexOf(".xpt"));
                WildcardMatcher wildcardMatcher = new WildcardMatcher(string10 + ".*", false, 2);
                File file = new File(string8);
                String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    SchdTools.copyFile(new File(file, stringArray[n4]), new File(string6, stringArray[n4]));
                    ++n4;
                }
            } else {
                SchdTools.copyFile(new File(string), new File(string6, string7));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
        return string6 + string7;
    }

    private static void append(String string, String string2, Vector vector, String string3) {
        Converter converter = ConverterFactory.getConverter();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string4 = (String)vector.elementAt(n2);
                String string5 = string + string4;
                boolean bl = false;
                try {
                    bl = converter.isPreviousReportSchema(string5);
                }
                catch (JetRptReportIOException jetRptReportIOException) {
                    ServiceLogger.logError(jetRptReportIOException);
                }
                if (bl) {
                    String string6 = string2.endsWith(File.separator) ? string2 + string4 : string2 + File.separator + string4;
                    try {
                        converter.convertRptSchema(string3, string5, string6);
                    }
                    catch (ReadFailureException readFailureException) {
                        ServiceLogger.logError(readFailureException);
                        return;
                    }
                    catch (UniverseFileException universeFileException) {
                        ServiceLogger.logError(universeFileException);
                        return;
                    }
                    catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
                        ServiceLogger.logError(jUpgradeNotSupportedException);
                        return;
                    }
                    catch (WriteFailureException writeFailureException) {
                        ServiceLogger.logError(writeFailureException);
                        return;
                    }
                    ConverterFactory.destroy();
                } else {
                    SchdTools.copyFile(new File(string, string4), new File(string2, string4));
                }
                ++n2;
            }
        }
    }

    private static String contains(String string, String string2) {
        Converter converter = ConverterFactory.getConverter();
        String string3 = ServerEnv.getReportHome();
        String string4 = !string3.endsWith(File.separator) ? string3 + File.separator + "temp" + File.separator + "convertFiles" : string3 + "temp" + File.separator + "convertFiles";
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string5 = new File(string).getName();
        String string6 = string4 + File.separator + string5;
        try {
            converter.convertRptSchema(string2, string, string6);
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
            return null;
        }
        catch (UniverseFileException universeFileException) {
            ServiceLogger.logError(universeFileException);
            return null;
        }
        catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
            ServiceLogger.logError(jUpgradeNotSupportedException);
            return null;
        }
        catch (WriteFailureException writeFailureException) {
            ServiceLogger.logError(writeFailureException);
            return null;
        }
        ConverterFactory.destroy();
        return string6;
    }

    public static void setHistDir(String string) {
        QOIV = string;
    }

    public static void setReportHome(String string) {
        add = string;
    }

    protected static String getHistDir() {
        if (QOIV == null) {
            if (ServerEnv.isSharedHistDir()) {
                QOIV = ServerEnv.getSharedHistDir();
            } else {
                String string = ServerEnv.homePath;
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                QOIV = string + "history";
            }
        }
        if (!QOIV.endsWith(File.separator)) {
            QOIV = QOIV + File.separator;
        }
        return QOIV;
    }

    private static String convertRptSchema(String string, String string2, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        String string3 = resourceTreeManagerImpl.getVersionService().getArchivePath(string2);
        if (!string3.endsWith(File.separator)) {
            string3 = string3 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string4 = string.substring(n + 1);
        String string5 = string.substring(0, n);
        try {
            Vector vector = RefResource.getCatRefFiles(string);
            if (vector != null) {
                ResourceToolkit.elementAt(string5, string3, vector);
            }
            String string6 = string4;
            try {
                if (ServerUtil.needCompileFml(string3, string6)) {
                    ServiceLogger.logDebug(5620026, string6, 5);
                    ServerUtil.saveCatFml(string3, string6);
                }
            }
            catch (ReadFailureException readFailureException) {
                ServiceLogger.logError(readFailureException);
            }
            catch (UniverseFileException universeFileException) {
                ServiceLogger.logError(universeFileException);
            }
            catch (FMLFileException fMLFileException) {
                ServiceLogger.logError(fMLFileException);
            }
            catch (WriteFailureException writeFailureException) {
                ServiceLogger.logError(writeFailureException);
            }
            Vector vector2 = new Vector();
            if (RefResource.hasHierDataSource(string) && (vector2 = ResourceToolkit.copyFile(string)) != null) {
                ResourceToolkit.elementAt(string5, string3, vector2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return string3 + string4;
    }

    private static Vector copyFile(String string) throws Exception {
        Vector vector = new Vector();
        int n = string.lastIndexOf(File.separator);
        String string2 = string.substring(0, n);
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null && (stringArray[n2].endsWith(".cls") || stringArray[n2].endsWith(".cls.xml"))) {
                    String string3 = string2 + File.separator + stringArray[n2];
                    Vector vector2 = null;
                    vector2 = RefResource.getHdsFiles(string, string3);
                    if (vector2 != null && vector2.size() > 0) {
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            vector.addElement(vector2.elementAt(n3));
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    private static String currentTimeMillis(String string, String string2, String string3, String string4, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        return ResourceToolkit.destroy(string, string2, string3, string4, null, resourceTreeManagerImpl);
    }

    private static String destroy(String string, String string2, String string3, String string4, Vector vector, ResourceTreeManagerImpl resourceTreeManagerImpl) {
        String string5 = string3;
        if (string5 == null) {
            string5 = resourceTreeManagerImpl.getVersionService().getArchivePath(string2);
        }
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        int n = string.lastIndexOf(File.separator);
        String string6 = string.substring(n + 1);
        String string7 = string.substring(0, n);
        SchdTools.copyFile(new File(string), new File(string5, string6));
        try {
            Object object;
            Serializable serializable;
            if ((string.endsWith(".rpt") || string.endsWith(".clx")) && ((File)(serializable = new File(string7, (String)(object = string6.substring(0, string6.indexOf("."))) + ".auth"))).exists()) {
                SchdTools.copyFile(new File(string7, (String)object + ".auth"), new File(string5, (String)object + ".auth"));
            }
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml")) {
                object = RefResource.getRptFilesWithoutEnv(string, string4);
                if (object != null) {
                    Vector vector2;
                    Vector vector3;
                    if (object[0] != null) {
                        ResourceToolkit.elementAt(string7, string5, object[0]);
                    }
                    if (object[1] != null) {
                        ResourceToolkit.elementAt(string7, string5, object[1]);
                    }
                    if (object[4] != null) {
                        ResourceToolkit.elementAt(string7, string5, object[4]);
                    }
                    if (object[6] != null) {
                        ResourceToolkit.elementAt(string7, string5, object[6]);
                    }
                    ResourceToolkit.equalsIgnoreCase(string7, string, string4, object[2]);
                    serializable = object[3];
                    if (serializable != null && ((Vector)serializable).size() > 0) {
                        ResourceToolkit.endsWith(string7, (Vector)serializable, ServerEnv.stylePath, "");
                    }
                    if ((vector3 = object[0]) != null && vector3.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        int n2 = 0;
                        while (n2 < vector3.size()) {
                            if (!vector.contains(vector3.elementAt(n2))) {
                                vector.add(vector3.elementAt(n2));
                                ResourceToolkit.destroy(string7 + File.separator + (String)vector3.elementAt(n2), string2, string5, string4, vector, resourceTreeManagerImpl);
                            }
                            ++n2;
                        }
                    }
                    if ((vector2 = object[6]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            if (!vector.contains(vector2.elementAt(n3))) {
                                vector.add(vector2.elementAt(n3));
                                ResourceToolkit.destroy(string7 + File.separator + (String)vector2.elementAt(n3), string2, string5, string4, vector, resourceTreeManagerImpl);
                            }
                            ++n3;
                        }
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                object = string6.substring(0, string6.lastIndexOf(".xpt"));
                serializable = new WildcardMatcher((String)object + ".*", false, 2);
                File file = new File(string7);
                String[] stringArray = file.list((FilenameFilter)((Object)serializable));
                int n4 = 0;
                while (n4 < stringArray.length) {
                    SchdTools.copyFile(new File(file, stringArray[n4]), new File(string5, stringArray[n4]));
                    ++n4;
                }
            } else {
                SchdTools.copyFile(new File(string), new File(string5, string6));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
        return string5 + string6;
    }

    private static void elementAt(String string, String string2, Vector vector) {
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string3 = (String)vector.elementAt(n2);
                SchdTools.copyFile(new File(string, string3), new File(string2, string3));
                ++n2;
            }
        }
    }

    public static ExProperties getResources(String string) {
        String string2 = ServerEnv.realmsPath + string + File.separator + "resource.alias";
        ExProperties exProperties = new ExProperties();
        if (!new File(string2).exists()) {
            return null;
        }
        try {
            exProperties.load(string2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (ServerEnv.getResourceRoot() != null) {
            exProperties.setProperty("/", ServerEnv.getResourceRoot());
        }
        return exProperties;
    }

    private static void endsWith(String string, Vector vector, String string2, String string3) {
        String string4 = string2.endsWith(File.separator) ? string2 + string3 : string2 + File.separator + string3;
        if (string != null) {
            File file = new File(string);
            int n = 0;
            while (n < vector.size()) {
                String string5 = (String)vector.elementAt(n);
                File file2 = new File(file, string5 = CSUtil.getFileNameOnly(string5));
                if (file2.exists()) {
                    SchdTools.copyFile(file2, new File(string4, string5));
                }
                ++n;
            }
        }
    }

    public static void saveStyleFiles(String string) {
        if (string == null) {
            return;
        }
        try {
            Vector vector = new Vector();
            vector = RefResource.getStyleFilesByExt(string);
            if (vector != null && vector.size() > 0) {
                ResourceToolkit.endsWith(string, vector, ServerEnv.stylePath, "");
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    private static void equalsIgnoreCase(String string, String string2, String string3, Vector vector) {
        if (string2 == null) {
            return;
        }
        try {
            Vector vector2 = vector;
            if (vector2 != null && !vector2.isEmpty()) {
                ResourceToolkit.endsWith(string, vector2, ServerEnv.getFontPath(), "");
            }
            if ((vector2 = RefResource.getFontFiles(string2, string3)) != null && !vector2.isEmpty()) {
                Vector<String> vector3 = new Vector<String>();
                int n = 0;
                while (n < vector2.size()) {
                    vector3.addElement(string3 + File.separator + vector2.elementAt(n));
                    ++n;
                }
                if (!vector3.isEmpty()) {
                    ResourceToolkit.endsWith(string3, vector3, ServerEnv.getFontPath(), "");
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static synchronized String convertingOldReport(String string, String string2) throws Exception {
        return ResourceToolkit.exists(string2, string, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String exists(String string, String string2, String string3, String object, Vector vector) throws Exception {
        ++addResource;
        String string4 = string + "[" + string2 + "]";
        String string5 = null;
        String string6 = null;
        Properties properties = addElement;
        synchronized (properties) {
            String string7;
            Object object2;
            string5 = addElement.getProperty(string4);
            if (string5 != null && string5.length() != 0) {
                object2 = new File(string5);
                if (object == null && ((File)object2).isFile() && CSUtil.isReportFile(string5)) {
                    String string8 = string5;
                    return string8;
                }
                addElement.remove(string4);
            }
            if (object == null) {
                String string9;
                int n = string.indexOf("history");
                if (n != -1) {
                    string9 = string.substring(n + 8);
                    n = string9.lastIndexOf(File.separator);
                    string9 = string9.substring(0, n);
                } else {
                    string9 = String.valueOf(System.currentTimeMillis());
                }
                string7 = ServerEnv.getReportHome();
                object2 = !string7.endsWith(File.separator) ? string7 + File.separator + "temp" + File.separator + "runingConvertFiles" + string9 + "_" + addResource : string7 + "temp" + File.separator + "runingConvertFiles" + File.separator + string9 + "_" + addResource;
                object = object2;
            }
            if (!((File)(object2 = new File((String)object))).exists()) {
                ((File)object2).mkdirs();
            }
            int n = string.lastIndexOf(File.separator);
            String string10 = string.substring(n + 1);
            string7 = string.substring(0, n);
            Converter converter = ConverterFactory.getConverter();
            string6 = (String)object + File.separator + string10;
            ServiceLogger.logDebug(6620024, new Object[]{string, string2, string6}, 6);
            converter.convertRptSchema(string2, string, string6);
            ServiceLogger.logDebug(6620025, string6, 6);
            ConverterFactory.destroy();
            if (string.endsWith(".cls") || string.endsWith(".rpt") || string.endsWith(".clx") || string.endsWith(".cls.xml")) {
                Vector[] vectorArray = RefResource.getRptFilesWithoutEnv(string, string3 == null ? string7 : string3);
                if (vectorArray != null) {
                    int n2;
                    Vector vector2;
                    if (vectorArray[0] != null && (vector2 = vectorArray[0]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        n2 = 0;
                        while (n2 < vector2.size()) {
                            if (!vector.contains(vector2.elementAt(n2))) {
                                vector.add(vector2.elementAt(n2));
                                ResourceToolkit.exists(string7 + File.separator + vector2.elementAt(n2), string2, string3, (String)object, vector);
                            }
                            ++n2;
                        }
                    }
                    if (vectorArray[6] != null && (vector2 = vectorArray[6]) != null && vector2.size() > 0) {
                        if (vector == null) {
                            vector = new Vector();
                        }
                        n2 = 0;
                        while (n2 < vector2.size()) {
                            if (!vector.contains(vector2.elementAt(n2))) {
                                vector.add(vector2.elementAt(n2));
                                ResourceToolkit.exists(string7 + File.separator + vector2.elementAt(n2), string2, string3, (String)object, vector);
                            }
                            ++n2;
                        }
                    }
                    if (vectorArray[4] != null) {
                        ResourceToolkit.elementAt(string7, (String)object, vectorArray[4]);
                    }
                    ResourceToolkit.equalsIgnoreCase(string7, string, string3, vectorArray[2]);
                    vector2 = vectorArray[3];
                    if (vector2 != null && vector2.size() > 0) {
                        ResourceToolkit.endsWith(string7, vector2, ServerEnv.stylePath, "");
                    }
                }
            } else if (string.endsWith(".xpt") || string.endsWith(".xpt.xml")) {
                String string11 = string10.substring(0, string10.lastIndexOf(".xpt"));
                WildcardMatcher wildcardMatcher = new WildcardMatcher(string11 + ".*", false, 2);
                File file = new File(string7);
                String[] stringArray = file.list((FilenameFilter)wildcardMatcher);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    SchdTools.copyFile(new File(file, stringArray[n3]), new File((String)object, stringArray[n3]));
                    ++n3;
                }
            } else {
                SchdTools.copyFile(new File(string), new File((String)object, string10));
            }
            addElement.setProperty(string4, string6);
        }
        return string6;
    }
}

