/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.security.acl.Permission;
import java.util.Date;
import java.util.Hashtable;
import jet.server.ServerEnv;
import jet.server.api.PathInfo;
import jet.server.api.VersionRecord;
import jet.server.api.exception.NoSuchUserException;
import jet.server.db.resource.VersionNodeRecord;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.ResourceTreeManager;
import jet.server.intf.resource.ResultInfo;
import jet.server.intf.resource.Version;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.CatalogVersionRecordImpl;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ReportVersionRecordImpl;
import jet.server.jrc.resource.ResultVersionRecordImpl;
import jet.server.jrc.security.JSPermissionImpl;

public class VersionImpl
extends NodeImpl
implements Version {
    private VersionNodeRecord QOIV;
    private ResourceInfo READ = null;

    public VersionImpl(String string, int n) {
        super(string);
        this.QOIV = new VersionNodeRecord();
        this.QOIV.setVersionNumber(n);
        this.setNodeType((byte)3);
    }

    public VersionImpl(VersionNodeRecord versionNodeRecord) {
        super(versionNodeRecord);
        this.QOIV = versionNodeRecord;
    }

    public int getVersionNumber() {
        return this.QOIV.getVersionNumber();
    }

    public void setVersionNumber(int n) {
        this.QOIV.setVersionNumber(n);
    }

    public ResourceInfo getEntity() {
        return this.READ;
    }

    public void setEntity(ResourceInfo resourceInfo) {
        this.READ = resourceInfo;
    }

    public String getVersionName() {
        return this.QOIV.getName();
    }

    public void setVersionName(String string) {
        this.QOIV.setName(string);
    }

    public void remove() {
        this.QOIV = null;
        super.remove();
    }

    public int getResourceID() {
        return this.QOIV.getResourceID();
    }

    public void setParent(Node node) {
        super.setParent(node);
        String string = node.getAbsolutePath();
        this.setAbsolutePath(string + ":" + this.QOIV.getName());
    }

    public PathInfo toPathInfo(String string) {
        PathInfoImpl pathInfoImpl = super.getPathInfo(string);
        return pathInfoImpl;
    }

    public String toString() {
        return "VersionImpl[" + super.toString() + "]";
    }

    public Object toVersionRecord(ResourceTreeManager resourceTreeManager, String string) {
        boolean bl;
        VersionRecord versionRecord;
        block9: {
            versionRecord = null;
            bl = true;
            try {
                bl = resourceTreeManager.checkPermission(this, resourceTreeManager.getSecurityService().getUser(string), (Permission)JSPermissionImpl.READ);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block9;
                bl = false;
            }
        }
        switch (this.READ.getResourceType()) {
            case 1: {
                String string2 = null;
                string2 = !this.QOIV.isDynamic() ? this.getParent().getAbsolutePath() : this.getAbsolutePath();
                versionRecord = new CatalogVersionRecordImpl(String.valueOf(this.QOIV.getID()), string2, this.QOIV.getVersionNumber(), this.QOIV.getName(), this.QOIV.getCreateTime(), this.QOIV.getCreatorName(), ((CatalogInfoImpl)this.READ).getCatalog());
                break;
            }
            case 2: {
                String string3 = !this.QOIV.isDynamic() ? this.getParent().getAbsolutePath() : this.getAbsolutePath();
                versionRecord = new ReportVersionRecordImpl(String.valueOf(this.QOIV.getID()), string3, this.QOIV.getVersionNumber(), this.QOIV.getName(), this.QOIV.getCreateTime(), this.QOIV.getCreatorName(), ((ReportInfoImpl)this.READ).getReportFile());
                break;
            }
            case 3: {
                ResultInfo resultInfo = bl ? (ResultInfo)this.READ : null;
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                long l = 0L;
                Date date = null;
                int n = 0;
                int n2 = 0;
                if (bl) {
                    Node node;
                    int n3 = resultInfo.getCatalogResourceId();
                    if (n3 != -1) {
                        node = resourceTreeManager.getNodeByID(n3);
                        string4 = node == null ? "unknown catalog" : node.getAbsolutePath();
                    }
                    string5 = (node = resourceTreeManager.getNodeByID(resultInfo.getReportResourceId())) != null ? node.getAbsolutePath() : "unknown report";
                    string6 = resultInfo.getResultFile();
                    string8 = resultInfo.getParamFile();
                    string7 = resultInfo.getTaskId();
                    l = resultInfo.getResultFormats();
                    date = resultInfo.getExpire() ? resultInfo.getExpireationTime() : null;
                    n = resultInfo.getExpireationMethod();
                    n2 = resultInfo.getLaunchType();
                }
                String string9 = !this.QOIV.isDynamic() ? this.getParent().getAbsolutePath() : this.getAbsolutePath();
                versionRecord = new ResultVersionRecordImpl(String.valueOf(this.QOIV.getID()), this.QOIV.getName(), this.QOIV.getVersionNumber(), string4, string5, string8, string6, string7, this.QOIV.getCreatorName(), l, this.QOIV.getCreateTime(), date, n2, string9, n, resultInfo.getReportAmount(), resultInfo.getSheetsResultDetails());
                break;
            }
        }
        return versionRecord;
    }

    public boolean setProperties(Hashtable hashtable) {
        return false;
    }
}

