/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.NLSFontInfo;
import jet.server.jrc.resource.nls.NLSFontMap;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.util.ServerUtil;
import jet.util.NLSResourceBundleManager;

public class NLSUtil {
    public static String VALUES_CONCAT_CHAR = ",";
    public static String CMD_FONT_MAP_EDIT = "edit_nls_font_map";
    public static String CMD_FONT_MAP_NEW = "new_nls_font_map";
    public static String NLS_ENCODING = "nls_server_properties_encoding";
    public static String CATEGORY_KEY_CONCAT_CHAR = "_";
    public static int NLS_SUB_REPORT_VERSION_NUMBER = -1117;
    public static String RPT_FILE_EXTENSION = ".rpt";
    public static String CLS_FILE_EXTENSION = ".cls";
    public static String XML_FILE_EXTENSION = ".xml";
    public static String FILENAME_CONCAT_CHAR = "_";
    public static String CONTROLLER_NAME_CHAR = "controller";

    public static String getLocaleName(Locale locale) {
        return ServerUtil.getLocaleName(locale);
    }

    public static String[] parseFontContext(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, VALUES_CONCAT_CHAR);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    public static Locale getLocale(String string) {
        return ServerUtil.getLocale(string);
    }

    public static Properties getFontMapInfo(Locale locale) {
        Properties properties = new Properties();
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        NLSFontMap nLSFontMap = nLSManager.getFontMap(locale, "admin");
        if (nLSFontMap == null) {
            return null;
        }
        Object object = nLSFontMap.getFontInfos();
        Enumeration enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            NLSFontInfo nLSFontInfo = (NLSFontInfo)enumeration.nextElement();
            String string = nLSFontInfo.getOriginalFontFace() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.getOriginalFontSize();
            if (nLSFontInfo.isIgnoreSize()) {
                string = nLSFontInfo.getOriginalFontFace() + CATEGORY_KEY_CONCAT_CHAR + "*";
            }
            String string2 = nLSFontInfo.getTargetFontFace() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.getTargetFontSize() + CATEGORY_KEY_CONCAT_CHAR + nLSFontInfo.isRelative();
            properties.put(string, string2);
        }
        object = nLSFontMap.getEncoding();
        properties.setProperty(NLS_ENCODING, (String)object);
        return properties;
    }

    public static String getNLSControllerFileNameFromReportName(String string, Locale locale) {
        string = string.endsWith(CLS_FILE_EXTENSION) ? string.substring(0, string.length() - CLS_FILE_EXTENSION.length()) : (string.endsWith(RPT_FILE_EXTENSION) ? string.substring(0, string.length() - RPT_FILE_EXTENSION.length()) : string.substring(0, string.indexOf(".")));
        return string + FILENAME_CONCAT_CHAR + locale + FILENAME_CONCAT_CHAR + CONTROLLER_NAME_CHAR + XML_FILE_EXTENSION;
    }

    public static String getNLSPropertyDisplayName(String string, int n) {
        String string2;
        switch (n) {
            case 0: {
                String string3 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT];
                string2 = string.substring(string3.length() + 1);
                break;
            }
            case 3: {
                String string4 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT];
                string2 = string.substring(string4.length() + 1);
                break;
            }
            case 4: {
                String string5 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT];
                string2 = string.substring(string5.length() + 1);
                break;
            }
            case 5: {
                String string6 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT];
                string2 = string.substring(string6.length() + 1);
                break;
            }
            case 1: {
                String string7 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT];
                string2 = string.substring(string7.length() + 1);
                break;
            }
            case 2: {
                String string8 = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT];
                string2 = string.substring(string8.length() + 1);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    public static String getNLSPropertyDisplayName(String string, int n, Map map) {
        String string2 = NLSUtil.getNLSPropertyDisplayName(string, n);
        if (map != null && map.containsKey(string2)) {
            string2 = (String)map.get(string2);
        }
        return string2;
    }

    public static String getTypeName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT];
                break;
            }
            case 3: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT];
                break;
            }
            case 4: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT];
                break;
            }
            case 5: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT];
                break;
            }
            case 1: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT];
                break;
            }
            case 2: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORYNAME[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT];
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static Map clearEmptyProperty(Map map, int n) {
        String string;
        switch (n) {
            case 0: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT];
                break;
            }
            case 3: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT];
                break;
            }
            case 4: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT];
                break;
            }
            case 5: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT];
                break;
            }
            case 1: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT];
                break;
            }
            case 2: {
                string = NLSResourceBundleManager.INDEX_TO_CATEGORY[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT];
                break;
            }
            default: {
                string = "";
            }
        }
        Hashtable hashtable = new Hashtable();
        if (map != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.length() == 0 || string2.equals(string + "_")) continue;
                hashtable.put(string2, map.get(string2));
            }
        }
        return hashtable;
    }

    public static Properties getHtmlNavNLS(Locale locale) {
        Properties properties = new Properties();
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        return nLSManager.getGlobalNls(0, locale);
    }
}

