/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JPrivilege;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.custom.security.group.GroupPrivilegeProvider;
import jet.server.api.custom.security.role.RolePermissionProvider;
import jet.server.api.custom.security.role.RolePrivilegeProvider;
import jet.server.api.custom.security.user.UserPermissionProvider;
import jet.server.api.custom.security.user.UserPrivilegeProvider;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.log.ServiceLogger;

public class AclDataManager {
    private CachedSecurityDataImpl QOIV;
    private String add;
    private SecurityListener addElement;
    protected UserPermissionProvider userPermissionProvider;
    protected UserPrivilegeProvider userPrivilegeProvider;
    protected GroupPermissionProvider groupPermissionProvider;
    protected GroupPrivilegeProvider groupPrivilegeProvider;
    protected RolePermissionProvider rolePermissionProvider;
    protected RolePrivilegeProvider rolePrivilegeProvider;
    boolean addPrivilegeToCode = true;
    boolean append = true;
    boolean checkPermissionCode = true;
    boolean elements = true;
    boolean equals = true;
    boolean get = true;

    public AclDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.QOIV = exCachedSecurityDataImpl;
        this.add = exCachedSecurityDataImpl.getRealmName();
        this.addPrivilegeToCode = securityWebUIController.isEditing(11);
        this.append = securityWebUIController.isEditing(12);
        this.checkPermissionCode = securityWebUIController.isEditing(13);
        this.elements = securityWebUIController.isEditing(14);
        this.equals = securityWebUIController.isEditing(15);
        this.get = securityWebUIController.isEditing(16);
        this.userPermissionProvider = exCachedSecurityDataImpl.getUserPermissionProvider();
        this.userPrivilegeProvider = exCachedSecurityDataImpl.getUserPrivilegeProvider();
        this.groupPermissionProvider = exCachedSecurityDataImpl.getGroupPermissionProvider();
        this.groupPrivilegeProvider = exCachedSecurityDataImpl.getGroupPrivilegeProvider();
        this.rolePermissionProvider = exCachedSecurityDataImpl.getRolePermissionProvider();
        this.rolePrivilegeProvider = exCachedSecurityDataImpl.getRolePrivilegeProvider();
        this.addElement = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public AclDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.QOIV = exCachedSecurityDataImpl;
        this.add = exCachedSecurityDataImpl.getRealmName();
        this.userPermissionProvider = exCachedSecurityDataImpl.getUserPermissionProvider();
        this.userPrivilegeProvider = exCachedSecurityDataImpl.getUserPrivilegeProvider();
        this.groupPermissionProvider = exCachedSecurityDataImpl.getGroupPermissionProvider();
        this.groupPrivilegeProvider = exCachedSecurityDataImpl.getGroupPrivilegeProvider();
        this.rolePermissionProvider = exCachedSecurityDataImpl.getRolePermissionProvider();
        this.rolePrivilegeProvider = exCachedSecurityDataImpl.getRolePrivilegeProvider();
        this.addElement = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized JAcl getDefaultAcl() throws NoSuchAclException {
        JAcl jAcl = this.QOIV.getAcl("/", -1);
        if (jAcl == null) {
            throw new NoSuchAclException(630007);
        }
        return jAcl;
    }

    public synchronized JAcl getAcl(String string, int n) throws NoSuchAclException {
        JAcl jAcl = this.QOIV.getAcl(string, n);
        if (jAcl == null) {
            throw new NoSuchAclException(630006, (Object[])new String[]{string + "[" + n + "]"}, null);
        }
        return jAcl;
    }

    public synchronized void addAcl(String string, String string2, int n, Hashtable[] hashtableArray) throws AclExistException {
        String string3;
        Principal principal;
        String string4;
        Enumeration enumeration;
        if (hashtableArray[0] != null && this.addPrivilegeToCode) {
            enumeration = hashtableArray[0].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.QOIV.getUser(string4);
                if (principal == null || (string3 = (String)hashtableArray[0].get(string4)) == null) continue;
                try {
                    this.userPermissionProvider.setUserPermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchUserException noSuchUserException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                }
            }
        }
        if (hashtableArray[1] != null && this.append) {
            enumeration = hashtableArray[1].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.QOIV.getRole(string4);
                if (principal == null || (string3 = (String)hashtableArray[1].get(string4)) == null) continue;
                try {
                    this.rolePermissionProvider.setRolePermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                }
            }
        }
        if (hashtableArray[2] != null && this.checkPermissionCode) {
            enumeration = hashtableArray[2].keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                principal = this.QOIV.getGroup(string4);
                if (principal == null || (string3 = (String)hashtableArray[2].get(string4)) == null) continue;
                try {
                    this.groupPermissionProvider.setGroupPermissions(this.add, string4, string2, n, string3);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                }
            }
        }
        this.addElement.updatePermissons(this.add, string2, n);
    }

    public synchronized boolean removeAcl(String string, int n) {
        Object object;
        Object object2;
        Object object3;
        try {
            this.getAcl(string, n);
        }
        catch (NoSuchAclException noSuchAclException) {
            return false;
        }
        Hashtable hashtable = null;
        if (this.addPrivilegeToCode) {
            try {
                hashtable = this.userPermissionProvider.getUserPermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
            }
            if (hashtable != null) {
                object3 = hashtable.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    if (object2 == null) continue;
                    try {
                        this.userPermissionProvider.setUserPermissions(this.add, (String)object2, string, n, null);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError(jRCustomerException);
                    }
                }
            }
        }
        object3 = null;
        if (this.checkPermissionCode) {
            try {
                object3 = this.groupPermissionProvider.getGroupPermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
            }
            if (object3 != null) {
                object2 = ((Hashtable)object3).keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (object == null) continue;
                    try {
                        this.groupPermissionProvider.setGroupPermissions(this.add, (String)object, string, n, null);
                    }
                    catch (NoSuchGroupException noSuchGroupException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError(jRCustomerException);
                    }
                }
            }
        }
        if (this.append) {
            object2 = null;
            try {
                object2 = this.rolePermissionProvider.getRolePermissions(this.add, string, n);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
            }
            if (object2 != null) {
                object = ((Hashtable)object2).keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (string2 == null) continue;
                    try {
                        this.rolePermissionProvider.setRolePermissions(this.add, string2, string, n, null);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError(jRCustomerException);
                    }
                }
            }
        }
        this.addElement.updatePermissons(this.add, string, n);
        return true;
    }

    public synchronized JAclEntry getAclEntry(String string, int n, Principal principal, boolean bl) throws NoSuchAclException, NoSuchAclEntryException {
        JAcl jAcl = this.getAcl(string, n);
        if (jAcl == null) {
            throw new NoSuchAclException(630006, (Object[])new String[]{string + "[" + n + "]"}, null);
        }
        JAclEntry jAclEntry = jAcl.getJAclEntry(principal, bl);
        if (jAclEntry == null) {
            throw new NoSuchAclEntryException(630080, (Object[])new String[]{principal.getName()}, null);
        }
        return jAclEntry;
    }

    public synchronized boolean remove(String string, int n, Principal principal) throws NoSuchAclEntryException, NoSuchAclException {
        JAcl jAcl = this.getAcl(string, n);
        String string2 = principal.getName();
        boolean bl = true;
        if (principal instanceof BaseUser && this.addPrivilegeToCode) {
            try {
                this.userPermissionProvider.setUserPermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException);
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                bl = false;
            }
        } else if (principal instanceof BaseRole && this.append) {
            try {
                this.rolePermissionProvider.setRolePermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError(noSuchRoleException);
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                bl = false;
            }
        } else if (this.checkPermissionCode) {
            try {
                this.groupPermissionProvider.setGroupPermissions(this.add, string2, string, n, null);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException);
                bl = false;
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                bl = false;
            }
        }
        if (bl) {
            jAcl.removeJAclEntry(principal, true);
            jAcl.removeJAclEntry(principal, false);
            this.addElement.updatePermissons(this.add, string, n);
            return true;
        }
        ServiceLogger.logError(3630073, string2, 3);
        return false;
    }

    public JAcl getExtendAcl() throws NoSuchAclException {
        JAcl jAcl = this.QOIV.getExtendAcl();
        if (jAcl == null) {
            throw new NoSuchAclException(630007);
        }
        return jAcl;
    }

    public String addExtendAclEntry(JAclEntry jAclEntry) {
        Principal principal = jAclEntry.getPrincipal();
        String string = principal.getName();
        int n = PermissionUtil.turnPrivilegesToCode(jAclEntry);
        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
        if (principal instanceof BaseUser && this.elements) {
            try {
                this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 1);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException);
                return JSvrResource.getMessage("SVR_93", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_03001", string);
            }
        }
        if (principal instanceof BaseRole && this.equals) {
            try {
                this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 2);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError(noSuchRoleException);
                return JSvrResource.getMessage("SECURITY_ERR_13_ROLE_NOT_EXIST", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_03002", string);
            }
        }
        if (this.get) {
            try {
                this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray);
                this.addElement.updatePrivileges(this.add, string, 3);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException);
                return JSvrResource.getMessage("SEUCRITY_ERR_63_GROUP_NOT_EXIST", string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_03003", string);
            }
        }
        return null;
    }

    public Vector getPrivilegedUsers(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.userPrivilegeProvider.getUserPrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getPrivilegedRoles(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getPrivilegedGroups(JPrivilege jPrivilege) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = null;
        try {
            hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return vector;
        }
        if (hashtable != null && hashtable.size() != 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (stringArray == null || !PermissionUtil.checkPermissionCode(n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray), jPrivilege)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public void addPrivilegedUsers(JPrivilege jPrivilege, Vector vector) {
        this.QOIV(jPrivilege, vector, (byte)1);
    }

    public void addPrivilegedRoles(JPrivilege jPrivilege, Vector vector) {
        this.QOIV(jPrivilege, vector, (byte)2);
    }

    public void addPrivilegedGroups(JPrivilege jPrivilege, Vector vector) {
        this.QOIV(jPrivilege, vector, (byte)3);
    }

    private void QOIV(JPrivilege jPrivilege, Vector vector, byte by) {
        Hashtable hashtable = null;
        switch (by) {
            case 1: {
                if (!this.elements) break;
                try {
                    hashtable = this.userPrivilegeProvider.getUserPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray2 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray2);
                            this.addElement.updatePrivileges(this.add, string, 1);
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            ServiceLogger.logError(noSuchUserException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.userPrivilegeProvider.setUserPrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 1);
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            ServiceLogger.logError(noSuchUserException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                }
                break;
            }
            case 2: {
                if (!this.equals) break;
                try {
                    hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray3 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray3);
                            this.addElement.updatePrivileges(this.add, string, 2);
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                            ServiceLogger.logError(noSuchRoleException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.rolePrivilegeProvider.setRolePrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 2);
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                            ServiceLogger.logError(noSuchRoleException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                }
                break;
            }
            case 3: {
                if (!this.get) break;
                try {
                    hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException);
                    return;
                }
                if (hashtable != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String[] stringArray = (String[])hashtable.get(string);
                        int n = 0;
                        if (stringArray != null) {
                            n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                            n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        } else {
                            n = PermissionUtil.addPrivilegeToCode(0, jPrivilege);
                        }
                        String[] stringArray4 = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray4);
                            this.addElement.updatePrivileges(this.add, string, 3);
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                            ServiceLogger.logError(noSuchGroupException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        int n = 0;
                        n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
                        String[] stringArray = PermissionUtil.getPrivilegesFromPrivilegesCode(n);
                        try {
                            this.groupPrivilegeProvider.setGroupPrivileges(this.add, string, stringArray);
                            this.addElement.updatePrivileges(this.add, string, 3);
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                            ServiceLogger.logError(noSuchGroupException);
                        }
                        catch (JRCustomerException jRCustomerException) {
                            ServiceLogger.logError(jRCustomerException);
                        }
                    }
                }
                break;
            }
        }
    }

    public String removePrivilegedUsers(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)1);
    }

    public String removePrivilegedRoles(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)2);
    }

    public String removePrivilegedGroups(JPrivilege jPrivilege, Vector vector) {
        return this.removePrivilegedPrincipals(jPrivilege, vector, (byte)3);
    }

    /*
     * Unable to fully structure code
     */
    public String removePrivilegedPrincipals(JPrivilege var1_1, Vector var2_2, byte var3_3) {
        var4_4 = null;
        var5_5 = new StringBuffer();
        var6_6 = var2_2.elements();
        switch (var3_3) {
            case 1: {
                if (!this.elements) break;
                try {
                    var7_7 = this.userPrivilegeProvider.getUserPrivileges(this.add);
                    if (true) ** GOTO lbl46
                }
                catch (JRCustomerException var8_10) {
                    ServiceLogger.logError(var8_10);
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                do {
                    var8_11 = (String)var6_6.nextElement();
                    var9_16 = new String[]{};
                    if (var7_7 != null) {
                        var9_16 = (String[])var7_7.get(var8_11);
                    }
                    var10_19 = new Vector<String>();
                    var11_22 = null;
                    var12_25 = PermissionUtil.turnPrivilegeToString(var1_1);
                    if (var9_16 != null) {
                        var13_28 = 0;
                        while (var13_28 < var9_16.length) {
                            var14_34 = var9_16[var13_28];
                            if (!var14_34.equals(var12_25)) {
                                var10_19.add(var14_34);
                            }
                            ++var13_28;
                        }
                    } else {
                        return null;
                    }
                    var11_22 = var10_19.toArray(new String[var10_19.size()]);
                    try {
                        this.userPrivilegeProvider.setUserPrivileges(this.add, var8_11, var11_22);
                        this.addElement.updatePrivileges(this.add, var8_11, 1);
                    }
                    catch (NoSuchUserException var13_29) {
                        ServiceLogger.logError(var13_29);
                        var5_5.append(var8_11).append(", ");
                    }
                    catch (JRCustomerException var14_35) {
                        ServiceLogger.logError(var14_35);
                        var5_5.append(var8_11).append(", ");
                    }
lbl46:
                    // 4 sources

                } while (var6_6.hasMoreElements());
                break;
            }
            case 2: {
                if (!this.equals) break;
                try {
                    var7_8 = this.rolePrivilegeProvider.getRolePrivileges(this.add);
                    if (true) ** GOTO lbl89
                }
                catch (JRCustomerException var8_12) {
                    ServiceLogger.logError(var8_12);
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                do {
                    var8_13 = (String)var6_6.nextElement();
                    var9_17 = new String[]{};
                    if (var7_8 != null) {
                        var9_17 = (String[])var7_8.get(var8_13);
                    }
                    var10_20 = new Vector<String>();
                    var11_23 = null;
                    var12_26 = PermissionUtil.turnPrivilegeToString(var1_1);
                    if (var9_17 != null) {
                        var13_30 = 0;
                        while (var13_30 < var9_17.length) {
                            var14_36 = var9_17[var13_30];
                            if (!var14_36.equals(var12_26)) {
                                var10_20.add(var14_36);
                            }
                            ++var13_30;
                        }
                    } else {
                        return null;
                    }
                    var11_23 = var10_20.toArray(new String[var10_20.size()]);
                    try {
                        this.rolePrivilegeProvider.setRolePrivileges(this.add, var8_13, var11_23);
                        this.addElement.updatePrivileges(this.add, var8_13, 2);
                    }
                    catch (NoSuchRoleException var13_31) {
                        ServiceLogger.logError(var13_31);
                        var5_5.append(var8_13).append(", ");
                    }
                    catch (JRCustomerException var14_37) {
                        ServiceLogger.logError(var14_37);
                        var5_5.append(var8_13).append(", ");
                    }
lbl89:
                    // 4 sources

                } while (var6_6.hasMoreElements());
                break;
            }
            case 3: {
                if (!this.get) break;
                try {
                    var7_9 = this.groupPrivilegeProvider.getGroupPrivileges(this.add);
                    if (true) ** GOTO lbl132
                }
                catch (JRCustomerException var8_14) {
                    ServiceLogger.logError(var8_14);
                    return JSvrResource.getMessage("SECYRITY_M_03012");
                }
                do {
                    var8_15 = (String)var6_6.nextElement();
                    var9_18 = new String[]{};
                    if (var7_9 != null) {
                        var9_18 = (String[])var7_9.get(var8_15);
                    }
                    var10_21 = new Vector<String>();
                    var11_24 = null;
                    var12_27 = PermissionUtil.turnPrivilegeToString(var1_1);
                    if (var9_18 != null) {
                        var13_32 = 0;
                        while (var13_32 < var9_18.length) {
                            var14_38 = var9_18[var13_32];
                            if (!var14_38.equals(var12_27)) {
                                var10_21.add(var14_38);
                            }
                            ++var13_32;
                        }
                    } else {
                        return null;
                    }
                    var11_24 = var10_21.toArray(new String[var10_21.size()]);
                    try {
                        this.groupPrivilegeProvider.setGroupPrivileges(this.add, var8_15, var11_24);
                        this.addElement.updatePrivileges(this.add, var8_15, 3);
                    }
                    catch (NoSuchGroupException var13_33) {
                        ServiceLogger.logError(var13_33);
                        var5_5.append(var8_15).append(", ");
                    }
                    catch (JRCustomerException var14_39) {
                        ServiceLogger.logError(var14_39);
                        var5_5.append(var8_15).append(", ");
                    }
lbl132:
                    // 4 sources

                } while (var6_6.hasMoreElements());
                break;
            }
        }
        if (var5_5.length() != 0) {
            var4_4 = "Remote [" + var5_5.toString() + "] error!";
        }
        return var4_4;
    }
}

