/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseGroup;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.intf.security.Group;
import jet.server.intf.security.GroupManager;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.log.ServiceLogger;

public class GroupDataManager
implements GroupManager {
    private String QOIV;
    private CachedSecurityDataImpl TAG_GROUP_DB_TYPE;
    private GroupProvider add;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    private SecurityListener addGroup;
    boolean addPrincipal = true;
    boolean addRelation = true;
    boolean addSubGroup = true;
    boolean contains = true;

    public GroupDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.TAG_GROUP_DB_TYPE = exCachedSecurityDataImpl;
        this.QOIV = exCachedSecurityDataImpl.getRealmName();
        this.addPrincipal = securityWebUIController.isEditing(8);
        this.addRelation = securityWebUIController.isEditing(10);
        this.addSubGroup = securityWebUIController.isEditing(9);
        this.contains = securityWebUIController.isEditing(20);
        this.add = exCachedSecurityDataImpl.getGroupProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.addGroup = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public GroupDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.TAG_GROUP_DB_TYPE = exCachedSecurityDataImpl;
        this.QOIV = exCachedSecurityDataImpl.getRealmName();
        this.add = exCachedSecurityDataImpl.getGroupProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.addGroup = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized String addNewGroup(String string, String string2, int n) throws GroupExistsException {
        if (!this.addRelation) {
            return "Can not add new group when the GroupProvider isEnableEdit() method return false";
        }
        try {
            this.getBaseGroup(string);
            throw new GroupExistsException(630042, (Object[])new String[]{string}, null);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException, 3);
            Properties properties = new Properties();
            properties.setProperty("group_name", string);
            properties.setProperty("group_description", string2);
            properties.setProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE, String.valueOf(n));
            try {
                this.add.addGroup(this.QOIV, properties);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_02001", string);
            }
            this.addGroup.addPrincipal(this.QOIV, string, 3);
            return null;
        }
    }

    public synchronized String removeGroup(String string) throws NoSuchGroupException {
        if (!this.addSubGroup) {
            return "Can not remove group when the GroupProvider isEnableEdit() method return false";
        }
        this.getBaseGroup(string);
        try {
            this.add.removeGroup(this.QOIV, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return JSvrResource.getMessage("SECURITY_M_02002", string);
        }
        this.addGroup.removePrincipal(this.QOIV, string, 3);
        return null;
    }

    public Group getGroup(String string) throws NoSuchGroupException {
        Group group = this.TAG_GROUP_DB_TYPE.getIntegrityGroup(string);
        if (group == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return group;
    }

    public BaseGroup getBaseGroup(String string) throws NoSuchGroupException {
        BaseGroup baseGroup = this.TAG_GROUP_DB_TYPE.getGroup(string);
        if (baseGroup == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return baseGroup;
    }

    public synchronized String removeGroupFromParentGroup(String string, String string2) throws NoSuchGroupException {
        if (!this.contains) {
            return "Can not edit the group-subGroup relation when the GroupProvider isEnableEdit() method return false";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        BaseGroup baseGroup2 = this.getBaseGroup(string2);
        if (!baseGroup.getParentGroupNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_67_HAVE_NOT_PARENTGROUP", objectArray);
        }
        if (!baseGroup2.getSubGroupNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_68_HAVE_NOT_SUBGROUP", objectArray);
        }
        try {
            this.add.removeSubGroup(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04015", objectArray);
        }
        this.addGroup.removeRelation(this.QOIV, string2, 3, string, 3);
        return null;
    }

    public synchronized String addGroupIntoParentGroup(String string, String string2) throws NoSuchGroupException {
        if (!this.contains) {
            return "Can not edit the group-subGroup relation when the GroupProvider isEnableEdit() method return false";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        BaseGroup baseGroup2 = this.getBaseGroup(string2);
        if (baseGroup.getParentGroupNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_70_HAVE_PARENTGROUP", objectArray);
        }
        if (baseGroup2.getSubGroupNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_71_HAVE_SUBGROUP", objectArray);
        }
        try {
            this.add.addSubGroup(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04016", objectArray);
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logError(groupExistsException);
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_M_04028", objectArray);
        }
        this.addGroup.addRelation(this.QOIV, string2, 3, string, 3);
        return null;
    }

    public Enumeration getAllGroups() {
        Group[] groupArray = this.TAG_GROUP_DB_TYPE.getAllGroups();
        Vector<Group> vector = new Vector<Group>();
        int n = 0;
        while (n < groupArray.length) {
            Group group = groupArray[n];
            vector.add(group);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getAllGroupNames() {
        Group[] groupArray = this.TAG_GROUP_DB_TYPE.getAllGroups();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < groupArray.length) {
            Group group = groupArray[n];
            vector.add(group.getName());
            ++n;
        }
        return vector.elements();
    }
}

