/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.intf.security.Group;
import jet.server.intf.security.GroupManager;
import jet.server.jrc.security.GroupDataManager;

public class GroupManagerImpl
implements GroupManager {
    private GroupDataManager QOIV = null;

    public GroupManagerImpl(GroupDataManager groupDataManager) {
        this.QOIV = groupDataManager;
    }

    public String addNewGroup(String string, String string2, int n) throws GroupExistsException {
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SECURITY_ERR_73_GROUP_NAME_NULL");
        }
        if (!this.isValidName(string)) {
            return "Invalid group name:" + string + "! " + "Valid name can contains only '_0-9a-zA-Z , . and blackspace'";
        }
        return this.QOIV.addNewGroup(string, string2, n);
    }

    public String removeGroup(String string) throws NoSuchGroupException, InUseException {
        Group group = this.getGroup(string);
        int n = group.getSubGroupNames().size();
        int n2 = group.getParentGroupNames().size();
        int n3 = group.getUserNames().size();
        int n4 = group.getRoleNames().size();
        if (n2 > 0) {
            throw new InUseException(630030, (Object[])new String[]{string}, null);
        }
        if (n > 0) {
            throw new InUseException(630031, (Object[])new String[]{string}, null);
        }
        if (n3 > 0) {
            throw new InUseException(630032, (Object[])new String[]{string}, null);
        }
        if (n4 > 0) {
            throw new InUseException(630033, (Object[])new String[]{string}, null);
        }
        return this.QOIV.removeGroup(string);
    }

    public Group getGroup(String string) throws NoSuchGroupException {
        Group group = this.QOIV.getGroup(string);
        return group;
    }

    public String removeGroupFromParentGroup(String string, String string2) throws NoSuchGroupException {
        return this.QOIV.removeGroupFromParentGroup(string, string2);
    }

    public String addGroupIntoParentGroup(String string, String string2) throws NoSuchGroupException {
        this.getGroup(string);
        Group group = this.getGroup(string2);
        if (string.equals(string2)) {
            return JSvrResource.getMessage("SECURITY_ERR_76_SAME_PARENT_GROUP_NAME");
        }
        if (this.QOIV(string, string2)) {
            Object[] objectArray = new String[]{string, string2, string2, string};
            String string3 = JSvrResource.getMessage("SECURITY_ERR_77_IN_GROUP_POSTERITY", objectArray);
            return string3;
        }
        Vector vector = group.getSubGroupNames();
        int n = 0;
        while (n < vector.size()) {
            String string4 = (String)vector.elementAt(n);
            if (string.equals(string4)) {
                Object[] objectArray = new String[]{string2, string};
                return JSvrResource.getMessage("SECURITY_ERR_78_IS_GROUP_SON", objectArray);
            }
            ++n;
        }
        return this.QOIV.addGroupIntoParentGroup(string, string2);
    }

    private synchronized boolean QOIV(String string, String string2) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        Vector vector = group.getSubGroupNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            try {
                Group group2 = this.getGroup(string3);
                String string4 = group2.getName();
                if (this.QOIV(string4, string2)) {
                    return true;
                }
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    public Enumeration getAllGroups() {
        return this.QOIV.getAllGroups();
    }

    public Enumeration getAllGroupNames() {
        return this.QOIV.getAllGroupNames();
    }

    public boolean isValidName(String string) {
        if (string.length() != string.trim().length()) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ',' || c == '.' || c == ' ' || c == '$')) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

