/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Vector;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPrivilege;
import jet.server.jrc.security.JSPermissionImpl;

public class PermissionUtil {
    public static JAclEntry addPermissionToAclEntry(JAclEntry jAclEntry, int n) {
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.VISIBLE)) {
            jAclEntry.addPermission(JSPermissionImpl.VISIBLE);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.READ)) {
            jAclEntry.addPermission(JSPermissionImpl.READ);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.WRITE)) {
            jAclEntry.addPermission(JSPermissionImpl.WRITE);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.EXECUTE)) {
            jAclEntry.addPermission(JSPermissionImpl.EXECUTE);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.SCHEDULE)) {
            jAclEntry.addPermission(JSPermissionImpl.SCHEDULE);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.DELETE)) {
            jAclEntry.addPermission(JSPermissionImpl.DELETE);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.GRANT)) {
            jAclEntry.addPermission(JSPermissionImpl.GRANT);
        }
        return jAclEntry;
    }

    public static int truePermisisonVectorToCode(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            JPermission jPermission = (JPermission)vector.elementAt(n2);
            JPrivilege jPrivilege = PermissionUtil.toPrivilege(jPermission);
            n = PermissionUtil.addPermissionToCode(n, jPrivilege);
            ++n2;
        }
        return n;
    }

    public static JAclEntry addPrivilegeToAclEntry(JAclEntry jAclEntry, int n) {
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.CREATE_ANALYSIS_REPORT)) {
            jAclEntry.addPermission(JSPermissionImpl.CREATE_ANALYSIS_REPORT);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.DEPLOY_REPORT)) {
            jAclEntry.addPermission(JSPermissionImpl.DEPLOY_REPORT);
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.ACCESS_ADVANCED_PROPERTIES)) {
            jAclEntry.addPermission(JSPermissionImpl.ACCESS_ADVANCED_PROPERTIES);
        }
        return jAclEntry;
    }

    public static boolean checkPermissionCode(int n, JPrivilege jPrivilege) {
        boolean bl = (n & PermissionUtil.bit(jPrivilege.getPermissionCode())) != 0;
        return bl;
    }

    private static int bit(int n) {
        return 1 << (n & 0x1F);
    }

    public static int turnPermissionsToCode(JAclEntry jAclEntry) {
        int n = 0;
        Enumeration enumeration = jAclEntry.permissions();
        while (enumeration.hasMoreElements()) {
            JPrivilege jPrivilege = PermissionUtil.toPrivilege((JPermission)enumeration.nextElement());
            n = PermissionUtil.addPermissionToCode(n, jPrivilege);
        }
        return n;
    }

    public static int turnPrivilegesToCode(JAclEntry jAclEntry) {
        int n = 0;
        Enumeration enumeration = jAclEntry.permissions();
        while (enumeration.hasMoreElements()) {
            JPrivilege jPrivilege = PermissionUtil.toPrivilege((JPermission)enumeration.nextElement());
            n = PermissionUtil.addPermissionToCode(n, jPrivilege);
        }
        return n;
    }

    public static JPrivilege toPrivilege(JPermission jPermission) {
        if (jPermission.equals(JSPermissionImpl.VISIBLE)) {
            return JPrivilege.VISIBLE;
        }
        if (jPermission.equals(JSPermissionImpl.READ)) {
            return JPrivilege.READ;
        }
        if (jPermission.equals(JSPermissionImpl.WRITE)) {
            return JPrivilege.WRITE;
        }
        if (jPermission.equals(JSPermissionImpl.EXECUTE)) {
            return JPrivilege.EXECUTE;
        }
        if (jPermission.equals(JSPermissionImpl.SCHEDULE)) {
            return JPrivilege.SCHEDULE;
        }
        if (jPermission.equals(JSPermissionImpl.DELETE)) {
            return JPrivilege.DELETE;
        }
        if (jPermission.equals(JSPermissionImpl.GRANT)) {
            return JPrivilege.GRANT;
        }
        if (jPermission.equals(JSPermissionImpl.CREATE_ANALYSIS_REPORT)) {
            return JPrivilege.CREATE_ANALYSIS_REPORT;
        }
        if (jPermission.equals(JSPermissionImpl.DEPLOY_REPORT)) {
            return JPrivilege.DEPLOY_REPORT;
        }
        if (jPermission.equals(JSPermissionImpl.ACCESS_ADVANCED_PROPERTIES)) {
            return JPrivilege.ACCESS_ADVANCED_PROPERTIES;
        }
        return null;
    }

    public static int addPermissionToCode(int n, JPrivilege jPrivilege) {
        return n | PermissionUtil.bit(jPrivilege.getPermissionCode());
    }

    public static int addPrivilegeToCode(int n, JPrivilege jPrivilege) {
        return n | PermissionUtil.bit(jPrivilege.getPermissionCode());
    }

    public static int removePermissionFromCode(int n, JPrivilege jPrivilege) {
        int n2 = n & ~PermissionUtil.bit(jPrivilege.getPermissionCode());
        return n2;
    }

    public static JPrivilege turnStringToPrivilege(String string) {
        JPrivilege jPrivilege = null;
        if (string.equalsIgnoreCase("jrs.privilege_create_analysis_report")) {
            jPrivilege = JPrivilege.CREATE_ANALYSIS_REPORT;
        } else if (string.equalsIgnoreCase("jrs.privilege_publish_report")) {
            jPrivilege = JPrivilege.DEPLOY_REPORT;
        } else if (string.equalsIgnoreCase("jrs.privilege_access_advanced_properties")) {
            jPrivilege = JPrivilege.ACCESS_ADVANCED_PROPERTIES;
        } else if (string.equalsIgnoreCase("jrs.privilege_deploy_report")) {
            jPrivilege = JPrivilege.DEPLOY_REPORT;
        }
        return jPrivilege;
    }

    public static String turnPrivilegeToString(JPrivilege jPrivilege) {
        String string = jPrivilege.getName();
        String string2 = null;
        if (string.equals(JPrivilege.CREATE_ANALYSIS_REPORT.getName())) {
            string2 = "jrs.privilege_create_analysis_report";
        }
        if (string.equals(JPrivilege.DEPLOY_REPORT.getName())) {
            string2 = "jrs.privilege_publish_report";
        }
        if (string.equals(JPrivilege.ACCESS_ADVANCED_PROPERTIES.getName())) {
            string2 = "jrs.privilege_access_advanced_properties";
        }
        return string2;
    }

    public static String[] getPrivilegesFromPrivilegesCode(int n) {
        Vector<String> vector = new Vector<String>();
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.CREATE_ANALYSIS_REPORT)) {
            vector.add("jrs.privilege_create_analysis_report");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.DEPLOY_REPORT)) {
            vector.add("jrs.privilege_publish_report");
            vector.add("jrs.privilege_deploy_report");
        }
        if (PermissionUtil.checkPermissionCode(n, JPrivilege.ACCESS_ADVANCED_PROPERTIES)) {
            vector.add("jrs.privilege_access_advanced_properties");
        }
        String[] stringArray = new String[vector.size()];
        return vector.toArray(stringArray);
    }

    public static int getPrivilegesCodeFromPrivilegeNames(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            JPrivilege jPrivilege = PermissionUtil.turnStringToPrivilege(string);
            if (jPrivilege != null) {
                n = PermissionUtil.addPrivilegeToCode(n, jPrivilege);
            }
            ++n2;
        }
        return n;
    }
}

