/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.RoleExistsException;
import jet.server.intf.security.Role;
import jet.server.jrc.security.RoleDataManager;

public class RoleManager {
    private RoleDataManager QOIV = null;

    public RoleManager(RoleDataManager roleDataManager) {
        this.QOIV = roleDataManager;
    }

    public String addNewRole(String string, String string2, int n) throws RoleExistsException {
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SECURITY_ERR_20_ROLE_NAME_NULL");
        }
        if (!this.isValidName(string)) {
            return "Invalid role name:" + string + "! " + "Valid name can contains only '_0-9a-zA-Z , . and blackspace'";
        }
        return this.QOIV.addNewRole(string, string2, n);
    }

    public String removeRole(String string) throws NoSuchRoleException, InUseException {
        if (string.equals("administrators")) {
            return JSvrResource.getMessage("SECURITY_ERR_53_REMOVE_ADMIN_ROLE");
        }
        if (string.equals("everyone")) {
            return JSvrResource.getMessage("SECURITY_ERR_54_REMOVE_ECERYONE_ROLE");
        }
        Role role = this.getRole(string);
        int n = role.getSubRoleNames().size();
        int n2 = role.getParentRoleNames().size();
        int n3 = role.getSubUserNames().size();
        int n4 = role.getGroupNames().size();
        if (n2 > 0) {
            throw new InUseException(630034, (Object[])new String[]{string}, null);
        }
        if (n > 0) {
            throw new InUseException(630035, (Object[])new String[]{string}, null);
        }
        if (n4 > 0) {
            throw new InUseException(630036, (Object[])new String[]{string}, null);
        }
        if (n3 > 0) {
            throw new InUseException(630037, (Object[])new String[]{string}, null);
        }
        return this.QOIV.removeRole(string);
    }

    public Role getRole(String string) throws NoSuchRoleException {
        Role role = this.QOIV.getRole(string);
        return role;
    }

    public String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        return this.QOIV.removeRoleFromParentRole(string, string2);
    }

    public String addRoleToParentRole(String string, String string2) throws NoSuchRoleException {
        this.getRole(string);
        Role role = this.getRole(string2);
        if (string.equals(string2)) {
            return JSvrResource.getMessage("SECURITY_ERR_23_SAME_PARENT_ROLE_NAME");
        }
        if (this.isPosterity(string, string2)) {
            Object[] objectArray = new String[]{string, string2, string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_24_IN_ROLE_POSTERITY", objectArray);
        }
        Vector vector = role.getSubRoleNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (string.equals(string3)) {
                Object[] objectArray = new String[]{string2, string};
                return JSvrResource.getMessage("SECURITY_ERR_25_IS_ROLE_SON", objectArray);
            }
            ++n;
        }
        return this.QOIV.addRoleToParentRole(string, string2);
    }

    public synchronized boolean isPosterity(String string, String string2) {
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        Vector vector = role.getSubRoleNames();
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (string2.equalsIgnoreCase(string3)) {
                return true;
            }
            try {
                Role role2 = this.getRole(string3);
                String string4 = role2.getName();
                if (this.isPosterity(string4, string2)) {
                    return true;
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    public String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.QOIV.removeGroupFromRole(string, string2);
    }

    public String addGroupIntoRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.QOIV.addGroupIntoRole(string, string2);
    }

    public Enumeration getAllRoles() {
        return this.QOIV.getAllRoles();
    }

    public Enumeration getAllRoleNames() {
        return this.QOIV.getAllRoleNames();
    }

    public Vector getSubUserNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getSubUserNames();
    }

    public Vector getSubRoleNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getSubRoleNames();
    }

    public Vector getParentRoleNames(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getParentRoleNames();
    }

    public int getMembersCount(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        return role.getMembersCount();
    }

    public boolean isValidName(String string) {
        if (string.length() != string.trim().length()) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ',' || c == '.' || c == ' ' || c == '$')) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

