/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.acl.Permission;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.ServerEnv;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.SecurityAdapter;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.JSPermissionImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class SecurityAdapterImpl
extends UnicastRemoteObject
implements SecurityAdapter {
    public SecurityAdapterImpl() throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
    }

    public String changePassword(String string, String string2, String string3, String string4, String string5) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.changePassword(securityService.isAdminUser(string2), string2, string4, string3, string5);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 2);
            return null;
        }
    }

    public boolean isPermissionOk(String string, String string2, String string3, int n, String string4) throws RemoteException {
        ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(string);
        Vector vector = JSPermissionImpl.parseCmds(string4);
        int n2 = 0;
        while (n2 < vector.size()) {
            try {
                if (n > 0 ? !resourceTreeManagerImpl.checkPermission(string3, n, string2, (Permission)vector.elementAt(n2)) : !resourceTreeManagerImpl.checkPermission(string3, string2, (Permission)vector.elementAt(n2))) {
                    return false;
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                return false;
            }
            catch (UnknownResource unknownResource) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean checkPrivilege(String string, String string2, String string3) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.checkPrivilege(string2, string3);
    }

    public boolean isValidUser(String string, String string2, String string3) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.isValidUser(string2, string3);
    }

    public boolean isValidAdminUser(String string, String string2, String string3) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.isValidUser(string2, string3) && securityService.isAdminUser(string2);
    }

    public boolean isAdminUser(String string, String string2) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.isAdminUser(string2);
    }

    public String getPassword(String string, String string2) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.getPassword(string2);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 2);
            return null;
        }
    }

    public Vector getUserNames(String string) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getAllUsersName();
    }

    public boolean getAuditState(String string, String string2, int n, boolean bl) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.getAuditState(string2, n, bl);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 2);
            return false;
        }
    }

    public BaseRole getRole(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getRole(string);
    }

    public BaseGroup getGroup(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getGroup(string);
    }

    public BaseUser getUser(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getUser(string);
    }

    public Vector getAllUsers(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getAllUsers(string);
    }

    public Vector getAllRoles(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getAllRoles(string);
    }

    public Vector getAllGroups(String string) throws RemoteException {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        return exSecurityData.getAllGroups(string);
    }

    public boolean checkExpire(String string, String string2) throws RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.isExpired(string2);
    }

    public Vector getUserNamesByGroup(String string, String string2) throws NoSuchGroupException, RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getUsersNameByGroup(string2);
    }

    public Vector getUserNamesByRole(String string, String string2) throws NoSuchRoleException, RemoteException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getUsersNameByRole(string2);
    }

    public Vector getAllUserNamesByReferedRole(String string, String string2) throws NoSuchRoleException, NoSuchGroupException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getAllUserNamesByReferedRole(string2);
    }

    public Vector getAllContainedUserNamesByGroup(String string, String string2) throws NoSuchGroupException {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getAllContainedUserNamesByGroup(string2);
    }
}

