/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.server.api.db.Database;
import jet.server.api.exception.NoSuchUserException;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.security2.AclEntryRecord;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclEntryTableImpl;
import jet.server.db.security2.AclRecord;
import jet.server.db.security2.AclTable;
import jet.server.db.security2.AclTableImpl;
import jet.server.db.security2.ExtendAclEntryRecord;
import jet.server.db.security2.ExtendAclEntryTable;
import jet.server.db.security2.ExtendAclEntryTableImpl;
import jet.server.db.security2.GUProfileTable;
import jet.server.db.security2.GUProfileTableImpl;
import jet.server.db.security2.GroupProfileTable;
import jet.server.db.security2.GroupProfileTableImpl;
import jet.server.db.security2.GroupRecord;
import jet.server.db.security2.GroupTable;
import jet.server.db.security2.GroupTableImpl;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RGProfileTableImpl;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleProfileTableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.RoleTableImpl;
import jet.server.db.security2.UserProfileRecord;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserProfileTableImpl;
import jet.server.db.security2.UserRecord;
import jet.server.db.security2.UserTable;
import jet.server.db.security2.UserTableImpl;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.JRDataService;
import jet.server.jrc.security.GroupImpl;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.UserImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class SecurityDataImpl
implements ExSecurityData {
    public static final String NULL_PASSWORD = "NullPassword.jinfonet";
    JRDataService QOIV = null;
    private UserTable add = null;
    private UserProfileTable addEntry = null;
    private RoleTable addGroup = null;
    private AclTable addParentGroup = null;
    private AclEntryTable addParentRole = null;
    private RoleProfileTable addPermissionToAclEntry = null;
    private GroupTable addPrivilegeToAclEntry = null;
    private GroupProfileTable addRecord = null;
    private RGProfileTable addRole = null;
    private GUProfileTable addSubGroup = null;
    private Hashtable addSubRole = new Hashtable();
    private Hashtable addSubUser = new Hashtable();
    private Hashtable addUser = new Hashtable();
    private Hashtable append = new Hashtable();
    private Hashtable contains = new Hashtable();
    private Hashtable currentTimeMillis = new Hashtable();
    private Hashtable elementAt = new Hashtable();
    private Hashtable elements = new Hashtable();
    private Hashtable encode = new Hashtable();
    private Hashtable equals = new Hashtable();
    private Hashtable get = new Hashtable();
    private Hashtable getAclEntryRecords = new Hashtable();
    private Hashtable getAclEntryTable = new Hashtable();
    private Hashtable getAclTable = new Hashtable();
    private ExtendAclEntryTable getAllAclID = null;
    private JAcl getAllGroups = null;
    public int defaultAclID;

    public SecurityDataImpl(JRDataService jRDataService) {
        this.QOIV = jRDataService;
        this.add();
        this.addGroup();
        this.addPrivilegeToAclEntry();
        this.addSubUser();
        this.addEntry();
        this.addParentGroup();
        this.addRecord();
        this.addSubGroup();
        this.elementAt();
        this.addUser();
    }

    public SecurityDataImpl(Database database) {
        this.QOIV(database);
        this.addGroup();
        this.addPrivilegeToAclEntry();
        this.addSubUser();
        this.addEntry();
        this.addParentGroup();
        this.addRecord();
        this.addUser();
    }

    private void QOIV(Database database) {
        UpdateDetailsTableImpl updateDetailsTableImpl = UpdateDetailsTableImpl.newInstance(database);
        this.add = UserTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addEntry = UserProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addGroup = RoleTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addParentGroup = AclTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addParentRole = AclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addPrivilegeToAclEntry = GroupTableImpl.newInstance(database);
        this.addRecord = GroupProfileTableImpl.newInstance(database);
        this.addRole = RGProfileTableImpl.newInstance(database);
        this.addSubGroup = GUProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.addPermissionToAclEntry = RoleProfileTableImpl.newInstance(database, updateDetailsTableImpl);
        this.getAllAclID = ExtendAclEntryTableImpl.newInstance(database, updateDetailsTableImpl);
    }

    private void add() {
        this.add = this.QOIV.getUserTable();
        this.addEntry = this.QOIV.getUserProfileTable();
        this.addGroup = this.QOIV.getRoleTable();
        this.addParentGroup = this.QOIV.getAclTable();
        this.addParentRole = this.QOIV.getAclEntryTable();
        this.addPrivilegeToAclEntry = this.QOIV.getGroupTable();
        this.addRecord = this.QOIV.getGroupProfileTable();
        this.addRole = this.QOIV.getRGProfileTable();
        this.addSubGroup = this.QOIV.getGUProfileTable();
        this.addPermissionToAclEntry = this.QOIV.getRoleProfileTable();
        this.getAllAclID = this.QOIV.getExtendAclEntryTable();
    }

    public Hashtable getUsersHT() {
        return this.get;
    }

    public Hashtable getRolesHT() {
        return this.getAclEntryRecords;
    }

    public Hashtable getAclsHT() {
        return this.getAclTable;
    }

    public Hashtable getGroupsHT() {
        return this.getAclEntryTable;
    }

    private void addEntry() {
        Hashtable[] hashtableArray = this.addEntry.getAllRecords();
        this.addSubRole = hashtableArray[0];
        this.addUser = hashtableArray[1];
        Hashtable[] hashtableArray2 = this.addPermissionToAclEntry.getAllRecords();
        this.contains = hashtableArray2[0];
        this.currentTimeMillis = hashtableArray2[1];
        Hashtable[] hashtableArray3 = this.addRole.getAllRecords();
        this.append = hashtableArray3[0];
        this.elements = hashtableArray3[1];
        Hashtable[] hashtableArray4 = this.addSubGroup.getAllRecords();
        this.elementAt = hashtableArray4[0];
        this.addSubUser = hashtableArray4[1];
        Hashtable[] hashtableArray5 = this.addRecord.getAllRecords();
        this.encode = hashtableArray5[0];
        this.equals = hashtableArray5[1];
    }

    private void addGroup() {
        try {
            this.addPermissionToAclEntry("admin");
        }
        catch (NoSuchUserException noSuchUserException) {
            this.add.addRecord("admin", "admin", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode("admin"), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
        try {
            this.addPermissionToAclEntry("guest");
        }
        catch (NoSuchUserException noSuchUserException) {
            this.add.addRecord("guest", "guest", "SystemBuild", "", new Date(System.currentTimeMillis()), ServerUtil.encode(NULL_PASSWORD), true, true, 6, new Date(System.currentTimeMillis()), true, 30, false, true, true, true, true, false, 0, 0);
        }
    }

    private void addParentGroup() {
        Vector vector = this.add.getAllUsers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            UserRecord userRecord = (UserRecord)enumeration.nextElement();
            User user = this.addParentRole(userRecord);
            String string = user.getName();
            Vector vector3 = (Vector)this.addSubRole.get(string);
            if (vector3 != null) {
                int n = 0;
                while (n < vector3.size()) {
                    String string2 = (String)vector3.elementAt(n);
                    user.addParentRole(string2);
                    ++n;
                }
            }
            if ((vector2 = (Vector)this.addSubUser.get(string)) != null) {
                int n = 0;
                while (n < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n);
                    user.addGroup(string3);
                    ++n;
                }
            }
            this.get.put(string, user);
        }
    }

    private User addParentRole(UserRecord userRecord) {
        UserImpl userImpl = new UserImpl();
        userImpl.setName(userRecord.getName());
        userImpl.setFullName(userRecord.getFullName());
        userImpl.setDescription(userRecord.getDescription());
        userImpl.setEmail(userRecord.getEmail());
        userImpl.setBuildin(userRecord.isBuiltin());
        userImpl.setPassword(userRecord.getPassword());
        userImpl.setEnableNullPS(userRecord.isEnableNullPS());
        userImpl.setMinPSLength(userRecord.getMinPSLength());
        userImpl.setNeverExpire(userRecord.isNeverExpire());
        userImpl.setLastModifyTime(userRecord.getLastModifyTime());
        userImpl.setExpireTime(userRecord.getExpireTime());
        userImpl.setAccountDisable(userRecord.isAccountDisable());
        userImpl.setAccessEventSuc(userRecord.isAccessedEventSuc());
        userImpl.setAccessEventFail(userRecord.isAccessedEventFail());
        userImpl.setManagementEventSuc(userRecord.isManagementEventSuc());
        userImpl.setManagementEventFail(userRecord.isManagementEventFail());
        userImpl.setNoAudit(userRecord.isNoAudit());
        userImpl.setAuthType(userRecord.getAuthType());
        userImpl.setLdapType(userRecord.getLdapType());
        return userImpl;
    }

    private User addPermissionToAclEntry(String string) throws NoSuchUserException {
        UserRecord userRecord = this.add.getUserRecordbyUN(string);
        if (userRecord == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string}, null);
        }
        UserImpl userImpl = new UserImpl();
        userImpl.setName(userRecord.getName());
        userImpl.setFullName(userRecord.getFullName());
        userImpl.setDescription(userRecord.getDescription());
        userImpl.setEmail(userRecord.getEmail());
        userImpl.setPassword(userRecord.getPassword());
        userImpl.setCreateTime(userRecord.getCreateTime());
        userImpl.setBuildin(userRecord.isBuiltin());
        userImpl.setEnableNullPS(userRecord.isEnableNullPS());
        userImpl.setMinPSLength(userRecord.getMinPSLength());
        userImpl.setNeverExpire(userRecord.isNeverExpire());
        userImpl.setLastModifyTime(userRecord.getLastModifyTime());
        userImpl.setExpireTime(userRecord.getExpireTime());
        userImpl.setAccountDisable(userRecord.isAccountDisable());
        userImpl.setAccessEventSuc(userRecord.isAccessedEventSuc());
        userImpl.setAccessEventFail(userRecord.isAccessedEventFail());
        userImpl.setManagementEventSuc(userRecord.isManagementEventSuc());
        userImpl.setManagementEventFail(userRecord.isManagementEventFail());
        userImpl.setNoAudit(userRecord.isNoAudit());
        userImpl.setAuthType(userRecord.getAuthType());
        userImpl.setLdapType(userRecord.getLdapType());
        return userImpl;
    }

    private void addPrivilegeToAclEntry() {
        UserProfileRecord userProfileRecord;
        RoleRecord roleRecord;
        RoleRecord roleRecord2 = this.addGroup.getRole("administrators");
        if (roleRecord2 == null) {
            this.addGroup.addRecord("administrators", true, "SystemBuild", 0);
        }
        if ((roleRecord = this.addGroup.getRole("everyone")) == null) {
            this.addGroup.addRecord("everyone", true, "SystemBuild", 0);
            userProfileRecord = this.addEntry.getRecord("guest", "everyone");
            if (userProfileRecord == null) {
                this.addEntry.addRecord("guest", "everyone");
            }
            if ((userProfileRecord = this.addEntry.getRecord("admin", "everyone")) == null) {
                this.addEntry.addRecord("admin", "everyone");
            }
        }
        if ((userProfileRecord = this.addEntry.getRecord("admin", "administrators")) == null) {
            this.addEntry.addRecord("admin", "administrators");
        }
    }

    private void addRecord() {
        Vector vector = this.addGroup.getAllRoles();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Vector vector2;
            Object object2;
            RoleRecord roleRecord = (RoleRecord)enumeration.nextElement();
            Role role = this.addRole(roleRecord);
            String string = role.getName();
            Vector vector3 = (Vector)this.addUser.get(string);
            if (vector3 != null) {
                int n = 0;
                while (n < vector3.size()) {
                    object2 = (String)vector3.get(n);
                    role.addSubUser((String)object2);
                    ++n;
                }
            }
            if ((vector2 = (Vector)this.append.get(string)) != null) {
                int n = 0;
                while (n < vector2.size()) {
                    object = (String)vector2.elementAt(n);
                    role.addGroup((String)object);
                    ++n;
                }
            }
            if ((object2 = (Vector)this.contains.get(string)) != null) {
                int n = 0;
                while (n < ((Vector)object2).size()) {
                    String string2 = (String)((Vector)object2).get(n);
                    role.addSubRole(string2);
                    ++n;
                }
            }
            if ((object = (Vector)this.currentTimeMillis.get(string)) != null) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    String string3 = (String)((Vector)object).get(n);
                    role.addParentRole(string3);
                    ++n;
                }
            }
            this.getAclEntryRecords.put(string, role);
        }
    }

    private Role addRole(RoleRecord roleRecord) {
        RoleImpl roleImpl = new RoleImpl(roleRecord.getName(), roleRecord.isBuiltin(), roleRecord.getDescription(), roleRecord.getType());
        return roleImpl;
    }

    private void addSubGroup() {
        Vector vector = this.addPrivilegeToAclEntry.getAllGroups();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Vector vector2;
            Object object2;
            GroupRecord groupRecord = (GroupRecord)enumeration.nextElement();
            Group group = this.addSubRole(groupRecord);
            String string = group.getName();
            Vector vector3 = (Vector)this.elementAt.get(string);
            if (vector3 != null) {
                int n = 0;
                while (n < vector3.size()) {
                    object2 = (String)vector3.get(n);
                    group.addUser((String)object2);
                    ++n;
                }
            }
            if ((vector2 = (Vector)this.elements.get(string)) != null) {
                int n = 0;
                while (n < vector2.size()) {
                    object = (String)vector2.elementAt(n);
                    group.addRole((String)object);
                    ++n;
                }
            }
            if ((object2 = (Vector)this.encode.get(string)) != null) {
                int n = 0;
                while (n < ((Vector)object2).size()) {
                    String string2 = (String)((Vector)object2).elementAt(n);
                    group.addSubGroup(string2);
                    ++n;
                }
            }
            if ((object = (Vector)this.equals.get(string)) != null) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    String string3 = (String)((Vector)object).elementAt(n);
                    group.addParentGroup(string3);
                    ++n;
                }
            }
            this.getAclEntryTable.put(string, group);
        }
    }

    private Group addSubRole(GroupRecord groupRecord) {
        GroupImpl groupImpl = new GroupImpl(groupRecord.getName(), groupRecord.isBuiltin(), groupRecord.getDescription(), groupRecord.getType());
        return groupImpl;
    }

    public BaseRole getRole(String string) {
        return (BaseRole)this.getAclEntryRecords.get(string);
    }

    public BaseUser getUser(String string) {
        return (BaseUser)this.get.get(string);
    }

    private void addSubUser() {
        AclRecord aclRecord = this.addParentGroup.getRecordByName("defaultAcl");
        if (aclRecord != null) {
            this.defaultAclID = aclRecord.getID();
            return;
        }
        AclRecord aclRecord2 = this.addParentGroup.addRecord("defaultAcl", "System", new Date(System.currentTimeMillis()), false);
        this.defaultAclID = aclRecord2.getID();
        byte by = 2;
        this.addParentRole.addRecord(this.defaultAclID, by, "everyone", true, 3);
    }

    private void addUser() {
        Vector vector = this.addParentGroup.getAllAclID();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException);
                continue;
            }
            JAcl jAcl = this.append(n);
            if (jAcl == null) continue;
            this.getAclTable.put(string, jAcl);
        }
        this.initExtendAcl();
    }

    public JAcl initExtendAcl() {
        this.getAllGroups = this.defaultAclID();
        return this.getAllGroups;
    }

    private JAcl append(int n) {
        Vector vector = this.addParentRole.getAclEntryRecords(n);
        AclRecord aclRecord = this.addParentGroup.getRecordByID(n);
        if (aclRecord == null) {
            return null;
        }
        String string = aclRecord.getName();
        JAclImpl jAclImpl = new JAclImpl(string, this);
        if (vector == null) {
            return jAclImpl;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Principal principal;
            AclEntryRecord aclEntryRecord = (AclEntryRecord)enumeration.nextElement();
            int n2 = aclEntryRecord.getPermissions();
            boolean bl = aclEntryRecord.isPositive();
            byte by = aclEntryRecord.getPrincipalType();
            String string2 = aclEntryRecord.getPrincipalName();
            JAclEntry jAclEntry = new JAclEntryImpl(string2, this);
            if (!bl) {
                jAclEntry.setNegativePermissions();
            }
            if (by == 1) {
                principal = this.getUser(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else if (by == 2) {
                principal = this.getRole(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else {
                principal = this.getGroup(string2);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            }
            principal = null;
            jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n2);
            try {
                jAclImpl.addEntry(principal, jAclEntry);
            }
            catch (NotOwnerException notOwnerException) {
                ServiceLogger.logError(notOwnerException);
            }
        }
        return jAclImpl;
    }

    public UserTable getUserTable() {
        return this.add;
    }

    public UserProfileTable getUserProfileTable() {
        return this.addEntry;
    }

    public RoleTable getRoleTable() {
        return this.addGroup;
    }

    public AclTable getAclTable() {
        return this.addParentGroup;
    }

    public AclEntryTable getAclEntryTable() {
        return this.addParentRole;
    }

    public RoleProfileTable getRoleProfileTable() {
        return this.addPermissionToAclEntry;
    }

    public ExtendAclEntryTable getExtendAclEntryTable() {
        return this.getAllAclID;
    }

    public Vector getAllUsers(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.get.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    public Vector getAllRoles(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.getAclEntryRecords.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    private boolean isAdminUser(String string) {
        Vector vector;
        try {
            vector = this.contains(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException);
            return false;
        }
        return vector.contains("administrators");
    }

    private Vector contains(String string) throws NoSuchUserException {
        Object object;
        Vector<String> vector = new Vector<String>();
        BaseUser baseUser = this.getUser(string);
        if (baseUser == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string}, null);
        }
        Vector vector2 = baseUser.getGroupNames();
        Vector vector3 = baseUser.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.currentTimeMillis((String)object, vector);
        }
        object = vector3.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            vector.add(string2);
            this.getAllRoleNames(string2, vector);
        }
        return vector;
    }

    private void getAllRoleNames(String string, Vector vector) {
        BaseRole baseRole = this.getRole(string);
        if (baseRole == null) {
            return;
        }
        Vector vector2 = baseRole.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector.add(string2);
            this.getAllRoleNames(string2, vector);
        }
    }

    private void currentTimeMillis(String string, Vector vector) {
        Object object;
        BaseGroup baseGroup = this.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        Vector vector2 = baseGroup.getRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            vector.add(object);
            this.getAllRoleNames((String)object, vector);
        }
        object = baseGroup.getParentGroupNames();
        Enumeration enumeration2 = ((Vector)object).elements();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            this.currentTimeMillis(string2, vector);
        }
    }

    public GroupTable getGroupTable() {
        return this.addPrivilegeToAclEntry;
    }

    public GroupProfileTable getGroupProfileTable() {
        return this.addRecord;
    }

    public RGProfileTable getRGProfileTable() {
        return this.addRole;
    }

    public GUProfileTable getGUProfileTable() {
        return this.addSubGroup;
    }

    public Vector getAllGroups(String string) {
        Vector vector = new Vector();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.getAclEntryTable.elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    public User[] getAllUsers() {
        return new User[0];
    }

    public Role[] getAllRoles() {
        return new Role[0];
    }

    public Group[] getAllGroups() {
        return new Group[0];
    }

    public JAcl getAcl(String string, int n) {
        return null;
    }

    public BaseGroup getGroup(String string) {
        return (BaseGroup)this.getAclEntryTable.get(string);
    }

    public JAcl getExtendAcl() {
        return this.getAllGroups;
    }

    public Permission[] getUserPermissions(String string, String string2, int n) {
        return new Permission[0];
    }

    private JAcl defaultAclID() {
        JAclImpl jAclImpl = new JAclImpl("extendAcl", this);
        Vector vector = this.getAllAclID.getExtendAclEntryRecords();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Principal principal;
            ExtendAclEntryRecord extendAclEntryRecord = (ExtendAclEntryRecord)enumeration.nextElement();
            String string = extendAclEntryRecord.getPrincipalName();
            byte by = extendAclEntryRecord.getPrincipalType();
            JAclEntry jAclEntry = new JAclEntryImpl(string + "_" + by, this);
            if (by == 1) {
                principal = this.getUser(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else if (by == 2) {
                principal = this.getRole(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            } else {
                principal = this.getGroup(string);
                if (principal == null) continue;
                jAclEntry.setPrincipal(principal);
            }
            principal = null;
            int n = extendAclEntryRecord.getPermissions();
            jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
            try {
                jAclImpl.addEntry(principal, jAclEntry);
            }
            catch (NotOwnerException notOwnerException) {
                ServiceLogger.logError(notOwnerException);
            }
        }
        return jAclImpl;
    }

    private void elementAt() {
        Object object;
        Enumeration enumeration = this.get.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).equals("admin") || this.getAllAclID.getExtendAclEntryRecord((String)object, (byte)1) != null) continue;
            this.getAllAclID.addRecord((String)object, (byte)1, Integer.MAX_VALUE);
        }
        object = this.getAclEntryRecords.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.equals("administrators") || this.getAllAclID.getExtendAclEntryRecord(string, (byte)2) != null) continue;
            this.getAllAclID.addRecord(string, (byte)2, Integer.MAX_VALUE);
        }
    }
}

