/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.intf.security.User;
import jet.server.jrc.security.UserDataManager;
import jet.server.log.ServiceLogger;
import jet.util.MiscTools;

public class UserManager {
    private UserDataManager QOIV;

    public UserManager(UserDataManager userDataManager) {
        this.QOIV = userDataManager;
    }

    public User getUser(String string) throws NoSuchUserException {
        return this.QOIV.getUser(string);
    }

    public String addNewUser(String string, String string2, String string3, String string4, Date date, String string5, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3, boolean bl4) throws UserExistsException {
        String string6 = null;
        if (string5 == null) {
            string5 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string == null || string.trim().length() == 0) {
            string6 = JSvrResource.getMessage("SVR_21");
        } else if (!UserManager.isValidName(string)) {
            string6 = JSvrResource.getMessage("SVR_121") + string + JSvrResource.getMessage("SVR_122");
        } else if (MiscTools.containChar((String)string2, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_23", "\":\"");
        } else if (MiscTools.containChar((String)string3, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_24", "\":\"");
        } else if (MiscTools.containChar((String)string4, (String)":")) {
            string6 = JSvrResource.getMessage("SVR_73", "\":\"");
        } else if (!bl2 && n2 < 0) {
            string6 = JSvrResource.getMessage("SVR_29");
        } else if (!bl) {
            if (n < 0) {
                string6 = JSvrResource.getMessage("SVR_31");
            }
            if (string5.length() < n) {
                string6 = JSvrResource.getMessage("SVR_32", "" + n);
            }
        }
        if (string6 != null) {
            return string6;
        }
        string6 = this.QOIV.addNewUser(string, string2, string3, string4, date, string5, bl, n, date2, bl2, n2, bl3, bl4);
        return string6;
    }

    public static boolean isValidName(String string) {
        if (string.length() != string.trim().length()) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ',' || c == '.' || c == ' ' || c == '$')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String removeUser(String string) throws InUseException, NoSuchUserException {
        if (string.equals("admin")) {
            return JSvrResource.getMessage("SECURITY_ERR_52_REMOVE_ADMIN_USER");
        }
        if (string.equals("guest")) {
            return JSvrResource.getMessage("SECURITY_ERR_51_REMOVE_GUSET_USER");
        }
        User user = this.getUser(string);
        int n = user.getGroupNames().size();
        if (n > 0) {
            throw new InUseException(630039, (Object[])new String[]{string}, null);
        }
        int n2 = user.getParentRoleNames().size();
        if (n2 > 1) {
            throw new InUseException(630038, (Object[])new String[]{string}, null);
        }
        if (n2 == 1) {
            String string2 = (String)user.getParentRoleNames().elementAt(0);
            if (string2.equals("everyone")) {
                String string3 = null;
                try {
                    string3 = this.QOIV.removeUserFromParentRole(string, "everyone");
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException);
                }
                if (string3 != null) {
                    return string3;
                }
            } else {
                throw new InUseException(630038, (Object[])new String[]{string}, null);
            }
        }
        return this.QOIV.removeUser(string);
    }

    public Vector getParentRoleNames(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getParentRoleNames();
    }

    public String updataAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        return this.QOIV.updataAttributes(string, string2, string3, string4, bl, n, date, bl2, n2, bl3);
    }

    public String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        return this.QOIV.updataEvent(string, bl, bl2, bl3, bl4, bl5);
    }

    public String changePassword(String string, String string2, String string3) throws NoSuchUserException {
        User user = this.getUser(string2);
        String string4 = null;
        if (MiscTools.containChar((String)string3, (String)" :")) {
            return JSvrResource.getMessage("SVR_26", "space and ':'");
        }
        boolean bl = user.isEnableNullPS();
        if (!bl) {
            if (string3 == null || string3.trim().length() == 0) {
                string4 = JSvrResource.getMessage("SVR_27");
            } else {
                int n = user.getMinPSLength();
                if (string3.length() < n) {
                    string4 = JSvrResource.getMessage("SVR_32", "" + n);
                }
            }
        }
        if (string4 == null) {
            string4 = this.QOIV.changePassword(string, string2, string3);
        }
        return string4;
    }

    public String getPassword(String string) throws NoSuchUserException {
        return this.QOIV.getPassword(string);
    }

    public String addUserToParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        return this.QOIV.addUserToParentRole(string, string2);
    }

    public String removeUserFromParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        return this.QOIV.removeUserFromParentRole(string, string2);
    }

    public String addUserToGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        return this.QOIV.addUserToGroup(string, string2);
    }

    public String removeUserFromGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        return this.QOIV.removeUserFromGroup(string, string2);
    }

    public Enumeration getAllUsers() {
        return this.QOIV.getAllUsers();
    }

    public Enumeration getAllUserNames() {
        return this.QOIV.getAllUserNames();
    }

    public int getParentRolesCount(String string) throws NoSuchUserException {
        return this.QOIV.getParentRolesCount(string);
    }
}

