/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.db.role;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.RoleExistsException;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.RGProfileTable;
import jet.server.db.security2.RoleProfileRecord;
import jet.server.db.security2.RoleProfileTable;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.UserProfileTable;
import jet.server.jrc.security.custom.db.SecurityDBBasic;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.log.ServiceLogger;

public class RoleProviderDBImpl
implements RoleProvider {
    public static String TAG_ROLE_DB_BUILDIN = "role_db_buildin";
    public static String TAG_ROLE_DB_TYPE = "role_db_type";

    public Iterator getAllRoles(String string) throws JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        Iterator iterator = null;
        RoleTable roleTable = securityDBBasic.getRoleTable();
        Vector vector = roleTable.getAllRoles();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            RoleRecord roleRecord = (RoleRecord)vector.elementAt(n);
            String string2 = roleRecord.getName();
            vector2.add(string2);
            ++n;
        }
        iterator = vector2.iterator();
        return iterator;
    }

    public Properties getRoleProperties(String string, String string2) throws NoSuchRoleException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        Properties properties = new Properties();
        properties.setProperty("role_name", string2);
        properties.setProperty("role_description", roleRecord.getDescription());
        properties.put(TAG_ROLE_DB_BUILDIN, String.valueOf(roleRecord.isBuiltin()));
        String string3 = "false";
        if (roleRecord.getType() == 1) {
            string3 = "true";
        }
        properties.put(TAG_ROLE_DB_TYPE, string3);
        return properties;
    }

    public Iterator getSubRoles(String string, String string2) throws NoSuchRoleException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        RoleProfileTable roleProfileTable = securityDBBasic.getRoleProfileTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        Vector vector = roleProfileTable.getSubRoles(string2);
        Iterator iterator = vector.iterator();
        return iterator;
    }

    public void addRole(String string, Properties properties) throws RoleExistsException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (properties == null || properties.size() == 0) {
            throw new JRCustomerException(630060);
        }
        String string2 = properties.getProperty("role_name");
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord != null) {
            throw new RoleExistsException(630082, (Object[])new String[]{string2}, null);
        }
        String string3 = properties.getProperty("role_description", "");
        boolean bl = false;
        int n = 0;
        String string4 = properties.getProperty(TAG_ROLE_DB_TYPE);
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
        }
        n = n == 1 ? 1 : 0;
        RoleRecord roleRecord2 = roleTable.addRecord(string2, bl, string3, n);
        if (roleRecord2 == null) {
            throw new JRCustomerException(630059, (Object[])new String[]{string2}, null);
        }
    }

    public void removeRole(String string, String string2) throws NoSuchRoleException, JRCustomerException {
        byte by;
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        UserProfileTable userProfileTable = securityDBBasic.getUserProfileTable();
        RoleProfileTable roleProfileTable = securityDBBasic.getRoleProfileTable();
        RGProfileTable rGProfileTable = securityDBBasic.getRgProfileTable();
        AclEntryTable aclEntryTable = securityDBBasic.getAclEntryTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        boolean bl = roleTable.deleteRole(string2);
        if (!bl) {
            throw new JRCustomerException(630058, (Object[])new String[]{string2}, null);
        }
        boolean bl2 = roleProfileTable.deleteRecord(string2);
        boolean bl3 = roleProfileTable.deleteRecordByRoleName(string2);
        if (!bl2 || !bl3) {
            ServiceLogger.logError(3630058, string2, 3);
        }
        if (!userProfileTable.deleteRecordByRoleName(string2)) {
            ServiceLogger.logError(3630059, string2, 3);
        }
        if (!rGProfileTable.deleteRecordByRoleName(string2)) {
            ServiceLogger.logError(3630060, string2, 3);
        }
        if (!aclEntryTable.deleteRecord(string2, by = 2)) {
            ServiceLogger.logError(3630061, string2, 3);
        }
    }

    public void addSubRole(String string, String string2, String string3) throws NoSuchRoleException, RoleExistsException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630055);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        RoleRecord roleRecord2 = roleTable.getRole(string3);
        if (roleRecord2 == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        RoleProfileTable roleProfileTable = securityDBBasic.getRoleProfileTable();
        RoleProfileRecord roleProfileRecord = roleProfileTable.getRecord(string2, string3);
        if (roleProfileRecord != null) {
            Object[] objectArray = new String[]{string2, string3};
            ServiceLogger.logDebug(6630062, objectArray, 6);
            return;
        }
        RoleProfileRecord roleProfileRecord2 = roleProfileTable.addRecord(string2, string3);
        if (roleProfileRecord2 == null) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630057, objectArray, null);
        }
    }

    public void removeSubRole(String string, String string2, String string3) throws NoSuchRoleException, JRCustomerException {
        if (string == null || string.length() == 0) {
            throw new JRCustomerException(630043);
        }
        SecurityDBBasic securityDBBasic = SecurityDBEnv.getSecurityDBBasic(string);
        if (securityDBBasic == null) {
            throw new JRCustomerException(630044, (Object[])new String[]{string}, null);
        }
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630055);
        }
        if (string3 == null || string3.length() == 0) {
            throw new JRCustomerException(630055);
        }
        RoleTable roleTable = securityDBBasic.getRoleTable();
        RoleRecord roleRecord = roleTable.getRole(string2);
        if (roleRecord == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        RoleRecord roleRecord2 = roleTable.getRole(string3);
        if (roleRecord2 == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string2}, null);
        }
        RoleProfileTable roleProfileTable = securityDBBasic.getRoleProfileTable();
        boolean bl = roleProfileTable.deleteRecord(string2, string3);
        if (!bl) {
            Object[] objectArray = new String[]{string3, string2};
            throw new JRCustomerException(630056, objectArray, null);
        }
    }

    public boolean isEnableEdit() {
        return true;
    }
}

