/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.custom.ldap.user;

import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;

public class UserProviderLDAPImpl
implements UserProvider {
    LDAPManager QOIV = UserDataToolkit.getLdapManager();

    public Iterator getAllUsers(String string) throws JRCustomerException {
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = this.QOIV.getAllLDAPUsers();
            int n = 0;
            while (n < vector2.size()) {
                LDAPUser lDAPUser = (LDAPUser)vector2.elementAt(n);
                vector.add(lDAPUser.getName());
                ++n;
            }
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        return vector.iterator();
    }

    public Properties getUserProperties(String string, String string2) throws NoSuchUserException, JRCustomerException {
        Properties properties = new Properties();
        if (string2 == null || string2.length() == 0) {
            throw new JRCustomerException(630046);
        }
        LDAPUser lDAPUser = null;
        try {
            lDAPUser = this.QOIV.getLDAPUser(string2);
        }
        catch (NamingException namingException) {
            throw new JRCustomerException(namingException);
        }
        if (lDAPUser == null) {
            throw new NoSuchUserException(630003, (Object[])new String[]{string2}, null);
        }
        properties.put("user_name", string2);
        properties.put("user_fullname", lDAPUser.getProperty("full_name"));
        properties.put("user_description", lDAPUser.getProperty("description"));
        properties.put("user_email", lDAPUser.getProperty("email"));
        properties.put("user_create_time", new Date(System.currentTimeMillis()));
        properties.put("user_password", "ldapUser");
        properties.put("user_enable_null_pwd", String.valueOf(true));
        properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
        properties.put("user_never_expire", String.valueOf(true));
        properties.put("user_expire_time", String.valueOf(30));
        properties.put("user_min_pwd_length", String.valueOf(6));
        properties.put("user_disabled_account", String.valueOf(false));
        return properties;
    }

    public void addUser(String string, Properties properties) throws UserExistsException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"UserProviderLDAPImpl:addUser()"}, null);
    }

    public void setUser(String string, Properties properties) throws NoSuchUserException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"UserProviderLDAPImpl:setUser()"}, null);
    }

    public void removeUser(String string, String string2) throws NoSuchUserException, JRCustomerException {
        throw new JRCustomerException(630047, (Object[])new String[]{"UserProviderLDAPImpl:removeUser()"}, null);
    }

    public boolean isEnableEdit() {
        return false;
    }
}

