/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import jet.JSvrResource;
import jet.server.jrc.security.ldap.LDAPAttributeUtil;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.LDAPGroupImpl;
import jet.server.jrc.security.ldap.LDAPUserImpl;
import jet.server.jrc.security.ldap.intf.LDAPConnection;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;

public class LDAPConnectionImpl
implements LDAPConnection {
    private DirContext QOIV = null;
    private Hashtable add = null;
    private LDAPEnvironments addElement;
    private LDAPAttributeUtil addSubGroup;
    private boolean addSubGroupDN = false;
    private boolean addUser = true;

    public LDAPConnectionImpl(LDAPEnvironments lDAPEnvironments) {
        this.addElement = lDAPEnvironments;
        this.addSubGroup = new LDAPAttributeUtil(lDAPEnvironments);
        this.add = lDAPEnvironments.getLDAPEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean connect() {
        block9: {
            try {
                InitialDirContext initialDirContext = new InitialDirContext(this.add);
                this.addSubGroupDN = true;
                this.QOIV = initialDirContext;
            }
            catch (Exception exception) {
                try {
                    if (this.addSubGroupDN) break block9;
                    ConnectionCreator connectionCreator = new ConnectionCreator(this, this, "connect LDAP[" + System.currentTimeMillis() + "]");
                    connectionCreator.start();
                    ConnectionCreator connectionCreator2 = connectionCreator;
                    synchronized (connectionCreator2) {
                        this.wait(this.addSubGroup());
                    }
                    if (this.addUser) {
                        if (connectionCreator.isAlive()) {
                            connectionCreator.interrupt();
                        }
                        throw new NamingException("Wrong LDAP server port type!(SSL and plain)");
                    }
                }
                catch (Exception exception2) {
                    ServiceLogger.logError(exception2);
                    this.QOIV = null;
                    return false;
                }
            }
        }
        return this.addSubGroupDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean reconnect(LDAPEnvironments lDAPEnvironments) {
        block10: {
            try {
                this.addElement = lDAPEnvironments;
                this.addSubGroup = new LDAPAttributeUtil(lDAPEnvironments);
                this.add = lDAPEnvironments.getLDAPEnv();
                if (this.QOIV != null) {
                    this.QOIV.close();
                }
                this.addSubGroupDN = false;
                this.addUser = true;
                InitialDirContext initialDirContext = new InitialDirContext(this.add);
                this.addSubGroupDN = true;
                this.QOIV = initialDirContext;
            }
            catch (Exception exception) {
                try {
                    if (this.addSubGroupDN) break block10;
                    ConnectionCreator connectionCreator = new ConnectionCreator(this, this, "connect LDAP[" + System.currentTimeMillis() + "]");
                    connectionCreator.start();
                    ConnectionCreator connectionCreator2 = connectionCreator;
                    synchronized (connectionCreator2) {
                        this.wait(this.addSubGroup());
                    }
                    if (this.addUser) {
                        if (connectionCreator.isAlive()) {
                            connectionCreator.interrupt();
                        }
                        throw new NamingException("Wrong LDAP server port type!(SSL and plain)");
                    }
                }
                catch (Exception exception2) {
                    ServiceLogger.logError(exception2);
                    this.QOIV = null;
                    return false;
                }
            }
        }
        return this.addSubGroupDN;
    }

    public synchronized boolean disconnect() {
        try {
            this.QOIV.close();
            this.QOIV = null;
        }
        catch (NamingException namingException) {
            this.QOIV = null;
            return false;
        }
        return true;
    }

    public synchronized DirContext getLdapContext() {
        if (this.QOIV == null) {
            this.connect();
        }
        String string = this.addSubGroup.getUserDN();
        try {
            this.QOIV.search(string, null);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            this.disconnect();
            this.connect();
        }
        return this.QOIV;
    }

    public synchronized boolean isValidLDAPUser(String string, String string2) {
        boolean bl;
        String string3 = "";
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null || string == null) {
            return false;
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            Object object;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string4 = this.addElement.getProperty("userAN");
            if (string4 == null) {
                return false;
            }
            String string5 = "(&(" + string4 + "=" + string + "))";
            String string6 = this.addSubGroup.getUserDN();
            if (string6 == null) {
                return false;
            }
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string6, string5, searchControls);
            if (!namingEnumeration.hasMore()) {
                return false;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            LDAPAttributeUtil lDAPAttributeUtil = new LDAPAttributeUtil(this.addElement);
            lDAPAttributeUtil.setAttributes(attributes);
            String string7 = lDAPAttributeUtil.getUserPassword();
            if (string7 != null && string2.equalsIgnoreCase("")) {
                return string7.equals("") && string2.equals("");
            }
            String string8 = string4 + "=" + string;
            Hashtable hashtable = (Hashtable)this.add.clone();
            String string9 = this.addSubGroup.getUserDN();
            String string10 = string9 != null && !string9.equals("") ? string8 + "," + this.addElement.getProperty("userDN") : string8;
            String string11 = this.addElement.getProperty("rootEntry");
            if (string11 != null && string11.length() != 0) {
                string10 = string10 + "," + string11;
            }
            hashtable.put("java.naming.security.principal", string10);
            hashtable.put("java.naming.security.credentials", string2);
            String string12 = this.addElement.getProperty("ldapVersion");
            if (string12 != null) {
                hashtable.put("java.naming.ldap.version", string12);
            }
            String string13 = this.addElement.getProperty("url");
            String string14 = this.addElement.getProperty("serverPort");
            if (string13 == null || string14 == null) {
                return false;
            }
            string3 = string3 + string13 + ":" + string14;
            hashtable.put("java.naming.provider.url", string3);
            if (this.addElement.getProperty("isUsingSSL") != null && this.addElement.getProperty("isUsingSSL").equals("true")) {
                hashtable.put("java.naming.security.protocol", "ssl");
                hashtable.put("java.naming.ldap.factory.socket", "jet.server.jrc.security.ldap.JSocketFactory");
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            if (string2 == null || string2.length() == 0) {
                object = new SearchControls();
                ((SearchControls)object).setSearchScope(1);
                initialDirContext.search(string11, "(CN=*)", (SearchControls)object);
            }
            if ((object = this.getLDAPUser(string)) == null) {
                return false;
            }
            namingEnumeration.close();
            bl = true;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            ServiceLogger.logError(nullPointerException, 3);
            return false;
        }
        return bl;
    }

    public synchronized boolean isValidLDAPUserByDN(String string, String string2, String string3) {
        boolean bl;
        ServiceLogger.logDebug(4630087, new Object[]{string, string2}, 4);
        String string4 = "";
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null || string2 == null) {
            return false;
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            Object object;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string5 = this.addElement.getProperty("userAN");
            if (string5 == null) {
                return false;
            }
            String string6 = "(&(" + string5 + "=" + string + "))";
            String string7 = this.addElement.getProperty("userDN");
            if (string2 == null) {
                return false;
            }
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string7, string6, searchControls);
            if (!namingEnumeration.hasMore()) {
                return false;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            LDAPAttributeUtil lDAPAttributeUtil = new LDAPAttributeUtil(this.addElement);
            lDAPAttributeUtil.setAttributes(attributes);
            String string8 = lDAPAttributeUtil.getUserPassword();
            if (string8 != null && string3.equalsIgnoreCase("")) {
                return string8.equals("") && string3.equals("");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string9 = "com.sun.jndi.ldap.LdapCtxFactory";
            hashtable.put("java.naming.factory.initial", string9);
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", string2);
            hashtable.put("java.naming.security.credentials", string3);
            String string10 = this.addElement.getProperty("ldapVersion");
            if (string10 != null) {
                hashtable.put("java.naming.ldap.version", string10);
            }
            String string11 = this.addElement.getProperty("url");
            String string12 = this.addElement.getProperty("serverPort");
            if (string11 == null || string12 == null) {
                return false;
            }
            string4 = string4 + string11 + ":" + string12;
            hashtable.put("java.naming.provider.url", string4);
            if (this.addElement.getProperty("isUsingSSL") != null && this.addElement.getProperty("isUsingSSL").equals("true")) {
                hashtable.put("java.naming.security.protocol", "ssl");
                hashtable.put("java.naming.ldap.factory.socket", "jet.server.jrc.security.ldap.JSocketFactory");
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            if (string3 == null || string3.length() == 0) {
                object = this.addElement.getProperty("rootEntry");
                SearchControls searchControls2 = new SearchControls();
                searchControls2.setSearchScope(1);
                initialDirContext.search((String)object, "(CN=*)", searchControls2);
            }
            if ((object = this.getLDAPUser(string)) == null) {
                return false;
            }
            namingEnumeration.close();
            bl = true;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            ServiceLogger.logError(nullPointerException);
            return false;
        }
        return bl;
    }

    public synchronized LDAPUser getLDAPUser(String string) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            throw new NamingException("Null LDAP context error!");
        }
        String string2 = this.addElement.getProperty("userAN");
        String string3 = this.addElement.getProperty("rootEntry");
        String string4 = this.addSubGroup.getUserDN();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string5 = "(&(" + string2 + "=" + string + "))";
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        LDAPUserImpl lDAPUserImpl = null;
        if (namingEnumeration.hasMore()) {
            String string6;
            lDAPUserImpl = new LDAPUserImpl();
            SearchResult searchResult = namingEnumeration.next();
            if (searchResult.getName().trim().length() == 0) {
                string6 = string4.trim();
            } else {
                string6 = searchResult.getName().trim();
                if (string4.trim() != null && string4.trim().length() != 0) {
                    string6 = string6 + "," + string4.trim();
                }
                if (string3.trim() != null && string3.trim().length() != 0) {
                    string6 = string6 + "," + string3.trim();
                }
            }
            Attributes attributes = searchResult.getAttributes();
            this.addSubGroup.setAttributes(attributes);
            String string7 = this.addSubGroup.getUserName();
            if (string7 == null || string7.length() == 0) {
                namingEnumeration.close();
                return null;
            }
            lDAPUserImpl.setName(string7);
            lDAPUserImpl.setProperties("full_name", this.addSubGroup.getUserFullname());
            lDAPUserImpl.setProperties("email", this.addSubGroup.getUserEmail());
            lDAPUserImpl.setProperties("ldapuser_dn", string6);
            ServiceLogger.logDebug(4630082, new Object[]{string7, string4}, 4);
            ServiceLogger.logDebug(4630083, new Object[]{string6}, 4);
        }
        namingEnumeration.close();
        return lDAPUserImpl;
    }

    public synchronized LDAPUser getLDAPUserByDN(String string) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            throw new NamingException("Null LDAP context error!");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "com.sun.jndi.ldap.LdapCtxFactory";
        hashtable.put("java.naming.factory.initial", string2);
        hashtable.put("java.naming.provider.url", this.addElement.getProperty("url") + ":" + this.addElement.getProperty("serverPort"));
        hashtable.put("java.naming.security.principal", this.addElement.getProperty("directoryManagerDN"));
        hashtable.put("java.naming.security.credentials", this.addElement.getProperty("password"));
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        String string3 = this.addElement.getProperty("userAN");
        String string4 = this.addElement.getProperty("rootEntry");
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string5 = "(" + string3 + "=*)";
        NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string, string5, searchControls);
        LDAPUserImpl lDAPUserImpl = null;
        if (namingEnumeration.hasMore()) {
            String string6;
            lDAPUserImpl = new LDAPUserImpl();
            SearchResult searchResult = namingEnumeration.next();
            if (searchResult.getName().trim().length() == 0) {
                string6 = string.trim();
            } else {
                string6 = searchResult.getName().trim();
                if (string.trim() != null && string.trim().length() != 0) {
                    string6 = string6 + "," + string.trim();
                }
                if (string4.trim() != null && string4.trim().length() != 0) {
                    string6 = string6 + "," + string4.trim();
                }
            }
            Attributes attributes = searchResult.getAttributes();
            this.addSubGroup.setAttributes(attributes);
            String string7 = this.addSubGroup.getUserName();
            if (string7 == null || string7.length() == 0) {
                namingEnumeration.close();
                return null;
            }
            lDAPUserImpl.setName(string7);
            lDAPUserImpl.setProperties("full_name", this.addSubGroup.getUserFullname());
            lDAPUserImpl.setProperties("email", this.addSubGroup.getUserEmail());
            lDAPUserImpl.setProperties("ldapuser_dn", string6);
            ServiceLogger.logDebug(0x46A644, new Object[]{string7, string}, 4);
            ServiceLogger.logDebug(4630085, new Object[]{string6}, 4);
        }
        namingEnumeration.close();
        return lDAPUserImpl;
    }

    public synchronized Hashtable getAllLDAPUsers() throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            throw new NamingException("Null LDAP context error!");
        }
        Hashtable<String, LDAPUserImpl> hashtable = new Hashtable<String, LDAPUserImpl>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string = this.addElement.getProperty("userFilter");
        String string2 = this.addElement.getProperty("userCN");
        String string3 = this.addElement.getProperty("rootEntry");
        String string4 = this.addSubGroup.getUserDN();
        String string5 = string.equalsIgnoreCase("") ? "(&(" + string2 + "=*))" : string;
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        while (namingEnumeration.hasMore()) {
            String string6;
            LDAPUserImpl lDAPUserImpl = new LDAPUserImpl();
            SearchResult searchResult = namingEnumeration.next();
            if (searchResult.getName().trim().length() == 0) {
                string6 = string4.trim();
            } else {
                string6 = searchResult.getName().trim();
                if (string4.trim() != null && string4.trim().length() != 0) {
                    string6 = string6 + "," + string4.trim();
                }
                if (string3.trim() != null && string3.trim().length() != 0) {
                    string6 = string6 + "," + string3.trim();
                }
            }
            this.addSubGroup.setAttributes(searchResult.getAttributes());
            String string7 = this.addSubGroup.getUserName();
            if (string7 == null || string7.length() == 0) continue;
            lDAPUserImpl.setName(string7);
            lDAPUserImpl.setProperties("full_name", this.addSubGroup.getUserFullname());
            lDAPUserImpl.setProperties("email", this.addSubGroup.getUserEmail());
            lDAPUserImpl.setProperties("ldapuser_dn", string6);
            ServiceLogger.logDebug(4630080, new Object[]{string7, string4}, 4);
            ServiceLogger.logDebug(4630081, new Object[]{string6}, 4);
            hashtable.put(string7, lDAPUserImpl);
        }
        namingEnumeration.close();
        return hashtable;
    }

    public synchronized Vector[] getLDAPGroup(String string) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration;
        Vector[] vectorArray;
        block13: {
            vectorArray = new Vector[]{new Vector(), new Vector()};
            DirContext dirContext = this.getLdapContext();
            if (dirContext == null) {
                throw new NamingException("Null LDAP context error!");
            }
            SearchControls searchControls = new SearchControls();
            String string2 = this.addElement.getProperty("rootEntry");
            searchControls.setSearchScope(2);
            String string3 = this.addElement.getProperty("groupCN");
            String string4 = this.addSubGroup.getGroupDN();
            String string5 = "(&(" + string3 + "=" + string + "))";
            namingEnumeration = dirContext.search(string4, string5, searchControls);
            try {
                String string6;
                if (!namingEnumeration.hasMore()) break block13;
                LDAPGroupImpl lDAPGroupImpl = new LDAPGroupImpl();
                SearchResult searchResult = namingEnumeration.next();
                if (searchResult.getName().trim().length() == 0) {
                    string6 = string4.trim();
                } else {
                    string6 = searchResult.getName().trim();
                    if (string4.trim() != null && string4.trim().length() != 0) {
                        string6 = string6 + "," + string4.trim();
                    }
                    if (string2.trim() != null && string2.trim().length() != 0) {
                        string6 = string6 + "," + string2.trim();
                    }
                }
                Attributes attributes = searchResult.getAttributes();
                this.addSubGroup.setAttributes(attributes);
                String string7 = this.addSubGroup.getGroupName();
                if (string7 == null || string7.length() == 0) {
                    return vectorArray;
                }
                lDAPGroupImpl.setName(string7);
                lDAPGroupImpl.setProperties("description", this.addSubGroup.getGroupDescription());
                lDAPGroupImpl.setProperties("group_dn", string6);
                if (this.addSubGroup.hasMembers()) {
                    Object object;
                    Object object2;
                    String[] stringArray;
                    Object object3;
                    Vector[] vectorArray2 = this.QOIV(attributes);
                    Enumeration enumeration = vectorArray2[0].elements();
                    while (enumeration.hasMoreElements()) {
                        object3 = (String[])enumeration.nextElement();
                        stringArray = object3[0];
                        object2 = object3[1];
                        object = null;
                        try {
                            object = this.getLDAPUserByDN((String)object2);
                        }
                        catch (NamingException namingException) {
                            ServiceLogger.logError(namingException);
                        }
                        if (object == null) continue;
                        vectorArray[1].add(object);
                        lDAPGroupImpl.addUser((String)stringArray);
                        lDAPGroupImpl.addUserDN((String)object2);
                    }
                    object3 = vectorArray2[1].elements();
                    while (object3.hasMoreElements()) {
                        stringArray = (String[])object3.nextElement();
                        object2 = stringArray[0];
                        object = stringArray[1];
                        lDAPGroupImpl.addSubGroup((String)object2);
                        lDAPGroupImpl.addSubGroupDN((String)object);
                    }
                }
                vectorArray[0].add(lDAPGroupImpl);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        namingEnumeration.close();
        return vectorArray;
    }

    public synchronized Hashtable getAllLDAPGroups() throws NamingException {
        DirContext dirContext = this.getLdapContext();
        Hashtable<String, LDAPGroupImpl> hashtable = new Hashtable<String, LDAPGroupImpl>();
        if (dirContext == null) {
            throw new NamingException("Null LDAP context error!");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string = this.addElement.getProperty("rootEntry");
        String string2 = this.addElement.getProperty("groupFilter");
        String string3 = this.addElement.getProperty("groupCN");
        String string4 = this.addSubGroup.getGroupDN();
        String string5 = string2.equalsIgnoreCase("") ? "(&(" + string3 + "=*))" : string2;
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string5, searchControls);
        while (namingEnumeration.hasMore()) {
            String string6;
            LDAPGroupImpl lDAPGroupImpl = new LDAPGroupImpl();
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            if (searchResult.getName().trim().length() == 0) {
                string6 = string4.trim();
            } else {
                string6 = searchResult.getName().trim();
                if (string4.trim() != null && string4.trim().length() != 0) {
                    string6 = string6 + "," + string4.trim();
                }
                if (string.trim() != null && string.trim().length() != 0) {
                    string6 = string6 + "," + string.trim();
                }
            }
            this.addSubGroup.setAttributes(attributes);
            String string7 = this.addSubGroup.getGroupName();
            if (string7 == null || string7.length() == 0) continue;
            lDAPGroupImpl.setName(string7);
            lDAPGroupImpl.setProperties("description", this.addSubGroup.getGroupDescription());
            lDAPGroupImpl.setProperties("group_dn", string6);
            if (this.addSubGroup.hasMembers()) {
                Object object;
                Object object2;
                String[] stringArray;
                Object object3;
                Vector[] vectorArray = this.QOIV(attributes);
                Enumeration enumeration = vectorArray[0].elements();
                while (enumeration.hasMoreElements()) {
                    object3 = (String[])enumeration.nextElement();
                    stringArray = object3[0];
                    object2 = object3[1];
                    object = null;
                    try {
                        object = this.getLDAPUserByDN((String)object2);
                    }
                    catch (NamingException namingException) {
                        ServiceLogger.logError(namingException);
                    }
                    if (object == null) continue;
                    lDAPGroupImpl.addUser((String)stringArray);
                    lDAPGroupImpl.addUserDN((String)object2);
                }
                object3 = vectorArray[1].elements();
                while (object3.hasMoreElements()) {
                    stringArray = (String[])object3.nextElement();
                    object2 = stringArray[0];
                    object = stringArray[1];
                    lDAPGroupImpl.addSubGroup((String)object2);
                    lDAPGroupImpl.addSubGroupDN((String)object);
                }
            }
            hashtable.put(string7, lDAPGroupImpl);
        }
        namingEnumeration.close();
        return hashtable;
    }

    private synchronized Vector[] QOIV(Attributes attributes) throws NamingException {
        Vector[] vectorArray;
        Vector<String[]> vector = new Vector<String[]>();
        Vector<String[]> vector2 = new Vector<String[]>();
        String string = this.addElement.getProperty("groupMemeberType");
        Attribute attribute = attributes.get(string);
        this.addSubGroup.setAttributes(attributes);
        if (attribute != null) {
            vectorArray = attribute.getAll();
            while (vectorArray.hasMoreElements()) {
                String[] stringArray;
                String string2;
                String string3 = (String)vectorArray.nextElement();
                if (string3.toUpperCase().indexOf(this.addSubGroup.getUserDN().toUpperCase()) != -1 && (string2 = this.add(string3, false)) != null) {
                    string2 = string2.trim();
                    stringArray = new String[]{string2, string3};
                    vector.addElement(stringArray);
                }
                if (string3.toUpperCase().indexOf(this.addSubGroup.getGroupDN().toUpperCase()) == -1 || (string2 = this.add(string3, true)) == null) continue;
                string2 = string2.trim();
                stringArray = new String[]{string2, string3};
                vector2.addElement(stringArray);
            }
        }
        vectorArray = new Vector[]{vector, vector2};
        return vectorArray;
    }

    private synchronized String add(String string, boolean bl) {
        String string2;
        String string3 = this.addElement.getProperty("url") + ":" + this.addElement.getProperty("serverPort") + "/";
        String string4 = this.addElement.getProperty("groupCN");
        String string5 = this.addElement.getProperty("userAN");
        Properties properties = this.addElement(string);
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return null;
        }
        try {
            if (!bl) {
                string2 = (String)properties.get(string5);
                if (string2 == null) {
                    Attributes attributes = dirContext.getAttributes(string3 + string);
                    string2 = (String)attributes.get(string5).get(0);
                }
            } else {
                string2 = (String)properties.get(string4);
                if (string2 == null) {
                    Attributes attributes = dirContext.getAttributes(string3 + string);
                    string2 = (String)attributes.get(string4).get(0);
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 != null) {
            return string2.trim();
        }
        return null;
    }

    private Properties addElement(String string) {
        Properties properties = new Properties();
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(",");
        if (n != -1) {
            String string2 = null;
            if (string.charAt(n - 1) != '\\') {
                string2 = string.substring(0, n);
                vector.add(string2);
            } else {
                n = string.indexOf(",", n + 1);
                string2 = string.substring(0, n);
                vector.add(string2);
            }
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string3 = (String)vector.elementAt(n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            int n3 = 0;
            String[] stringArray = new String[2];
            while (stringTokenizer.hasMoreElements() && n3 < 2) {
                stringArray[n3] = (String)stringTokenizer.nextElement();
                ++n3;
            }
            properties.put(stringArray[0], stringArray[1]);
            ++n2;
        }
        return properties;
    }

    public synchronized Vector getLDAPUserParentGroupNames(String string) throws NamingException {
        Vector<String> vector = new Vector<String>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string2 = this.addElement.getProperty("groupFilter");
        String string3 = this.addElement.getProperty("groupCN");
        String string4 = this.addElement.getProperty("rootEntry");
        String string5 = this.addElement.getProperty("userAN");
        String[] stringArray = new String[]{string3};
        searchControls.setReturningAttributes(stringArray);
        String string6 = this.addElement.getProperty("groupMemeberType");
        String string7 = this.addSubGroup.getGroupDN();
        String string8 = this.addSubGroup.getUserDN();
        String string9 = "(" + string6 + "=" + string5 + "=" + string + "," + string8 + "," + string4 + ")";
        String string10 = string2.equalsIgnoreCase("") ? "(&(" + string3 + "=*)" + string9 + ")" : "(&" + string2 + string9 + ")";
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return vector;
        }
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string7, string10, searchControls);
        while (namingEnumeration != null && namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            this.addSubGroup.setAttributes(attributes);
            String string11 = this.addSubGroup.getGroupName();
            vector.add(string11);
        }
        if (namingEnumeration != null) {
            namingEnumeration.close();
        }
        return vector;
    }

    public String testFilter(String string) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return "LDAP connection is null!";
        }
        String string2 = this.addElement.getProperty("userAN");
        String string3 = this.addSubGroup.getUserDN();
        String string4 = this.addElement.getProperty("userFilter");
        String string5 = "(" + string2 + "=*)";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string6 = "(&" + string + string5 + string4 + ")";
        String[] stringArray = new String[]{};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setCountLimit(1L);
        searchControls.setTimeLimit(10000);
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string3, string6, searchControls);
        int n = 0;
        if (namingEnumeration != null && namingEnumeration.hasMore()) {
            ++n;
            namingEnumeration.close();
        }
        if (n == 1) {
            return JSvrResource.getMessage("SECURITY_ERR_55_LDAP_ROLEMAP_TEST_SUCESS");
        }
        return JSvrResource.getMessage("SECURITY_ERR_56_LDAP_ROLEMAP_TEST_NOUSER");
    }

    public boolean isInFilter(String string, String string2) throws NamingException {
        DirContext dirContext = this.getLdapContext();
        if (dirContext == null) {
            return false;
        }
        String string3 = this.addElement.getProperty("userAN");
        String string4 = this.addSubGroup.getUserDN();
        String string5 = this.addElement.getProperty("userFilter");
        String string6 = "(" + string3 + "=" + string2 + ")";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string7 = "(&" + string6 + string + string5 + ")";
        String[] stringArray = new String[]{};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setCountLimit(1L);
        searchControls.setTimeLimit(10000);
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(string4, string7, searchControls);
        int n = 0;
        if (namingEnumeration != null && namingEnumeration.hasMore()) {
            ++n;
            namingEnumeration.close();
        }
        return n == 1;
    }

    private int addSubGroup() {
        int n;
        String string = this.addElement.getProperty("socketTime");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            n = 10;
        }
        return n * 1000;
    }

    static Hashtable access$000(LDAPConnectionImpl lDAPConnectionImpl) {
        return lDAPConnectionImpl.add;
    }

    static boolean access$102(LDAPConnectionImpl lDAPConnectionImpl, boolean bl) {
        lDAPConnectionImpl.addSubGroupDN = bl;
        return lDAPConnectionImpl.addSubGroupDN;
    }

    static DirContext access$202(LDAPConnectionImpl lDAPConnectionImpl, DirContext dirContext) {
        lDAPConnectionImpl.QOIV = dirContext;
        return lDAPConnectionImpl.QOIV;
    }

    static boolean access$302(LDAPConnectionImpl lDAPConnectionImpl, boolean bl) {
        lDAPConnectionImpl.addUser = bl;
        return lDAPConnectionImpl.addUser;
    }

    class ConnectionCreator
    extends Thread {
        LDAPConnectionImpl QOIV;
        private final LDAPConnectionImpl this$0;

        public ConnectionCreator(LDAPConnectionImpl lDAPConnectionImpl, LDAPConnectionImpl lDAPConnectionImpl2, String string) {
            this.this$0 = lDAPConnectionImpl;
            super(string);
            this.QOIV = lDAPConnectionImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    InitialDirContext initialDirContext = new InitialDirContext(LDAPConnectionImpl.access$000(this.this$0));
                    LDAPConnectionImpl.access$102(this.this$0, true);
                    LDAPConnectionImpl.access$202(this.this$0, initialDirContext);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                    LDAPConnectionImpl.access$202(this.this$0, null);
                    LDAPConnectionImpl.access$102(this.this$0, false);
                    Object var3_4 = null;
                    LDAPConnectionImpl.access$302(this.this$0, false);
                    return;
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                LDAPConnectionImpl.access$302(this.this$0, false);
                throw throwable;
            }
            LDAPConnectionImpl.access$302(this.this$0, false);
        }
    }
}

