/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import jet.server.jrc.security.ldap.LDAPData;

public class LDAPEnvironments {
    private Hashtable QOIV = new Hashtable();
    private Hashtable append = new Hashtable();
    boolean buildEnvironments = true;

    public LDAPEnvironments() {
        this.QOIV.clear();
        this.QOIV = (Hashtable)LDAPData.getLDAPProperties().clone();
        this.QOIV();
        this.buildEnvironments();
    }

    public LDAPEnvironments(Hashtable hashtable) {
        this.buildEnvironments = false;
        this.QOIV.clear();
        this.QOIV = hashtable;
        this.QOIV();
        this.buildEnvironments();
    }

    public void refresh() {
        if (this.buildEnvironments) {
            this.append.clear();
            this.QOIV.clear();
            this.QOIV = (Hashtable)LDAPData.getLDAPProperties().clone();
        }
        this.QOIV();
        this.buildEnvironments();
    }

    public void refresh(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.QOIV.clear();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.QOIV.put(string, hashtable.get(string));
        }
        this.QOIV();
        this.buildEnvironments();
    }

    public Hashtable getLDAPEnv() {
        return this.append;
    }

    private void QOIV() {
        this.append.clear();
        this.append.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String string = (String)this.QOIV.get("ldapVersion");
        if (string != null) {
            this.append.put("java.naming.ldap.version", string);
        }
        this.append.put("java.naming.referral", "follow");
        this.append.put("java.naming.security.authentication", "simple");
    }

    public void buildEnvironments() {
        this.QOIV();
        Enumeration enumeration = this.QOIV.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.append(string);
            String string3 = (String)this.QOIV.get(string);
            if (string.equals("url")) {
                String string4 = (String)this.QOIV.get("rootEntry");
                if (string4 == null) {
                    string4 = "";
                }
                string3 = string3 + ":" + this.QOIV.get("serverPort") + "/" + string4;
            }
            if (string.equals("isUsingSSL")) {
                if (string3 != null && string3.trim().equals("true")) {
                    string3 = "ssl";
                    this.append.put("java.naming.ldap.factory.socket", "jet.server.jrc.security.ldap.JSocketFactory");
                } else {
                    string2 = null;
                }
            }
            if (string2 == null) continue;
            this.append.put(string2, string3);
        }
    }

    private String append(String string) {
        if (string.equals("url")) {
            return "java.naming.provider.url";
        }
        if (string.equals("directoryManagerDN")) {
            return "java.naming.security.principal";
        }
        if (string.equals("password")) {
            return "java.naming.security.credentials";
        }
        if (string.equals("isUsingSSL")) {
            return "java.naming.security.protocol";
        }
        return null;
    }

    public Hashtable getLDAPProperties() {
        return this.QOIV;
    }

    public boolean editLDAPProperties(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        if (this.buildEnvironments) {
            if (LDAPData.editLDAPProperties(string, string2)) {
                this.QOIV.put(string, string2);
                return true;
            }
        } else {
            this.QOIV.put(string, string2);
            return true;
        }
        return false;
    }

    public boolean replaceProperties(Hashtable hashtable) {
        if (this.buildEnvironments) {
            if (LDAPData.replaceProperties(hashtable)) {
                this.refresh();
                return true;
            }
            return false;
        }
        this.refresh(hashtable);
        return false;
    }

    public String getProperty(String string) {
        return (String)this.QOIV.get(string);
    }
}

