/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.version;

import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.db.version.CatalogVersionRecord;
import jet.server.db.version.DynamicResultDetailRecord;
import jet.server.db.version.DynamicResultDetailTable;
import jet.server.db.version.DynamicResultVersionTableImpl;
import jet.server.db.version.ReportVersionRecord;
import jet.server.db.version.ResultDetailRecord;
import jet.server.db.version.ResultDetailTable;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.db.version.ResultVersionRecord;
import jet.server.db.version.ResultVersionTableImpl;
import jet.server.intf.jrs.DataService;
import jet.server.intf.resource.CatalogInfo;
import jet.server.intf.resource.ReportInfo;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.ResultInfo;
import jet.server.intf.version.CatalogVersionTable;
import jet.server.intf.version.DynamicResultVersionTable;
import jet.server.intf.version.ReportVersionTable;
import jet.server.intf.version.ResultVersionTableNew;
import jet.server.intf.version.VersionController;
import jet.server.jrc.JRDataService;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.jrc.version.VersionFolderManager;
import jet.server.log.ServiceLogger;
import jet.util.IntKeyHashtable;

public class VersionControllerImpl
implements VersionController {
    JRDataService QOIV = null;
    JRSchedulingService add = null;
    private VersionFolderManager addRecord = null;
    private String append = null;

    public VersionControllerImpl(DataService dataService) {
        this.QOIV = (JRDataService)dataService;
        this.append = System.getProperty("history_dir") != null ? System.getProperty("history_dir") : ServerEnv.homePath + "history";
        String string = this.append = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : this.append;
        if (!this.append.endsWith(File.separator)) {
            this.append = this.append + File.separator;
        }
    }

    public int addVersion(ResourceInfo resourceInfo, int n, String string) {
        int n2 = -1;
        if (resourceInfo == null) {
            return -1;
        }
        switch (resourceInfo.getResourceType()) {
            case 1: {
                CatalogInfoImpl catalogInfoImpl = (CatalogInfoImpl)resourceInfo;
                n2 = this.add(catalogInfoImpl, n, string);
                break;
            }
            case 2: {
                ReportInfo reportInfo = (ReportInfo)resourceInfo;
                n2 = this.append(reportInfo, n, string);
                break;
            }
            case 3: {
                ResultInfoImpl resultInfoImpl = (ResultInfoImpl)resourceInfo;
                n2 = this.clearMem(resultInfoImpl, n, string);
                break;
            }
        }
        return n2;
    }

    public void updateVersion(ResourceInfo resourceInfo, int n, int n2, String string) {
        switch (resourceInfo.getResourceType()) {
            case 1: {
                CatalogInfoImpl catalogInfoImpl = (CatalogInfoImpl)resourceInfo;
                this.addRecord(catalogInfoImpl, n, n2, string);
                break;
            }
            case 2: {
                ReportInfo reportInfo = (ReportInfo)resourceInfo;
                this.changeVersionFolderAmount(reportInfo, n, n2, string);
                break;
            }
            case 3: {
                ResultInfoImpl resultInfoImpl = (ResultInfoImpl)resourceInfo;
                this.delEarliestVersion(resultInfoImpl, n, n2, string);
                break;
            }
        }
    }

    public ResourceInfo getVersion(int n, int n2, int n3) {
        ResourceInfo resourceInfo = null;
        switch (n3) {
            case 1: {
                resourceInfo = this.getCatalogVersion(n, n2);
                break;
            }
            case 2: {
                resourceInfo = this.getReportVersion(n, n2);
                break;
            }
            case 3: {
                resourceInfo = this.getResultVersion(n, n2);
                break;
            }
        }
        return resourceInfo;
    }

    public ResourceInfo getVersionByID(int n, int n2) {
        ResourceInfo resourceInfo = null;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                resourceInfo = this.delRecord(n);
                break;
            }
        }
        return resourceInfo;
    }

    public ResourceInfo getLatestVersion(int n, int n2) {
        ResourceInfo resourceInfo = null;
        switch (n2) {
            case 1: {
                resourceInfo = this.delRecords(n);
                break;
            }
            case 2: {
                resourceInfo = this.delVersionArchiveFolder(n);
                break;
            }
            case 3: {
                resourceInfo = this.deleteRecord(n);
                break;
            }
        }
        return resourceInfo;
    }

    public IntKeyHashtable getVersions(int n, int n2) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        switch (n2) {
            case 1: {
                intKeyHashtable = this.getCatalogVersions(n);
                break;
            }
            case 2: {
                intKeyHashtable = this.getReportVersions(n);
                break;
            }
            case 3: {
                intKeyHashtable = this.getResultVersions(n);
                break;
            }
        }
        return intKeyHashtable;
    }

    public boolean removeVersion(int n, int n2, int n3) {
        boolean bl = false;
        switch (n3) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
                try {
                    CatalogInfo catalogInfo = (CatalogInfo)this.getVersion(n, n2, 1);
                    this.addRecord.delVersionArchive(catalogInfo.getCatalog());
                    catalogVersionTable.delRecord(n2, n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
                try {
                    ReportInfo reportInfo = (ReportInfo)this.getVersion(n, n2, 2);
                    this.addRecord.delVersionArchive(reportInfo.getReportFile());
                    reportVersionTable.delRecord(n2, n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 3: {
                ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
                try {
                    Enumeration enumeration;
                    Hashtable hashtable;
                    ResultInfo resultInfo = (ResultInfo)this.getVersion(n, n2, 3);
                    String string = resultInfo.getResultFile();
                    if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        string = ((ResultDetailedInfo)hashtable.get(string2)).getResult();
                    }
                    this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                    resultVersionTableNew.delRecord(n2, n);
                    this.QOIV(resultInfo);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    public boolean removeVersionByID(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (n >= -1) break;
                DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
                try {
                    Enumeration enumeration;
                    Hashtable hashtable;
                    ResultInfo resultInfo = (ResultInfo)this.getVersionByID(n, n2);
                    if (resultInfo == null) break;
                    String string = resultInfo.getResultFile();
                    if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        string = ((ResultDetailedInfo)hashtable.get(string2)).getResult();
                    }
                    this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                    dynamicResultVersionTable.deleteRecord(resultInfo.getName(), resultInfo.getVersionNumber());
                    this.QOIV(resultInfo);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    public boolean removeVersions(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
                try {
                    Vector vector = this.getVersions(n, 1).elements();
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        CatalogInfo catalogInfo = (CatalogInfo)vector.elementAt(n3);
                        this.addRecord.delVersionArchive(catalogInfo.getCatalog());
                        ++n3;
                    }
                    catalogVersionTable.delRecords(n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
                try {
                    Vector vector = this.getVersions(n, 2).elements();
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        ReportInfo reportInfo = (ReportInfo)vector.elementAt(n4);
                        this.addRecord.delVersionArchive(reportInfo.getReportFile());
                        ++n4;
                    }
                    reportVersionTable.delRecords(n);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
            case 3: {
                ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
                try {
                    Object object;
                    Vector vector = this.getVersions(n, 3).elements();
                    int n5 = 0;
                    while (n5 < vector.size()) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        ResultInfo resultInfo = (ResultInfo)vector.elementAt(n5);
                        object = resultInfo.getResultFile();
                        if ((object == null || ((String)object).trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            object = ((ResultDetailedInfo)hashtable.get(string)).getResult();
                        }
                        this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), (String)object);
                        ++n5;
                    }
                    if (n < -1) {
                        this.QOIV.getDynamicResultVersionTable().deleteRecords(this.QOIV.getResourceMapTable().getResource(n));
                    } else {
                        resultVersionTableNew.delRecords(n);
                    }
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        object = (ResultInfo)vector.elementAt(n6);
                        this.QOIV((ResultInfo)object);
                        ++n6;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 6);
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    private void QOIV(ResultInfo resultInfo) {
        if (resultInfo.getParamFile() == null || resultInfo.getParamFile().trim().length() == 0) {
            return;
        }
        try {
            ParameterFileManager.getInstance().delete(resultInfo.getParamFile());
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
    }

    public boolean adjustVersions(int n, int n2, int n3) {
        int n4 = 0;
        switch (n2) {
            case 1: {
                CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
                n4 = catalogVersionTable.getVersionAmount(n);
                while (n4 > n3) {
                    CatalogInfo catalogInfo = (CatalogInfo)this.delVersionArchive(n);
                    this.addRecord.delVersionArchive(catalogInfo.getCatalog());
                    catalogVersionTable.delEarliestVersion(n);
                    --n4;
                }
                break;
            }
            case 2: {
                ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
                n4 = reportVersionTable.getVersionAmount(n);
                while (n4 > n3) {
                    ReportInfo reportInfo = (ReportInfo)this.delete(n);
                    this.addRecord.delVersionArchive(reportInfo.getReportFile());
                    reportVersionTable.delEarliestVersion(n);
                    --n4;
                }
                break;
            }
            case 3: {
                if (n < -1) {
                    String string = this.QOIV.getResourceMapTable().getResource(n);
                    DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
                    n4 = dynamicResultVersionTable.getVersionAmount(string);
                    while (n4 > n3) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        ResultInfo resultInfo = (ResultInfo)this.elements(n);
                        String string2 = resultInfo.getResultFile();
                        if ((string2 == null || string2.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            string2 = ((ResultDetailedInfo)hashtable.get(string3)).getResult();
                        }
                        this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string2);
                        dynamicResultVersionTable.delEarliestVersion(string);
                        --n4;
                    }
                } else {
                    ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
                    n4 = resultVersionTableNew.getVersionAmount(n);
                    while (n4 > n3) {
                        Enumeration enumeration;
                        Hashtable hashtable;
                        ResultInfo resultInfo = (ResultInfo)this.elements(n);
                        String string = resultInfo.getResultFile();
                        if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            string = ((ResultDetailedInfo)hashtable.get(string4)).getResult();
                        }
                        this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                        resultVersionTableNew.delEarliestVersion(n);
                        --n4;
                    }
                }
                break;
            }
        }
        return false;
    }

    private int add(CatalogInfo catalogInfo, int n, String string) {
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        int n2 = -1;
        try {
            n2 = catalogVersionTable.addRecord("", n, string, System.currentTimeMillis(), "", 0L, this.getFileWithoutHistDir(catalogInfo.getCatalog()));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return n2;
    }

    private void addRecord(CatalogInfo catalogInfo, int n, int n2, String string) {
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        CatalogInfo catalogInfo2 = (CatalogInfo)this.getCatalogVersion(n, n2);
        if (!catalogInfo2.getCatalog().trim().equalsIgnoreCase(catalogInfo.getCatalog().trim())) {
            this.addRecord.delVersionArchive(catalogInfo2.getCatalog());
        }
        CatalogVersionRecord catalogVersionRecord = new CatalogVersionRecord(n2, catalogInfo.getName(), n, catalogInfo.getCreator(), catalogInfo.getCreatedTime(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(catalogInfo.getCatalog()));
        catalogVersionTable.updateRecord(catalogVersionRecord);
    }

    private int append(ReportInfo reportInfo, int n, String string) {
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        int n2 = -1;
        try {
            n2 = reportVersionTable.addRecord(reportInfo.getName(), n, string, System.currentTimeMillis(), "", 0L, this.getFileWithoutHistDir(reportInfo.getReportFile()));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return n2;
    }

    private void changeVersionFolderAmount(ReportInfo reportInfo, int n, int n2, String string) {
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        ReportInfo reportInfo2 = (ReportInfo)this.getReportVersion(n, n2);
        if (!reportInfo2.getReportFile().trim().equalsIgnoreCase(reportInfo.getReportFile().trim())) {
            this.addRecord.delVersionArchive(reportInfo2.getReportFile());
        }
        ReportVersionRecord reportVersionRecord = new ReportVersionRecord(n2, reportInfo.getName(), n, reportInfo.getCreator(), reportInfo.getCreatedTime(), string, System.currentTimeMillis(), this.getFileWithoutHistDir(reportInfo.getReportFile()));
        reportVersionTable.updateRecord(reportVersionRecord);
    }

    private int clearMem(ResultInfo resultInfo, int n, String string) {
        if (n == -1) {
            return this.currentTimeMillis(resultInfo, string);
        }
        ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
        int n2 = -1;
        try {
            long l = 0L;
            if (resultInfo.getExpireationTime() != null) {
                l = resultInfo.getExpireationTime().getTime();
            }
            n2 = resultVersionTableNew.addRecord(resultInfo.getName(), n, string, System.currentTimeMillis(), "", 0L, resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), l, resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getSpecifiedFolder(), resultInfo.getReportAmount());
            Hashtable hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable != null && hashtable.size() > 0) {
                ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string2);
                    String string3 = resultDetailedInfo.getResult();
                    if (string3 == null) continue;
                    resultDetailTable.addRecord(n, n2, string2, this.getDisplayName(resultDetailedInfo, string2), string3, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return n2;
    }

    private String getDisplayName(ResultDetailedInfo resultDetailedInfo, String string) {
        String string2 = resultDetailedInfo.getReportDisplayname();
        if (string2 == null && !string.equalsIgnoreCase("jrs.rst_result") && !string.equalsIgnoreCase("jrs.rsd_result")) {
            string2 = string;
        }
        return string2;
    }

    private int currentTimeMillis(ResultInfo resultInfo, String string) {
        DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
        int n = -1;
        long l = 0L;
        if (resultInfo.getExpireationTime() != null) {
            l = resultInfo.getExpireationTime().getTime();
        }
        n = dynamicResultVersionTable.addRecord(resultInfo.getName(), string, System.currentTimeMillis(), resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), l, resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getReportAmount());
        Hashtable hashtable = resultInfo.getSheetsResultDetails();
        if (hashtable != null && hashtable.size() > 0) {
            DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string2);
                String string3 = resultDetailedInfo.getResult();
                if (string3 == null) continue;
                try {
                    dynamicResultDetailTable.addRecord(resultInfo.getName(), n, string2, this.getDisplayName(resultDetailedInfo, string2), string3, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException.getMessage());
                }
            }
        }
        return n;
    }

    private void delEarliestVersion(ResultInfo resultInfo, int n, int n2, String string) {
        block10: {
            ResultInfo resultInfo2 = (ResultInfo)this.getResultVersion(n, n2);
            if (!resultInfo2.getResultFile().trim().equalsIgnoreCase(resultInfo.getResultFile().trim())) {
                this.addRecord.delVersionArchive(resultInfo2.getResultFile());
            }
            ResultVersionRecord resultVersionRecord = new ResultVersionRecord(n2, resultInfo.getName(), n, resultInfo.getCreator(), resultInfo.getCreatedTime(), string, System.currentTimeMillis(), resultInfo.getCatalogVerNum(), resultInfo.getCatalogResourceId(), resultInfo.getReportVerNum(), resultInfo.getReportResourceId(), resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getResultFormats(), resultInfo.getLaunchType(), resultInfo.getTaskId(), resultInfo.getExpireationTime().getTime(), resultInfo.getExpire(), resultInfo.getExpireationMethod(), resultInfo.getSpecifiedFolder());
            resultVersionRecord.setReportAmount(resultInfo.getReportAmount());
            if (n >= 0) {
                try {
                    ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
                    resultVersionTableNew.updateRecord(resultVersionRecord);
                    Hashtable hashtable = resultInfo.getSheetsResultDetails();
                    if (hashtable == null || hashtable.size() <= 0) break block10;
                    ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
                    resultDetailTable.delRecord(n2, n);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string2);
                        String string3 = resultDetailedInfo.getResult();
                        if (string3 == null) continue;
                        resultDetailTable.addRecord(n, n2, string2, this.getDisplayName(resultDetailedInfo, string2), string3, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            } else {
                DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
                dynamicResultVersionTable.updateRecord(resultVersionRecord);
                Hashtable hashtable = resultInfo.getSheetsResultDetails();
                if (hashtable != null && hashtable.size() > 0) {
                    DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
                    dynamicResultDetailTable.delRecord(resultInfo.getName(), n2);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string4);
                        String string5 = resultDetailedInfo.getResult();
                        if (string5 == null) continue;
                        try {
                            dynamicResultDetailTable.addRecord(resultInfo.getName(), n2, string4, this.getDisplayName(resultDetailedInfo, string4), string5, resultDetailedInfo.getPlsResultBits(), resultDetailedInfo.getSecConstraintBits());
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException.getMessage());
                        }
                    }
                }
            }
        }
    }

    private ResourceInfo getCatalogVersion(int n, int n2) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getRecord(n2, n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.get(catalogVersionRecord);
        }
        return catalogInfo;
    }

    private ResourceInfo getReportVersion(int n, int n2) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getRecord(n2, n);
        if (reportVersionRecord != null) {
            reportInfo = this.equalsIgnoreCase(reportVersionRecord);
        }
        return reportInfo;
    }

    private ResourceInfo getResultVersion(int n, int n2) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getRecord(this.QOIV.getResourceMapTable().getResource(n), n2);
            resultInfo = this.endsWith(resultVersionRecord);
            resultInfo = this.elementAt(resultInfo, dynamicResultVersionTable);
        } else {
            ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
            ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getRecord(n2, n);
            resultInfo = this.endsWith(resultVersionRecord);
            resultInfo = this.deleteRecords(resultInfo, resultVersionTableNew);
        }
        return resultInfo;
    }

    private ResourceInfo delRecord(int n) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getRecordByID(n);
            if (resultVersionRecord != null) {
                resultInfo = this.endsWith(resultVersionRecord);
                resultInfo = this.elementAt(resultInfo, dynamicResultVersionTable);
            }
        } else {
            ResultVersionRecord resultVersionRecord = new ResultVersionRecord();
        }
        return resultInfo;
    }

    public int getDynamicResultVersionId(String string, int n) {
        int n2 = -1;
        DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
        n2 = dynamicResultVersionTable.getVersionRecordId(string, n);
        return n2;
    }

    private ResourceInfo delRecords(int n) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getLatestVerRec(n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.get(catalogVersionRecord);
            return catalogInfo;
        }
        return null;
    }

    private ResourceInfo delVersionArchive(int n) {
        CatalogInfo catalogInfo = new CatalogInfoImpl();
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)catalogVersionTable.getEarliestVerRec(n);
        if (catalogVersionRecord != null) {
            catalogInfo = this.get(catalogVersionRecord);
            return catalogInfo;
        }
        return null;
    }

    private ResourceInfo delVersionArchiveFolder(int n) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getLatestVerRec(n);
        if (reportVersionRecord != null) {
            reportInfo = this.equalsIgnoreCase(reportVersionRecord);
            return reportInfo;
        }
        return null;
    }

    private ResourceInfo delete(int n) {
        ReportInfo reportInfo = new ReportInfoImpl();
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)reportVersionTable.getEarliestVerRec(n);
        if (reportVersionRecord != null) {
            reportInfo = this.equalsIgnoreCase(reportVersionRecord);
            return reportInfo;
        }
        return null;
    }

    private ResourceInfo deleteRecord(int n) {
        ResultInfo resultInfo = new ResultInfoImpl();
        ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
        ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getLatestVerRec(n);
        if (resultVersionRecord != null) {
            resultInfo = this.endsWith(resultVersionRecord);
            resultInfo = this.deleteRecords(resultInfo, resultVersionTableNew);
            return resultInfo;
        }
        return null;
    }

    private ResultInfo deleteRecords(ResultInfo resultInfo, ResultVersionTableNew resultVersionTableNew) {
        Vector vector = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable().getResultFiles(resultInfo.getResID(), resultInfo.getVersionNumber());
        if (vector != null && vector.size() > 0) {
            Hashtable<String, ResultDetailRecord> hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable == null) {
                hashtable = new Hashtable<String, ResultDetailRecord>();
            }
            int n = 0;
            while (n < vector.size()) {
                ResultDetailRecord resultDetailRecord = (ResultDetailRecord)vector.elementAt(n);
                String string = resultDetailRecord.getReport();
                hashtable.put(string, resultDetailRecord);
                ++n;
            }
            resultInfo.setSheetsResultDetails(hashtable);
        }
        return resultInfo;
    }

    private ResultInfo elementAt(ResultInfo resultInfo, DynamicResultVersionTable dynamicResultVersionTable) {
        Vector vector = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable().getResultFiles(resultInfo.getName(), resultInfo.getVersionNumber());
        if (vector != null && vector.size() > 0) {
            Hashtable<String, DynamicResultDetailRecord> hashtable = resultInfo.getSheetsResultDetails();
            if (hashtable == null) {
                hashtable = new Hashtable<String, DynamicResultDetailRecord>();
            }
            int n = 0;
            while (n < vector.size()) {
                DynamicResultDetailRecord dynamicResultDetailRecord = (DynamicResultDetailRecord)vector.elementAt(n);
                String string = dynamicResultDetailRecord.getReport();
                hashtable.put(string, dynamicResultDetailRecord);
                ++n;
            }
            resultInfo.setSheetsResultDetails(hashtable);
        }
        return resultInfo;
    }

    private ResourceInfo elements(int n) {
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
            ResultVersionRecord resultVersionRecord = dynamicResultVersionTable.getEarliestVerRec(this.QOIV.getResourceMapTable().getResource(n));
            if (resultVersionRecord != null) {
                resultInfo = this.endsWith(resultVersionRecord);
                resultInfo = this.elementAt(resultInfo, dynamicResultVersionTable);
            }
        } else {
            ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
            ResultVersionRecord resultVersionRecord = (ResultVersionRecord)resultVersionTableNew.getEarliestVerRec(n);
            if (resultVersionRecord != null) {
                resultInfo = this.endsWith(resultVersionRecord);
                resultInfo = this.deleteRecords(resultInfo, resultVersionTableNew);
            }
        }
        return resultInfo;
    }

    private IntKeyHashtable getCatalogVersions(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        CatalogVersionTable catalogVersionTable = this.QOIV.getCatalogVersionTable();
        try {
            vector = catalogVersionTable.getAllRecords(n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            CatalogVersionRecord catalogVersionRecord = (CatalogVersionRecord)vector.elementAt(n2);
            CatalogInfo catalogInfo = this.get(catalogVersionRecord);
            intKeyHashtable.put(catalogInfo.getVersionNumber(), (Object)catalogInfo);
            ++n2;
        }
        return intKeyHashtable;
    }

    private IntKeyHashtable getReportVersions(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        ReportInfo reportInfo = null;
        ReportVersionTable reportVersionTable = this.QOIV.getReportVersionTable();
        try {
            vector = reportVersionTable.getAllRecords(n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            ReportVersionRecord reportVersionRecord = (ReportVersionRecord)vector.elementAt(n2);
            if (reportVersionRecord != null) {
                reportInfo = this.equalsIgnoreCase(reportVersionRecord);
                intKeyHashtable.put(reportInfo.getVersionNumber(), (Object)reportInfo);
            }
            ++n2;
        }
        return intKeyHashtable;
    }

    private IntKeyHashtable getResultVersions(int n) {
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector vector = null;
        ResultInfo resultInfo = null;
        if (n < -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
            String string = this.QOIV.getResourceMapTable().getResource(n);
            vector = dynamicResultVersionTable.getAllRecords(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(n2);
                resultInfo = this.endsWith(resultVersionRecord);
                resultInfo = this.elementAt(resultInfo, dynamicResultVersionTable);
                intKeyHashtable.put(resultInfo.getVersionNumber(), (Object)resultInfo);
                ++n2;
            }
        } else {
            ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
            try {
                vector = resultVersionTableNew.getAllRecords(n);
                int n3 = 0;
                while (n3 < vector.size()) {
                    ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(n3);
                    resultInfo = this.endsWith(resultVersionRecord);
                    resultInfo = this.deleteRecords(resultInfo, resultVersionTableNew);
                    intKeyHashtable.put(resultInfo.getVersionNumber(), (Object)resultInfo);
                    ++n3;
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return intKeyHashtable;
    }

    public void setVersionFolderManager(String string) {
        this.addRecord = new VersionFolderManager(string);
    }

    public VersionFolderManager getVersionFolderManager() {
        return this.addRecord;
    }

    public void chgVerFldNum(int n) {
        this.addRecord.changeVersionFolderAmount(n);
    }

    public String getArchivePath(String string) {
        return this.addRecord.getArchivePath(string);
    }

    public void setSchedulingService(JRSchedulingService jRSchedulingService) {
        this.add = jRSchedulingService;
    }

    public boolean hasResultWithTaskID(String string) {
        return this.QOIV.getResultVersionTableNew().hasResultWithTaskID(string);
    }

    public void clearMem() {
        this.addRecord.clearMem();
        this.addRecord = null;
        this.add = null;
    }

    public String getFileWithHistory(String string) {
        String string2 = string;
        string2 = this.append + string2;
        return string2;
    }

    public String getFileWithoutHistDir(String string) {
        String string2 = string;
        int n = this.append.length();
        if (string2.startsWith(this.append)) {
            string2 = string2.substring(n);
        }
        return string2;
    }

    public void removeResultsByCatalog(int n) {
        DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
        Vector vector = null;
        Object var4_4 = null;
        vector = dynamicResultVersionTable.getRecordsByCatalog(n);
        if (vector != null && vector.size() != 0) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(n2);
                this.addRecord.delVersionArchive(this.getFileWithHistory(resultVersionRecord.getResultFile()));
                dynamicResultVersionTable.deleteRecord(resultVersionRecord.getVersionName(), resultVersionRecord.getVersionID());
                ++n2;
            }
        }
    }

    public Vector getResultByReport(int n) {
        Vector<ResultInfo> vector = new Vector<ResultInfo>();
        ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
        Vector vector2 = resultVersionTableNew.getRecordsByReport(n);
        ResultInfo resultInfo = null;
        if (vector2 != null && vector2.size() != 0) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector2.elementAt(n2);
                resultInfo = this.endsWith(resultVersionRecord);
                vector.add(resultInfo);
                ++n2;
            }
        }
        return vector;
    }

    public Vector getResultByCatalog(int n) {
        Vector<ResultInfo> vector = new Vector<ResultInfo>();
        ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
        Vector vector2 = resultVersionTableNew.getRecordsByCatalog(n);
        ResultInfo resultInfo = null;
        if (vector2 != null && vector2.size() != 0) {
            int n2 = 0;
            while (n2 < vector2.size()) {
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector2.elementAt(n2);
                resultInfo = this.endsWith(resultVersionRecord);
                vector.add(resultInfo);
                ++n2;
            }
        }
        return vector;
    }

    public void expireDynamicResultDelete() {
        DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
        Vector vector = dynamicResultVersionTable.getExpiredVersions();
        if (vector != null && vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                Enumeration enumeration;
                Hashtable hashtable;
                ResultVersionRecord resultVersionRecord = (ResultVersionRecord)vector.elementAt(n);
                ResultInfo resultInfo = this.endsWith(resultVersionRecord);
                String string = resultInfo.getResultFile();
                if ((string == null || string.trim().length() == 0) && (hashtable = resultInfo.getSheetsResultDetails()) != null && (enumeration = hashtable.keys()).hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    string = ((ResultDetailedInfo)hashtable.get(string2)).getResult();
                }
                this.addRecord.delVersionArchiveFolder(resultInfo.getSpecifiedFolder(), string);
                this.QOIV(resultInfo);
                dynamicResultVersionTable.deleteRecord(resultVersionRecord.getReportName(), resultVersionRecord.getVersionID());
                ++n;
            }
        }
    }

    private ResultInfo endsWith(ResultVersionRecord resultVersionRecord) {
        if (resultVersionRecord == null) {
            return null;
        }
        ResultInfoImpl resultInfoImpl = new ResultInfoImpl();
        resultInfoImpl.setVersionNumber(resultVersionRecord.getVersionID());
        resultInfoImpl.setName(resultVersionRecord.getVersionName());
        resultInfoImpl.setCreator(resultVersionRecord.getCreator());
        resultInfoImpl.setCreatedTime(resultVersionRecord.getCreatedTime());
        resultInfoImpl.setCatalogVerNum(resultVersionRecord.getCatalogVerNum());
        resultInfoImpl.setCatalogReourceId(resultVersionRecord.getCatalogResNum());
        resultInfoImpl.setReportVerNum(resultVersionRecord.getReportVerNum());
        resultInfoImpl.setReportResourceId(resultVersionRecord.getReportResNum());
        resultInfoImpl.setParamFile(resultVersionRecord.getParamFile());
        resultInfoImpl.setResultFile(resultVersionRecord.getResultFile());
        resultInfoImpl.setResultFormats(resultVersionRecord.getResultFmts());
        resultInfoImpl.setLaunchType(resultVersionRecord.getLaunchType());
        resultInfoImpl.setTaskId(resultVersionRecord.getTaskID());
        resultInfoImpl.setExpireationTime(new Date(resultVersionRecord.getExpirationTime()));
        resultInfoImpl.setExpire(resultVersionRecord.getExpire());
        resultInfoImpl.setExpireationMethod(resultVersionRecord.getExpireationMethod());
        resultInfoImpl.setSpecifiedFolder(resultVersionRecord.getSpecifiedFolder());
        resultInfoImpl.setReportAmount(resultVersionRecord.getReportAmount());
        resultInfoImpl.setResID(resultVersionRecord.getResourceID());
        return resultInfoImpl;
    }

    private ReportInfo equalsIgnoreCase(ReportVersionRecord reportVersionRecord) {
        ReportInfoImpl reportInfoImpl = new ReportInfoImpl();
        reportInfoImpl.setVersionNumber(reportVersionRecord.getVersionID());
        reportInfoImpl.setName(reportVersionRecord.getVersionName());
        reportInfoImpl.setCreator(reportVersionRecord.getCreator());
        reportInfoImpl.setCreatedTime(reportVersionRecord.getCreatedTime());
        reportInfoImpl.setReportFile(this.getFileWithHistory(reportVersionRecord.getReportFile()));
        return reportInfoImpl;
    }

    private CatalogInfo get(CatalogVersionRecord catalogVersionRecord) {
        CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
        catalogInfoImpl.setVersionNumber(catalogVersionRecord.getVersionID());
        catalogInfoImpl.setName(catalogVersionRecord.getVersionName());
        catalogInfoImpl.setCreator(catalogVersionRecord.getCreator());
        catalogInfoImpl.setCreatedTime(catalogVersionRecord.getCreatedTime());
        catalogInfoImpl.setCatalog(this.getFileWithHistory(catalogVersionRecord.getCatalogFile()));
        return catalogInfoImpl;
    }

    public void updateViewedFormats(int n, String string, int n2, String string2, long l) {
        if (n == -1) {
            DynamicResultVersionTable dynamicResultVersionTable = this.QOIV.getDynamicResultVersionTable();
            DynamicResultDetailTable dynamicResultDetailTable = ((DynamicResultVersionTableImpl)dynamicResultVersionTable).getResultDetailTable();
            dynamicResultDetailTable.updateViewedFormats(string, n2, string2, l);
        } else {
            ResultVersionTableNew resultVersionTableNew = this.QOIV.getResultVersionTableNew();
            ResultDetailTable resultDetailTable = ((ResultVersionTableImpl)resultVersionTableNew).getResultDetailTable();
            resultDetailTable.updateViewedFormats(n, n2, string2, l);
        }
    }
}

