/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.ExportedFileList;
import jet.server.api.RptServer;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.ReportServerRMIWrapper;
import jet.server.jrserver.JRRptServer;

public class JRReportServerRMIWrapper
extends UnicastRemoteObject
implements ReportServerRMIWrapper {
    private RptServer QOIV = null;

    public JRReportServerRMIWrapper(RptServer rptServer) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = rptServer;
    }

    public RptServer getRptServer() throws RemoteException {
        return this.QOIV;
    }

    public void shutdown() throws RemoteException {
        if (System.getProperty("jrs.isMyServer") == "true") {
            this.QOIV.shutdown();
            System.exit(0);
        }
    }

    public String runReport(String string, String string2, String string3, Properties properties) throws RemoteException {
        try {
            return this.QOIV.runReport(string, string2, string3, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    public String runReportWithTimeouts(String string, String string2, String string3, Properties properties, long l) throws RemoteException {
        try {
            return this.QOIV.runReportWithTimeouts(string, string2, string3, properties, l);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    public boolean isTempResultReady(String string) throws RemoteException {
        try {
            return this.QOIV.isTempResultReady(string);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    public String waitTempResultReady(String string) throws RemoteException {
        try {
            return this.QOIV.waitTempResultReady(string);
        }
        catch (InterruptedException interruptedException) {
            throw new ServerException("", interruptedException);
        }
    }

    public ExportedFileList exportResult(String string, String string2, Properties properties) throws RemoteException {
        try {
            return this.QOIV.exportResult(string, string2, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    public String submitScheduledTask(String string, Properties properties) throws RemoteException {
        try {
            return this.QOIV.submitScheduledTask(string, properties);
        }
        catch (Exception exception) {
            throw new ServerException("", exception);
        }
    }

    public Vector getScheduledTasks() throws RemoteException {
        return this.QOIV.getScheduledTasks();
    }

    public Properties getScheduledTask(String string) throws RemoteException {
        return this.QOIV.getScheduledTask(string);
    }

    public boolean removeScheduledTask(String string) throws RemoteException {
        return this.QOIV.removeScheduledTask(string);
    }

    public void removeLargeReport(String string, boolean bl) throws RemoteException {
        this.QOIV.getLargeReportManager().removeLargeReport(string, bl);
    }

    public Member[] getPredefinedServers() throws RemoteException {
        if (this.QOIV.getAdminService().getClusterAdminService() != null) {
            return this.QOIV.getAdminService().getClusterAdminService().getPredefinedServers();
        }
        return null;
    }

    public Member[] getAllMembers() throws RemoteException {
        try {
            if (this.QOIV.getClusterService() != null) {
                return this.QOIV.getClusterService().getAllMembers();
            }
        }
        catch (ClusterException clusterException) {
            throw new ServerException("", clusterException);
        }
        return null;
    }

    public int getServerStatus() throws RemoteException {
        try {
            return ((JRRptServer)this.QOIV).getServerStatus();
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

