/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrrmisvr;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.JSRuntimeException;
import jet.server.api.Authenticator;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.jrrmisvr.JRAuthenticator;
import jet.server.jrrmisvr.ServiceLogger;
import jet.server.jrserver.rmi.JRRemoteAuthenticator;

public class JRUserSessionManager
implements UserSessionManager {
    private RemoteUserSessionManager QOIV = null;
    protected Authenticator authenticator = null;
    protected Hashtable htHttpSessions = new Hashtable(4);
    protected Hashtable htSessions = new Hashtable(4);

    public JRUserSessionManager(RemoteUserSessionManager remoteUserSessionManager) {
        this.QOIV = remoteUserSessionManager;
    }

    public void setAuthenticator(Authenticator authenticator) {
        try {
            this.QOIV.setAuthenticator(new JRRemoteAuthenticator(authenticator));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public Authenticator getAuthenticator() {
        try {
            if (this.authenticator == null) {
                this.authenticator = new JRAuthenticator(this.QOIV.getAuthenticator());
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return this.authenticator;
    }

    public void setDefaultMaxInactiveInterval(int n) {
        try {
            this.QOIV.setDefaultMaxInactiveInterval(n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public int getDefaultMaxInactiveInterval() {
        try {
            return this.QOIV.getDefaultMaxInactiveInterval();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0;
        }
    }

    public UserSession login(String string, String string2, String string3, Object object) throws TooManyUsersException {
        try {
            UserSession userSession = null;
            userSession = !this.needSecurity() ? this.QOIV.login(string, "", "") : this.QOIV.login(string, string2, string3);
            if (userSession != null && this.needSecurity()) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    public UserSession login(String string, String string2, String string3, Object object, boolean bl, boolean bl2) throws TooManyUsersException {
        try {
            UserSession userSession = null;
            userSession = !this.needSecurity() ? this.QOIV.login(string, "", "", false, false) : this.QOIV.login(string, string2, string3, bl, bl2);
            if (userSession != null && this.needSecurity()) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    public UserSession loginExternalAuthorized(String string, String string2, Object object) throws TooManyUsersException {
        try {
            UserSession userSession = this.QOIV.loginExternalAuthorized(string, string2);
            if (userSession != null) {
                this.htHttpSessions.put(userSession.getID(), object);
                this.htSessions.put(userSession.getID(), new Long(System.currentTimeMillis()));
            }
            return userSession;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new JSRuntimeException(remoteException.getMessage());
        }
    }

    public void logout(UserSession userSession) {
        try {
            String string = userSession.getID();
            this.QOIV.logout(string);
            this.htHttpSessions.remove(string);
            this.htSessions.remove(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public UserSession getUserSession(String string) {
        try {
            return this.QOIV.getUserSession(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Enumeration getAllUserSessions() {
        try {
            return this.QOIV.getAllUserSessions().elements();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Enumeration getAllWaitUserSessions() {
        try {
            return this.QOIV.getAllWaitUserSessions().elements();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public void refreshLastAccessTime(String string) throws InvalidUserSessionException {
        try {
            this.QOIV.refreshLastAccessTime(string);
            this.htSessions.put(string, new Long(System.currentTimeMillis()));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new InvalidUserSessionException(remoteException);
        }
    }

    public boolean isWait(String string) {
        try {
            return this.QOIV.isWait(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    public void putSessions(UserSession userSession) {
        try {
            String string = userSession.getID();
            this.QOIV.putSessions(string);
            Object object = this.getExtObj(userSession.getID());
            if (object != null) {
                this.htHttpSessions.put(string, object);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public boolean needSecurity() {
        try {
            return this.QOIV.needSecurity();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return true;
        }
    }

    protected Object getExtObj(String string) {
        Object var2_2 = null;
        if (string != null) {
            var2_2 = this.htHttpSessions.get(string);
        }
        return var2_2;
    }

    protected long getLastAccessTime(String string) {
        Long l = (Long)this.htSessions.get(string);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public long getLastLoginTime(String string) {
        try {
            return this.QOIV.getLastLoginTime(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0L;
        }
    }

    public long getLastLogoutTime(String string) {
        try {
            return this.QOIV.getLastLogoutTime(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return 0L;
        }
    }
}

