/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.CompletedTaskTable;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.db.CompletedTable;
import jet.server.log.ServiceLogger;

public class JRCompletedTaskTable
implements CompletedTaskTable {
    private CompletedTable QOIV = null;
    private ResourceManager commit = null;

    public JRCompletedTaskTable(CompletedTable completedTable, ResourceManager resourceManager) {
        this.QOIV = completedTable;
        this.commit = resourceManager;
    }

    public Vector getCompletedTaskRecordsByTaskID(String string) throws RptServerException {
        try {
            return this.QOIV.getCompletedTaskRecordsByTaskID(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public Vector getCompletedTaskRecordsByReport(String string, String string2) throws RptServerException {
        try {
            return this.QOIV.getCompletedTaskRecordsByReport(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public Vector getCompletedTaskRecordsByUser(String string) throws RptServerException {
        try {
            if (this.commit.isAdminUser(string)) {
                return this.QOIV.getAllCompletedTaskRecordsVector();
            }
            return this.QOIV.getCompletedTaskRecordsByUser(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public Enumeration getAllCompletedTaskRecords() throws RptServerException {
        try {
            Vector vector = this.QOIV.getAllCompletedTaskRecordsVector();
            return vector.elements();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public CompletedTaskRecord getCompletedTaskRecord(String string) throws RptServerException {
        CompletedTaskRecord completedTaskRecord = null;
        try {
            completedTaskRecord = this.QOIV.getCompletedTaskRecord(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
        return completedTaskRecord;
    }

    public boolean removeCompletedTaskRecord(String string) throws RptServerException {
        try {
            return this.QOIV.removeCompletedTaskRecord(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public boolean removeAllCompletedTaskRecord() throws RptServerException {
        try {
            return this.QOIV.removeAllCompletedTaskRecord();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return false;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }

    public void commit() throws RptServerException {
        try {
            this.QOIV.commit();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            throw new RptServerException(remoteException);
        }
    }
}

