/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Locale;
import java.util.Vector;
import jet.connect.DbValue;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.server.api.ParamInfo;
import jet.server.api.RptServerException;

public class JRParamInfo
implements ParamInfo {
    private ParamDesc IsParameters = null;
    private ParamDesc QOIV = null;
    private Vector add = null;
    private Locale append = Locale.getDefault();
    private Locale clone = Locale.getDefault();

    public JRParamInfo(ParamDesc paramDesc) {
        this.IsParameters = paramDesc;
    }

    public String getName() {
        return this.IsParameters.name;
    }

    public String getType() {
        return this.IsParameters.type;
    }

    public String getPrompt() {
        String string = this.IsParameters.promptText;
        if (string != null && string.equals("*")) {
            string = this.getName() + "*";
        }
        return string;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.equals(this.append)) {
            this.add = null;
            this.append = locale;
        }
    }

    public Locale getLocale() {
        return this.append;
    }

    public String getDefaultValue() {
        if (this.add == null) {
            this.getValueOptions();
        }
        if (this.add != null && this.add.size() > 0) {
            int n = this.IsParameters.getDefaultIndex();
            if (n > -1) {
                return (String)this.add.elementAt(n);
            }
            return (String)this.add.lastElement();
        }
        return this.IsParameters.value;
    }

    public boolean isColumn() {
        return this.IsParameters.isColumn();
    }

    public boolean isDistinct() {
        return this.IsParameters.isDistinct();
    }

    public boolean isRequired() {
        return this.IsParameters.isRequired();
    }

    public Vector getDisplayValues(Locale locale) {
        return this.getDisplayValues();
    }

    public Vector getDisplayValues() {
        return this.IsParameters.getBeColumn() == 4 ? this.IsParameters.getShowValues() : this.IsParameters.getDisplayValues(this.getLocale());
    }

    public Vector getValueOptions(Locale locale) {
        return this.getValueOptions();
    }

    public Vector getValueOptions() {
        this.add = this.IsParameters.getDisplayValues(this.getLocale());
        return this.add;
    }

    public String toString() {
        return super.toString() + "[" + this.IsParameters.name + ":" + this.IsParameters.type + ":" + this.IsParameters.value + "]";
    }

    public void setValue(String string) {
        this.IsParameters.value = string;
    }

    public ParamDesc getParamDesc() {
        return this.IsParameters;
    }

    public String getMaxLimit(Locale locale) {
        return this.getMaxLimit();
    }

    public String getMaxLimit() {
        Vector vector = this.IsParameters.getDisplayLimit(this.getLocale());
        if (vector != null && vector.size() > 1) {
            return (String)vector.elementAt(1);
        }
        return null;
    }

    public String getMinLimit(Locale locale) {
        return this.getMinLimit();
    }

    public String getMinLimit() {
        Vector vector = this.IsParameters.getDisplayLimit(this.getLocale());
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return null;
    }

    public String getUserFormat() {
        return this.IsParameters.getFormat();
    }

    public void setEncoding(String string) {
        this.IsParameters.setEncoding(string);
    }

    public boolean isParameters() {
        return this.IsParameters.IsParameters();
    }

    public boolean isReferedBy() {
        return this.IsParameters.isReferedBy();
    }

    public Vector getReferedBy() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.IsParameters.getReferedBy();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                ParamDesc paramDesc = (ParamDesc)vector2.get(n);
                vector.add(paramDesc.getName());
                ++n;
            }
        }
        return vector;
    }

    public boolean isReferOther() {
        return this.IsParameters.isReferOther();
    }

    public String getBoundSQL() {
        return this.IsParameters.getImportSql();
    }

    public boolean isDynamicDateParameter() {
        return this.IsParameters.isUseCurrentDate() || this.IsParameters.isUseCurrentDateWhenBlank();
    }

    public String getDynamicDisplayValue(long l, Locale locale) {
        return this.getDynamicDisplayValue(l);
    }

    public String getDynamicDisplayValue(long l) {
        DbValue dbValue = this.IsParameters.getDynamicValue(l, this.getLocale());
        return this.IsParameters.getDisplayValue(dbValue, this.getLocale());
    }

    public boolean isHideParameterWhenSingleValueReturn() {
        return this.IsParameters.isHideParameterWhenSingleValueReturn();
    }

    public String[][] getBooleanLiteral() {
        return this.IsParameters.getBooleanLiteral();
    }

    public boolean isMultiple() {
        return this.IsParameters.isMultipleValue();
    }

    public boolean isAllowAll() {
        return this.IsParameters.isAllowAll();
    }

    public boolean isCascading() {
        return this.IsParameters.isCascading();
    }

    public String getPreviousLevel() {
        return this.IsParameters.getPreviousLevel();
    }

    public String getNextLevel() {
        return this.IsParameters.getNextLevel();
    }

    public boolean isSetAsParameter() {
        return this.IsParameters.isSetAsParameter();
    }

    public boolean isAllowTypeIn() {
        return this.IsParameters.isAllowTypeIn();
    }

    public int getWhenOutOfRange() {
        return this.IsParameters.getWhenOutOfRange();
    }

    public String[] detectInvalidValues(String[] stringArray) {
        String[] stringArray2 = null;
        if (this.IsParameters.getWhenOutOfRange() == 3) {
            boolean bl = this.IsParameters.isAllSelected();
            this.IsParameters.setAllSelected(false);
            try {
                stringArray2 = this.IsParameters.detectInvalidValues(stringArray, this.getLocale());
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            this.IsParameters.setAllSelected(bl);
        }
        return stringArray2;
    }

    public void check(String string) throws RptServerException {
        if (string == null) {
            return;
        }
        if (this.QOIV == null) {
            this.QOIV = (ParamDesc)this.IsParameters.clone();
        }
        try {
            if (this.IsParameters.isMultipleValue()) {
                this.QOIV.setValue(new String[]{string}, this.getLocale());
            } else {
                this.QOIV.setValue(string, this.getLocale());
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RptServerException(invalidParameterException.getMessage(), (Throwable)invalidParameterException);
        }
    }

    public String getDefaultDateFormat() {
        return this.IsParameters.getDefaultDateFormat(this.clone);
    }
}

