/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.File;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.security.acl.Permission;
import java.sql.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.PathInfo;
import jet.server.api.RemoteFileService;
import jet.server.api.ReportVersionRecord;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.VersionRecord;
import jet.server.api.cluster.Member;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.intf.jrs.RemoteResourceManager;
import jet.server.jrc.JRRemoteResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.JRServerEnv;
import jet.server.util.ui.UITree;

public class JRResourceManager
implements ExResourceManager,
JRServerEnv {
    private RemoteResourceManager QOIV = null;
    private RemoteFileService add = null;
    private String addElement = null;
    private String addFolder = null;
    private boolean addResource = false;

    public JRResourceManager(String string, String string2, RemoteResourceManager remoteResourceManager) {
        this.addElement = string;
        this.addFolder = string2;
        this.QOIV = remoteResourceManager;
    }

    public void setAdmin(boolean bl) {
        this.addResource = bl;
    }

    public boolean isAdmin() {
        return this.addResource;
    }

    public void setAdminRemotefs(RemoteFileService remoteFileService) {
        this.add = remoteFileService;
    }

    public String getMIMEType(String string) {
        try {
            return this.QOIV.getMIMEType(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String[] getExtensions(String string) {
        try {
            return this.QOIV.getExtensions(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getRealm() {
        try {
            return this.QOIV.getRealm();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getRealmDir() {
        try {
            return this.QOIV.getRealmDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public PathInfo getPathInfo(String string, String string2) throws RptServerException {
        try {
            return this.QOIV.getPathInfo(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getSubpaths(String string, String string2) throws RptServerException {
        try {
            return this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public Vector getSubpathsAndCatalogs(String string, String string2) throws RptServerException {
        try {
            return this.QOIV.getSubpathsAndCatalogs(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getSubnodes(String string, String string2) throws RptServerException {
        try {
            return this.QOIV.getSubnodes(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getFileSysDirsInPath(String string, String string2) throws RptServerException {
        try {
            return this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public Vector getCatalogsInPath(String string, String string2) throws RptServerException {
        try {
            return this.QOIV.getCatalogsInPath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getFileSysFilesInPath(String string, String string2) throws RptServerException {
        Vector vector = this.getSubnodes(string, string2);
        Vector<PathInfo> vector2 = new Vector<PathInfo>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PathInfo pathInfo = (PathInfo)vector.elementAt(n2);
            if (!pathInfo.isDir()) {
                vector2.addElement(pathInfo);
            }
            ++n2;
        }
        return vector2;
    }

    public Vector getReports(String string, String string2) throws RptServerException {
        String string3 = string2.substring(0, string2.lastIndexOf("/"));
        if (string3 == null || string3.length() == 0) {
            string3 = "/";
        }
        try {
            return this.getReportsInPath(string, string3);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public String getRoot() {
        try {
            return this.QOIV.getRoot();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getTempDir() {
        String string = this.addElement;
        if (ServerEnv.isSharedTempDir()) {
            string = ServerEnv.getSharedTempDir();
        }
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    public String getHistDir() {
        return this.addFolder;
    }

    public String getRemoteHistFile(String string) {
        try {
            if (string.startsWith(this.addFolder)) {
                string = string.substring(this.addFolder.length());
            }
            String string2 = this.QOIV.getHistDir() + string;
            return string2;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getHistFile(String string) {
        try {
            if (string.startsWith(this.addFolder)) {
                string = string.substring(this.addFolder.length());
            }
            if (ServerEnv.isSharedHistDir()) {
                return this.getHistDir() + string;
            }
            String string2 = this.QOIV.getHistDir() + string;
            String string3 = this.getHistDir() + string;
            if (this.add == null) {
                return string2;
            }
            this.add.copyFromRemote(string2, string3);
            return string3;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        return null;
    }

    public String getAdminHomePath() {
        try {
            return this.QOIV.getHomePath();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getRealmPath() {
        try {
            return this.QOIV.getRealmDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getRemoteHistDir() {
        try {
            return this.QOIV.getHistDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getLocalPath(String string) {
        String string2;
        String string3;
        try {
            string3 = this.QOIV.getHistDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
        if (string.startsWith(string3)) {
            int n = string3.length();
            string2 = string.substring(n);
        } else {
            string2 = string;
            int n = string2.indexOf(CSUtil.fileSep);
            string2 = string2.substring(n + 1);
        }
        return this.getHistDir() + string2;
    }

    public String getRealPath(String string, String string2, int n) throws Exception {
        String string3 = this.QOIV.getRealPath(string, string2, n);
        boolean bl = this.getPathInfo(string, string2).isDynamic();
        boolean bl2 = false;
        if (bl) {
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            bl2 = this.getPathInfo(string, string4).isShared();
        }
        return this.QOIV(string3, bl, bl2);
    }

    public String getURLForCatalogReferedFile(String string, String string2, String string3, int n) {
        String string4 = string2.substring(0, string2.lastIndexOf(File.separator));
        String string5 = "";
        string5 = !string4.endsWith(File.separator) ? string4 + File.separator + string3 : string4 + string3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ServerEnv.getJSPWebAppName("jsp.webapp.sendfile")).append("?").append("jrs.file").append("=").append(string5).append("&").append("jrs.uid").append("=").append(string);
        return stringBuffer.toString();
    }

    public String checkRealPath(String string) throws Exception {
        return this.QOIV(string, false, false);
    }

    private String QOIV(String string, boolean bl, boolean bl2) throws Exception {
        boolean bl3 = string.endsWith(".cat");
        if (!this.isAdmin() && bl3) {
            this.add();
        }
        if (this.isAdmin()) {
            return string;
        }
        boolean bl4 = ServerEnv.isSharedHistDir();
        if (!bl) {
            if (bl4) {
                return this.getLocalPath(string);
            }
        } else if (bl2) {
            return string;
        }
        if (this.add == null) {
            return null;
        }
        String string2 = this.getLocalPath(string);
        if (bl3) {
            int n = string.lastIndexOf(File.separator);
            String string3 = string.substring(0, n + 1);
            String string4 = string3 + "*.*";
            String string5 = this.getLocalPath(string4);
            this.add.copyFromRemote(string4, string5);
        } else {
            this.add.copyFromRemote(string, string2);
        }
        return string2;
    }

    public String getRealPath(String string, String string2) throws Exception {
        String string3 = this.QOIV.getRealPath(string, string2);
        PathInfo pathInfo = this.getPathInfo(string, string2);
        boolean bl = pathInfo.isDynamic();
        boolean bl2 = false;
        if (pathInfo.isDir()) {
            return string3;
        }
        if (bl) {
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            bl2 = this.getPathInfo(string, string4).isShared();
        }
        return this.QOIV(string3, bl, bl2);
    }

    private void add() throws Exception {
        if (this.add != null) {
            String string = this.QOIV.getHomePath() + ServerEnv.getStyleFolder() + File.separator;
            String string2 = this.getHomePath() + ServerEnv.getStyleFolder() + File.separator;
            String string3 = "*_stl.xsd";
            this.add.copyFromRemote(string + string3, string2 + string3);
            string3 = "*.css";
            this.add.copyFromRemote(string + string3, string2 + string3);
            string = this.QOIV.getFontPath();
            string2 = ServerEnv.getFontPath();
            String string4 = "*.*";
            this.add.copyFromRemote(string + string4, string2 + string4);
        }
    }

    public String getRptRealPath(String string, String string2) throws Exception {
        return this.getRptRealPath(string, string2, false);
    }

    public String getRptRealPath(String string, String string2, boolean bl) throws Exception {
        int n;
        String string3;
        String string4 = this.QOIV.getRptRealPath(string, string2);
        boolean bl2 = ServerEnv.isSharedHistDir();
        boolean bl3 = this.getPathInfo(string, string2).isDynamic();
        if (!bl3) {
            if (bl2) {
                return this.getLocalPath(string4);
            }
        } else {
            string3 = string2.substring(0, string2.lastIndexOf("/"));
            if (string3 == null || string3.length() == 0) {
                string3 = "/";
            }
            if ((n = this.getPathInfo(string, string3).isShared()) != 0) {
                return string4;
            }
        }
        if (this.isAdmin()) {
            return string4;
        }
        if (this.add == null) {
            return null;
        }
        string3 = this.getLocalPath(string4);
        if (bl) {
            n = string4.lastIndexOf(File.separator);
            String string5 = string4.substring(0, n + 1);
            String string6 = string5 + "*.*";
            String string7 = this.getLocalPath(string6);
            this.add.copyFromRemote(string6, string7);
        } else {
            this.add.copyFromRemote(string4, string3);
        }
        return string3;
    }

    public String getRptRealPath(String string, String string2, String string3) throws Exception {
        return this.getRptRealPath(string, string2, string3, false);
    }

    public String getRptRealPath(String string, String string2, int n) throws Exception {
        String string3 = this.QOIV.getRptRealPath(string, string2, n);
        boolean bl = ServerEnv.isSharedHistDir();
        boolean bl2 = this.getPathInfo(string, string2).isDynamic();
        if (!bl2) {
            if (bl) {
                return this.getLocalPath(string3);
            }
        } else {
            boolean bl3;
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            if (bl3 = this.getPathInfo(string, string4).isShared()) {
                return string3;
            }
        }
        if (this.isAdmin()) {
            return string3;
        }
        if (this.add == null) {
            return null;
        }
        int n2 = string3.lastIndexOf(File.separator);
        String string5 = string3.substring(0, n2 + 1);
        String string6 = string5 + "*.*";
        String string7 = this.getLocalPath(string6);
        this.add.copyFromRemote(string6, string7);
        String string8 = this.getLocalPath(string3);
        return string8;
    }

    public String getRptRealPath(String string, String string2, String string3, boolean bl) throws Exception {
        int n;
        String string4;
        String string5 = this.QOIV.getRptRealPath(string, string2, string3);
        boolean bl2 = ServerEnv.isSharedHistDir();
        boolean bl3 = this.getPathInfo(string, string2).isDynamic();
        if (!bl3) {
            if (bl2) {
                return this.getLocalPath(string5);
            }
        } else {
            string4 = string3.substring(0, string3.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            if ((n = this.getPathInfo(string, string4).isShared()) != 0) {
                return string5;
            }
        }
        if (this.isAdmin()) {
            return string5;
        }
        if (this.add == null) {
            return null;
        }
        string4 = this.getLocalPath(string5);
        if (bl) {
            n = string5.lastIndexOf(File.separator);
            String string6 = string5.substring(0, n + 1);
            String string7 = string6 + "*.*";
            String string8 = this.getLocalPath(string7);
            this.add.copyFromRemote(string7, string8);
        } else {
            this.add.copyFromRemote(string5, string4);
        }
        return string4;
    }

    public void prepareRslt(String string) {
    }

    public void completeRslt(String string, Object object) {
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return null;
    }

    String addElement(String string) {
        return null;
    }

    boolean isTempResultReady(String string) {
        return false;
    }

    String waitTempResultReady(String string) throws InterruptedException {
        while (!this.isTempResultReady(string)) {
            Thread.sleep(2000L);
        }
        return this.addElement(string);
    }

    public String getHomePath() {
        String string = ServerEnv.homePath;
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    public int getBuildNumber() {
        return 900;
    }

    public String getSchedulePath() {
        String string;
        File file;
        String string2 = ServerEnv.realmsPath;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if (!(file = new File(string = string2 + this.getRealm() + CSUtil.fileSep + "schedule" + CSUtil.fileSep)).exists()) {
            file.mkdir();
        }
        return string;
    }

    public RptResourceManager getRptResourceManager() {
        if (this.QOIV instanceof JRRemoteResourceManager) {
            return ((JRRemoteResourceManager)this.QOIV).getRptResourceManager();
        }
        return null;
    }

    public Vector getImagesByCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getImagesByCatalog(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReportsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getReportsInPath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getResultsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultsInPath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getFoldersInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getFoldersInPath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getCatalogVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getCatalogVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReportVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getReportVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getResultVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public ResultVersionRecord getResultVersionByNodeID(String string) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultVersionByNodeID(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getResultDocVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultDocVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void setResultMaxVersionAmount(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            this.QOIV.setResultMaxVersionAmount(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public int getResultMaxVersionAmount(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultMaxVersionAmount(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    public void removeNode(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            this.QOIV.removeNode(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public VersionRecord addResource(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.QOIV.addResource(string, string2, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public VersionRecord addResource(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.QOIV.addResource(string, string2, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public VersionRecord addResource(String string, String string2, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.QOIV.addResource(string, string2, bl, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String addFolder(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.QOIV.addFolder(string, string2, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String createFolder(String string, String string2, String string3, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.QOIV.createFolder(string, string2, string3, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        if (ServerEnv.hasClusterLicense()) {
            Member member = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
            hashtable.put("jrs.remote_host", member.getHost());
            hashtable.put("jrs.remote_port", member.getPort());
        }
        try {
            this.QOIV.addResourcesToFolder(string, string2, string3, bl, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, boolean bl2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        if (ServerEnv.hasClusterLicense()) {
            Member member = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
            hashtable.put("jrs.remote_host", member.getHost());
            hashtable.put("jrs.remote_port", member.getPort());
        }
        try {
            this.QOIV.addResourcesToFolder(string, string2, string3, bl, bl2, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public Vector getAllUsers(String string) {
        try {
            return this.QOIV.getAllUsers(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getUsersByRole(String string, String string2) throws NoSuchRoleException {
        try {
            return this.QOIV.getUsersByRole(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getAllRoles(String string) {
        try {
            return this.QOIV.getAllRoles(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getRolesByUser(String string, String string2) throws NoSuchUserException {
        try {
            return this.QOIV.getRolesByUser(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReferRoles(String string) throws NoSuchUserException {
        try {
            return this.QOIV.getReferRoles(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReferGroups(String string) throws NoSuchUserException {
        try {
            return this.QOIV.getReferGroups(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReferUsers(String string) throws NoSuchUserException {
        try {
            return this.QOIV.getReferUsers(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Hashtable[] getPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getPermissions(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Hashtable[] getInheritedPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getInheritedPermissions(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void setPermissions(String string, String string2, int n, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource {
        try {
            this.QOIV.setPermissions(string, string2, n, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public VersionRecord addResultInReport(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.addResultInReport(string, string2, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public void removeVersion(String string, String string2) throws NoPrivilegeException {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(204805, String.valueOf(string2), 6);
            return;
        }
        try {
            this.QOIV.removeVersion(string, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public String getRealPathOfNode(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getRealPathOfNode(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String refreshFolders(String string) {
        String string2 = null;
        try {
            UITree uITree = this.QOIV.refreshFolders(string);
            string2 = string == null || string.trim().length() == 0 ? ServerEnv.realmsPath + "folders.xml" : ServerEnv.realmsPath + string + ".xml";
            uITree.toXML(string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return string2;
    }

    public int getLatestVersionNumber(String string) throws UnknownResource {
        try {
            return this.QOIV.getLatestVersinNumber(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    public int getLatestVersionNumber(String string, String string2) throws UnknownResource {
        try {
            return this.QOIV.getLatestVersinNumber(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    public void setNodeProperties(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            this.QOIV.setNodeProperties(string, string2, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setNodeProperties(String string, String string2, int n, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource {
        if (CSUtil.getBoolean((String)hashtable.get("jrs.need_expire"))) {
            int n2 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 0);
            if (n2 == 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(5, CSUtil.parseInt((String)hashtable.get("jrs.expire_days")));
                Date date = new Date(gregorianCalendar.getTime().getTime());
                hashtable.put("jrs.expired_time", date);
            } else {
                int n3 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_year"), 1900) - 1900;
                int n4 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_month"), 1) - 1;
                int n5 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_date"), 0);
                Date date = new Date(n3, n4, n5);
                hashtable.put("jrs.expired_time", date);
            }
        }
        try {
            this.QOIV.setNodeProperties(string, string2, n, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void setResultVersionProperties(String string, String string2, int n, Hashtable hashtable) throws NoPrivilegeException, UnknownResource {
        if (CSUtil.getBoolean((String)hashtable.get("jrs.need_expire"))) {
            int n2 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 0);
            if (n2 == 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(5, CSUtil.parseInt((String)hashtable.get("jrs.expire_days")));
                Date date = new Date(gregorianCalendar.getTime().getTime());
                hashtable.put("jrs.expired_time", date);
            } else {
                int n3 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_year"), 1900) - 1900;
                int n4 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_month"), 1) - 1;
                int n5 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_date"), 0);
                Date date = new Date(n3, n4, n5);
                hashtable.put("jrs.expired_time", date);
            }
        }
        try {
            this.QOIV.setResultVersionProperties(string, string2, n, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public CatalogVersionRecord getCatalogVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getCatalogVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public ReportVersionRecord getReportVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getReportVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public ResultVersionRecord getResultVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public ResultVersionRecord getResultDocVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.getResultDocVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getArchivePath(String string) {
        try {
            return this.QOIV.getArchivePath(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public String getArchivePath(String string, String string2) {
        try {
            return this.QOIV.getArchivePath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public boolean deleteArchivePath(String string) {
        try {
            return this.QOIV.deleteArchivePath(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public String getFileWithoutHistDir(String string) {
        String string2;
        String string3 = string;
        try {
            string2 = this.QOIV.getHistDir();
        }
        catch (RemoteException remoteException) {
            string2 = this.getHistDir();
        }
        int n = string2.length();
        if (string3.startsWith(string2)) {
            string3 = string3.substring(n);
        }
        return string3;
    }

    public String getArchiveRstByRealPath(String string, String string2) {
        int n;
        String string3;
        String string4 = string;
        try {
            string3 = this.QOIV.getHistDir();
        }
        catch (RemoteException remoteException) {
            string3 = this.getHistDir();
        }
        int n2 = string3.length();
        if (string4.startsWith(string3)) {
            string4 = string4.substring(n2);
        }
        if ((n = string4.lastIndexOf(".")) > 0) {
            boolean bl = false;
            String[] stringArray = JRResultFiles.suffixs;
            String string5 = string4.toLowerCase();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (string5.equals(stringArray[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                string4 = string4.substring(0, n);
            }
        }
        n = string4.lastIndexOf(File.separator);
        String string6 = "";
        if (n < 0) {
            string6 = string4;
        } else {
            if (n + 1 <= string4.length()) {
                string6 = string4.substring(n + 1);
            }
            string4 = string4.substring(0, n);
        }
        if (string6.length() > 0) {
            int n4;
            int n5 = string6.indexOf(string2);
            if (n5 == 0) {
                string6 = string6.substring(string2.length());
            }
            if ((n4 = string6.lastIndexOf("_")) > 0) {
                string6 = string6.substring(0, n4);
            }
            if (n5 == 0) {
                string6 = string2 + string6;
            }
        }
        return string4 + File.separator + string6;
    }

    public boolean isAdminUser(String string) {
        try {
            return this.QOIV.isAdminUser(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public boolean checkPermission(String string, String string2, Permission permission) throws NoSuchUserException, UnknownResource {
        try {
            return this.QOIV.checkPermission(string2, string, permission);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public boolean checkPermission(String string, String string2, int n, Permission permission) throws NoSuchUserException, UnknownResource {
        try {
            return this.QOIV.checkPermission(string2, n, string, permission);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, Properties properties2, String string6) throws NoPrivilegeException, UnknownResource {
        try {
            this.QOIV.publishResultToVersion(string, string2, string3, string4, string5, properties, properties2, string6);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void loadUserResAliasToMem(String string) {
        try {
            this.QOIV.loadUserResAliasToMem(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public void rmUserResAliasFromMem(String string) {
        try {
            this.QOIV.rmUserResAliasFromMem(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    public String getInheritedLinkedCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource {
        String string3 = null;
        try {
            string3 = this.QOIV.getInheritedLinkedCatalog(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return string3;
    }

    public boolean isNodeExist(String string, String string2) {
        try {
            return this.QOIV.isNodeExist(string, string2);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError(rptServerException);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public boolean isCatalogLinked(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.QOIV.isCatalogLinked(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    public void setResultVersionViewed(String string, String string2, int n, String string3, int n2) throws NoPrivilegeException, UnknownResource {
        try {
            this.QOIV.setResultVersionViewed(string, string2, n, string3, n2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }
}

