/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.RemoteFileService;
import jet.server.api.UserPreferenceManager;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRRemoteFileService;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.util.HeadlessHelper;

public class JRUserPreferenceManager
implements UserPreferenceManager {
    String QOIV;
    String addElement;
    Properties append;
    private Hashtable broadcastDefaultPreference;
    RemoteFileService containsKey;

    JRUserPreferenceManager(String string, String string2) throws Exception {
        this.QOIV = string2;
        this.addElement = string + string2 + File.separator;
        this.broadcastDefaultPreference = new Hashtable();
        try {
            this.containsKey = new JRRemoteFileService(ServerEnv.getClusterAdminHost(), APIUtil.parseInt(ServerEnv.getClusterAdminRMIPort()));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw exception;
        }
        this.append = new Properties();
        this.setDefaultPref();
        this.loadDefaultPref();
    }

    JRUserPreferenceManager(String string, RemoteFileService remoteFileService) throws Exception {
        this.addElement = string;
        if (!this.addElement.endsWith(File.separator)) {
            this.addElement = this.addElement + File.separator;
        }
        this.broadcastDefaultPreference = new Hashtable();
        this.containsKey = remoteFileService;
        this.append = new Properties();
        this.setDefaultPref();
        this.loadDefaultPref();
    }

    public void loadDefaultPref() {
        String string = this.addElement + "preference.properties";
        try {
            if (this.containsKey.exists(string)) {
                try {
                    this.append.load(this.containsKey.readFile(string));
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    public void loadPreference(String string) {
        String string2 = this.addElement + string + File.separator;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        if (this.broadcastDefaultPreference.containsKey(string)) {
            return;
        }
        Properties properties = new Properties(this.append);
        String string3 = this.addElement + string + File.separator + "preference.properties";
        try {
            if (this.containsKey.exists(string3) && !this.addElement(string)) {
                try {
                    properties.load(this.containsKey.readFile(string3));
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        this.broadcastDefaultPreference.put(string, properties);
    }

    public Properties getDefaultUserPreference() {
        return this.append;
    }

    public Properties getUserPreference(String string) {
        this.loadPreference(string);
        if (this.broadcastDefaultPreference.containsKey(string)) {
            Properties properties = (Properties)this.broadcastDefaultPreference.get(string);
            if (properties.size() == 0) {
                return this.append;
            }
            return properties;
        }
        return this.append;
    }

    public void removePreference(String string) {
        this.broadcastDefaultPreference.remove(string);
    }

    public void removePreferencesByValidUserNames(Enumeration enumeration) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration2 = this.broadcastDefaultPreference.keys();
        while (enumeration2.hasMoreElements()) {
            vector.addElement((String)enumeration2.nextElement());
        }
        while (enumeration.hasMoreElements()) {
            vector.removeElement((String)enumeration.nextElement());
        }
        Enumeration enumeration3 = vector.elements();
        while (enumeration3.hasMoreElements()) {
            this.broadcastDefaultPreference.remove((String)enumeration3.nextElement());
        }
    }

    public void saveDefaultUserPreference(Properties properties) throws IOException {
        String string = this.addElement + "preference.properties";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.append(this.append, properties);
        this.append.save(byteArrayOutputStream, null);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.containsKey.writeFile(byteArrayInputStream, string);
        if (HttpUtil.getHttpRptServer().isClusterEnable()) {
            this.QOIV();
        }
    }

    public void saveUserPreference(String string, Properties properties) throws IOException {
        if (this.addElement(string)) {
            return;
        }
        this.loadPreference(string);
        Properties properties2 = (Properties)this.broadcastDefaultPreference.get(string);
        this.append(properties2, properties);
        String string2 = this.addElement + string + File.separator + "preference.properties";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties2.save(byteArrayOutputStream, null);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.containsKey.writeFile(byteArrayInputStream, string2);
    }

    public boolean useDefaultUserPreference(String string) {
        if (this.addElement(string)) {
            return true;
        }
        String string2 = this.addElement + string + File.separator + "preference.properties";
        boolean bl = true;
        try {
            if (this.containsKey.exists(string2)) {
                bl = this.containsKey.delete(string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (bl) {
            this.removePreference(string);
        }
        return bl;
    }

    private void QOIV() {
        JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
        ClusterService clusterService = jRRptServer.getClusterService();
        if (clusterService != null) {
            Member[] memberArray = null;
            try {
                memberArray = clusterService.getAllMembers();
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError(clusterException, 3);
            }
            int n = 0;
            while (n < memberArray.length) {
                try {
                    MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(memberArray[n].getHost(), Integer.parseInt(memberArray[n].getPort()), "MemberMonitor");
                    memberMonitor.broadcastDefaultPreference();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                ++n;
            }
        }
    }

    private boolean addElement(String string) {
        return string.equalsIgnoreCase("");
    }

    protected void setDefaultPref() {
        this.append.put("folder_selector_format", String.valueOf(2));
        this.append.put("page_style", String.valueOf(1));
        this.append.put("default_view_format", String.valueOf(8));
        this.append.put("days_definition_for_completed", "0");
        this.append.put("parameters_display_size", "100");
        this.append.put("reports_name", "true");
        this.append.put("reports_type", "true");
        this.append.put("reports_description", "true");
        this.append.put("reports_last_modified", "true");
        this.append.put("scheduled_task_id", "false");
        this.append.put("scheduled_task_name", "true");
        this.append.put("scheduled_catalog", "false");
        this.append.put("scheduled_report", "true");
        this.append.put("scheduled_reports", "false");
        this.append.put("scheduled_submitter", "false");
        this.append.put("scheduled_launch_type", "false");
        this.append.put("scheduled_next_run_at", "true");
        this.append.put("scheduled_last_run_at", "false");
        this.append.put("scheduled_is_successful", "false");
        this.append.put("scheduled_task_type", "true");
        this.append.put("scheduled_is_enable", "true");
        this.append.put("active_task_id", "false");
        this.append.put("active_task_name", "true");
        this.append.put("active_started_time", "true");
        this.append.put("active_engine_status", "false");
        this.append.put("active_catalog", "false");
        this.append.put("active_report", "true");
        this.append.put("active_reports", "false");
        this.append.put("active_launch_type", "false");
        this.append.put("active_task_type", "true");
        this.append.put("active_submitter", "false");
        this.append.put("active_parameters", "false");
        this.append.put("active_parameters_values", "true");
        this.append.put("completed_task_id", "false");
        this.append.put("completed_task_name", "true");
        this.append.put("completed_completed_time", "true");
        this.append.put("completed_is_successful", "true");
        this.append.put("completed_catalog", "false");
        this.append.put("completed_report", "true");
        this.append.put("completed_reports", "false");
        this.append.put("completed_parameter_file", "false");
        this.append.put("completed_parameters", "false");
        this.append.put("completed_result_files", "false");
        this.append.put("completed_launch_type", "false");
        this.append.put("completed_task_type", "true");
        this.append.put("completed_submitter", "false");
        this.append.put("completed_error_message", "false");
        this.append.put("completed_engine_status", "false");
        this.append.put("ondemands_report", "true");
        this.append.put("ondemands_time", "true");
        this.append.put("ondemands_time_elapse", "false");
        this.append.put("ondemands_started_time", "true");
        this.append.put("ondemands_catalog_version", "false");
        this.append.put("background_status", "true");
        this.append.put("background_format", "true");
        this.append.put("ondemands_report_version", "false");
        this.append.put("ondemands_catalog", "false");
        this.append.put("ondemands_parameter", "false");
        this.append.put("ondemands_cancelled", "false");
        this.append.put("version_output", "true");
        this.append.put("version_number", "true");
        this.append.put("version_creator", "true");
        this.append.put("version_parameters", "true");
        this.append.put("doc_version_output", "true");
        this.append.put("doc_version_number", "true");
        this.append.put("doc_version_creator", "true");
        this.append.put("doc_version_parameters", "true");
        this.append.put("cat_version_number", "true");
        this.append.put("rpt_version_number", "true");
        this.append.put("skin_style", "Default");
        this.append.put("skin_enable_waitting_page", "true");
        this.append.put("skin_format", "standard");
        this.append.put("skin_enable_loading_statue", "true");
        this.append.put("skin_waitting_statue", "loadingxp.gif");
        this.append.put("skin_waitting_page", "waiting.jsp");
        this.append.put("skin_tip_font_family", "Tahoma");
        this.append.put("skin_tip_font_size", "11");
        this.append.put("skin_tip_font_isblod", "true");
        this.append.put("skin_tip_font_isitalic", "false");
        this.append.put("skin_tip_font_isunderline", "false");
        this.append.put("skin_statue_align", "Bottom");
        this.append.put("popup_dhtml_window", "true");
        this.append.put("only_css_style", "true");
        this.append.put("jrs.enable_to_prefer_server", "true");
        this.append.put("jrs.use_section508_compliant_page", "false");
        this.append.put("locale_nls", "en_US");
        this.append.put("enable_setting_display_language", "false");
        this.append.put("is_forced_language", "false");
        this.append.put("jrs.zip_result", "false");
        this.append.put("jrs.dhtml_resolution", String.valueOf(HeadlessHelper.getScreenResolution()));
        this.append.put("jrs.no_margin_html", "false");
        this.append.put("jrs.is_multi_files", "false");
        this.append.put("jrs.embedded_css", "false");
        this.append.put("jrs.has_hyperlink", "true");
        this.append.put("jrs.has_page_number", "true");
        this.append.put("jrs.relative_font_size", "false");
        this.append.put("jrs.drilldown", "false");
        this.append.put("jrs.use_section508_output", "false");
        this.append.put("jrs.use_html_table", "false");
        this.append.put("jrs.is_applet_chart", "true");
        this.append.put("jrs.format_chart", "0");
        this.append.put("jrs.html_resolution", String.valueOf(HeadlessHelper.getScreenResolution()));
        this.append.put("jrs.web_browser", "0");
        this.append.put("jrs.text_overflow", "1");
        this.append.put("jrs.no_margin_pdf", "false");
        this.append.put("jrs.compress_image_pdf", "20");
        this.append.put("jrs.print_mode_pdf", "false");
        this.append.put("jrs.toc_pdf", "false");
        this.append.put("jrs.drilldown_pdf", "false");
        this.append.put("jrs.pdf_encrypt", "false");
        this.append.put("jrs.pdf_sign", "false");
        this.append.put("jrs.is_wordwrap", "0");
        this.append.put("jrs.excel2000", "false");
        this.append.put("jrs.excel_layout", "true");
        this.append.put("jrs.has_shapes", "false");
        this.append.put("jrs.excel_advanced", "false");
        this.append.put("jrs.print_header", "");
        this.append.put("jrs.print_footer", "");
        this.append.put("jrs.print_gridlines", "false");
        this.append.put("jrs.is_norm_txt", "true");
        this.append.put("jrs.is_quotemark", "true");
        this.append.put("jrs.is_repeat", "false");
        this.append.put("jrs.delimiter", "");
        this.append.put("jrs.is_text_delimiter", "jrs.is_csv");
        this.append.put("jrs.txt_compress", "false");
        this.append.put("jrs.udchar_width", "");
        this.append.put("jrs.udchar_height", "");
        this.append.put("jrs.hasHeadFoot", "true");
        this.append.put("jrs.txt_windows", "true");
        this.append.put("jrs.best_editing_rtp", "false");
        this.append.put("jrs.no_margin_rtf", "false");
        this.append.put("jrs.is_only_data", "false");
        this.append.put("jrs.no_margin_ps", "false");
        this.append.put("jrs.frameapplet", "true");
        this.append.put("jrs.zip_applet_result", "false");
        this.append.put("jrs.applet_type", String.valueOf(3));
        this.append.put("jrs.pdf_compatibitly", "1");
        this.append.put("jrs.password_pdf", "");
        this.append.put("jrs.has_pdf_permis_pasw", "false");
        this.append.put("jrs.pdf_permis_pasw", "");
        this.append.put("jrs.pdf_printallow", "0");
        this.append.put("jrs.pdf_changallow", "0");
        this.append.put("jrs.pdf_check_enablecopy", "false");
        this.append.put("jrs.pdf_check_enableaccess", "true");
        this.append.put("jrs.pdf_sign_method", "0");
        this.append.put("jrs.pdf_digital_path", "");
        this.append.put("jrs.pdf_user_pasw", "");
        this.append.put("jrs.pdf_document_reson", "None");
        this.append.put("jrs.pdf_edit_yourself", "");
        this.append.put("jrs.pdf_location", "");
        this.append.put("jrs.pdf_contact_inf", "");
        this.append.put("jrs.user_last_login_time", "true");
        this.append.put("jrs.user_last_logout_time", "false");
        this.append.put("max_autocomplete_list_num", "3");
        this.append.put("jrs.enable_save_used_parameter_values", "false");
    }

    private void append(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!this.append.containsKey(string)) continue;
            properties.setProperty(string, properties2.getProperty(string));
        }
    }
}

