/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.log.ServiceLogger;

public class JRConfigurationAdvanced
implements ConfigurationAdvanced {
    private ExProperties J = new ExProperties();
    private String MIN_RESULT_LIFE = ServerEnv.getServPropName();
    private Properties QOIV = new Properties();

    public JRConfigurationAdvanced() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.J.load(this.MIN_RESULT_LIFE);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void saveProperty() {
        try {
            this.J.save(this.MIN_RESULT_LIFE, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setUserSessionTimeout(int n) {
        this.J.setProperty("server.session.timeout", n);
        this.QOIV.put("server.session.timeout", String.valueOf(n));
        this.saveProperty();
    }

    public int getUserSessionTimeout() {
        String string = (String)this.QOIV.get("server.session.timeout");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getSessionTimeout();
    }

    public void setViewReportTimeout(int n) {
        this.J.setProperty("web.timeouts.report_wait", n);
        this.QOIV.put("web.timeouts.report_wait", String.valueOf(n));
        this.saveProperty();
    }

    public int getViewReportTimeout() {
        String string = (String)this.QOIV.get("web.timeouts.report_wait");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getViewReportTimeout();
    }

    public void setAdminPort(int n) {
        this.J.setProperty("httpserver.admin.port", n);
        this.QOIV.put("httpserver.admin.port", String.valueOf(n));
        this.saveProperty();
    }

    public int getAdminPort() {
        String string = (String)this.QOIV.get("httpserver.admin.port");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getAdminPort();
    }

    public void setReportResultLife(long l) {
        l = l < ServerEnv.MIN_RESULT_LIFE ? ServerEnv.MIN_RESULT_LIFE : l;
        this.J.setProperty("resource.result.life", l);
        this.QOIV.put("resource.result.life", String.valueOf(l));
        this.saveProperty();
    }

    public long getReportResultLife() {
        String string = (String)this.QOIV.get("resource.result.life");
        if (string != null && string.trim().length() > 0) {
            long l = APIUtil.parseLong(string);
            l = l < ServerEnv.MIN_RESULT_LIFE ? ServerEnv.MIN_RESULT_LIFE : l;
            return l;
        }
        return ServerEnv.getResultLife();
    }

    public void setEnginePriority(int n) {
        this.J.setProperty("engine.priority", n);
        this.QOIV.put("engine.priority", String.valueOf(n));
        this.saveProperty();
    }

    public int getEnginePriority() {
        String string = (String)this.QOIV.get("engine.priority");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getInternalEnginePriority();
    }

    public void setEnableJSP(boolean bl) {
    }

    public boolean getEnableJSP() {
        return true;
    }

    public void setEnableSecurityCheck(boolean bl) {
        this.J.setProperty("server.security", bl);
        this.QOIV.put("server.security", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean getEnableSecurityCheck() {
        String string = (String)this.QOIV.get("server.security");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.needSecurity();
    }

    public void setEnablePublishTempToVersion(boolean bl) {
        this.J.setProperty("server.version.from.temp", bl);
        this.QOIV.put("server.version.from.temp", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean getEnablePublishTempToVersion() {
        String string = (String)this.QOIV.get("server.version.from.temp");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isPublishTempToVersion();
    }

    public void setConnectionKeepAlive(boolean bl) {
        this.J.setProperty("server.connection.keepalive", bl);
        this.QOIV.put("server.connection.keepalive", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean getConnectionKeepAlive() {
        String string = (String)this.QOIV.get("server.connection.keepalive");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.keepAlive();
    }

    public void setScheduleShouldRun(boolean bl) {
        this.J.setProperty("server.schedule_should_run", bl);
        this.QOIV.put("server.schedule_should_run", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean getScheduleShouldRun() {
        String string = (String)this.QOIV.get("server.schedule_should_run");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.shouldSchedule();
    }

    public void setEngineDefaultLanguage(String string) {
        this.J.setProperty("engine.default_language", string);
        this.QOIV.put("engine.default_language", String.valueOf(string));
        this.saveProperty();
    }

    public String getEngineDefaultLanguage() {
        String string = (String)this.QOIV.get("engine.default_language");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getEngineDefaultLanguage();
    }

    public void setMaxCompletedRecordCount(int n) {
        this.J.setProperty("server.completed.max_count", n);
        this.QOIV.put("server.completed.max_count", String.valueOf(n));
        this.saveProperty();
    }

    public int getMaxCompletedRecordCount() {
        String string = (String)this.QOIV.get("server.completed.max_count");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMaxCompletedRecordCount();
    }

    public boolean isEnableMultipleLogin() {
        String string = (String)this.QOIV.get("server.enableMultipleLogin");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableMultipleLogin();
    }

    public void setEnableMultipleLogin(boolean bl) {
        this.J.setProperty("server.enableMultipleLogin", bl);
        this.QOIV.put("server.enableMultipleLogin", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean isEnableDynamicResource() {
        String string = (String)this.QOIV.get("server.enableDynamicResource");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableDynamicResource();
    }

    public void setEnableDynamicResource(boolean bl) {
        this.J.setProperty("server.enableDynamicResource", bl);
        this.QOIV.put("server.enableDynamicResource", String.valueOf(bl));
        this.saveProperty();
    }

    public void setEnableRoleBasedAuthorization(boolean bl) {
        this.J.setProperty("server.rolebased.authorization", bl);
        this.QOIV.put("server.rolebased.authorization", String.valueOf(bl));
        this.saveProperty();
    }

    public void setEnableDisplayUserPermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.user", bl);
        this.QOIV.put("server.ui.set_permissions.user", String.valueOf(bl));
        this.saveProperty();
    }

    public void setEnableDisplayRolePermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.role", bl);
        this.QOIV.put("server.ui.set_permissions.role", String.valueOf(bl));
        this.saveProperty();
    }

    public void setEnableDisplayGroupPermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.group", bl);
        this.QOIV.put("server.ui.set_permissions.group", String.valueOf(bl));
        this.saveProperty();
    }

    public boolean isEnableRoleBasedAuthorization() {
        String string = (String)this.QOIV.get("server.rolebased.authorization");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableRoleBasedAuthorization();
    }

    public boolean isEnableDispalyUserPermissionUI() {
        String string = (String)this.QOIV.get("server.ui.set_permissions.user");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableDispalyUserPermissionUI();
    }

    public boolean isEnableDispalyRolePermissionUI() {
        String string = (String)this.QOIV.get("server.ui.set_permissions.role");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableDispalyRolePermissionUI();
    }

    public boolean isEnableDispalyGroupPermissionUI() {
        String string = (String)this.QOIV.get("server.ui.set_permissions.group");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableDispalyGroupPermissionUI();
    }

    public int getPermissionAlgorithmType() {
        String string = (String)this.QOIV.get("server.permission.algorithm");
        if (string != null && string.trim().length() > 0) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 6);
            }
        }
        return ServerEnv.getPermissionAlgorithmType();
    }

    public void setPermissionAlgorithmType(int n) {
        if (n != 0 && n != 1) {
            n = 0;
        }
        this.J.setProperty("server.permission.algorithm", n);
        this.QOIV.put("server.permission.algorithm", String.valueOf(n));
        this.saveProperty();
    }

    public boolean isEnableTaskDuration() {
        String string = (String)this.QOIV.get("task.duration.enable");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableTaskDuration();
    }

    public void setEnableTaskDuration(boolean bl) {
        this.J.setProperty("task.duration.enable", bl);
        this.QOIV.put("task.duration.enable", String.valueOf(bl));
        this.saveProperty();
    }

    public int getTaskDurationCheckPeriod() {
        String string = (String)this.QOIV.get("task.duration.check_cycle");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getTimeoutsCheckCycle();
    }

    public void setTaskDurationCheckPeriod(int n) {
        this.J.setProperty("task.duration.check_cycle", n);
        this.QOIV.put("task.duration.check_cycle", String.valueOf(n));
        this.saveProperty();
    }

    public boolean isEnableLinkedCatalog() {
        String string = (String)this.QOIV.get("server.resource.enable_linked_catalog");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isEnableLinkedCatalog();
    }

    public void setEnableLinkedCatalog(boolean bl) {
        this.J.setProperty("server.resource.enable_linked_catalog", bl);
        this.QOIV.put("server.resource.enable_linked_catalog", String.valueOf(bl));
        this.saveProperty();
    }

    public String getLinkedCatalog() {
        String string = (String)this.QOIV.get("server.resource.linked_catalog");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getLinkedCatalog();
    }

    public void setLinkedCatalog(String string) {
        if (string == null) {
            this.J.remove("server.resource.linked_catalog");
            this.QOIV.remove("server.resource.linked_catalog");
        } else {
            this.J.setProperty("server.resource.linked_catalog", string);
            this.QOIV.put("server.resource.linked_catalog", string);
        }
        this.saveProperty();
    }

    public boolean isPromptTaskQueueFull() {
        String string = (String)this.QOIV.get("web.prompt.taskqueue_full");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isPromptTaskQueueFull();
    }

    public boolean isPromptActionQueueFull() {
        String string = (String)this.QOIV.get("web.prompt.actionqueue_full");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isPromptActionQueueFull();
    }

    public void setPromptTaskQueueFull(boolean bl) {
        this.J.setProperty("web.prompt.taskqueue_full", bl);
        this.QOIV.put("web.prompt.taskqueue_full", String.valueOf(bl));
        this.saveProperty();
    }

    public void setPromptActionQueueFull(boolean bl) {
        this.J.setProperty("web.prompt.actionqueue_full", bl);
        this.QOIV.put("web.prompt.actionqueue_full", String.valueOf(bl));
        this.saveProperty();
    }
}

