/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationCache;
import jet.server.log.ServiceLogger;
import jet.server.util.ResourceConvertor;
import jet.web.dhtml.DHTMLClientService;
import jet.web.dhtml.DHTMLServiceFactory;

public class JRConfigurationCache
implements ConfigurationCache {
    private ExProperties QOIV = null;
    private String add = null;
    private Hashtable addElement = new Hashtable(2);
    private Hashtable append = new Hashtable(2);
    private HashSet appendAnImage = new HashSet(2);
    private Hashtable cacheCatalogs = new Hashtable(2);
    public static Hashtable resources = new Hashtable(2);

    public JRConfigurationCache() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.QOIV = ServerEnv.getServerProps();
            this.QOIV();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.add = ServerEnv.getServPropName();
    }

    private void QOIV() {
        String string;
        String string2;
        StringTokenizer stringTokenizer;
        String string3 = this.QOIV.getProperty("performance.preloadedcats");
        if (string3 != null && string3.trim().length() > 0) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string = (String)resources.get(string2);
                this.addElement.put(string == null ? string2 : string, string2);
            }
        }
        if ((string3 = this.QOIV.getProperty("performance.preloadedrpts")) != null && string3.trim().length() > 0) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.endsWith(")")) {
                    string2 = string2 + "(None)";
                }
                this.append.put((string = (String)resources.get(string2)) == null ? string2 : string, string2);
            }
        }
    }

    public void saveProperties() {
        try {
            this.QOIV.save(this.add, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setEnableCacheCatelog(boolean bl) {
        this.QOIV.setProperty("performance.cachecat", bl);
        ServerEnv.enginePerform.cacheLoadedCatalogs(bl);
    }

    public boolean getEnableCacheCatelog() {
        return this.QOIV.getProperty("performance.cachecat", true);
    }

    public void setEnableCacheReport(boolean bl) {
        this.QOIV.setProperty("performance.cacherpt", bl);
        ServerEnv.enginePerform.cacheLoadedReports(bl);
    }

    public boolean getEnableCacheReport() {
        return this.QOIV.getProperty("performance.cacherpt", true);
    }

    public void setEnableCacheImage(boolean bl) {
        this.QOIV.setProperty("performance.cacheimg", bl);
        ServerEnv.imageCacher.setEnableStatus(bl);
    }

    public boolean getEnableCacheImage() {
        return this.QOIV.getProperty("performance.cacheimg", true);
    }

    public boolean getDisplayImageDetail() {
        return this.QOIV.getProperty("performance.showimgdetail", true);
    }

    public void setDisplayImageDetail(boolean bl) {
        this.QOIV.setProperty("performance.showimgdetail", bl);
    }

    public void setMaxCacheCatalogSize(int n) {
        this.QOIV.setProperty("performance.catpoolsize", n);
        ServerEnv.enginePerform.setCatCacheSize(n);
    }

    public int getMaxCacheCatalogSize() {
        return this.QOIV.getProperty("performance.catpoolsize", 10);
    }

    public void setMaxCacheReportSize(int n) {
        this.QOIV.setProperty("performance.rptpoolsize", n);
        ServerEnv.enginePerform.setRptCacheSize(n);
    }

    public int getMaxCacheReportSize() {
        return this.QOIV.getProperty("performance.rptpoolsize", 10);
    }

    public void setMaxCacheImageSize(int n) {
        this.QOIV.setProperty("performance.imgpoolsize", n);
        ServerEnv.imageCacher.setCacheSize(0x100000L * (long)n);
    }

    public int getMaxCacheImageSize() {
        return this.QOIV.getProperty("performance.imgpoolsize", 10);
    }

    public boolean setCachedCatalogs(Vector vector) {
        Hashtable hashtable = ServerEnv.enginePerform.cacheCatalogs(vector);
        return hashtable == null || hashtable.size() <= 0;
    }

    private String add(String string, String string2) {
        String string3 = (String)this.cacheCatalogs.get(string2);
        if (string3 != null) {
            return string3;
        }
        if (string2.startsWith("/")) {
            string3 = ResourceConvertor.getInstance().getLatestCatRealPath(string, string2);
            this.cacheCatalogs.put(string2, string3);
        } else {
            string3 = string2;
        }
        return string3;
    }

    public Vector getCachedImages() {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = ServerEnv.imageCacher.getCachedImages();
        int n = 0;
        while (n < fileArray.length) {
            vector.addElement(fileArray[n]);
            ++n;
        }
        return vector;
    }

    public void appendImage(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        File file = new File(string4);
        String string5 = file.getParent();
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        File file2 = new File(string5 + string2);
        this.appendAnImage.add(file2.getAbsolutePath());
        ServerEnv.imageCacher.appendAnImage(file, file2);
    }

    public void removeImage(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        this.appendAnImage.remove(string4);
        File file = new File(string4);
        ServerEnv.imageCacher.removeAnImage(file, string2);
    }

    public void removeAllImages() {
        this.appendAnImage.removeAll(this.appendAnImage);
        ServerEnv.imageCacher.removeAllImages();
    }

    public String getImageBelongedCatalog(String string) {
        File file = ServerEnv.imageCacher.getImageBelongedCatalog(new File(string));
        if (file != null) {
            String string2 = file.getAbsolutePath();
            if (this.appendAnImage.contains(string)) {
                Iterator iterator = this.cacheCatalogs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!entry.getValue().equals(string2)) continue;
                    string2 = (String)entry.getKey();
                    break;
                }
            }
            return string2;
        }
        return "";
    }

    public boolean lockCachedImage(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        File file = new File(string4);
        return ServerEnv.imageCacher.lockAnImage(file, string2);
    }

    public boolean unlockCachedImage(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        File file = new File(string4);
        return ServerEnv.imageCacher.unlockAnImage(file, string2);
    }

    public boolean isLockedImage(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        File file = new File(string4);
        return ServerEnv.imageCacher.isLockedImage(file, string2);
    }

    public boolean isCacheAllImages() {
        return this.QOIV.getProperty("performance.cacheallimg", true);
    }

    public void setCacheAllImages(boolean bl) {
        this.QOIV.setProperty("performance.cacheallimg", bl);
        if (bl) {
            ServerEnv.imageCacher.setCacheAll();
        }
    }

    public long getUsedImageCacheSize() {
        long l = ServerEnv.imageCacher.getUsedCacheSize();
        if (l <= 0L) {
            return 0L;
        }
        return l;
    }

    public long getAnImageSize(String string, String string2, String string3) {
        String string4 = this.add(string3, string);
        File file = new File(string4);
        return ServerEnv.imageCacher.getAnImageSize(file, string2);
    }

    public boolean setCachedCatalogs(String string, Vector vector) {
        Vector vector2 = this.addElement(string, vector);
        Hashtable hashtable = ServerEnv.enginePerform.cacheCatalogs(vector2);
        return hashtable == null || hashtable.size() <= 0;
    }

    public Vector getCachedCatalogs() {
        Vector<String> vector = null;
        Vector vector2 = ServerEnv.enginePerform.getCachedCatNames();
        if (vector2 != null) {
            int n = vector2.size();
            vector = new Vector<String>(4);
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(vector2.elementAt(n2).toString());
                ++n2;
            }
        }
        return this.appendAnImage(vector);
    }

    public boolean setCachedReports(Vector vector) {
        Hashtable hashtable = ServerEnv.enginePerform.cacheReports(vector);
        return hashtable == null || hashtable.size() <= 0;
    }

    public boolean setCachedReportsWithStyles(Vector vector) {
        Hashtable hashtable = ServerEnv.enginePerform.cacheReportsWithStls(vector);
        return hashtable == null || hashtable.size() <= 0;
    }

    public boolean setCachedReportsWithStyles(String string, Vector vector) {
        Vector vector2 = this.append(string, vector);
        Hashtable hashtable = ServerEnv.enginePerform.cacheReportsWithStls(vector2);
        return hashtable == null || hashtable.size() <= 0;
    }

    public Vector getCachedReports() {
        Vector<String> vector = null;
        Vector vector2 = ServerEnv.enginePerform.getCachedRptNames();
        if (vector2 != null) {
            int n = vector2.size();
            vector = new Vector<String>(4);
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(vector2.elementAt(n2).toString());
                ++n2;
            }
        }
        return this.cacheCatalogs(vector);
    }

    public Vector getCachedReportsWithStyles() {
        Vector<String> vector = null;
        Vector vector2 = ServerEnv.enginePerform.getCachedRptNamesWithStls();
        if (vector2 != null) {
            int n = vector2.size();
            vector = new Vector<String>(4);
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(vector2.elementAt(n2).toString());
                ++n2;
            }
        }
        return this.cacheCatalogs(vector);
    }

    public void unloadCatalogs(Vector vector) {
        ServerEnv.enginePerform.uncacheCatalogs(vector);
    }

    public void unloadCatalogs(String string, Vector vector) {
        Vector vector2 = this.addElement(string, vector);
        ServerEnv.enginePerform.uncacheCatalogs(vector2);
    }

    public void unloadReports(Vector vector) {
        ServerEnv.enginePerform.uncacheReports(vector);
    }

    public void unloadReportsWithStyles(Vector vector) {
        ServerEnv.enginePerform.uncacheReportsWithStls(vector);
    }

    public void unloadReportsWithStyles(String string, Vector vector) {
        Vector vector2 = this.append(string, vector);
        ServerEnv.enginePerform.uncacheReportsWithStls(vector2);
    }

    public void setSecurityUserCacheSize(int n) {
        this.QOIV.setProperty("server.security.user.cache.size", n);
    }

    public int getSecurityUserCacheSize() {
        return this.QOIV.getProperty("server.security.user.cache.size", 1000);
    }

    public void setSecurityRoleCacheSize(int n) {
        this.QOIV.setProperty("server.security.role.cache.size", n);
    }

    public int getSecurityRoleCacheSize() {
        return this.QOIV.getProperty("server.security.role.cache.size", 50);
    }

    public void setSecurityGroupCacheSize(int n) {
        this.QOIV.setProperty("server.security.group.cache.size", n);
    }

    public int getSecurityGroupCacheSize() {
        return this.QOIV.getProperty("server.security.group.cache.size", 50);
    }

    public void setSecurityProtectionCacheSize(int n) {
        this.QOIV.setProperty("server.security.protection.cache.size", n);
    }

    public int getSecurityProectionCacheSize() {
        return this.QOIV.getProperty("server.security.protection.cache.size", 100);
    }

    private Vector addElement(String string, Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string2 = ResourceConvertor.getInstance().getCatRealPath(string, (String)vector.elementAt(n));
            this.addElement.put(string2, (String)vector.elementAt(n));
            vector2.add(string2);
            ++n;
        }
        return vector2;
    }

    private Vector append(String string, Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string2 = ResourceConvertor.getInstance().getRptRealPath(string, (String)vector.elementAt(n));
            this.append.put(string2, (String)vector.elementAt(n));
            vector2.add(string2);
            ++n;
        }
        return vector2;
    }

    private Vector appendAnImage(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = (String)this.addElement.get(string);
            if (string2 != null) {
                vector2.add(string2);
            } else {
                vector2.add(string);
                this.addElement.put(string, string);
            }
            ++n;
        }
        return vector2;
    }

    private Vector cacheCatalogs(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = (String)this.append.get(string);
            if (string2 != null) {
                vector2.add(string2);
            } else {
                vector2.add(string);
                this.addElement.put(string, string);
            }
            ++n;
        }
        return vector2;
    }

    public int getEngineSortBufferSize() {
        return this.QOIV.getProperty("engine.sort.buffer_size", -1);
    }

    public void setEngineSortBufferSize(int n) {
        this.QOIV.setProperty("engine.sort.buffer_size", n);
        DHTMLClientService dHTMLClientService = DHTMLServiceFactory.getDHTMLClientService();
        dHTMLClientService.notify_change_engine_dosort_buffer_size(n);
    }
}

