/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationCluster;
import jet.server.log.ServiceLogger;

public class JRConfigurationCluster
implements ConfigurationCluster {
    private ExProperties QOIV = new ExProperties();
    private String equalsIgnoreCase = ServerEnv.getServPropName();
    private Properties get = new Properties();

    public JRConfigurationCluster() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.QOIV.load(this.equalsIgnoreCase);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isClusterAdminServer() {
        String string = (String)this.get.get("cluster.server.admin");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isClusterAdminServer();
    }

    public void setClusterAdminServer(boolean bl) {
        try {
            this.QOIV.load(this.equalsIgnoreCase);
            this.QOIV.setProperty("cluster.server.admin", bl);
            this.get.put("cluster.server.admin", String.valueOf(bl));
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isClusterBackupServer() {
        String string = (String)this.get.get("cluster.server.backup");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.isClusterBackupServer();
    }

    public void setClusterBackupServer(boolean bl) {
        try {
            this.QOIV.setProperty("cluster.server.backup", bl);
            this.get.put("cluster.server.backup", String.valueOf(bl));
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getClusterAdminHost() {
        String string = (String)this.get.get("cluster.admin.rmi.host");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getClusterAdminHost();
    }

    public void setClusterAdminHost(String string) {
        try {
            this.QOIV.setProperty("cluster.admin.rmi.host", string);
            this.get.put("cluster.admin.rmi.host", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getClusterAdminRMIPort() {
        String string = (String)this.get.get("cluster.admin.rmi.port");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        try {
            string = (String)ServerEnv.getServerProps().get("cluster.admin.rmi.port");
            if (string != null && string.trim().length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return ServerEnv.getClusterAdminRMIPort();
    }

    public void setClusterAdminRMIPort(String string) {
        try {
            this.QOIV.setProperty("cluster.admin.rmi.port", string);
            this.get.put("cluster.admin.rmi.port", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getServerRMIPort() {
        String string = (String)this.get.get("server.rmi.port");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getServerRMIPort();
    }

    public void setServerRMIPort(String string) {
        try {
            this.QOIV.setProperty("server.rmi.port", string);
            this.get.put("server.rmi.port", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getSharePropertyDirectory() {
        String string = (String)this.get.get("resource.share.properties.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getSharePropertyDirectory();
    }

    public void setSharePropertyDirectory(String string) {
        try {
            this.QOIV.setProperty("resource.share.properties.dir", string);
            this.get.put("resource.share.properties.dir", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getShareRealmDirectory() {
        String string = (String)this.get.get("resource.share.realm.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareRealmDirectory();
    }

    public void setShareRealmDirectory(String string) {
        try {
            this.QOIV.setProperty("resource.share.realm.dir", string);
            this.get.put("resource.share.realm.dir", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getClusterResourceRoot() {
        String string = (String)this.get.get("resource.root");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getClusterResourceRoot();
    }

    public void setClusterResourceRoot(String string) {
        try {
            this.QOIV.setProperty("resource.root", string);
            this.get.put("resource.root", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getShareTempDirectory() {
        String string = (String)this.get.get("resource.share.temp.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareTempDirectory();
    }

    public void setShareTempDirectory(String string) {
        try {
            this.QOIV.setProperty("resource.share.temp.dir", string);
            this.get.put("resource.share.temp.dir", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getShareDsoDirectory() {
        return "";
    }

    public void setShareDsoDirectory(String string) {
    }

    public String getShareHistoryDirectory() {
        String string = (String)this.get.get("resource.share.hist.dir");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getShareHistoryDirectory();
    }

    public void setShareHistoryDirectory(String string) {
        try {
            this.QOIV.setProperty("resource.share.hist.dir", string);
            this.get.put("resource.share.hist.dir", string);
            this.QOIV.save(this.equalsIgnoreCase, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

