/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationLDAP;
import jet.server.api.admin.cfg.SynchronizationResult;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityProvider;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.SynchronizationResultImpl;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;

public class JRConfigurationLDAP
implements ConfigurationLDAP {
    private LDAPManager QOIV = UserDataToolkit.getLdapManager();
    private SecurityService add;
    private SecurityProvider addElement;
    private boolean addLDAPGroup = false;

    public JRConfigurationLDAP() {
        String string = ServerEnv.getActiveRealm();
        this.add = UserDataToolkit.getSecurityService(string);
        this.addElement = UserDataToolkit.getSecurityProvider(string);
    }

    public Enumeration getLdapSynchronization() {
        return null;
    }

    public Enumeration getUserNames() {
        Vector vector = new Vector();
        if (!this.QOIV.isLDAPEnable()) {
            return vector.elements();
        }
        try {
            vector = this.QOIV.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
            vector2.add(lDAPUser.getName());
        }
        return vector2.elements();
    }

    public boolean importLDAPGroupsAndUsers() {
        return false;
    }

    public boolean checkSynchronization() {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        this.synchronize();
        return true;
    }

    public void setEncryptedUserAuthInfo(String string, String string2) {
    }

    public Vector listExistedUsers() {
        Vector vector;
        Vector<LDAPUser> vector2 = new Vector<LDAPUser>();
        if (!this.QOIV.isLDAPEnable()) {
            return vector2;
        }
        try {
            vector = this.QOIV.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector2;
        }
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = this.addElement.getImportedLDAPUserNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("admin") || string.equals("guest")) continue;
            int n = 0;
            while (n < vector.size()) {
                LDAPUser lDAPUser = (LDAPUser)vector.get(n);
                if (lDAPUser.getName().equalsIgnoreCase(string)) {
                    vector2.addElement(lDAPUser);
                }
                ++n;
            }
        }
        return vector2;
    }

    public Vector listExistedGroups() {
        Vector vector;
        Vector<LDAPGroup> vector2 = new Vector<LDAPGroup>();
        if (!this.QOIV.isLDAPEnable()) {
            return vector2;
        }
        try {
            vector = this.QOIV.getAllLDAPGroups();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return vector2;
        }
        if (vector == null) {
            return null;
        }
        if (this.QOIV.isImportToRole()) {
            Enumeration enumeration = this.add.getAllRoles().elements();
            while (enumeration.hasMoreElements()) {
                Role role = (Role)enumeration.nextElement();
                if (role.getName().equals("administrators") || role.getName().equals("everyone")) continue;
                int n = 0;
                while (n < vector.size()) {
                    LDAPGroup lDAPGroup = (LDAPGroup)vector.get(n);
                    if (lDAPGroup.getName().equalsIgnoreCase(role.getName())) {
                        vector2.addElement(lDAPGroup);
                    }
                    ++n;
                }
            }
        } else {
            Enumeration enumeration = this.add.getAllGroups().elements();
            while (enumeration.hasMoreElements()) {
                Group group = (Group)enumeration.nextElement();
                int n = 0;
                while (n < vector.size()) {
                    LDAPGroup lDAPGroup = (LDAPGroup)vector.get(n);
                    if (lDAPGroup.getName().equalsIgnoreCase(group.getName())) {
                        vector2.addElement(lDAPGroup);
                    }
                    ++n;
                }
            }
        }
        return vector2;
    }

    public Vector listExistedUserNames() {
        return null;
    }

    public String listExistedUserFullName(String string) {
        return null;
    }

    public Vector listExistedGroupsName() {
        return null;
    }

    public String listExistedGroupDescriptions(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importLDAPUsers(boolean bl) {
        block10: {
            boolean bl2;
            block9: {
                try {
                    try {
                        Vector vector;
                        if (this.addLDAPGroup || !this.QOIV.isLDAPEnable()) {
                            boolean bl3 = false;
                            Object var6_5 = null;
                            this.addLDAPGroup = false;
                            return bl3;
                        }
                        this.addLDAPGroup = true;
                        try {
                            vector = this.QOIV.getAllLDAPUsers();
                        }
                        catch (NamingException namingException) {
                            ServiceLogger.logError(namingException);
                            this.addLDAPGroup = false;
                            boolean bl4 = false;
                            Object var6_6 = null;
                            this.addLDAPGroup = false;
                            return bl4;
                        }
                        if (vector == null || vector.size() == 0) {
                            ServiceLogger.logDebug(6660217, 6);
                            this.addLDAPGroup = false;
                            bl2 = false;
                            break block9;
                        }
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            LDAPUser lDAPUser = (LDAPUser)enumeration.nextElement();
                            this.addElement.addLDAPUser(lDAPUser, bl);
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        this.addLDAPGroup = false;
                        boolean bl5 = false;
                        Object var6_9 = null;
                        this.addLDAPGroup = false;
                        return bl5;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this.addLDAPGroup = false;
                    throw throwable;
                }
            }
            Object var6_7 = null;
            this.addLDAPGroup = false;
            return bl2;
        }
        Object var6_8 = null;
        this.addLDAPGroup = false;
        this.addLDAPGroup = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importSpecifyLDAPUsers(Vector vector, boolean bl) {
        block10: {
            boolean bl2;
            block9: {
                if (this.addLDAPGroup || !this.QOIV.isLDAPEnable()) {
                    return false;
                }
                try {
                    try {
                        this.addLDAPGroup = true;
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            LDAPUser lDAPUser;
                            String string = (String)enumeration.nextElement();
                            try {
                                lDAPUser = this.QOIV.getLDAPUser(string);
                            }
                            catch (NamingException namingException) {
                                ServiceLogger.logError(namingException);
                                this.addLDAPGroup = false;
                                boolean bl3 = false;
                                Object var9_13 = null;
                                this.addLDAPGroup = false;
                                return bl3;
                            }
                            if (lDAPUser == null) {
                                this.addLDAPGroup = false;
                                ServiceLogger.logError("The ldap user: " + string + " does not exist!");
                                boolean bl4 = false;
                                Object var9_14 = null;
                                this.addLDAPGroup = false;
                                return bl4;
                            }
                            String string2 = null;
                            if (lDAPUser == null || (string2 = this.addElement.addLDAPUser(lDAPUser, bl)) == null) continue;
                            this.addLDAPGroup = false;
                            bl2 = false;
                            break block9;
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                        exception.printStackTrace();
                        this.addLDAPGroup = false;
                        boolean bl5 = false;
                        Object var9_17 = null;
                        this.addLDAPGroup = false;
                        return bl5;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_18 = null;
                    this.addLDAPGroup = false;
                    throw throwable;
                }
            }
            Object var9_15 = null;
            this.addLDAPGroup = false;
            return bl2;
        }
        Object var9_16 = null;
        this.addLDAPGroup = false;
        this.addLDAPGroup = false;
        return true;
    }

    public boolean importLDAPRoles(boolean bl) {
        return this.importLDAPGroups(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importLDAPGroups(boolean bl) {
        if (this.addLDAPGroup || !this.QOIV.isLDAPEnable()) {
            return false;
        }
        try {
            try {
                Object object;
                Object object2;
                Hashtable hashtable;
                Hashtable hashtable2;
                this.addLDAPGroup = true;
                try {
                    hashtable2 = this.QOIV.getAllLDAPGroupsHT();
                    hashtable = this.QOIV.getAllLDAPUsersHT();
                }
                catch (NamingException namingException) {
                    ServiceLogger.logError(namingException);
                    this.addLDAPGroup = false;
                    boolean bl2 = false;
                    Object var20_9 = null;
                    this.addLDAPGroup = false;
                    return bl2;
                }
                boolean bl3 = this.QOIV.isImportToRole();
                Enumeration enumeration = hashtable2.elements();
                Hashtable<Object, LDAPUser> hashtable3 = new Hashtable<Object, LDAPUser>();
                Hashtable<Object, LDAPUser> hashtable4 = new Hashtable<Object, LDAPUser>();
                Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
                while (enumeration.hasMoreElements()) {
                    object2 = (LDAPGroup)enumeration.nextElement();
                    object = this.addElement.addLDAPGroup((LDAPGroup)object2, bl3);
                    if (object != null) {
                        ServiceLogger.logDebug((String)object);
                        continue;
                    }
                    hashtable5.put(object2.getName(), object2);
                }
                object2 = hashtable5.elements();
                while (object2.hasMoreElements()) {
                    String string;
                    Object object3;
                    object = (LDAPGroup)object2.nextElement();
                    String string2 = object.getName();
                    Vector vector = object.getUserNames();
                    int n = 0;
                    while (n < vector.size()) {
                        object3 = (String)vector.elementAt(n);
                        LDAPUser lDAPUser = (LDAPUser)hashtable.get(object3);
                        if (lDAPUser != null) {
                            if (!hashtable3.containsKey(object3) && !hashtable4.containsKey(object3)) {
                                string = this.addElement.addLDAPUser(lDAPUser, bl);
                                if (string == null) {
                                    hashtable3.put(object3, lDAPUser);
                                } else {
                                    hashtable4.put(object3, lDAPUser);
                                }
                            }
                            if (hashtable3.containsKey(object3) && !hashtable4.containsKey(object3)) {
                                try {
                                    if (bl3) {
                                        this.addElement.addSubUserToRole((String)object3, string2);
                                    } else {
                                        this.addElement.addUserToGroup((String)object3, string2);
                                    }
                                }
                                catch (NoSuchRoleException noSuchRoleException) {
                                    ServiceLogger.logError(noSuchRoleException);
                                    break;
                                }
                                catch (NoSuchUserException noSuchUserException) {
                                }
                                catch (NoSuchGroupException noSuchGroupException) {
                                    ServiceLogger.logError(noSuchGroupException);
                                    break;
                                }
                            }
                        }
                        ++n;
                    }
                    object3 = object.getSubGroupNames();
                    int n2 = 0;
                    while (n2 < ((Vector)object3).size()) {
                        string = (String)((Vector)object3).elementAt(n2);
                        if (hashtable5.containsKey(string)) {
                            try {
                                if (bl3) {
                                    this.addElement.addSubRoleToRole(string, string2);
                                } else {
                                    this.addElement.addSubGroupToGroup(string, string2);
                                }
                            }
                            catch (NoSuchRoleException noSuchRoleException) {
                            }
                            catch (NoSuchGroupException noSuchGroupException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                this.addLDAPGroup = false;
                Object var20_11 = null;
                this.addLDAPGroup = false;
            }
            Object var20_10 = null;
            this.addLDAPGroup = false;
        }
        catch (Throwable throwable) {
            Object var20_12 = null;
            this.addLDAPGroup = false;
            throw throwable;
        }
        this.addLDAPGroup = false;
        return true;
    }

    public boolean importSpecifyLDAPRoles(Vector vector, boolean bl) {
        return this.importSpecifyLDAPGroups(vector, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importSpecifyLDAPGroups(Vector vector, boolean bl) {
        if (this.addLDAPGroup || !this.QOIV.isLDAPEnable()) {
            return false;
        }
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                this.addLDAPGroup = true;
                Enumeration enumeration = vector.elements();
                boolean bl2 = this.QOIV.isImportToRole();
                Hashtable<String, LDAPUser> hashtable = new Hashtable<String, LDAPUser>();
                Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
                block13: while (enumeration.hasMoreElements()) {
                    object3 = (String)enumeration.nextElement();
                    try {
                        object2 = this.QOIV.getLDAPGroup((String)object3);
                    }
                    catch (NamingException namingException) {
                        ServiceLogger.logError(namingException);
                        this.addLDAPGroup = false;
                        boolean bl3 = false;
                        Object var18_25 = null;
                        this.addLDAPGroup = false;
                        return bl3;
                    }
                    if (object2[0] == null || ((Vector)object2[0]).size() != 1) {
                        ServiceLogger.logDebug(6660218, object3, 6);
                        continue;
                    }
                    object = (LDAPGroup)((Vector)object2[0]).firstElement();
                    String string = this.addElement.addLDAPGroup((LDAPGroup)object, bl2);
                    if (string != null) {
                        ServiceLogger.logDebug(string);
                        continue;
                    }
                    hashtable2.put(object3, object);
                    if (object2[1] == null || ((Vector)object2[1]).size() == 0) continue;
                    int n = 0;
                    while (n < ((Vector)object2[1]).size()) {
                        LDAPUser lDAPUser = (LDAPUser)((Vector)object2[1]).elementAt(n);
                        String string2 = lDAPUser.getName();
                        if (!hashtable.containsKey(string2)) {
                            this.addElement.addLDAPUser(lDAPUser, bl);
                            hashtable.put(string2, lDAPUser);
                        }
                        try {
                            if (bl2) {
                                this.addElement.addSubUserToRole(string2, (String)object3);
                            } else {
                                this.addElement.addUserToGroup(string2, (String)object3);
                            }
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                            ServiceLogger.logError(noSuchRoleException);
                            continue block13;
                        }
                        catch (NoSuchUserException noSuchUserException) {
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                            // empty catch block
                        }
                        ++n;
                    }
                }
                object3 = hashtable2.elements();
                while (object3.hasMoreElements()) {
                    object2 = (LDAPGroup)object3.nextElement();
                    object = object2.getSubGroupNames();
                    int n = 0;
                    while (n < ((Vector)object).size()) {
                        String string = (String)((Vector)object).elementAt(n);
                        if (hashtable2.containsKey(string)) {
                            try {
                                if (bl2) {
                                    this.addElement.addSubRoleToRole(string, object2.getName());
                                } else {
                                    this.addElement.addSubGroupToGroup(string, object2.getName());
                                }
                            }
                            catch (NoSuchRoleException noSuchRoleException) {
                            }
                            catch (NoSuchGroupException noSuchGroupException) {
                                // empty catch block
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                this.addLDAPGroup = false;
                Object var18_27 = null;
                this.addLDAPGroup = false;
            }
            Object var18_26 = null;
            this.addLDAPGroup = false;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            this.addLDAPGroup = false;
            throw throwable;
        }
        this.addLDAPGroup = false;
        return true;
    }

    public boolean importAllLDAPUsersAndGroups(boolean bl) {
        if (this.importLDAPUsers(bl)) {
            return this.importLDAPGroups(bl);
        }
        return false;
    }

    public Vector getLDAPUsers() {
        if (!this.QOIV.isLDAPEnable()) {
            return new Vector();
        }
        try {
            return this.QOIV.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    public Vector getLDAPGroups() {
        if (!this.QOIV.isLDAPEnable()) {
            return new Vector();
        }
        try {
            return this.QOIV.getAllLDAPGroups();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    public Vector getEncryptedUsers() {
        return null;
    }

    public String testRoleMap(String string, String string2) {
        if (!this.QOIV.isLDAPEnable()) {
            return "LDAP support is disable!";
        }
        try {
            this.add.getRole(string2);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return JSvrResource.getMessage("SECURITY_ERR_13_ROLE_NOT_EXIST", string2);
        }
        return this.QOIV.testFilter(string);
    }

    public String autoImportLDAPUser(String string, String string2) {
        String string3;
        LDAPUser lDAPUser;
        if (!this.QOIV.isLDAPEnable()) {
            return "LDAP support is disable!";
        }
        try {
            lDAPUser = this.QOIV.getLDAPUser(string);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return JSvrResource.getMessage("SECURITY_ERR_61_LDAP_NOT_GET_USER", string);
        }
        if (lDAPUser == null) {
            return JSvrResource.getMessage("SECURITY_ERR_61_LDAP_NOT_GET_USER", string);
        }
        boolean bl = this.QOIV.isValidLdapUser(string, string2);
        if (!bl) {
            string3 = lDAPUser.getProperty("ldapuser_dn");
            bl = this.QOIV.isValidLdapUserByDN(string, string3, string2);
        }
        if (!bl) {
            return JSvrResource.getMessage("SECURITY_ERR_60_LDAP_NOT_VALID_USER", string);
        }
        string3 = this.addElement.addLDAPUser(lDAPUser, false);
        if (string3 != null) {
            return string3;
        }
        if (this.QOIV.isImportToRole()) {
            Object object;
            Vector vector;
            try {
                vector = this.QOIV.getLDAPGroupsNameByUser(string);
                object = this.addElement.getImportedLDAPRoleNames();
                int n = 0;
                while (n < ((Vector)object).size()) {
                    String string4 = (String)((Vector)object).elementAt(n);
                    if (vector.contains(string4)) {
                        try {
                            this.addElement.addSubUserToRole(string, string4);
                        }
                        catch (NoSuchRoleException noSuchRoleException) {
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                        }
                    }
                    ++n;
                }
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
            }
            vector = this.QOIV.getRoleNamsByFilter(string);
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                try {
                    this.addElement.addSubUserToRole(string, string5);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (NoSuchUserException noSuchUserException) {
                    return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                }
            }
        } else {
            Object object;
            Vector vector;
            try {
                vector = this.QOIV.getLDAPGroupsNameByUser(string);
                object = this.addElement.getImportedLDAPGroupNames();
                int n = 0;
                while (n < ((Vector)object).size()) {
                    String string6 = (String)((Vector)object).elementAt(n);
                    if (vector.contains(string6)) {
                        try {
                            this.addElement.addUserToGroup(string, string6);
                        }
                        catch (NoSuchGroupException noSuchGroupException) {
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                        }
                    }
                    ++n;
                }
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException);
            }
            vector = this.QOIV.getRoleNamsByFilter(string);
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string7 = (String)object.nextElement();
                try {
                    this.addElement.addSubUserToRole(string, string7);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                }
                catch (NoSuchUserException noSuchUserException) {
                    return JSvrResource.getMessage("SEUCRITY_ERR_62_LDAP_ADD_USER_FAILED");
                }
            }
        }
        return null;
    }

    public boolean confirmFilter(String string, String string2) {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        return this.QOIV.isInFilter(string2, string);
    }

    public boolean isConfromFilter(String string, String string2) {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        return this.QOIV.isInFilter(string2, string);
    }

    public boolean isValidLDAPUser(String string, String string2) {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        return this.QOIV.isValidLdapUser(string, string2);
    }

    public boolean isValidLDAPUserByDN(String string, String string2, String string3) {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        return this.QOIV.isValidLdapUserByDN(string, string2, string3);
    }

    public SynchronizationResult synchronize() {
        Object object;
        String string;
        Principal principal;
        Object object2;
        Object object3;
        Hashtable hashtable;
        Hashtable hashtable2;
        SynchronizationResultImpl synchronizationResultImpl = new SynchronizationResultImpl();
        if (this.addLDAPGroup || !this.QOIV.isLDAPEnable()) {
            return synchronizationResultImpl;
        }
        this.addLDAPGroup = true;
        try {
            hashtable2 = this.QOIV.getAllLDAPUsersHT();
            hashtable = this.QOIV.getAllLDAPGroupsHT();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            this.addLDAPGroup = false;
            return synchronizationResultImpl;
        }
        Vector vector = this.addElement.getImportedLDAPUsers();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (User)enumeration.nextElement();
            object2 = object3.getName();
            if (hashtable2.containsKey(object2)) {
                principal = (LDAPUser)hashtable2.get(object2);
                string = object3.getEmail();
                object = principal.getProperty("email");
                String string2 = object3.getFullName();
                String string3 = principal.getProperty("full_name");
                if (string.equals(object) && string2.equals(string3)) continue;
                try {
                    this.addElement.updateAttributes((String)object2, string3, object3.getDescription(), (String)object, object3.isEnableNullPS(), object3.getMinPSLength(), new Date(System.currentTimeMillis()), object3.isNeverExpire(), object3.getExpireTime(), object3.isAccountDisable());
                    synchronizationResultImpl.addModifiedUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                }
                continue;
            }
            try {
                this.addElement.removeUserInherRelation((String)object2);
                this.addElement.removeUser((String)object2, "admin");
                synchronizationResultImpl.addRemovedUser((String)object2);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException, 3);
            }
            catch (InUseException inUseException) {
                ServiceLogger.logError(inUseException, 3);
            }
        }
        if (this.QOIV.isImportToRole()) {
            object3 = this.addElement.getImportedLDAPRoles();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                principal = (Role)object2.nextElement();
                string = principal.getName();
                if (hashtable.containsKey(string)) {
                    object = (LDAPGroup)hashtable.get(string);
                    boolean bl = this.QOIV((LDAPGroup)object, (Role)principal);
                    if (!bl) continue;
                    synchronizationResultImpl.addModifiedRole(string);
                    continue;
                }
                try {
                    this.addElement.removeRoleInherRelation(string);
                    this.addElement.removeRole(string);
                    synchronizationResultImpl.addRemovedRole(string);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
                catch (InUseException inUseException) {
                    ServiceLogger.logError(inUseException, 3);
                }
            }
        } else {
            object3 = this.addElement.getImportedLDAPGroups();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                principal = (Group)object2.nextElement();
                string = principal.getName();
                if (hashtable.containsKey(string)) {
                    object = (LDAPGroup)hashtable.get(string);
                    boolean bl = this.add((LDAPGroup)object, (Group)principal);
                    if (!bl) continue;
                    synchronizationResultImpl.addModifiedGroup(string);
                    continue;
                }
                try {
                    this.addElement.removeGroupInherRelation(string);
                    this.addElement.removeGroup(string);
                    synchronizationResultImpl.addRemovedGroup(string);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                }
                catch (InUseException inUseException) {
                    ServiceLogger.logError(inUseException, 3);
                }
            }
        }
        this.addLDAPGroup = false;
        return synchronizationResultImpl;
    }

    private boolean QOIV(LDAPGroup lDAPGroup, Role role) {
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        String string = role.getName();
        boolean bl = false;
        Vector vector2 = lDAPGroup.getUserNames();
        int n = 0;
        if (role.getSubUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = (Vector)role.getSubUserNames().clone();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector2.contains(object2)) continue;
                try {
                    this.addElement.removeUserFromParentRole((String)object2, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (role.getSubUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = role.getSubUserNames();
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector.contains(object2)) continue;
                try {
                    object = this.add.getIntegrityUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                    continue;
                }
                if (object.getLdapType() != 1) continue;
                try {
                    this.addElement.addSubUserToRole((String)object2, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        vector = lDAPGroup.getSubGroupNames();
        if (role.getSubRolesFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = (Vector)role.getSubRoleNames().clone();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (vector.contains(object)) continue;
                try {
                    this.addElement.removeRoleFromParentRole((String)object, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (role.getSubRolesFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = role.getSubRoleNames();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                Role role2;
                object = (String)object2.nextElement();
                if (((Vector)object3).contains(object)) continue;
                try {
                    role2 = this.add.getRole((String)object);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                    continue;
                }
                if (role2.getType() != 1) continue;
                try {
                    this.addElement.addSubRoleToRole((String)object, string);
                    ++n;
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
            }
            if (n != 0) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean add(LDAPGroup lDAPGroup, Group group) {
        Object object;
        Object object2;
        Object object3;
        Vector vector;
        String string = group.getName();
        boolean bl = false;
        Vector vector2 = lDAPGroup.getUserNames();
        int n = 0;
        if (group.getUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = (Vector)group.getUserNames().clone();
            object3 = vector.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector2.contains(object2)) continue;
                try {
                    this.addElement.removeUserFromGroup((String)object2, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (group.getUsersFlag() != lDAPGroup.getUsersFlag()) {
            vector = group.getUserNames();
            object3 = vector2.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (vector.contains(object2)) continue;
                try {
                    object = this.add.getIntegrityUser((String)object2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                    continue;
                }
                if (object.getLdapType() != 1) continue;
                try {
                    this.addElement.addUserToGroup((String)object2, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        vector = lDAPGroup.getSubGroupNames();
        if (group.getSubGroupsFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = (Vector)group.getSubGroupNames().clone();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (vector.contains(object)) continue;
                try {
                    this.addElement.removeSubGroupFromGroup((String)object, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                }
            }
            if (n != 0) {
                bl = true;
                n = 0;
            }
        }
        if (group.getSubGroupsFlag() != lDAPGroup.getSubGroupsFlag()) {
            object3 = group.getSubGroupNames();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                Group group2;
                object = (String)object2.nextElement();
                if (((Vector)object3).contains(object)) continue;
                try {
                    group2 = this.add.getGroup((String)object);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                    continue;
                }
                if (group2.getType() != 1) continue;
                try {
                    this.addElement.addSubGroupToGroup((String)object, string);
                    ++n;
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    ServiceLogger.logError(noSuchGroupException, 3);
                }
            }
            if (n != 0) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isLDAPScheduleEnable() {
        return this.QOIV.isLDAPScheduleEnable();
    }

    public Properties getSynchronizeSchedule() {
        return this.QOIV.getSynchronizeSchedule();
    }

    public boolean disableSynSchedule() {
        return this.QOIV.disableSynSchedule();
    }

    public boolean enableSynSchedule() {
        return this.QOIV.enableSynSchedule();
    }

    public boolean deleteSynSchedule() {
        return this.QOIV.deleteSynSchedule();
    }

    public boolean exportSynResultToXMLFile(String string, SynchronizationResult synchronizationResult) {
        return this.QOIV.exportSynResultToXMLFile(string, synchronizationResult);
    }

    public SynchronizationResult getLastLDAPSynchronizeScheduleResult() {
        return this.QOIV.getLastSynScheduleResult();
    }

    public boolean submitSynchronizeSchedule(Properties properties, String string) {
        if (!this.QOIV.isLDAPEnable()) {
            return false;
        }
        return this.QOIV.submitSynchronizeSchedule(properties, string);
    }
}

