/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.LDAPConnectionImpl;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.NoSuchRoleMapException;
import jet.server.jrc.security.ldap.RoleMapExistException;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRConfigurationLDAPServer
implements ConfigurationLDAPServer {
    private LDAPManager QOIV;
    private Hashtable addElement = new Hashtable();

    public JRConfigurationLDAPServer() {
        this.QOIV = UserDataToolkit.getLdapManager();
        this.addElement = (Hashtable)this.QOIV.getLDAPProperties().clone();
    }

    public void setLdapEnable(boolean bl) {
        this.addElement.put("enableLDAPSupport", String.valueOf(bl));
    }

    public boolean isLdapEnable() {
        String string = (String)this.addElement.get("enableLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public String getLDAPVersion() {
        String string = (String)this.addElement.get("ldapVersion");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setLDAPVersion(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("ldapVersion", string);
    }

    public void setImportUserUponAuthentication(boolean bl) {
        this.addElement.put("enableAutoImportLDAPUser", String.valueOf(bl));
    }

    public boolean isImportUserUponAuthentication() {
        String string = (String)this.addElement.get("enableAutoImportLDAPUser");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public void setLDAPURL(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("url", string);
    }

    public String getLDAPURL() {
        String string = (String)this.addElement.get("url");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setLADPServerPort(int n) {
        this.addElement.put("serverPort", String.valueOf(n));
    }

    public int getLADPServerPort() {
        int n = -1;
        String string = (String)this.addElement.get("serverPort");
        if (string != null && string.trim().length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ServiceLogger.logError(numberFormatException, 3);
            }
            return n;
        }
        return n;
    }

    public void setEncryptedPort(int n) {
    }

    public int getEncryptedPort() {
        return 0;
    }

    public void setRoot(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("rootEntry", string);
    }

    public String getRoot() {
        String string = (String)this.addElement.get("rootEntry");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setDirectoryManagerDN(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("directoryManagerDN", string);
    }

    public String getDirectoryManagerDN() {
        String string = (String)this.addElement.get("directoryManagerDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setPassword(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("password", string);
    }

    public String getPassword() {
        String string = (String)this.addElement.get("password");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setEncryptionType(String string) {
    }

    public String getEncryptionType() {
        return "";
    }

    public void setEncryptionInLayer(boolean bl) {
        this.addElement.put("isUsingSSL", String.valueOf(bl));
    }

    public boolean isEncryptionInLayer() {
        String string = (String)this.addElement.get("isUsingSSL");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.trim().equals("true");
    }

    public void setImportGroupType(String string) {
        this.addElement.put("importGroupType", string);
    }

    public String getImportGroupType() {
        String string = (String)this.addElement.get("importGroupType");
        if (string == null || string.trim().length() == 0) {
            return "role";
        }
        return string;
    }

    public void setFirstUseLocal(boolean bl) {
    }

    public boolean isFirstUseLocal() {
        return false;
    }

    public String[] getUseServerList() {
        String[] stringArray = new String[]{"Current Settings", "Novell Directory Server", "iPlanet Directory Server", "Microsoft Site Server", "OpenLDAP Directory Server", "Win2000 Active Directory", "Lotus Domino on NT"};
        return stringArray;
    }

    public boolean isConnection() {
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        return lDAPConnectionImpl.connect();
    }

    public boolean isConnection(Hashtable hashtable) {
        hashtable.put("socketTime", this.QOIV.getSocketTimeStr());
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(hashtable);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        return lDAPConnectionImpl.connect();
    }

    public Vector getRootUsers() {
        try {
            return this.QOIV.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return new Vector();
        }
    }

    public void setGroupCommonName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupCN", string);
    }

    public String getGroupCommonName() {
        String string = (String)this.addElement.get("groupCN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setGroupMemberType(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupMemeberType", string);
    }

    public String getGroupMemberType() {
        String string = (String)this.addElement.get("groupMemeberType");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setGroupDistinguishName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupDN", string);
    }

    public String getGroupDistinguishName() {
        String string = (String)this.addElement.get("groupDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setGroupFilter(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupFilter", string);
    }

    public String getGroupFilter() {
        String string = (String)this.addElement.get("groupFilter");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setAdminGroup(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("groupAdminGroup", string);
    }

    public String getAdminGroup() {
        String string = (String)this.addElement.get("groupAdminGroup");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public Vector getGroupNames() {
        var1_1 = new Vector<String>();
        if (!this.isLdapEnable()) {
            return var1_1;
        }
        var2_2 = new LDAPEnvironments(this.addElement);
        var3_3 = new LDAPConnectionImpl(var2_2);
        var3_3.connect();
        try {
            var4_4 = var3_3.getAllLDAPGroups().keys();
            if (true) ** GOTO lbl17
        }
        catch (NamingException var5_5) {
            ServiceLogger.logError(var5_5);
            return var1_1;
        }
        do {
            var5_6 = (String)var4_4.nextElement();
            var1_1.addElement(var5_6);
lbl17:
            // 2 sources

        } while (var4_4.hasMoreElements());
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public Vector queryGroups(Hashtable var1_1) {
        var2_2 = new Vector<LDAPGroup>();
        if (!this.isLdapEnable(var1_1)) {
            return var2_2;
        }
        var1_1.put("socketTime", this.QOIV.getSocketTimeStr());
        var3_3 = new LDAPEnvironments(var1_1);
        var4_4 = new LDAPConnectionImpl(var3_3);
        var4_4.connect();
        try {
            var5_5 = var4_4.getAllLDAPGroups().elements();
            if (true) ** GOTO lbl19
        }
        catch (NamingException var6_6) {
            ServiceLogger.logError(var6_6);
            return var2_2;
        }
        do {
            var6_7 = (LDAPGroup)var5_5.nextElement();
            var2_2.addElement(var6_7);
lbl19:
            // 2 sources

        } while (var5_5.hasMoreElements());
        return var2_2;
    }

    private boolean isLdapEnable(Hashtable hashtable) {
        String string = (String)hashtable.get("enableLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public String getGroupDescriptions(String string) {
        LDAPGroup lDAPGroup;
        if (!this.isLdapEnable()) {
            return null;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            lDAPGroup = (LDAPGroup)lDAPConnectionImpl.getLDAPGroup(string)[0].get(0);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return "";
        }
        return lDAPGroup.getProperty("description");
    }

    public void setUserAttributeName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userAN", string);
    }

    public String getUserAttributeName() {
        String string = (String)this.addElement.get("userAN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setUserCommonName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userCN", string);
    }

    public String getUserCommonName() {
        String string = (String)this.addElement.get("userCN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setUserPassword(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userPassword", string);
    }

    public String getUserPassword() {
        String string = (String)this.addElement.get("userPassword");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setUserDistinguishName(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userDN", string);
    }

    public String getUserDistinguishName() {
        String string = (String)this.addElement.get("userDN");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    public void setUserFilter(String string) {
        if (string == null || string.trim().length() < 1) {
            string = "";
        }
        this.addElement.put("userFilter", string);
    }

    public String getUserFilter() {
        String string = (String)this.addElement.get("userFilter");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public Vector getUserNames() {
        var1_1 = new Vector<String>();
        if (!this.isLdapEnable()) {
            return var1_1;
        }
        var2_2 = new LDAPEnvironments(this.addElement);
        var3_3 = new LDAPConnectionImpl(var2_2);
        var3_3.connect();
        try {
            var4_4 = var3_3.getAllLDAPUsers().keys();
            if (true) ** GOTO lbl17
        }
        catch (NamingException var5_5) {
            ServiceLogger.logError(var5_5);
            return var1_1;
        }
        do {
            var5_6 = (String)var4_4.nextElement();
            var1_1.addElement(var5_6);
lbl17:
            // 2 sources

        } while (var4_4.hasMoreElements());
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    public Vector queryUsers(Hashtable var1_1) {
        var2_2 = new Vector<LDAPUser>();
        if (!this.isLdapEnable(var1_1)) {
            return var2_2;
        }
        var1_1.put("socketTime", this.QOIV.getSocketTimeStr());
        var3_3 = new LDAPEnvironments(var1_1);
        var4_4 = new LDAPConnectionImpl(var3_3);
        var4_4.connect();
        try {
            var5_5 = var4_4.getAllLDAPUsers().elements();
            if (true) ** GOTO lbl19
        }
        catch (NamingException var6_6) {
            ServiceLogger.logError(var6_6);
            return var2_2;
        }
        do {
            var6_7 = (LDAPUser)var5_5.nextElement();
            var2_2.addElement(var6_7);
lbl19:
            // 2 sources

        } while (var5_5.hasMoreElements());
        return var2_2;
    }

    public String getUserFullNames(String string) {
        Hashtable hashtable;
        if (!this.isLdapEnable()) {
            return null;
        }
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.addElement);
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        try {
            hashtable = lDAPConnectionImpl.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return "";
        }
        LDAPUser lDAPUser = (LDAPUser)hashtable.get(string);
        if (lDAPUser != null) {
            return lDAPUser.getProperty("full_name");
        }
        return "";
    }

    public void getDefauleSettingValue(String string) {
        if (string != null && string.trim().length() > 0) {
            if (string.equalsIgnoreCase("iPlanet Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=people");
                this.addElement.put("userFilter", "(&(uid=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemeberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Microsoft Site Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=Members");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=member))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "cn");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=mgroup))");
                this.addElement.put("groupMemeberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Novell Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=people");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemeberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("OpenLDAP Directory Server")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "ou=members");
                this.addElement.put("userFilter", "(&(uid=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "ou=groups");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofuniquenames))");
                this.addElement.put("groupMemeberType", "uniqueMember");
            } else if (string.equalsIgnoreCase("Win2000 Active Directory")) {
                this.addElement.put("userCN", "userPrincipalName");
                this.addElement.put("userDN", "cn=users");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "cn");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "cn=users");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=group))");
                this.addElement.put("groupMemeberType", "member");
            } else if (string.equalsIgnoreCase("Lotus Domino on NT")) {
                this.addElement.put("userCN", "cn");
                this.addElement.put("userDN", "");
                this.addElement.put("userFilter", "(&(cn=*)(objectclass=person))");
                this.addElement.put("userPassword", "userPassword");
                this.addElement.put("userAN", "uid");
                this.addElement.put("groupAdminGroup", "");
                this.addElement.put("groupCN", "cn");
                this.addElement.put("groupDN", "");
                this.addElement.put("groupFilter", "(&(cn=*)(objectclass=groupofnames))");
                this.addElement.put("groupMemeberType", "member");
            } else if (string.equalsIgnoreCase("Current Settings")) {
                this.addElement = (Hashtable)this.QOIV.getLDAPProperties().clone();
            }
        }
    }

    public Hashtable getProperties() {
        return this.addElement;
    }

    public void saveProperties() {
        this.QOIV.savePropertiese(this.addElement);
    }

    public void runAtServerRestart() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ClusterService clusterService = httpRptServer.getClusterService();
        if (clusterService != null) {
            Member[] memberArray = null;
            try {
                memberArray = clusterService.getAllMembers();
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError(clusterException, 3);
            }
            int n = 0;
            while (n < memberArray.length) {
                if (memberArray[n].isBackupAdmin()) {
                    try {
                        String string = memberArray[n].getHost();
                        int n2 = Integer.parseInt(memberArray[n].getPort());
                        String string2 = "MemberMonitor";
                        MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, n2, string2);
                        memberMonitor.setLdapConfig(this.addElement);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                ++n;
            }
        }
    }

    public void setEncryptedPort(String string) {
    }

    public boolean createNewRoleMap(String string, String string2) throws RoleMapExistException {
        return this.QOIV.addRoleMap(string, string2);
    }

    public String createRoleMap(String string, String string2) throws RoleMapExistException {
        return this.QOIV.addNewRoleMap(string, string2);
    }

    public boolean removeRoleMap(String string) throws NoSuchRoleMapException {
        return this.QOIV.removeRoleMap(string);
    }

    public boolean editRoleMap(String string, String string2, String string3) throws NoSuchRoleMapException {
        return this.QOIV.editRoleMap(string, string2, string3);
    }

    public Vector getAllRoleMaps() {
        return this.QOIV.getRoleMaps();
    }

    public boolean isEnableNoneImportedLDAPSupport() {
        String string = (String)this.addElement.get("enableNoneImportedLDAPSupport");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return false;
    }

    public void setEnableLDAPProviders(boolean bl) {
        this.addElement.put("enableNoneImportedLDAPSupport", String.valueOf(bl));
    }
}

