/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationPerformance;
import jet.server.log.ServiceLogger;

public class JRConfigurationPerformance
implements ConfigurationPerformance {
    private ExProperties QOIV = new ExProperties();
    private String addElement = ServerEnv.getServPropName();

    public JRConfigurationPerformance() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.QOIV.load(this.addElement);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void saveProperty() {
        try {
            this.QOIV.save(this.addElement, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setEnablePreloadFont(boolean bl) {
        this.QOIV.setProperty("performance.loadfont", bl);
        this.saveProperty();
    }

    public boolean getEnablePreloadFont() {
        return this.QOIV.getProperty("performance.loadfont", true);
    }

    public void setPreloadCatalogsName(Vector vector) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            string = string + (String)vector.elementAt(n) + ",";
            ++n;
        }
        this.QOIV.setProperty("performance.preloadedcats", string);
        this.saveProperty();
    }

    public Vector getPreloadCatalogsName() {
        String string = this.QOIV.getProperty("performance.preloadedcats");
        Vector<String> vector = new Vector<String>();
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public void setPreloadReportsName(Vector vector) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            string = string + (String)vector.elementAt(n) + ",";
            ++n;
        }
        this.QOIV.setProperty("performance.preloadedrpts", string);
        this.saveProperty();
    }

    public Vector getPreloadReportsName() {
        Vector<String> vector = new Vector<String>();
        String string = this.QOIV.getProperty("performance.preloadedrpts");
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public void setPreloadCatalogClass(boolean bl) {
        this.QOIV.setProperty("performance.preloadcatcls", bl);
        this.saveProperty();
    }

    public boolean getPreloadCatalogClass() {
        return this.QOIV.getProperty("performance.preloadcatcls", true);
    }

    public void setPreloadReportClass(boolean bl) {
        this.QOIV.setProperty("performance.preloadrptcls", bl);
        this.saveProperty();
    }

    public boolean getPreloadReportClass() {
        return this.QOIV.getProperty("performance.preloadrptcls", true);
    }

    public void setPreloadEngineClass(boolean bl) {
        this.QOIV.setProperty("performance.preloadenginecls", bl);
        this.saveProperty();
    }

    public boolean getPreloadEngineClass() {
        return this.QOIV.getProperty("performance.preloadenginecls", true);
    }

    public void setPreloadDsoClass(boolean bl) {
        this.QOIV.setProperty("performance.preloaddsocls", bl);
        this.saveProperty();
    }

    public void setCompressIO(boolean bl) {
        this.QOIV.setProperty("performance.compressio", bl);
        this.saveProperty();
    }

    public boolean getCompressIO() {
        return this.QOIV.getProperty("performance.compressio", false);
    }

    public boolean getPreloadDsoClass() {
        return this.QOIV.getProperty("performance.preloaddsocls", true);
    }
}

