/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationRMI;
import jet.server.log.ServiceLogger;

public class JRConfigurationRMI
implements ConfigurationRMI {
    private ExProperties QOIV = new ExProperties();
    private String get = ServerEnv.getServPropName();
    private Properties getLocalRMIHost = new Properties();

    public JRConfigurationRMI() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            this.QOIV.load(this.get);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getServerRMIHost() {
        String string = (String)this.getLocalRMIHost.get("server.rmi.host");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getLocalRMIHost();
    }

    public void setServerRMIHost(String string) {
        try {
            this.QOIV.load(this.get);
            this.QOIV.setProperty("server.rmi.host", string);
            this.getLocalRMIHost.put("server.rmi.host", string);
            this.QOIV.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getServerRMIPort() {
        String string = (String)this.getLocalRMIHost.get("server.rmi.port");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getServerRMIPort();
    }

    public void setServerRMIPort(String string) {
        try {
            this.QOIV.load(this.get);
            this.QOIV.setProperty("server.rmi.port", string);
            this.getLocalRMIHost.put("server.rmi.port", string);
            this.QOIV.save(this.get, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

