/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.http.HttpExternalAuthorized;
import jet.server.api.http.HttpUserSessionManager;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRUserSession;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.jrserver.http.AuthInfo;
import jet.server.jrserver.http.LogoutReg;
import jet.server.jrserver.http.MD5Info;
import jet.server.jrserver.http.RawUserSession;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    public static final String TAG_JRSESSION = "jrs.userssn";
    public static final String TAG_RAWSESSION = "jrs.rawssn";
    private int QOIV = 5;
    private Hashtable append = new Hashtable();
    private long askInvalidate = 86400000L;
    private int checkAdminLogin = 1024;
    private HttpExternalAuthorized checkLogin = null;
    private boolean clear = ServerEnv.invalidateHttpSessionWhenLogout();

    public JRHttpUserSessionManager(Authenticator authenticator) {
        super(authenticator);
        String string = System.getProperty("jrs.httpExternalAuthorized");
        if (string != null && string.trim().length() > 0) {
            try {
                this.checkLogin = (HttpExternalAuthorized)Class.forName(string.trim()).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(3630046, string, 3);
                ServiceLogger.logError(throwable);
            }
        }
    }

    public String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    public UserSession getUserSession(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            String string = (String)httpSession.getValue("isUserSessionValid");
            if (string == null || "true".equals(string)) {
                try {
                    userSession = this.getUserSession((String)httpSession.getValue(TAG_JRSESSION));
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            } else {
                userSession = new JRUserSession();
            }
        }
        return userSession;
    }

    public void setHttpExternalAuthorized(HttpExternalAuthorized httpExternalAuthorized) {
        this.checkLogin = httpExternalAuthorized;
    }

    public HttpExternalAuthorized getHttpExternalAuthorized() {
        return this.checkLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        try {
            Object object;
            UserSession userSession = null;
            Hashtable hashtable = this.htSessions;
            synchronized (hashtable) {
                object = this.getAllUserSessions();
                while (object.hasMoreElements()) {
                    userSession = (UserSession)object.nextElement();
                    if (System.currentTimeMillis() - userSession.getLastAccessTime() <= (long)userSession.getMaxInactiveInterval()) continue;
                    if (this.checkLogin != null) {
                        boolean bl = this.checkLogin.askInvalidate(userSession);
                        if (userSession.isExternalAuthorized() && !bl) continue;
                        this.logout(httpServletRequest, userSession);
                        continue;
                    }
                    this.logout(httpServletRequest, userSession);
                }
            }
            object = this.htWaitSessions;
            synchronized (object) {
                Enumeration enumeration = this.htWaitSessions.elements();
                while (enumeration.hasMoreElements()) {
                    userSession = (UserSession)enumeration.nextElement();
                    if (System.currentTimeMillis() - userSession.getLastAccessTime() <= (long)userSession.getMaxInactiveInterval()) continue;
                    if (this.checkLogin != null) {
                        boolean bl = this.checkLogin.askInvalidate(userSession);
                        if (userSession.isExternalAuthorized() && !bl) continue;
                        this.logout(httpServletRequest, userSession);
                        continue;
                    }
                    this.logout(httpServletRequest, userSession);
                }
            }
            userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                this.putSessions(userSession);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object) throws TooManyUsersException {
        return this.loginMD5(string, string2, string3, string4, string5, string6, object, false);
    }

    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6, Object object, boolean bl) throws TooManyUsersException {
        UserSession userSession = null;
        String string7 = null;
        try {
            string7 = UserDataToolkit.securityAdapter.getPassword(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 3);
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7, object, false, bl);
        }
        return userSession;
    }

    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkLogin(httpServletRequest, null, string, properties);
    }

    public boolean checkLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.elements(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.QOIV) {
                throw new TooManyTimesException(630085);
            }
            if (!this.needSecurity()) {
                String string2 = (String)properties.get("isWait");
                boolean bl = string2 == null ? false : string2.equals("true");
                userSession = this.login(string, "", "", userSession, false, bl);
            } else {
                userSession = this.forName(httpServletRequest, httpServletResponse, string, properties);
            }
            if (userSession != null) {
                this.currentTimeMillis(httpServletRequest, userSession);
                return true;
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        return true;
    }

    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        return this.checkAdminLogin(httpServletRequest, null, string, properties);
    }

    public boolean checkAdminLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, TooManyTimesException, IOException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.elements(httpServletRequest);
            if (rawUserSession != null && rawUserSession.retry >= this.QOIV) {
                throw new TooManyTimesException(630085);
            }
            properties.setProperty("isAdmin", "true");
            userSession = this.forName(httpServletRequest, httpServletResponse, string, properties);
            if (userSession != null) {
                AuthInfo authInfo = this.equals(httpServletRequest, string, properties);
                if (UserDataToolkit.securityAdapter.isAdminUser(string, userSession.getUserID())) {
                    this.currentTimeMillis(httpServletRequest, userSession);
                    return true;
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                if (httpSession != null) {
                    this.askInvalidate(httpSession);
                }
            }
            return false;
        }
        if (userSession.getID() == null) {
            throw new TooManyUsersException(630088);
        }
        if (UserDataToolkit.securityAdapter.isAdminUser(string, userSession.getUserID())) {
            return true;
        }
        if (this.clear) {
            httpServletRequest.getSession().invalidate();
        }
        return false;
    }

    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        Object object;
        if (this.QOIV(httpServletRequest)) {
            return;
        }
        this.decode(httpServletRequest);
        RawUserSession rawUserSession = this.elements(httpServletRequest);
        rawUserSession.realm = string2;
        if (string.equals("Digest")) {
            rawUserSession.md5 = new MD5Info(httpServletRequest);
        }
        if (this.checkLogin != null && !this.checkLogin.handleUnAuthenticatedRequest(httpServletRequest, httpServletResponse, string, string2)) {
            return;
        }
        String string3 = "";
        if (ServerEnv.isUseNewRealmName() && (object = httpServletRequest.getHeader("User-Agent")) != null && ((String)object).indexOf("MSIE") != -1) {
            string3 = "_" + this.get();
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", rawUserSession.makeAuthHeader(string3));
        httpServletResponse.setContentType("text/html");
        object = ServerUtil.getResponseWriter(httpServletResponse);
        ((PrintWriter)object).println("<html>");
        ((PrintWriter)object).println("<head>");
        ((PrintWriter)object).println("<title>" + JCliResource.getMessage("CS_MSG_110") + "</title>");
        ((PrintWriter)object).println("</head>");
        ((PrintWriter)object).println("<body>");
        ((PrintWriter)object).println("<H1>401 " + JCliResource.getMessage("CS_MSG_110") + "</H1><h2>");
        ((PrintWriter)object).println("</body>");
        ((PrintWriter)object).println("</html>");
    }

    private boolean QOIV(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("jrs.kickOutOldSsn");
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string2 = null;
        if (httpSession != null) {
            string2 = (String)httpSession.getValue("jrs.kickOutOldSsn");
            httpSession.removeValue("jrs.kickOutOldSsn");
        }
        return string != null || string2 != null;
    }

    public boolean isExtraChannel(HttpServletRequest httpServletRequest) {
        return this.isExtraSession(httpServletRequest.getSession(false));
    }

    public void logout(HttpServletRequest httpServletRequest) {
        this.clear();
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            UserSession userSession = this.getUserSession(httpServletRequest);
            if (userSession != null) {
                // empty if block
            }
            this.logout(httpServletRequest, userSession, true);
        }
    }

    private void append(HttpSession httpSession) {
        try {
            if (httpSession != null) {
                String string = httpSession.getId();
                this.append.remove(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void askInvalidate(HttpSession httpSession) {
        block5: {
            try {
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this.append.get(string);
                    if (logoutReg != null) {
                        logoutReg.C();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean checkAdminLogin(HttpServletRequest httpServletRequest) {
        boolean bl;
        block5: {
            bl = false;
            try {
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession == null) break block5;
                try {
                    String string = httpSession.getId();
                    LogoutReg logoutReg = (LogoutReg)this.append.get(string);
                    if (logoutReg != null && !logoutReg.Z()) {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    private void checkLogin(HttpServletRequest httpServletRequest, String string) {
        try {
            if (string != null && !HttpUtil.isJRClient(httpServletRequest, null)) {
                this.append.put(string, new LogoutReg());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        try {
            Hashtable hashtable = this.append;
            synchronized (hashtable) {
                if (this.append.size() >= this.checkAdminLogin) {
                    String string;
                    Enumeration enumeration = this.append.keys();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (System.currentTimeMillis() - ((LogoutReg)this.append.get(string)).I() <= this.askInvalidate) continue;
                        this.append.remove(string);
                    }
                    if (this.append.size() >= this.checkAdminLogin) {
                        int n = 0;
                        int n2 = this.checkAdminLogin / 2;
                        enumeration = this.append.keys();
                        while (enumeration.hasMoreElements() && n < n2) {
                            string = (String)enumeration.nextElement();
                            this.append.remove(string);
                            ++n;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Hashtable hashtable = this.append;
                synchronized (hashtable) {
                    if (this.append.size() > this.checkAdminLogin) {
                        this.append.clear();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    public void logout(HttpServletRequest httpServletRequest, UserSession userSession) {
        this.logout(httpServletRequest, userSession, false);
    }

    private void logout(HttpServletRequest httpServletRequest, UserSession userSession, boolean bl) {
        if (userSession != null) {
            HttpSession httpSession;
            this.setUserOndemandClearTime(userSession.getUserID());
            Object object = this.getExtObj(userSession.getID());
            HttpSession httpSession2 = httpSession = object instanceof HttpSession ? (HttpSession)object : null;
            if (userSession.getID() != null) {
                super.logout(userSession);
            }
            if (httpSession != null) {
                try {
                    httpSession.removeValue(TAG_JRSESSION);
                    if (this.clear) {
                        httpSession.invalidate();
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
                httpSession = httpServletRequest.getSession(true);
                if (bl) {
                    try {
                        this.checkLogin(httpServletRequest, httpSession.getId());
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                    }
                }
            }
            if (userSession.isExternalAuthorized() && this.checkLogin != null) {
                this.checkLogin.notifyLogout(userSession);
            }
        }
    }

    private void currentTimeMillis(HttpServletRequest httpServletRequest, UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue(TAG_JRSESSION, (Object)userSession.getID());
            httpSession.removeValue(TAG_RAWSESSION);
            httpSession.putValue("isUserSessionValid", (Object)"true");
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void decode(HttpServletRequest httpServletRequest) {
        if (this.elements(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(TAG_RAWSESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private RawUserSession elements(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                rawUserSession = (RawUserSession)httpSession.getValue(TAG_RAWSESSION);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return rawUserSession;
    }

    private AuthInfo equals(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        if (string2 != null && string2.length() > 0) {
            if (this.checkAdminLogin(httpServletRequest)) {
                this.askInvalidate(httpServletRequest.getSession(true));
                return null;
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            if ((httpSession == null || httpSession.isNew()) && (authInfo = this.equalsIgnoreCase(properties)) == null) {
                this.askInvalidate(httpServletRequest.getSession(true));
                return null;
            }
            int n = (string2 = string2.trim()).indexOf(" ");
            if (n > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1");
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.I = string3.substring(0, n);
                        authInfo.Z = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).nonce = string6;
                    ((MD5Info)object).opaque = string8;
                    ((MD5Info)object).response = string7;
                    authInfo = new AuthInfo();
                    authInfo.I = string4;
                    authInfo.C = object;
                }
            }
        } else {
            authInfo = this.equalsIgnoreCase(properties);
        }
        return authInfo;
    }

    private AuthInfo equalsIgnoreCase(Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1");
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.I = string;
            authInfo.Z = string2;
        }
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserSession forName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Properties properties) throws TooManyUsersException, IOException {
        Object object;
        UserSession userSession = null;
        if (this.checkLogin != null && (object = this.checkLogin.getExternalAuthorizedUser(string, httpServletRequest)) != null) {
            userSession = this.loginExternalAuthorized(string, (String)object, httpServletRequest.getSession(true));
        }
        if (userSession == null) {
            object = this.equals(httpServletRequest, string, properties);
            String string2 = (String)properties.get("isWait");
            boolean bl = string2 == null ? false : string2.equals("true");
            if (object != null) {
                RawUserSession rawUserSession = this.elements(httpServletRequest);
                if (rawUserSession != null && ((AuthInfo)object).C != null && rawUserSession.md5 != null && ((AuthInfo)object).I != null && ((AuthInfo)object).C.response != null && ((AuthInfo)object).C.nonce != null && ((AuthInfo)object).C.nonce.equals(rawUserSession.md5.nonce) && (((AuthInfo)object).C.opaque == null || ((AuthInfo)object).C.opaque.equals(rawUserSession.md5.opaque))) {
                    return this.loginMD5(rawUserSession.realm, ((AuthInfo)object).I, ((AuthInfo)object).C.response, ((AuthInfo)object).C.nonce, rawUserSession.md5.uri, httpServletRequest.getMethod(), httpServletRequest.getSession(true), bl);
                }
                HttpSession httpSession = httpServletRequest.getSession(true);
                boolean bl2 = super.getAuthenticator().isValidAdminUser(string, ((AuthInfo)object).I, ((AuthInfo)object).Z);
                if (!properties.getProperty("isAdmin", "false").equals("true") || bl2) {
                    if (httpServletRequest != null && httpServletResponse != null) {
                        try {
                            httpSession.putValue("jrs.extraReq", (Object)httpServletRequest);
                            httpSession.putValue("jrs.extraRes", (Object)httpServletResponse);
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable, 3);
                        }
                    }
                    try {
                        userSession = this.login(string, ((AuthInfo)object).I, ((AuthInfo)object).Z, httpSession, false, bl, HttpUtil.isJRClient(httpServletRequest, properties));
                        Object var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        httpSession.removeValue("jrs.extraReq");
                        httpSession.removeValue("jrs.extraRes");
                        throw throwable;
                    }
                    httpSession.removeValue("jrs.extraReq");
                    httpSession.removeValue("jrs.extraRes");
                    {
                    }
                }
                if (userSession != null) {
                    this.append(httpSession);
                } else if (httpSession != null) {
                    this.askInvalidate(httpSession);
                }
            }
        }
        return userSession;
    }

    private String get() {
        Object var1_1 = null;
        int n = 4;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)(Math.random() * 10.0 + 48.0);
            ++n2;
        }
        return new String(cArray);
    }
}

