/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.monitor;

import java.io.Serializable;
import java.util.Vector;
import jet.connect.DbDate;
import jet.server.api.monitor.CurrentMonitorStatistics;
import jet.server.jrserver.monitor.JRFinishedReport;

public class JRCurrentMonitorStatistics
implements CurrentMonitorStatistics,
Serializable {
    private Vector allSta = new Vector();
    private long setSubmitTime = 0L;
    private long setEndTime = 0L;
    private long leastSubmitTime = 0L;
    private long maxEndTime = 0L;
    private long allSubmitTime = 0L;
    private long allEndTime = 0L;
    private long allStartRunTime = 0L;
    private long succeeNum = 0L;
    private long allPageNumber = 0L;
    private long waitTime = 0L;

    public JRCurrentMonitorStatistics() {
    }

    public JRCurrentMonitorStatistics(Vector vector, long l, long l2) {
        this.allSta = vector;
        this.setSubmitTime = l;
        this.setEndTime = l2;
        this.computeValue();
    }

    public JRCurrentMonitorStatistics(Vector vector) {
        this.allSta = vector;
        this.setSubmitTime = 0L;
        this.setEndTime = 0L;
        this.computeValue();
    }

    public void computeValue() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        int n = 0;
        this.waitTime = 0L;
        int n2 = 0;
        while (n2 < this.allSta.size()) {
            JRFinishedReport jRFinishedReport = (JRFinishedReport)this.allSta.elementAt(n2);
            l2 = jRFinishedReport.getSubmitTime();
            l4 = jRFinishedReport.getEndTime();
            if (this.setSubmitTime <= l2 && this.setEndTime >= l4 || this.setSubmitTime == 0L && this.setEndTime == 0L) {
                l6 += l2;
                l7 += l4;
                if (l2 > 0L && (l2 < l || l == 0L)) {
                    l = l2;
                }
                if (l4 > 0L && l4 > l3) {
                    l3 = l4;
                }
                if ((n = jRFinishedReport.getTotalPageNumber()) > 0) {
                    l9 += (long)n;
                }
                l5 += jRFinishedReport.getStartRunTime();
                if (jRFinishedReport.getReason().trim() == null || jRFinishedReport.getReason().trim().length() == 0) {
                    ++l8;
                }
                this.waitTime = this.waitTime + jRFinishedReport.getWaitTimeInRun() - jRFinishedReport.getStartRunTime();
            }
            ++n2;
        }
        this.leastSubmitTime = l;
        this.maxEndTime = l3;
        this.allSubmitTime = l6;
        this.allEndTime = l7;
        this.allStartRunTime = l5;
        this.allSubmitTime = l6;
        this.succeeNum = l8;
        this.allPageNumber = l9;
    }

    public int getAmountOfReportPagesEveryMinute() {
        int n = 0;
        if (this.maxEndTime - this.leastSubmitTime > 0L) {
            n = (int)(this.allPageNumber * 60L * 1000L / (this.maxEndTime - this.leastSubmitTime));
        }
        return n;
    }

    public int getAmountOfReportsEveryMinute() {
        int n = 0;
        if (this.maxEndTime - this.leastSubmitTime > 0L) {
            n = (int)((long)(this.allSta.size() * 1000 * 60) / (this.maxEndTime - this.leastSubmitTime));
        }
        return n;
    }

    public long getAverageWaitTimeInRun() {
        long l = 0L;
        if (this.allSta.size() > 0) {
            l = this.waitTime / (long)this.allSta.size();
        }
        return l;
    }

    public int getAverageWaitTimeToRun() {
        int n = 0;
        if (this.allStartRunTime - this.allSubmitTime > 0L) {
            n = (int)((long)(this.allSta.size() * 1000) / (this.allStartRunTime - this.allSubmitTime));
        }
        return n;
    }

    public int getAverageNeedTimeEveryReport() {
        int n = 0;
        n = (int)((this.allEndTime - this.allSubmitTime) / (long)this.allSta.size());
        return n;
    }

    public int getAverageRunTimeEveryReport() {
        int n = 0;
        n = (int)((this.allEndTime - this.allStartRunTime) / (long)this.allSta.size());
        return n;
    }

    public long getAmountOfSucceedReports() {
        return this.succeeNum;
    }

    public long getAmountOfReports() {
        return this.allSta.size();
    }

    public void setBeginTimeToStatistics(long l) {
        if (l > 0L) {
            this.leastSubmitTime = l;
        }
    }

    public void setEndTimeToStatistics(long l) {
        if (l > 0L) {
            this.maxEndTime = l;
        }
    }

    public long getBeginTimeToStatistics() {
        return this.leastSubmitTime;
    }

    public String displayBeginTime() {
        DbDate dbDate = new DbDate();
        dbDate.set(this.leastSubmitTime);
        return dbDate.toUtilDate().toString();
    }

    public String displayEndTime() {
        DbDate dbDate = new DbDate();
        dbDate.set(this.maxEndTime);
        return dbDate.toUtilDate().toString();
    }

    public long getEndTimeToStatistics() {
        return this.maxEndTime;
    }
}

