/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.monitor;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.monitor.FinishedReportTable;
import jet.server.api.monitor.MonitorSetting;
import jet.server.jrserver.monitor.JRMonitorService;
import jet.server.log.ServiceLogger;

public class JRMonitorSetting
implements MonitorSetting {
    private ExProperties QOIV = new ExProperties();
    private Properties get = new Properties();
    JRMonitorService getClusterMonitorRefreshInterval = null;

    public JRMonitorSetting(JRMonitorService jRMonitorService) {
        this.getClusterMonitorRefreshInterval = jRMonitorService;
    }

    public long getClusterMonitorRefreshInterval() {
        String string = (String)this.get.get("monitor.cluster.refresh.interval");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getClusterMonitorRefreshInterval();
    }

    public long getMonitorRefreshInterval() {
        String string = (String)this.get.get("monitor.refresh.interval");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getMonitorRefreshInterval();
    }

    public long getMonitorOverTimeRunning() {
        String string = (String)this.get.get("monitor.overtime.running");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getMonitorOverTimeRunning();
    }

    public int getMonitorMaxNumberSaveReport() {
        String string = (String)this.get.get("monitor.maxnumber.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorMaxNumberSaveReport();
    }

    public int getMonitorNumberSaveReport() {
        String string = (String)this.get.get("monitor.number.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorNumberSaveReport();
    }

    public int getMonitorMaxMinuteSaveReport() {
        String string = (String)this.get.get("monitor.maxminute.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorMaxMinuteSaveReport();
    }

    public void setClusterMonitorRefreshInterval(long l) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.cluster.refresh.interval", l);
            this.get.put("monitor.cluster.refresh.interval", String.valueOf(l));
            this.QOIV.save(ServerEnv.getServPropName(), null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMonitorRefreshInterval(long l) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.refresh.interval", l);
            this.QOIV.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.refresh.interval", String.valueOf(l));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMonitorOverTimeRunning(long l) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.overtime.running", l);
            this.QOIV.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.overtime.running", String.valueOf(l));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMonitorNumberSaveReport(int n) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.number.savereport", n);
            FinishedReportTable finishedReportTable = this.getClusterMonitorRefreshInterval.getFinishedReportTable();
            finishedReportTable.setMaxSaveNumber(n);
            this.QOIV.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.number.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMonitorMaxNumberSaveReport(int n) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.maxnumber.savereport", n);
            this.QOIV.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.maxnumber.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void setMonitorMaxMinuteSaveReport(int n) {
        try {
            this.QOIV.load(ServerEnv.getServPropName());
            this.QOIV.setProperty("monitor.maxminute.savereport", Integer.toString(n));
            FinishedReportTable finishedReportTable = this.getClusterMonitorRefreshInterval.getFinishedReportTable();
            finishedReportTable.setMaxKeepTime((long)n * 60L * 1000L);
            this.QOIV.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.maxminute.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

