/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import com.jinfonet.util.JRLoggerReg;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.JSRuntimeException;
import jet.JSvrResource;
import jet.log.JRLoggingUtil;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.monitor.jrmon.MonitorEnv;

public class JRLoggerUtility
extends JRLoggingUtil {
    public static String getConfigPropName(Properties properties, String string) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty("log.config.filename");
        }
        if (string2 == null) {
            string2 = string != null ? string : "LogConfig.properties";
        }
        if (string2.indexOf("/") == -1 && string2.indexOf("\\") == -1) {
            String string3 = ServerEnv.binPath;
            if (string3 == null) {
                string3 = properties.getProperty("monitor.server.bin.path");
            }
            if (string3 != null) {
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                string2 = string3 + string2;
            }
        }
        properties.setProperty("log.config.filename", string2);
        return string2;
    }

    public static boolean getConfigAutoWatch(Properties properties, boolean bl) {
        boolean bl2 = bl;
        if (properties != null && properties.containsKey("log.config.update")) {
            bl2 = "true".equalsIgnoreCase(properties.getProperty("log.config.update"));
        }
        properties.setProperty("log.config.update", String.valueOf(bl2));
        return bl2;
    }

    public static long getConfigWatchInterval(Properties properties, long l) {
        long l2 = l;
        if (properties != null && properties.containsKey("log.config.update.interval")) {
            try {
                l2 = Long.parseLong(properties.getProperty("log.config.update.interval"));
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
        }
        properties.setProperty("log.config.update.interval", String.valueOf(l2));
        return l2;
    }

    public static String getLogPath() {
        String string = "";
        if (ServerEnv.logsPath != null) {
            string = ServerEnv.logsPath;
        } else {
            try {
                string = MonitorEnv.getLogsPath();
            }
            catch (Throwable throwable) {
                string = "";
            }
        }
        if (string.length() > 0 && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static void validLog4jProps(Properties properties) {
        String string = JRLoggerUtility.getLogPath();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.toUpperCase().endsWith(".File".toUpperCase())) continue;
            String string3 = properties.getProperty(string2);
            if (string3.indexOf("/") == -1 && string3.indexOf("\\") == -1) {
                string3 = string + string3;
                properties.setProperty(string2, string3);
            }
            JRLoggerUtility.QOIV(string3);
        }
    }

    private static void QOIV(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List readLines(String string, boolean bl) {
        String string2;
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = null;
        bufferedReader = new LineNumberReader(new InputStreamReader(new FileInputStream(string)));
        while ((string2 = ((LineNumberReader)bufferedReader).readLine()) != null) {
            if (bl) {
                if (string2.trim().length() == 0 || string2.trim().charAt(0) == '#') continue;
                vector.add(string2);
                continue;
            }
            vector.add(string2);
        }
        Object var7_5 = null;
        if (bufferedReader == null) return vector;
        try {
            bufferedReader.close();
            return vector;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        return vector;
        {
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                throw new JSRuntimeException(670015, new Object[]{string}, null);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            throw throwable;
        }
    }

    public static void saveToFile(String string, List list) {
        if (string == null) {
            throw new IllegalArgumentException(JSvrResource.getMessage("LOGGING_M_00003", new String[]{"static", "'JRLoggerUtility.saveToFile()'", "'String resourceFile'", JSvrResource.getMessage("LOGGING_M_00004", "'" + string + "'")}));
        }
        if (list == null) {
            return;
        }
        PrintStream printStream = null;
        try {
            try {
                printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string)));
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    printStream.println(iterator.next());
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                throw new JSRuntimeException(670016, new Object[]{string}, null);
            }
            Object var5_5 = null;
            if (printStream != null) {
                printStream.flush();
                printStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (printStream != null) {
                printStream.flush();
                printStream.close();
            }
            throw throwable;
        }
    }

    public static String[] getLoggerLevels(boolean bl) {
        String[] stringArray = JRLoggerReg.getPublicLevels((boolean)bl);
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].toUpperCase();
            ++n;
        }
        return stringArray;
    }
}

