/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import java.io.IOException;
import java.io.OutputStream;
import jet.server.log.NullTraceLog;
import jet.server.log.TraceLog;
import jet.server.util.ErrorMessages;
import jet.server.util.TypeUtil;

public class Log {
    private OutputStream QOIV;
    private int close;
    private String[] error;
    private boolean flush;
    private static TraceLog getBytes = null;
    private static TraceLog getProperty = null;
    protected static final String lineSeparator = System.getProperty("line.separator", "\n");

    public Log() {
    }

    public Log(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }

    public static synchronized boolean setErrorLog(TraceLog traceLog) {
        if (getBytes == null || getBytes instanceof NullTraceLog) {
            getBytes = traceLog;
            return true;
        }
        return false;
    }

    public static TraceLog getErrorLog() {
        if (getBytes == null) {
            getBytes = new NullTraceLog();
        }
        return getBytes;
    }

    public static synchronized boolean setEventLog(TraceLog traceLog) {
        if (getProperty == null || getProperty instanceof NullTraceLog) {
            getProperty = traceLog;
            return true;
        }
        return false;
    }

    public static TraceLog getEventLog() {
        if (getProperty == null) {
            getProperty = new NullTraceLog();
        }
        return getProperty;
    }

    public synchronized void useGMT(boolean bl) {
        this.flush = bl;
    }

    public boolean useGMT() {
        return this.flush;
    }

    public synchronized void setOutputStream(OutputStream outputStream) {
        if (this.QOIV != null) {
            this.close();
        }
        this.QOIV = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.QOIV;
    }

    public synchronized void setLevel(int n) {
        this.close = n;
    }

    public synchronized int getLevel() {
        return this.close;
    }

    public synchronized void setOptions(String string) {
        if (string == null) {
            this.error = null;
        }
        this.error = TypeUtil.stringToArray(string, " ");
    }

    public synchronized String[] getOptions() {
        return this.error;
    }

    public synchronized void flush() {
        if (this.close == 0) {
            return;
        }
        try {
            this.QOIV.flush();
        }
        catch (IOException iOException) {
            ErrorMessages.error("Log.flush(): ", iOException);
        }
    }

    public synchronized void close() {
        if (this.close == 0) {
            return;
        }
        try {
            this.QOIV.close();
        }
        catch (IOException iOException) {
            ErrorMessages.error("Log.close(): ", iOException);
        }
    }

    public synchronized void print(String string) throws IOException {
        if (string != null) {
            this.QOIV.write(string.getBytes());
        }
    }

    public synchronized void print(int n) throws IOException {
        this.print(String.valueOf(n));
    }

    public synchronized void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public synchronized void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public synchronized void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public synchronized void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public synchronized void println() throws IOException {
        this.print(lineSeparator);
    }
}

