/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import jet.server.util.Alarm;
import jet.server.util.AlarmHandler;
import jet.server.util.AlarmManager;
import jet.server.util.ErrorMessages;

public class LogOutputStream
extends OutputStream
implements AlarmHandler {
    protected byte[] buf;
    protected int count;
    long QOIV;
    File append;
    long arraycopy;
    final int canWrite = 9;
    protected static final String lineSeparator = System.getProperty("line.separator", "\n");
    private FileOutputStream close;
    private static AlarmManager delete = new AlarmManager();
    private int error;
    private Date exists = new Date();

    public LogOutputStream(File file, long l, int n, int n2) throws IOException {
        this.buf = new byte[n];
        this.arraycopy = l;
        this.append = file;
        this.error = n2;
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new FileNotFoundException("Cannot create log directory " + file2 + ". " + "Make sure that the parent directory has the " + "correct permissions.");
        }
        if (file.exists() && !file.canWrite()) {
            throw new FileNotFoundException("Cannot write to log file " + file + ". " + "Make sure that the file has the correct permissions.");
        }
        if (l != 0L && file.length() >= l) {
            this.QOIV();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Cannot write to log file " + file + ". " + "Make sure that the file has the correct permissions.");
        }
        randomAccessFile.seek(randomAccessFile.length());
        this.close = new FileOutputStream(randomAccessFile.getFD());
        if (n2 > 0) {
            Alarm alarm = new Alarm(this);
            alarm.setTimeFromNow(n2 * 1000);
            delete.schedule(alarm);
        }
    }

    public LogOutputStream(File file) throws IOException {
        this(file, 100000L, 512, 0);
    }

    public LogOutputStream(File file, long l, int n) throws IOException {
        this(file, l, n, 0);
    }

    public synchronized void write(int n) throws IOException {
        long l;
        ++this.QOIV;
        if (this.buf.length > 0) {
            if (this.count == this.buf.length) {
                this.flush();
            }
            this.buf[this.count++] = (byte)n;
        } else {
            this.close.write(n);
        }
        if (this.arraycopy != 0L && (l = this.append.length()) >= this.arraycopy) {
            this.flush();
            this.QOIV();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        long l;
        int n3 = this.buf.length - this.count;
        this.QOIV += (long)n2;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
        } else {
            this.flush();
            this.close.write(byArray, n, n2);
        }
        if (this.arraycopy != 0L && (l = this.append.length()) >= this.arraycopy) {
            this.flush();
            this.QOIV();
        }
    }

    public synchronized void flush() throws IOException {
        if (this.error == 0) {
            this.exists = new Date();
        }
        this.close.write(this.buf, 0, this.count);
        this.close.flush();
        this.count = 0;
    }

    public void handleAlarm(Alarm alarm) {
        if (this.error == 0) {
            return;
        }
        if (alarm.getTime() >= this.exists.getTime() + (long)(this.error * 1000)) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                ErrorMessages.error("Autoflush: error writing to log file " + this.append, iOException);
            }
        }
        alarm.setTimeFromNow(this.error * 1000);
        delete.schedule(alarm);
    }

    void QOIV() throws IOException {
        File file;
        File file2;
        if (this.close != null) {
            this.close.flush();
            this.close.close();
        }
        if ((file2 = new File(this.append.getAbsolutePath() + "." + 9)).exists()) {
            file2.delete();
        }
        int n = 8;
        while (n > 0) {
            file = new File(this.append.getAbsolutePath() + "." + n);
            if (file.exists()) {
                file.renameTo(new File(this.append.getAbsolutePath() + "." + (n + 1)));
            }
            --n;
        }
        file = new File(this.append.getAbsolutePath() + "." + 1);
        this.append.renameTo(file);
        this.close = new FileOutputStream(this.append);
        this.QOIV = 0L;
    }

    public void close() throws IOException {
        super.close();
        if (this.close != null) {
            this.close.close();
        }
    }

    static {
        new Thread((Runnable)delete, "Logging Alarm Manager").start();
    }
}

