/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import jet.server.log.Log;
import jet.server.util.ErrorMessages;

public class TraceLog
extends Log {
    private Date QOIV = new Date();
    private PrintStream append;

    public TraceLog() {
    }

    public TraceLog(OutputStream outputStream) {
        super(outputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream);
        this.append = null;
    }

    public void write(String string) {
        this.write(2, string);
    }

    public synchronized void write(int n, String string) {
        if (this.getLevel() < n) {
            return;
        }
        this.QOIV.setTime(System.currentTimeMillis());
        try {
            this.print("[");
            this.print(this.useGMT() ? this.QOIV.toGMTString() : this.QOIV.toString());
            this.print("] " + n + " ");
            this.println(string);
        }
        catch (IOException iOException) {
            ErrorMessages.error("TraceLog.write()", iOException);
        }
    }

    public void write(Throwable throwable) {
        this.write(2, throwable);
    }

    public synchronized void write(int n, Throwable throwable) {
        if (this.getLevel() < n) {
            return;
        }
        this.write(n, throwable.toString());
        if (this.append == null) {
            this.append = new PrintStream(this.getOutputStream());
        }
        throwable.printStackTrace(this.append);
    }
}

