/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.adhoc;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.adhoc.AdhocEngineInfo;
import jet.server.monitor.api.adhoc.AdhocMonitor;
import jet.server.monitor.api.adhoc.AdhocServiceInfo;
import jet.server.monitor.api.adhoc.AdhocTaskInfo;
import jet.server.monitor.event.EventType;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.adhoc.AdhocConstants;
import jet.server.monitor.jrmon.adhoc.AdhocMonitorThread;
import jet.server.monitor.jrmon.adhoc.JRAdhocEngineInfo;
import jet.server.monitor.jrmon.adhoc.JRAdhocServiceInfo;
import jet.server.monitor.jrmon.adhoc.JRAdhocTaskInfo;

public class JRAdhocMonitor
implements AdhocMonitor,
AdhocConstants,
EventType {
    private MonitorService QOIV = null;
    private int addElement = 2000;
    private int addFailedTask = 180000;
    private int addFinishedTask = 50;
    private boolean append = false;
    private Hashtable arraycopy = new Hashtable();
    private Hashtable clear = null;
    private Hashtable containsKey = null;
    private Hashtable currentTimeMillis = null;
    private Hashtable elementAt = null;
    private Hashtable elements = null;
    private Hashtable equals = null;
    private Hashtable equalsIgnoreCase = null;
    private boolean get = true;
    private int getAllFinishedTasks = 0;
    private int getCompletedTime = 0;
    private int getDefaultInterval = 0;
    private AdhocMonitorThread getEngines = null;
    private long getMaxNumberSaveReport = 0L;

    public JRAdhocMonitor() {
    }

    public JRAdhocMonitor(MonitorService monitorService) {
        this(monitorService, monitorService.getDefaultInterval());
    }

    public JRAdhocMonitor(MonitorService monitorService, int n) {
        this.QOIV = monitorService;
        this.addElement = n;
        this.init();
    }

    public void init() {
        this.clear = new Hashtable();
        this.containsKey = new Hashtable();
        this.currentTimeMillis = new Hashtable();
        this.elementAt = new Hashtable();
        this.arraycopy = new Hashtable();
        this.elements = new Hashtable();
        this.equals = new Hashtable();
        this.equalsIgnoreCase = new Hashtable();
        this.get = true;
        this.getAllFinishedTasks = 0;
        this.getCompletedTime = 0;
        this.getDefaultInterval = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllRunningTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRunningTasksByUser(String string) {
        Vector<AdhocTaskInfo> vector = new Vector<AdhocTaskInfo>();
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (!adhocTaskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(adhocTaskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllWaitingTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.clear;
        synchronized (hashtable) {
            Enumeration enumeration = this.clear.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getWaitingTasksByUser(String string) {
        Vector<AdhocTaskInfo> vector = new Vector<AdhocTaskInfo>();
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.clear;
        synchronized (hashtable) {
            Enumeration enumeration = this.clear.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (!adhocTaskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(adhocTaskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFinishedTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFinishedTasksByUser(String string) {
        Vector<AdhocTaskInfo> vector = new Vector<AdhocTaskInfo>();
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (!adhocTaskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(adhocTaskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFailedTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.elementAt;
        synchronized (hashtable) {
            Enumeration enumeration = this.elementAt.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFailedTasksByUser(String string) {
        Vector<AdhocTaskInfo> vector = new Vector<AdhocTaskInfo>();
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.elementAt;
        synchronized (hashtable) {
            Enumeration enumeration = this.elementAt.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (!adhocTaskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(adhocTaskInfo);
            }
        }
        return vector;
    }

    public AdhocTaskInfo getTaskInfo(String string) {
        AdhocTaskInfo adhocTaskInfo = null;
        adhocTaskInfo = this.clear.get(string) != null ? (AdhocTaskInfo)this.clear.get(string) : (this.containsKey.get(string) != null ? (AdhocTaskInfo)this.containsKey.get(string) : (AdhocTaskInfo)this.currentTimeMillis.get(string));
        return adhocTaskInfo;
    }

    public void stopTask(String string) {
    }

    public void stopTask(AdhocTaskInfo adhocTaskInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllEngines() {
        Vector vector = new Vector();
        Hashtable hashtable = this.elements;
        synchronized (hashtable) {
            Enumeration enumeration = this.elements.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllServices() {
        Vector vector = new Vector();
        Hashtable hashtable = this.equals;
        synchronized (hashtable) {
            Enumeration enumeration = this.equals.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getServicesByUser(String string) {
        Vector<AdhocServiceInfo> vector = new Vector<AdhocServiceInfo>();
        AdhocServiceInfo adhocServiceInfo = null;
        Hashtable hashtable = this.equals;
        synchronized (hashtable) {
            Enumeration enumeration = this.equals.elements();
            while (enumeration.hasMoreElements()) {
                adhocServiceInfo = (AdhocServiceInfo)enumeration.nextElement();
                if (!string.equalsIgnoreCase(adhocServiceInfo.getUserName())) continue;
                vector.addElement(adhocServiceInfo);
            }
        }
        return vector;
    }

    public void start() {
        int n = 0;
        while (this.getMaxNumberSaveReport == 0L && n++ < 5) {
            try {
                this.getMaxNumberSaveReport = ((JRMonitorService)this.QOIV).getRemoteMonitorService().getServerCurrentTime();
            }
            catch (RemoteException remoteException) {
                this.getMaxNumberSaveReport = 0L;
            }
        }
        this.getMaxNumberSaveReport = this.getMaxNumberSaveReport == 0L ? 0L : System.currentTimeMillis() - this.getMaxNumberSaveReport;
        this.elements.clear();
        this.equals.clear();
        this.getEngines = new AdhocMonitorThread(this);
        this.getEngines.start();
        this.append = true;
    }

    public void restart() {
        this.getEngines.stopRun();
        this.init();
        this.start();
    }

    public void stop() {
        this.getEngines.stopRun();
        this.append = false;
    }

    public void setInterval(int n) {
        this.addElement = n;
    }

    public int getInterval() {
        return this.addElement;
    }

    public void setDuration(int n) {
        this.addFailedTask = n;
    }

    public int getDuration() {
        return this.addFailedTask;
    }

    public boolean isStarted() {
        return this.append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object;
        String string;
        this.addFailedTask = MonitorEnv.getMaxTimeSaveReport() * 60 * 1000;
        this.addFinishedTask = MonitorEnv.getMaxNumberSaveReport();
        if (this.addFailedTask == 0 && this.addFinishedTask == 0) {
            return;
        }
        if (this.addFailedTask > 0) {
            string = null;
            object = null;
            Hashtable hashtable = this.currentTimeMillis;
            synchronized (hashtable) {
                Enumeration enumeration = this.currentTimeMillis.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (AdhocTaskInfo)this.currentTimeMillis.get(string);
                    if (System.currentTimeMillis() - object.getCompletedTime() <= (long)this.addFailedTask) continue;
                    this.currentTimeMillis.remove(string);
                }
            }
        }
        if (this.addFinishedTask > 0) {
            string = null;
            object = this.currentTimeMillis;
            synchronized (object) {
                while (this.currentTimeMillis.size() > this.addFinishedTask) {
                    string = this.QOIV();
                    this.currentTimeMillis.remove(string);
                }
            }
        }
    }

    private String QOIV() {
        String string = null;
        String string2 = "";
        AdhocTaskInfo adhocTaskInfo = null;
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.currentTimeMillis.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            adhocTaskInfo = (AdhocTaskInfo)this.currentTimeMillis.get(string);
            if (adhocTaskInfo.getCompletedTime() >= l) continue;
            l = adhocTaskInfo.getCompletedTime();
            string2 = string;
        }
        return string2;
    }

    private void addElement(AdhocTaskInfo adhocTaskInfo) {
        this.clear.put(adhocTaskInfo.getTaskID(), adhocTaskInfo);
    }

    private void append(AdhocTaskInfo adhocTaskInfo) {
        this.clear.remove(adhocTaskInfo.getTaskID());
        this.containsKey.put(adhocTaskInfo.getTaskID(), adhocTaskInfo);
    }

    public void addFinishedTask(AdhocTaskInfo adhocTaskInfo) {
        this.clear.remove(adhocTaskInfo.getTaskID());
        this.containsKey.remove(adhocTaskInfo.getTaskID());
        this.currentTimeMillis.put(adhocTaskInfo.getTaskID(), adhocTaskInfo);
        if (this.get) {
            this.getAllFinishedTasks = (int)((long)this.getAllFinishedTasks + (adhocTaskInfo.getCompletedTime() - adhocTaskInfo.getStartedTime()));
            this.getCompletedTime = (int)((long)this.getCompletedTime + (adhocTaskInfo.getStartedTime() - adhocTaskInfo.getSubmittedTime()));
            ++this.getDefaultInterval;
        }
        String string = adhocTaskInfo.getUserName();
        int n = 0;
        if (this.arraycopy.get(string) != null) {
            n = (Integer)this.arraycopy.get(string);
        }
        this.arraycopy.put(string, new Integer(++n));
    }

    public void addFailedTask(AdhocTaskInfo adhocTaskInfo) {
        this.clear.remove(adhocTaskInfo.getTaskID());
        this.containsKey.remove(adhocTaskInfo.getTaskID());
        this.currentTimeMillis.remove(adhocTaskInfo.getTaskID());
        this.elementAt.put(adhocTaskInfo.getTaskID(), adhocTaskInfo);
    }

    private int arraycopy(Hashtable hashtable, String string) {
        int n = 0;
        if (hashtable.containsKey(string)) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                if (!((String)enumeration.nextElement()).startsWith(string)) continue;
                ++n;
            }
        }
        return n;
    }

    private String clear(String string) {
        int n;
        String string2 = null;
        int n2 = this.arraycopy(this.clear, string);
        if (n2 < (n = this.arraycopy(this.containsKey, string))) {
            n2 = n;
        }
        if (n2 < (n = this.arraycopy(this.currentTimeMillis, string))) {
            n2 = n;
        }
        if (n2 == 0) {
            string2 = string;
            if (this.equalsIgnoreCase.get(string) != null) {
                this.equalsIgnoreCase.remove(string);
            }
        } else {
            if (this.equalsIgnoreCase.get(string) != null) {
                n2 = (Integer)this.equalsIgnoreCase.get(string) + 1;
            }
            string2 = string + "_uid_" + n2;
            this.equalsIgnoreCase.put(string, new Integer(n2));
        }
        return string2;
    }

    private AdhocTaskInfo containsKey(Hashtable hashtable, String string) {
        AdhocTaskInfo adhocTaskInfo = null;
        if (this.equalsIgnoreCase.containsKey(string)) {
            int n = (Integer)this.equalsIgnoreCase.get(string);
            int n2 = 1;
            while (n2 <= n) {
                adhocTaskInfo = (AdhocTaskInfo)hashtable.get(string + "_uid_" + n2);
                if (adhocTaskInfo != null) break;
                ++n2;
            }
        }
        return adhocTaskInfo;
    }

    public void addTask(int n, Properties properties) {
        AdhocTaskInfo adhocTaskInfo = null;
        String string = properties.getProperty("task_id");
        int n2 = Integer.parseInt(properties.getProperty("task_status"));
        switch (n) {
            case 0: {
                adhocTaskInfo = (AdhocTaskInfo)this.clear.get(string);
                if (adhocTaskInfo == null || n2 == 1) {
                    int n3 = -1;
                    try {
                        n3 = Integer.parseInt(properties.getProperty("task_port"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = -1;
                    }
                    long l = -1L;
                    try {
                        l = Long.parseLong(properties.getProperty("task_init_time")) + this.getMaxNumberSaveReport;
                    }
                    catch (NumberFormatException numberFormatException) {
                        l = -1L;
                    }
                    adhocTaskInfo = new JRAdhocTaskInfo(string, properties.getProperty("task_user_id"), properties.getProperty("task_type"), properties.getProperty("task_host_name"), n3, l, n2);
                    ((JRAdhocTaskInfo)adhocTaskInfo).setTaskID(this.clear(string));
                    this.addElement(adhocTaskInfo);
                }
                ((JRAdhocTaskInfo)adhocTaskInfo).setTaskStatus(n2);
                break;
            }
            case 1: {
                adhocTaskInfo = (AdhocTaskInfo)this.clear.get(string);
                if (adhocTaskInfo == null) {
                    adhocTaskInfo = this.containsKey(this.clear, string);
                }
                if (adhocTaskInfo == null) break;
                long l = -1L;
                try {
                    l = Long.parseLong(properties.getProperty("task_run_time")) + this.getMaxNumberSaveReport;
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                ((JRAdhocTaskInfo)adhocTaskInfo).setReports((String[])properties.get("task_reports"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setDSOs((String[])properties.get("task_dso"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setStartedTime(l);
                ((JRAdhocTaskInfo)adhocTaskInfo).setResultFiles((String[])properties.get("task_result_files"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setTaskStatus(n2);
                this.append(adhocTaskInfo);
                break;
            }
            case 2: {
                adhocTaskInfo = (AdhocTaskInfo)this.containsKey.get(string);
                if (adhocTaskInfo == null && (adhocTaskInfo = this.containsKey(this.containsKey, string)) == null && (adhocTaskInfo = (AdhocTaskInfo)this.clear.get(string)) == null) {
                    adhocTaskInfo = this.containsKey(this.clear, string);
                }
                if (adhocTaskInfo == null) break;
                long l = -1L;
                try {
                    l = Long.parseLong(properties.getProperty("task_run_time")) + this.getMaxNumberSaveReport;
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                long l2 = -1L;
                try {
                    l2 = Long.parseLong(properties.getProperty("task_complete_time")) + this.getMaxNumberSaveReport;
                }
                catch (NumberFormatException numberFormatException) {
                    l2 = -1L;
                }
                int n4 = -1;
                try {
                    n4 = Integer.parseInt(properties.getProperty("task_rpt_page"));
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = -1;
                }
                ((JRAdhocTaskInfo)adhocTaskInfo).setReports((String[])properties.get("task_reports"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setDSOs((String[])properties.get("task_dso"));
                if (l != -1L) {
                    ((JRAdhocTaskInfo)adhocTaskInfo).setStartedTime(l);
                }
                ((JRAdhocTaskInfo)adhocTaskInfo).setCompletedTime(l2);
                ((JRAdhocTaskInfo)adhocTaskInfo).setReportPages(n4);
                ((JRAdhocTaskInfo)adhocTaskInfo).setReason(properties.getProperty("task_reason"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setTaskStatus(n2);
                this.addFinishedTask(adhocTaskInfo);
                break;
            }
            case 3: {
                adhocTaskInfo = (AdhocTaskInfo)this.currentTimeMillis.get(string);
                if (adhocTaskInfo == null && (adhocTaskInfo = (AdhocTaskInfo)this.containsKey.get(string)) == null && (adhocTaskInfo = (AdhocTaskInfo)this.clear.get(string)) == null && (adhocTaskInfo = this.containsKey(this.clear, string)) == null && (adhocTaskInfo = this.containsKey(this.containsKey, string)) == null) {
                    adhocTaskInfo = this.containsKey(this.currentTimeMillis, string);
                }
                if (adhocTaskInfo == null) break;
                ((JRAdhocTaskInfo)adhocTaskInfo).setFailedInfo(properties.getProperty("task_failed_info"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setReports((String[])properties.get("task_reports"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setDSOs((String[])properties.get("task_dso"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setReason(properties.getProperty("task_reason"));
                ((JRAdhocTaskInfo)adhocTaskInfo).setFailedToRun();
                ((JRAdhocTaskInfo)adhocTaskInfo).setTaskStatus(n2);
                this.addFailedTask(adhocTaskInfo);
                break;
            }
            default: {
                ServiceLogger.logEvent(6660027, String.valueOf(n), 6);
            }
        }
    }

    public void addEngine(int n, Properties properties) {
        String string = properties.getProperty("engine_id");
        AdhocEngineInfo adhocEngineInfo = (AdhocEngineInfo)this.elements.get(string);
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        try {
            l = Long.parseLong(properties.getProperty("engine_create_time"));
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        try {
            l2 = Long.parseLong(properties.getProperty("engine_run_time"));
        }
        catch (NumberFormatException numberFormatException) {
            l2 = -1L;
        }
        try {
            n2 = Integer.parseInt(properties.getProperty("engine_status"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        switch (n) {
            case 0: {
                String string2;
                if (adhocEngineInfo != null) {
                    ServiceLogger.logEvent(6660028, String.valueOf(string), 6);
                }
                if ((string2 = properties.getProperty("service_session_id")) == null) {
                    string2 = "";
                }
                adhocEngineInfo = new JRAdhocEngineInfo(string, string2, (String[])properties.get("engine_reports"), properties.getProperty("engine_running_report"), l, l2, n2);
                this.elements.put(string, adhocEngineInfo);
                if (string2.trim().length() <= 0) break;
                JRAdhocServiceInfo jRAdhocServiceInfo = (JRAdhocServiceInfo)this.equals.get(string2);
                if (jRAdhocServiceInfo == null) {
                    ServiceLogger.logEvent(6660029, new Object[]{string2, string}, 6);
                    return;
                }
                String[] stringArray = jRAdhocServiceInfo.getEngines();
                boolean bl = false;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string.equals(stringArray[n3])) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) break;
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string;
                jRAdhocServiceInfo.setEngines(stringArray2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (adhocEngineInfo == null) {
                    ServiceLogger.logEvent(6660030, string, 6);
                    adhocEngineInfo = new JRAdhocEngineInfo(string, properties.getProperty("service_session_id"), (String[])properties.get("engine_reports"), properties.getProperty("engine_running_report"), l, l2, n2);
                    this.elements.put(string, adhocEngineInfo);
                    break;
                }
                ((JRAdhocEngineInfo)adhocEngineInfo).setSessionID(properties.getProperty("service_session_id"));
                ((JRAdhocEngineInfo)adhocEngineInfo).setReports((String[])properties.get("engine_reports"));
                ((JRAdhocEngineInfo)adhocEngineInfo).setRunningReport(properties.getProperty("engine_running_report"));
                ((JRAdhocEngineInfo)adhocEngineInfo).setCreateTime(l);
                ((JRAdhocEngineInfo)adhocEngineInfo).setRunningTime(l2);
                ((JRAdhocEngineInfo)adhocEngineInfo).setRunningStatus(n2);
                break;
            }
            case 6: {
                if (adhocEngineInfo == null) break;
                this.elements.remove(string);
                break;
            }
            default: {
                ServiceLogger.logEvent(6660031, String.valueOf(n), 6);
            }
        }
    }

    public void addService(int n, Properties properties) {
        String string = properties.getProperty("service_session_id");
        JRAdhocServiceInfo jRAdhocServiceInfo = (JRAdhocServiceInfo)this.equals.get(string);
        String[] stringArray = (String[])properties.get("service_engines");
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        try {
            l = Long.parseLong(properties.getProperty("service_start_time"));
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        try {
            l2 = Long.parseLong(properties.getProperty("service_last_access_time"));
        }
        catch (NumberFormatException numberFormatException) {
            l2 = -1L;
        }
        try {
            n2 = Integer.parseInt(properties.getProperty("service_status"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (jRAdhocServiceInfo == null) {
                    if (n2 == 2 || n2 == 3) {
                        ServiceLogger.logEvent(6660032, string, 6);
                    }
                    jRAdhocServiceInfo = new JRAdhocServiceInfo(string, properties.getProperty("service_user_id"), stringArray, (String[])properties.get("service_report_sets"), l, l2, n2);
                    this.equals.put(string, jRAdhocServiceInfo);
                    break;
                }
                jRAdhocServiceInfo.setUserName(properties.getProperty("service_user_id"));
                jRAdhocServiceInfo.setEngines(stringArray);
                jRAdhocServiceInfo.setReportSets((String[])properties.get("service_report_sets"));
                jRAdhocServiceInfo.setStartedTime(l);
                jRAdhocServiceInfo.setlastAccessedTime(l2);
                jRAdhocServiceInfo.setStatus(n2);
                break;
            }
            case 3: {
                this.equals.remove(string);
                String string2 = "";
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string2 = stringArray[n3];
                    this.elements.remove(string2);
                    ++n3;
                }
                break;
            }
            default: {
                ServiceLogger.logEvent(6660033, String.valueOf(n), 6);
            }
        }
    }

    public MonitorService getMonitorService() {
        return this.QOIV;
    }

    public int getWaitingRptNums() {
        return this.clear.size();
    }

    public int getRunningRptNums() {
        return this.containsKey.size();
    }

    public int getFinishedRptNums() {
        return this.getAllFinishedTasks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages() {
        int n = 0;
        JRAdhocTaskInfo jRAdhocTaskInfo = null;
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Vector vector = this.getAllFinishedTasks();
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                jRAdhocTaskInfo = (JRAdhocTaskInfo)vector.elementAt(n2);
                n += jRAdhocTaskInfo.getTotalPages();
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptNums(int n) {
        int n2 = 0;
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - adhocTaskInfo.getCompletedTime() >= (long)(n * 60 * 1000)) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages(int n) {
        int n2 = 0;
        AdhocTaskInfo adhocTaskInfo = null;
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                adhocTaskInfo = (AdhocTaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - adhocTaskInfo.getCompletedTime() >= (long)(n * 60 * 1000)) continue;
                n2 += ((JRAdhocTaskInfo)adhocTaskInfo).getTotalPages();
            }
        }
        return n2;
    }

    public int getAvgProcessTimeByRpt() {
        if (this.getDefaultInterval != 0) {
            return this.getAllFinishedTasks / this.getDefaultInterval;
        }
        return 0;
    }

    public int getAvgWaitTimeByRpt() {
        if (this.getDefaultInterval != 0) {
            return this.getCompletedTime / this.getDefaultInterval;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgSubmitRptNumsByUser() {
        int n = 0;
        int n2 = 0;
        Hashtable hashtable = this.arraycopy;
        synchronized (hashtable) {
            Enumeration enumeration = this.arraycopy.keys();
            while (enumeration.hasMoreElements()) {
                n += ((Integer)this.arraycopy.get((String)enumeration.nextElement())).intValue();
                ++n2;
            }
        }
        if (n2 != 0) {
            return n / n2;
        }
        return 0;
    }

    public int getRptNumsSubmittedByUser(String string) {
        return (Integer)this.arraycopy.get(string);
    }
}

