/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.InvalidUserSessionException;
import jet.server.monitor.api.UserSession;
import jet.server.monitor.api.http.HttpUserSessionManager;
import jet.server.monitor.jrmon.JRUserSessionManager;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.http.AuthInfo;
import jet.server.monitor.jrmon.http.MD5Info;
import jet.server.monitor.jrmon.http.RawUserSession;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    public static final String JRM_RAW_SESSION = "jrm.raw.session";
    private int I = 5;

    public UserSession getUserSession(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            userSession = this.getUserSession((String)httpSession.getValue("jrm.user.session"));
        }
        return userSession;
    }

    private void I(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string != null && string.indexOf("index.jsp") >= 0) {
            MonitorEnv.setMonitorWebEntry("http://" + MonitorEnv.getHostAddress(httpServletRequest.getServerName()) + ":" + httpServletRequest.getServerPort() + string);
        }
    }

    private void QOIV(HttpServletRequest httpServletRequest, UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue("jrm.user.session", (Object)userSession.getID());
            httpSession.removeValue(JRM_RAW_SESSION);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException, InvalidUserSessionException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.elementAt(httpServletRequest);
            if (rawUserSession != null && rawUserSession.I > this.I) {
                throw new InvalidUserSessionException(630090);
            }
            userSession = this.append(httpServletRequest, string, properties);
            if (userSession != null) {
                AuthInfo authInfo = this.currentTimeMillis(httpServletRequest, string, properties);
                if (MonitorEnv.isAdminUser(string, authInfo.I, authInfo.Z)) {
                    this.QOIV(httpServletRequest, userSession);
                    this.I(httpServletRequest);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private UserSession append(HttpServletRequest httpServletRequest, String string, Properties properties) throws InvalidUserSessionException, IOException {
        UserSession userSession = null;
        AuthInfo authInfo = this.currentTimeMillis(httpServletRequest, string, properties);
        if (authInfo != null) {
            RawUserSession rawUserSession = this.elementAt(httpServletRequest);
            if (rawUserSession != null && authInfo.C != null && rawUserSession.C != null && authInfo.I != null && authInfo.C.B != null && authInfo.C.Z != null && authInfo.C.Z.equals(rawUserSession.C.Z) && (authInfo.C.C == null || authInfo.C.C.equals(rawUserSession.C.C))) {
                return this.loginMD5(rawUserSession.Z, authInfo.I, authInfo.C.B, authInfo.C.Z, rawUserSession.C.I, httpServletRequest.getMethod());
            }
            userSession = this.login(string, authInfo.I, authInfo.Z);
        }
        return userSession;
    }

    private AuthInfo currentTimeMillis(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        if (string2 != null && string2.length() > 0) {
            int n;
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null || httpSession.isNew()) {
                authInfo = this.decode(properties);
            }
            if ((n = (string2 = string2.trim()).indexOf(" ")) > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1");
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.I = string3.substring(0, n);
                        authInfo.Z = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).Z = string6;
                    ((MD5Info)object).C = string8;
                    ((MD5Info)object).B = string7;
                    authInfo = new AuthInfo();
                    authInfo.I = string4;
                    authInfo.C = object;
                }
            }
        } else {
            authInfo = this.decode(properties);
        }
        return authInfo;
    }

    private AuthInfo decode(Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1");
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.I = string;
            authInfo.Z = string2;
        }
        return authInfo;
    }

    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        this.equals(httpServletRequest);
        RawUserSession rawUserSession = this.elementAt(httpServletRequest);
        rawUserSession.Z = string2;
        if (string.equals("Digest")) {
            rawUserSession.C = new MD5Info(httpServletRequest);
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", rawUserSession.I());
        httpServletResponse.setHeader("MonitoredTo", MonitorEnv.getAdminAddress());
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>Unauthorized</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>401 Unauthorized</h1>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Vector vector = this.getAllUserSessions();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                userSession = (UserSession)vector.elementAt(n);
                if (System.currentTimeMillis() - userSession.getLastAccessTime() > (long)userSession.getMaxInactiveInterval()) {
                    this.logout(httpServletRequest, userSession);
                }
                ++n;
            }
        }
        userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            this.putUsersessions(userSession);
        }
    }

    public void logout(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            UserSession userSession = this.getUserSession(httpServletRequest);
            this.logout(httpServletRequest, userSession);
        }
    }

    public void logout(HttpServletRequest httpServletRequest, UserSession userSession) {
        if (userSession != null) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                try {
                    httpSession.removeValue("jrm.user.session");
                    httpSession.invalidate();
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            super.logout(userSession);
        }
    }

    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6) throws InvalidUserSessionException {
        UserSession userSession = null;
        String string7 = MonitorEnv.getPassword(string, string2);
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7);
        }
        return userSession;
    }

    private RawUserSession elementAt(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            rawUserSession = (RawUserSession)httpSession.getValue(JRM_RAW_SESSION);
        }
        return rawUserSession;
    }

    private void equals(HttpServletRequest httpServletRequest) {
        if (this.elementAt(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(JRM_RAW_SESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }
}

