/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.task;

import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import jet.server.monitor.api.task.TaskInfo;

public class JRTaskInfo
implements TaskInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3131623626156526947L;
    public static final int ON_DEMAND = 1;
    public static final int SCHEDULED = 2;
    public static final int BURSTING_MAIN = 3;
    public static final int BURSTING_SUB = 4;
    public static final String[] Task_Type = new String[]{"", "On-Demand", "Schedule", "Bursting(main)", "Bursting(sub)"};
    public static final int SUBMITED = 1;
    public static final int UNLAUNCH = 2;
    public static final int TASK_QUEUE = 3;
    public static final int RUNNING = 4;
    public static final int INIT_ENGINE = 5;
    public static final int LOAD_REPORT = 6;
    public static final int EXPORTING = 7;
    public static final int EXIT_ENGINE = 8;
    public static final int COMPLETED = 9;
    public static final int FAILED = 10;
    public static final String[] Task_Status = new String[]{"", "Submited", "Unlaunch", "Task Queue", "Running", "Initializing Engine", "Loading Report", "Exporting", "Exiting Engine", "Completed", "Failed"};
    private String taskID = null;
    private long submitTime = -1L;
    private long startTime = -1L;
    private long finishTime = -1L;
    private String rptName = null;
    private int rptPages = -1;
    private String rptSource = null;
    private String rstFileName = null;
    private int taskType = 0;
    private int taskStatus = 0;
    private String userName = null;
    private String serverName = null;
    private String runHost = null;
    private int runPort = -1;
    private String reason = null;
    private String engineInfo = null;
    private String failedInfo = null;
    private boolean isFailed = false;
    private int totalPages = -1;

    public JRTaskInfo() {
    }

    public JRTaskInfo(String string, String string2, int n, String string3, long l, String string4, String string5) {
        this(string, string2, n, string3, null, -1, l, -1L, string4, string5);
    }

    public JRTaskInfo(String string, String string2, int n, String string3, String string4, int n2, long l, long l2, String string5, String string6) {
        this(string, string2, n, string3, string4, n2, l, l2, -1L, 0, string5, null, string6, null, null);
    }

    public JRTaskInfo(String string, String string2, int n, String string3, String string4, int n2, long l, long l2, long l3, int n3, String string5, String string6, String string7, String string8, String string9) {
        this.taskID = string;
        this.rptName = string2;
        this.taskType = n;
        this.serverName = string3;
        this.runHost = string4;
        this.runPort = n2;
        this.submitTime = l;
        this.startTime = l2;
        this.finishTime = l3;
        this.rptPages = n3;
        this.rptSource = string5;
        this.rstFileName = string6;
        this.userName = string7;
        this.reason = string8;
        this.engineInfo = string9;
    }

    public JRTaskInfo(String string, String string2, int n, String string3, String string4, int n2, long l, long l2, long l3, int n3, String string5, String string6, String string7, String string8, String string9, int n4, String string10) {
        this.taskID = string;
        this.rptName = string2;
        this.taskType = n;
        this.serverName = string3;
        this.runHost = string4;
        this.runPort = n2;
        this.submitTime = l;
        this.startTime = l2;
        this.finishTime = l3;
        this.rptPages = n3;
        this.rptSource = string5;
        this.rstFileName = string6;
        this.userName = string7;
        this.reason = string8;
        this.engineInfo = string9;
        this.taskStatus = n4;
        this.failedInfo = string10;
    }

    public JRTaskInfo(TaskInfo taskInfo) {
        this(taskInfo.getTaskID(), taskInfo.getReportName(), taskInfo.getTaskType().equals(Task_Type[1]) ? 1 : 2, taskInfo.getRunServerName(), taskInfo.getRunHost(), taskInfo.getRunPort(), taskInfo.getSubmittedTime(), taskInfo.getStartedTime(), taskInfo.getFinishedTime(), taskInfo.getReportPages(), taskInfo.getReportSource(), taskInfo.getResultFileName(), taskInfo.getUserName(), taskInfo.getReason(), ((JRTaskInfo)taskInfo).getEngineInfo(), ((JRTaskInfo)taskInfo).getTaskStatusIntValue(), taskInfo.getFailedInfo());
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String string) {
        this.taskID = string;
    }

    public long getSubmittedTime() {
        return this.submitTime;
    }

    public void setSubmittedTime(long l) {
        this.submitTime = l;
    }

    public long getStartedTime() {
        return this.startTime;
    }

    public void setStartedTime(long l) {
        this.startTime = l;
    }

    public long getFinishedTime() {
        return this.finishTime;
    }

    public void setFinishedTime(long l) {
        this.finishTime = l;
    }

    public String getReportName() {
        return this.rptName;
    }

    public void setReportName(String string) {
        this.rptName = string;
    }

    public int getReportPages() {
        return this.rptPages;
    }

    public void setReportPages(int n) {
        this.rptPages = n;
    }

    public String getReportSource() {
        return this.rptSource;
    }

    public void setReportSource(String string) {
        this.rptSource = string;
    }

    public String getResultFileName() {
        return this.rstFileName;
    }

    public void setResultFileName(String string) {
        this.rstFileName = string;
    }

    public String getTaskType() {
        return Task_Type[this.taskType];
    }

    public void setTaskType(int n) {
        this.taskType = n;
    }

    public String getTaskStatus() {
        return Task_Status[this.taskStatus];
    }

    public void setTaskStatus(int n) {
        this.taskStatus = n;
    }

    public int getTaskStatusIntValue() {
        return this.taskStatus;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getRunServerName() {
        return this.serverName;
    }

    public void setRunServerName(String string) {
        this.serverName = string;
    }

    public String getRunHost() {
        return this.runHost;
    }

    public void setRunHost(String string) {
        this.runHost = string;
    }

    public int getRunPort() {
        return this.runPort;
    }

    public void setRunPort(int n) {
        this.runPort = n;
    }

    public boolean isFailedToRun() {
        return this.isFailed | (this.reason != null && this.reason.trim().length() != 0) | (this.failedInfo != null && this.failedInfo.trim().length() != 0);
    }

    public void setFailedToRun() {
        this.isFailed = true;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getReason() {
        return this.reason;
    }

    public void setEngineInfo(String string) {
        this.engineInfo = string;
    }

    public String getEngineInfo() {
        return this.engineInfo;
    }

    public String getFailedInfo() {
        return this.failedInfo;
    }

    public void setFailedInfo(String string) {
        this.failedInfo = string;
    }

    public int getTotalPages() {
        if (this.totalPages < 0) {
            if (this.taskType == 1) {
                this.totalPages = this.rptPages;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.rstFileName, ",");
                int n = this.rstFileName.trim().lastIndexOf("[");
                n = n > 1 ? 1 : 0;
                while (stringTokenizer.hasMoreTokens()) {
                    ++n;
                    stringTokenizer.nextToken();
                }
                if (this.rstFileName.indexOf("File System") > -1) {
                    --n;
                }
                if (this.rstFileName.indexOf("Versioning System") > -1) {
                    --n;
                }
                this.totalPages = this.rptPages * n;
            }
        }
        return this.totalPages;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TaskInfo) {
            TaskInfo taskInfo = (TaskInfo)object;
            return !(taskInfo.getTaskID() != this.taskID && !taskInfo.getTaskID().equals(this.taskID) || taskInfo.getReportName() != this.rptName && !taskInfo.getReportName().equals(this.rptName) || taskInfo.getTaskType() != Task_Type[this.taskType] || taskInfo.getRunServerName() != this.serverName && !taskInfo.getRunServerName().equals(this.serverName) || taskInfo.getRunHost() != this.runHost && !taskInfo.getRunHost().equals(this.runHost) || taskInfo.getRunPort() != this.runPort || taskInfo.getSubmittedTime() != this.submitTime || taskInfo.getStartedTime() != this.startTime || taskInfo.getFinishedTime() != this.finishTime || taskInfo.getReportPages() != this.rptPages || taskInfo.getReportSource() != this.rptSource && !taskInfo.getReportSource().equals(this.rptSource) || taskInfo.getResultFileName() != this.rstFileName && !taskInfo.getResultFileName().equals(this.rstFileName) || taskInfo.getUserName() != this.userName && !taskInfo.getUserName().equals(this.userName) || taskInfo.getReason() != this.reason && !taskInfo.getReason().equals(this.reason) || taskInfo.getFailedInfo() != this.failedInfo && !taskInfo.getFailedInfo().equals(this.failedInfo) || ((JRTaskInfo)taskInfo).getTaskStatusIntValue() != this.taskStatus);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Task Info [task ID:").append(this.taskID);
        stringBuffer.append(";report name:").append(this.rptName);
        stringBuffer.append(";task type:").append(this.taskType == 1 ? "On-Demand" : "Schedule");
        stringBuffer.append(";server name:").append(this.serverName);
        stringBuffer.append(";catalog:").append(this.rptSource);
        stringBuffer.append(";user anme:").append(this.userName);
        stringBuffer.append(";submit time:").append(new Date(this.submitTime));
        stringBuffer.append(";task status:").append(this.getTaskStatus());
        if (this.startTime != -1L) {
            stringBuffer.append(";start time:").append(new Date(this.startTime));
            stringBuffer.append(";run host:").append(this.runHost);
            stringBuffer.append(";run port:").append(this.runPort);
        }
        if (this.finishTime != -1L) {
            stringBuffer.append(";finish time:").append(new Date(this.finishTime));
            stringBuffer.append(";result files:").append(this.rstFileName);
            stringBuffer.append(";report pages:").append(this.rptPages);
            stringBuffer.append(";reason:").append(this.reason);
        }
        if (this.isFailedToRun()) {
            stringBuffer.append(";failed info:").append(this.failedInfo);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new JRTaskInfo(this);
    }
}

