/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.task;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.task.TaskInfo;
import jet.server.monitor.api.task.TaskMonitor;
import jet.server.monitor.api.task.TaskStatistic;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.task.JRTaskInfo;
import jet.server.monitor.jrmon.task.JRTaskStatistic;
import jet.server.monitor.jrmon.task.TaskMonitorThread;

public class JRTaskMonitor
implements TaskMonitor {
    public static final String FAILED_INFO = "failedInfo";
    public static final String FIRST_SUBMIT_TIME = "firstSubmitTime";
    public static final String RUN_TIMES_NUMBER = "runTimesNumber";
    private MonitorService QOIV = null;
    private int Task_Type = 2000;
    private int addElement = 180000;
    private int addFailedTask = 50;
    private boolean addFinishedTask = false;
    private Hashtable addRunningTask = new Hashtable();
    private Hashtable addWaitingTask = null;
    private Hashtable append = null;
    private Hashtable containsKey = null;
    private Hashtable currentTimeMillis = null;
    private Hashtable elementAt = null;
    private boolean elements = true;
    private int equals = 0;
    private int equalsIgnoreCase = 0;
    private int get = 0;
    private TaskMonitorThread getAllFinishedTasks = null;
    private long getAllTaskStatistics = 0L;
    private Hashtable getDefaultInterval = null;

    public JRTaskMonitor() {
    }

    public JRTaskMonitor(MonitorService monitorService) {
        this(monitorService, monitorService.getDefaultInterval());
    }

    public JRTaskMonitor(MonitorService monitorService, int n) {
        this.QOIV = monitorService;
        this.Task_Type = n;
        this.init();
    }

    public void init() {
        this.addWaitingTask = new Hashtable();
        this.append = new Hashtable();
        this.containsKey = new Hashtable();
        this.currentTimeMillis = new Hashtable();
        this.addRunningTask = new Hashtable();
        this.elementAt = new Hashtable();
        this.elements = true;
        this.equals = 0;
        this.equalsIgnoreCase = 0;
        this.get = 0;
        this.QOIV();
    }

    private void QOIV() {
        this.getDefaultInterval = new Hashtable();
        RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.QOIV).getRemoteMonitorService();
        try {
            Vector vector = remoteMonitorService.getAllTaskStatistics();
            int n = 0;
            while (n < vector.size()) {
                Properties properties = (Properties)vector.get(n);
                JRTaskStatistic jRTaskStatistic = new JRTaskStatistic(properties.getProperty("rptName"), Long.parseLong(properties.getProperty(FIRST_SUBMIT_TIME)), Integer.parseInt(properties.getProperty(RUN_TIMES_NUMBER)));
                jRTaskStatistic.setLastCatalogName(properties.getProperty("rptSource"));
                jRTaskStatistic.setLastSubmittedTime(Long.parseLong(properties.getProperty("submitTime")));
                jRTaskStatistic.setLastTaskID(properties.getProperty("taskID"));
                jRTaskStatistic.setLastUser(properties.getProperty("userName"));
                jRTaskStatistic.setLastPageeNumber(Integer.parseInt(properties.getProperty("rptPages")));
                this.getDefaultInterval.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
                ++n;
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllRunningTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.append;
        synchronized (hashtable) {
            Enumeration enumeration = this.append.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRunningTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.append;
        synchronized (hashtable) {
            Enumeration enumeration = this.append.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllWaitingTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.addWaitingTask;
        synchronized (hashtable) {
            Enumeration enumeration = this.addWaitingTask.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getWaitingTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.addWaitingTask;
        synchronized (hashtable) {
            Enumeration enumeration = this.addWaitingTask.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFinishedTasks() {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFinishedTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFinishedTasks(int n) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFinishedTasksByUser(String string, int n) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string) || System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllFailedTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFailedTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.currentTimeMillis;
        synchronized (hashtable) {
            Enumeration enumeration = this.currentTimeMillis.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingTask(TaskInfo taskInfo) {
        this.addWaitingTask.put(taskInfo.getTaskID(), taskInfo);
        JRTaskStatistic jRTaskStatistic = null;
        Hashtable hashtable = this.getDefaultInterval;
        synchronized (hashtable) {
            jRTaskStatistic = (JRTaskStatistic)this.getDefaultInterval.get(taskInfo.getReportName());
            if (jRTaskStatistic == null) {
                jRTaskStatistic = new JRTaskStatistic(taskInfo.getReportName(), taskInfo.getSubmittedTime(), 0);
                this.getDefaultInterval.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
            }
        }
        jRTaskStatistic.setLastUser(taskInfo.getUserName());
        jRTaskStatistic.setLastSubmittedTime(taskInfo.getSubmittedTime());
        jRTaskStatistic.setLastCatalogName(taskInfo.getReportSource());
        jRTaskStatistic.setLastTaskID(taskInfo.getTaskID());
        jRTaskStatistic.runOnce();
    }

    public void addRunningTask(TaskInfo taskInfo) {
        this.addWaitingTask.remove(taskInfo.getTaskID());
        this.append.put(taskInfo.getTaskID(), taskInfo);
    }

    public void addFinishedTask(TaskInfo taskInfo) {
        this.append.remove(taskInfo.getTaskID());
        this.containsKey.put(taskInfo.getTaskID(), taskInfo);
        if (this.elements) {
            this.equals = (int)((long)this.equals + (taskInfo.getFinishedTime() - taskInfo.getStartedTime()));
            this.equalsIgnoreCase = (int)((long)this.equalsIgnoreCase + (taskInfo.getStartedTime() - taskInfo.getSubmittedTime()));
            ++this.get;
        }
        String string = taskInfo.getUserName();
        int n = 0;
        if (this.addRunningTask.get(string) != null) {
            n = (Integer)this.addRunningTask.get(string);
        }
        this.addRunningTask.put(string, new Integer(++n));
        JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.getDefaultInterval.get(taskInfo.getReportName());
        jRTaskStatistic.setLastPageeNumber(taskInfo.getReportPages());
    }

    public void addFailedTask(TaskInfo taskInfo) {
        this.addWaitingTask.remove(taskInfo.getTaskID());
        this.append.remove(taskInfo.getTaskID());
        this.containsKey.remove(taskInfo.getTaskID());
        this.currentTimeMillis.put(taskInfo.getTaskID(), taskInfo);
        JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.getDefaultInterval.get(taskInfo.getReportName());
        jRTaskStatistic.setLastPageeNumber(taskInfo.getReportPages());
    }

    private int Task_Type(Hashtable hashtable, String string) {
        int n = 0;
        if (hashtable.containsKey(string)) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                if (!((String)enumeration.nextElement()).startsWith(string)) continue;
                ++n;
            }
        }
        return n;
    }

    private String addElement(String string) {
        int n;
        String string2 = null;
        int n2 = this.Task_Type(this.addWaitingTask, string);
        if (n2 < (n = this.Task_Type(this.append, string))) {
            n2 = n;
        }
        if (n2 < (n = this.Task_Type(this.containsKey, string))) {
            n2 = n;
        }
        if (n2 == 0) {
            string2 = string;
            if (this.elementAt.get(string) != null) {
                this.elementAt.remove(string);
            }
        } else {
            if (this.elementAt.get(string) != null) {
                n2 = (Integer)this.elementAt.get(string) + 1;
            }
            string2 = string + "_uid_" + n2;
            this.elementAt.put(string, new Integer(n2));
        }
        return string2;
    }

    private TaskInfo addFailedTask(Hashtable hashtable, String string) {
        TaskInfo taskInfo = null;
        if (this.elementAt.containsKey(string)) {
            int n = (Integer)this.elementAt.get(string);
            int n2 = 1;
            while (n2 <= n) {
                taskInfo = (TaskInfo)hashtable.get(string + "_uid_" + n2);
                if (taskInfo != null) break;
                ++n2;
            }
        }
        return taskInfo;
    }

    public void addTask(int n, Properties properties) {
        TaskInfo taskInfo = null;
        switch (n) {
            case 0: {
                taskInfo = (TaskInfo)this.addWaitingTask.get(properties.getProperty("taskID"));
                int n2 = Integer.parseInt(properties.getProperty("taskStatus"));
                if (taskInfo == null && n2 == 3) {
                    return;
                }
                if (taskInfo == null || n2 == 1 || n2 == 2) {
                    taskInfo = new JRTaskInfo(properties.getProperty("taskID"), properties.getProperty("rptName"), Integer.parseInt(properties.getProperty("taskType")), properties.getProperty("serverName"), Long.parseLong(properties.getProperty("submitTime")), properties.getProperty("rptSource"), properties.getProperty("userName"));
                    if (Integer.parseInt(properties.getProperty("taskType")) == 2) {
                        ((JRTaskInfo)taskInfo).setTaskID(this.addElement(properties.getProperty("taskID")));
                    }
                    long l = Long.parseLong(properties.getProperty("submitTime")) + this.getAllTaskStatistics;
                    ((JRTaskInfo)taskInfo).setSubmittedTime(l);
                    this.addWaitingTask(taskInfo);
                }
                ((JRTaskInfo)taskInfo).setTaskStatus(n2);
                break;
            }
            case 1: {
                String string = properties.getProperty("taskID");
                int n3 = Integer.parseInt(properties.getProperty("taskStatus"));
                if (n3 == 5 || n3 == 4) {
                    taskInfo = (TaskInfo)this.addWaitingTask.get(string);
                    if (taskInfo == null) {
                        taskInfo = this.addFailedTask(this.addWaitingTask, string);
                    }
                    if (taskInfo == null) break;
                    ((JRTaskInfo)taskInfo).setRunHost(properties.getProperty("runHost"));
                    try {
                        ((JRTaskInfo)taskInfo).setRunPort(Integer.parseInt(properties.getProperty("runPort")));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((JRTaskInfo)taskInfo).setRunPort(-1);
                    }
                    long l = Long.parseLong(properties.getProperty("startTime")) + this.getAllTaskStatistics;
                    ((JRTaskInfo)taskInfo).setStartedTime(l);
                    ((JRTaskInfo)taskInfo).setTaskStatus(n3);
                    this.addRunningTask(taskInfo);
                    break;
                }
                taskInfo = (TaskInfo)this.append.get(string);
                if (taskInfo == null) {
                    taskInfo = this.addFailedTask(this.append, string);
                }
                if (taskInfo == null) break;
                ((JRTaskInfo)taskInfo).setTaskStatus(n3);
                break;
            }
            case 2: {
                String string = properties.getProperty("taskID");
                taskInfo = (TaskInfo)this.append.get(string);
                if (taskInfo == null) {
                    taskInfo = this.addFailedTask(this.append, string);
                }
                if (taskInfo == null) break;
                ((JRTaskInfo)taskInfo).setRunHost(properties.getProperty("runHost"));
                try {
                    ((JRTaskInfo)taskInfo).setRunPort(Integer.parseInt(properties.getProperty("runPort")));
                }
                catch (NumberFormatException numberFormatException) {
                    ((JRTaskInfo)taskInfo).setRunPort(-1);
                }
                long l = Long.parseLong(properties.getProperty("finishTime")) + this.getAllTaskStatistics;
                ((JRTaskInfo)taskInfo).setFinishedTime(l);
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(properties.getProperty("rptPages"));
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = -1;
                }
                if (n4 < 0) {
                    ServiceLogger.logEvent(6660023, String.valueOf(n4), 6);
                    n4 = 0;
                }
                ((JRTaskInfo)taskInfo).setReportPages(n4);
                ((JRTaskInfo)taskInfo).setResultFileName(properties.getProperty("rstFileName"));
                ((JRTaskInfo)taskInfo).setReason(properties.getProperty("reason"));
                ((JRTaskInfo)taskInfo).setEngineInfo(properties.getProperty("engineInfo"));
                ((JRTaskInfo)taskInfo).setTaskStatus(Integer.parseInt(properties.getProperty("taskStatus")));
                this.addFinishedTask(taskInfo);
                break;
            }
            case 3: {
                String string = properties.getProperty("taskID");
                taskInfo = (TaskInfo)this.containsKey.get(string);
                if (taskInfo == null && (taskInfo = (TaskInfo)this.append.get(string)) == null && (taskInfo = (TaskInfo)this.addWaitingTask.get(string)) == null && (taskInfo = this.addFailedTask(this.addWaitingTask, string)) == null && (taskInfo = this.addFailedTask(this.append, string)) == null) {
                    taskInfo = this.addFailedTask(this.containsKey, string);
                }
                if (taskInfo == null) break;
                ((JRTaskInfo)taskInfo).setFailedInfo(properties.getProperty(FAILED_INFO));
                ((JRTaskInfo)taskInfo).setTaskStatus(Integer.parseInt(properties.getProperty("taskStatus")));
                ((JRTaskInfo)taskInfo).setFailedToRun();
                this.addFailedTask(taskInfo);
                break;
            }
            default: {
                ServiceLogger.logEvent(6660024, String.valueOf(n), 6);
            }
        }
    }

    public TaskInfo getTask(String string) {
        TaskInfo taskInfo = null;
        taskInfo = this.addWaitingTask.get(string) != null ? (TaskInfo)this.addWaitingTask.get(string) : (this.append.get(string) != null ? (TaskInfo)this.append.get(string) : (TaskInfo)this.containsKey.get(string));
        return taskInfo;
    }

    public void stopTask(TaskInfo taskInfo) {
        if (taskInfo != null) {
            String string = taskInfo.getTaskID();
            if (this.addWaitingTask.containsKey(string)) {
                this.addWaitingTask.remove(string);
            } else if (this.append.containsKey(string)) {
                this.append.remove(string);
            } else if (this.containsKey.containsKey(string)) {
                this.containsKey.remove(string);
            }
            int n = string.indexOf("_uid_");
            if (n != -1) {
                string = string.substring(0, n);
            }
            try {
                ((JRMonitorService)this.QOIV).getRemoteMonitorService().stopTask(string, taskInfo.getTaskType().equals(JRTaskInfo.Task_Type[1]) ? 1 : 2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            ServiceLogger.logEvent(6660025, 6);
        }
    }

    public void killTask(TaskInfo taskInfo) {
        if (taskInfo != null) {
            String string = taskInfo.getTaskID();
            if (this.addWaitingTask.containsKey(string)) {
                this.addWaitingTask.remove(string);
            } else if (this.append.containsKey(string)) {
                this.append.remove(string);
            } else if (this.containsKey.containsKey(string)) {
                this.containsKey.remove(string);
            }
            int n = string.indexOf("_uid_");
            if (n != -1) {
                string = string.substring(0, n);
            }
            ServiceLogger.logDebug(4660223, string, 4);
            try {
                ((JRMonitorService)this.QOIV).getRemoteMonitorService().killTask(string, taskInfo.getTaskType().equals(JRTaskInfo.Task_Type[1]) ? 1 : 2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            ServiceLogger.logEvent(6660025, 6);
        }
    }

    public int getWaitingRptNums() {
        return this.addWaitingTask.size();
    }

    public int getRunningRptNums() {
        return this.append.size();
    }

    public int getFinishedRptNums() {
        return this.getAllFinishedTasks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages() {
        int n = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Vector vector = this.getAllFinishedTasks();
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                taskInfo = (TaskInfo)vector.elementAt(n2);
                n += ((JRTaskInfo)taskInfo).getTotalPages();
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptNums(int n) {
        int n2 = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages(int n) {
        int n2 = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.containsKey;
        synchronized (hashtable) {
            Enumeration enumeration = this.containsKey.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                n2 += ((JRTaskInfo)taskInfo).getTotalPages();
            }
        }
        return n2;
    }

    public int getAvgProcessTimeByRpt() {
        if (this.get != 0) {
            return this.equals / this.get;
        }
        return 0;
    }

    public int getAvgWaitTimeByRpt() {
        if (this.get != 0) {
            return this.equalsIgnoreCase / this.get;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgSubmitRptNumsByUser() {
        int n = 0;
        int n2 = 0;
        Hashtable hashtable = this.addRunningTask;
        synchronized (hashtable) {
            Enumeration enumeration = this.addRunningTask.keys();
            while (enumeration.hasMoreElements()) {
                n += ((Integer)this.addRunningTask.get((String)enumeration.nextElement())).intValue();
                ++n2;
            }
        }
        if (n2 != 0) {
            return n / n2;
        }
        return 0;
    }

    public int getRptNumsSubmittedByUser(String string) {
        return (Integer)this.addRunningTask.get(string);
    }

    public void setInterval(int n) {
        this.Task_Type = n;
    }

    public int getInterval() {
        return this.Task_Type;
    }

    public void setDuration(int n) {
        this.addElement = n;
    }

    public int getDuration() {
        return this.addElement;
    }

    public void start() {
        int n = 0;
        this.getAllTaskStatistics = 0L;
        while (this.getAllTaskStatistics == 0L && n++ < 5) {
            try {
                this.getAllTaskStatistics = ((JRMonitorService)this.QOIV).getRemoteMonitorService().getServerCurrentTime();
            }
            catch (RemoteException remoteException) {
                this.getAllTaskStatistics = 0L;
            }
        }
        this.getAllTaskStatistics = this.getAllTaskStatistics == 0L ? 0L : System.currentTimeMillis() - this.getAllTaskStatistics;
        this.getAllFinishedTasks = new TaskMonitorThread(this);
        this.getAllFinishedTasks.start();
        this.addFinishedTask = true;
    }

    public void restart() {
        this.getAllFinishedTasks.stopRun();
        this.init();
        this.start();
    }

    public void stop() {
        this.getAllFinishedTasks.stopRun();
        this.addFinishedTask = false;
    }

    public boolean isStarted() {
        return this.addFinishedTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object;
        String string;
        this.addElement = MonitorEnv.getMaxTimeSaveReport() * 60 * 1000;
        this.addFailedTask = MonitorEnv.getMaxNumberSaveReport();
        if (this.addElement == 0 && this.addFailedTask == 0) {
            return;
        }
        if (this.addElement > 0) {
            string = null;
            object = null;
            Hashtable hashtable = this.containsKey;
            synchronized (hashtable) {
                Enumeration enumeration = this.containsKey.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (TaskInfo)this.containsKey.get(string);
                    if (System.currentTimeMillis() - object.getFinishedTime() <= (long)this.addElement) continue;
                    this.containsKey.remove(string);
                }
            }
        }
        if (this.addFailedTask > 0) {
            string = null;
            object = this.containsKey;
            synchronized (object) {
                while (this.containsKey.size() > this.addFailedTask) {
                    string = this.addFinishedTask();
                    this.containsKey.remove(string);
                }
            }
        }
    }

    private String addFinishedTask() {
        String string = null;
        String string2 = "";
        TaskInfo taskInfo = null;
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.containsKey.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            taskInfo = (TaskInfo)this.containsKey.get(string);
            if (taskInfo.getFinishedTime() >= l) continue;
            l = taskInfo.getFinishedTime();
            string2 = string;
        }
        return string2;
    }

    public MonitorService getMonitorService() {
        return this.QOIV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllTaskStatistics() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getDefaultInterval;
        synchronized (hashtable) {
            Enumeration enumeration = this.getDefaultInterval.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public TaskStatistic getTaskStatistic(String string) {
        return (TaskStatistic)this.getDefaultInterval.get(string);
    }
}

