/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.user;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.UserSession;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.user.UserMonitor;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.user.UserMonitorThread;

public class JRUserMonitor
implements UserMonitor {
    private int QOIV = 10000;
    private int addElement = 600000;
    private boolean clear = false;
    private UserMonitorThread destroy = null;
    private MonitorService elementAt = null;
    private Vector equals = new Vector();
    private Hashtable get = new Hashtable();
    private int getAllUserSessions = -1;

    public JRUserMonitor() {
    }

    public JRUserMonitor(MonitorService monitorService) {
        this(monitorService, monitorService.getDefaultInterval());
    }

    public JRUserMonitor(MonitorService monitorService, int n) {
        this();
        this.elementAt = monitorService;
        this.QOIV = n;
    }

    public Vector getAllUserSessions() {
        Vector vector = null;
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                vector = remoteMonitorService.getAllUserSessions();
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        if (vector != null) {
            this.equals = vector;
            this.get.clear();
        } else {
            vector = this.equals;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUserSessionsByUser(String string) {
        Object object;
        Vector vector = null;
        try {
            object = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (object != null) {
                vector = object.getUserSessionsByUser(string);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vector != null) {
            this.equals = this.getAllUserSessions();
        } else if (this.equals != null) {
            object = this.equals;
            synchronized (object) {
                int n = 0;
                int n2 = this.equals.size();
                while (n < n2) {
                    if (string.equals(((UserSession)this.equals.elementAt(n)).getUserID())) {
                        vector.addElement(this.equals.elementAt(n));
                    }
                    ++n;
                }
            }
        }
        return vector;
    }

    public Vector getSortedUserSessions(Vector vector, int[] nArray) {
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                return remoteMonitorService.getSortedUserSessions(vector, nArray);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserSessionBySessionID(String string) {
        Object object;
        try {
            object = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (object != null) {
                object.removeUserSessionBySessionID(string);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        object = null;
        Vector vector = this.equals;
        synchronized (vector) {
            int n = 0;
            int n2 = this.equals.size();
            while (n < n2) {
                object = ((UserSession)this.equals.elementAt(n)).getID();
                if (((String)object).equals(string)) {
                    this.equals.remove(n);
                    this.get.remove(object);
                    n = 0;
                    n2 = this.equals.size();
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserSessionsByUserID(String string) {
        Object object;
        try {
            object = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (object != null) {
                object.removeUserSessionsByUserID(string);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        object = null;
        Vector vector = this.equals;
        synchronized (vector) {
            int n = 0;
            int n2 = this.equals.size();
            while (n < n2) {
                UserSession userSession = (UserSession)this.equals.elementAt(n);
                object = userSession.getUserID();
                if (((String)object).equals(string)) {
                    this.equals.remove(n);
                    this.get.remove(userSession.getID());
                    n = 0;
                    n2 = this.equals.size();
                }
                ++n;
            }
        }
    }

    public void removeAllSelectedUserSessions(String[] stringArray) {
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                remoteMonitorService.removeAllSelectedUserSessions(stringArray);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int n = 0;
        while (n < stringArray.length) {
            this.removeUserSessionBySessionID(stringArray[n]);
            ++n;
        }
    }

    public void removeAllUserSessions() {
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                remoteMonitorService.removeAllUserSessions();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.equals.clear();
        this.get.clear();
    }

    public String getHttpSessionID(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                string2 = remoteMonitorService.getHttpSessionID(string);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (string2 != null) {
            this.get.put(string, string2);
        } else {
            string2 = (String)this.get.get(string);
        }
        return string2;
    }

    public void setSessionTimeout(int n) {
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                remoteMonitorService.setSessionTimeout(n);
            }
        }
        catch (RemoteException remoteException) {
            this.getAllUserSessions = n;
        }
    }

    public int getSessionTimeout() {
        int n = -1;
        try {
            RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.elementAt).getRemoteMonitorService();
            if (remoteMonitorService != null) {
                n = remoteMonitorService.getSessionTimeout();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (n != -1) {
            this.getAllUserSessions = n;
        } else {
            n = this.getAllUserSessions;
        }
        return n;
    }

    public int getValidUserSessionNums() {
        return this.getAllUserSessions().size();
    }

    public void setInterval(int n) {
        this.QOIV = n;
    }

    public int getInterval() {
        return this.QOIV;
    }

    public void setDuration(int n) {
        this.addElement = n;
    }

    public int getDuration() {
        return this.addElement;
    }

    public void start() {
        this.destroy = new UserMonitorThread(this);
        this.destroy.start();
        this.clear = true;
    }

    public void restart() {
        this.destroy.destroy();
        this.start();
    }

    public void stop() {
        this.destroy.stopRun();
        this.clear = false;
    }

    public boolean isStarted() {
        return this.clear;
    }

    public void update() {
    }

    public MonitorService getMonitorService() {
        return this.elementAt;
    }
}

