/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.profiling.CollectingAgency;
import jet.server.log.ServiceLogger;
import jet.server.profiling.CounterCategory;
import jet.server.profiling.CounterType;
import jet.server.profiling.PerformanceCounter;
import jet.server.profiling.jreport.TaskContextTable;

public final class RptServerCollectingAgency
implements CollectingAgency {
    private static boolean AverageBase = false;
    private TaskContextTable AverageCount = null;
    private static CounterCategory AverageTimer = CounterCategory.createCategory(null, "RptServerProfile");
    private PerformanceCounter PercentCount;
    private PerformanceCounter QOIV;
    private PerformanceCounter clear;
    private PerformanceCounter close;
    private PerformanceCounter createCategory;
    private PerformanceCounter createCounter;
    private PerformanceCounter destroy;
    private PerformanceCounter fields;
    private HashMap get = new HashMap();

    public void init(Properties properties) {
        if (this.isAlive()) {
            return;
        }
        Database database = (Database)properties.get("database");
        if (database != null) {
            try {
                this.AverageCount = new TaskContextTable(database);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            String string = properties.getProperty("restore.profiling");
            if (string != null && string.trim().length() > 0) {
                try {
                    database.restore(string);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        this.AverageBase();
        AverageBase = true;
    }

    public void destroy() {
        if (this.AverageCount != null) {
            this.AverageCount.close();
        }
        CounterCategory.destroy();
        AverageBase = false;
    }

    public boolean isAlive() {
        return AverageBase;
    }

    public void collects(Hashtable hashtable) {
        if (this.AverageCount != null) {
            FieldValue[] fieldValueArray;
            this.get.clear();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                fieldValueArray = (FieldValue[])enumeration.nextElement();
                this.get.put(fieldValueArray.toUpperCase(), hashtable.get(fieldValueArray));
            }
            fieldValueArray = this.AverageCount.fields().values();
            int n = fieldValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = fieldValueArray[n2].getName();
                Object v = this.get.get(string);
                if (string.startsWith("TS")) {
                    long l = v == null ? 0L : (Long)v;
                    fieldValueArray[n2].setValue(new Timestamp(l));
                } else {
                    fieldValueArray[n2].setValue(v);
                }
                ++n2;
            }
            try {
                this.AverageCount.insert(fieldValueArray);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    private void AverageBase() {
        this.PercentCount = AverageTimer.createCounter("TotalTasks", CounterType.AverageBase, null);
        this.PercentCount.setCounterHelp("Total of completed task since this counter initialize.");
        this.QOIV = AverageTimer.createCounter("PercentOfSuccessful", CounterType.PercentCount, this.PercentCount);
        this.QOIV.setCounterHelp("Percent of successful in total complected tasks.");
        this.clear = AverageTimer.createCounter("PercentOfOndemand", CounterType.PercentCount, this.PercentCount);
        this.clear.setCounterHelp("Percent of on-demand type in total completed tasks.");
        this.close = AverageTimer.createCounter("AverageOfWaited", CounterType.AverageTimer, this.PercentCount);
        this.close.setCounterHelp("Average waited time(ms) before the task is launched.");
        this.createCategory = AverageTimer.createCounter("AverageOfEngine", CounterType.AverageTimer, this.PercentCount);
        this.createCategory.setCounterHelp("Average cost engine time(ms) per report.");
        this.createCounter = AverageTimer.createCounter("AverageOfPages", CounterType.AverageCount, this.PercentCount);
        this.createCounter.setCounterHelp("Average pages per report exports.");
        this.destroy = AverageTimer.createCounter("AverageOfQueue", CounterType.AverageCount, this.PercentCount);
        this.destroy.setCounterHelp("Average queue length of this report server.");
        this.fields = AverageTimer.createCounter("AverageOfConcurrent", CounterType.AverageCount, this.PercentCount);
        this.fields.setCounterHelp("Average concurrent engines of this report server.");
    }
}

